/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.ci.CIServer;
import com.intellij.ide.starter.process.ProcessInfo;
import com.intellij.ide.starter.process.ProcessKiller;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.util.system.OS;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJE\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\r0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/starter/utils/PortUtil;", "", "<init>", "()V", "isPortAvailable", "", "host", "Ljava/net/InetAddress;", "port", "", "getPortUnavailabilityReason", "", "checkFree", "T", "onSuccess", "Lkotlin/Function0;", "onFailure", "Lkotlin/Function1;", "", "(Ljava/net/InetAddress;ILkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getAvailablePort", "proposedPort", "getProcessesUsingPort", "", "Lcom/intellij/ide/starter/process/ProcessInfo;", "killProcessesUsingPort", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nPortUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortUtil.kt\ncom/intellij/ide/starter/utils/PortUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1205#2,2:156\n1282#2,4:158\n1915#2,2:168\n1642#2,10:170\n1915#2:180\n1916#2:182\n1652#2:183\n1642#2,10:184\n1915#2:194\n1916#2:196\n1652#2:197\n1586#2:198\n1661#2,3:199\n129#3:162\n158#3,3:163\n221#3,2:166\n1#4:181\n1#4:195\n*S KotlinDebug\n*F\n+ 1 PortUtil.kt\ncom/intellij/ide/starter/utils/PortUtil\n*L\n46#1:156,2\n46#1:158,4\n71#1:168,2\n112#1:170,10\n112#1:180\n112#1:182\n112#1:183\n118#1:184,10\n118#1:194\n118#1:196\n118#1:197\n121#1:198\n121#1:199,3\n47#1:162\n47#1:163,3\n60#1:166,2\n112#1:181\n118#1:195\n*E\n"})
public final class PortUtil {
    @NotNull
    public static final PortUtil INSTANCE = new PortUtil();

    private PortUtil() {
    }

    public final boolean isPortAvailable(@NotNull InetAddress host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return (Boolean)this.checkFree(host, port, PortUtil::isPortAvailable$lambda$0, PortUtil::isPortAvailable$lambda$1);
    }

    @Nullable
    public final String getPortUnavailabilityReason(@NotNull InetAddress host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return (String)this.checkFree(host, port, PortUtil::getPortUnavailabilityReason$lambda$0, PortUtil::getPortUnavailabilityReason$lambda$1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T checkFree(InetAddress host, int port, Function0<? extends T> onSuccess, Function1<? super Throwable, ? extends T> onFailure) {
        Object object;
        try {
            object = new ServerSocket();
            Throwable throwable = null;
            try {
                ServerSocket it = (ServerSocket)object;
                boolean bl = false;
                it.setReuseAddress(true);
                it.bind(new InetSocketAddress(host, port), 50);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = onSuccess.invoke();
        }
        catch (Throwable t) {
            object = onFailure.invoke((Object)t);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAvailablePort(@NotNull InetAddress host, int proposedPort) {
        Object $this$forEach$iv;
        void $this$getAvailablePort_u24lambda_u2432;
        StringBuilder stringBuilder;
        Object object;
        String pidsInfoMap;
        Object object2;
        block13: {
            block12: {
                void $this$mapTo$iv$iv;
                Object object3;
                Object it;
                Object destination$iv$iv;
                List<ProcessInfo> processes;
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                if (this.isPortAvailable(host, proposedPort)) {
                    return proposedPort;
                }
                List<ProcessInfo> list = processes = this.getProcessesUsingPort(proposedPort);
                if (list != null) {
                    void $this$associateTo$iv$iv;
                    Iterable $this$associate$iv = list;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associate$iv;
                    destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Iterator element$iv$iv : $this$associateTo$iv$iv) {
                        Object object4 = destination$iv$iv;
                        it = (ProcessInfo)((Object)element$iv$iv);
                        boolean bl = false;
                        it = TuplesKt.to((Object)((ProcessInfo)it).getPid(), (Object)it);
                        object4.put(it.getFirst(), it.getSecond());
                    }
                    object3 = destination$iv$iv;
                } else {
                    object3 = null;
                }
                if ((object2 = (pidsInfoMap = object3)) == null) break block12;
                String $this$map$iv = object2;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    it = item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    object.add(((ProcessInfo)it.getValue()).getName());
                }
                object2 = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                if (object2 != null && (object2 = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) != null) break block13;
            }
            object2 = "Failed to retrieve processes";
        }
        String processNames = object2;
        StringBuilder $this$map$iv = stringBuilder = new StringBuilder();
        String string = "Proposed port " + proposedPort + " is not available on host " + host + " as it used by processes " + processNames;
        object = CIServer.Companion.getInstance();
        boolean bl = false;
        $this$getAvailablePort_u24lambda_u2432.append("Busy port could mean that the previous process is still running or the port is blocked by another application.").append('\n');
        $this$getAvailablePort_u24lambda_u2432.append("Please make sure to investigate, the uninvestigated hanging processes could lead to further unclear test failure.").append('\n');
        $this$getAvailablePort_u24lambda_u2432.append("PLEASE BE CAREFUL WHEN MUTING").append('\n');
        if (pidsInfoMap != null) {
            $this$getAvailablePort_u24lambda_u2432.append('\n');
            $this$getAvailablePort_u24lambda_u2432.append("Processes using the port " + proposedPort + ":").append('\n');
            $this$forEach$iv = pidsInfoMap;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                Map.Entry item$iv$iv;
                item$iv$iv = element$iv;
                boolean bl2 = false;
                ProcessInfo info = (ProcessInfo)item$iv$iv.getValue();
                $this$getAvailablePort_u24lambda_u2432.append(info.getDescription()).append('\n');
            }
        }
        Unit unit = Unit.INSTANCE;
        CIServer.reportTestFailure$default((CIServer)object, string, stringBuilder.toString(), "", null, 8, null);
        int n = 100;
        int $this$getAvailablePort_u24lambda_u2432 = 0;
        while ($this$getAvailablePort_u24lambda_u2432 < n) {
            int it = $this$getAvailablePort_u24lambda_u2432++;
            boolean bl3 = false;
            if (!INSTANCE.isPortAvailable(host, proposedPort + it)) continue;
            return proposedPort + it;
        }
        CharSequence charSequence = new StringBuilder();
        StringBuilder $this$getAvailablePort_u24lambda_u244 = charSequence;
        boolean bl4 = false;
        $this$getAvailablePort_u24lambda_u244.append("No available port found in a range " + proposedPort + ".." + (proposedPort + 100)).append('\n');
        Object[] bl3 = new Integer[]{proposedPort, proposedPort + 50, proposedPort + 100};
        $this$forEach$iv = CollectionsKt.listOf((Object[])bl3);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            element$iv = iterator.next();
            int port = ((Number)((Object)element$iv)).intValue();
            boolean bl5 = false;
            $this$getAvailablePort_u24lambda_u244.append("Unavailability reason of " + port + " is " + INSTANCE.getPortUnavailabilityReason(host, port)).append('\n');
        }
        charSequence = ((StringBuilder)charSequence).toString();
        throw new IllegalStateException(((Object)charSequence).toString());
    }

    public static /* synthetic */ int getAvailablePort$default(PortUtil portUtil, InetAddress inetAddress, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            InetAddress inetAddress2 = InetAddress.getLoopbackAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getLoopbackAddress(...)");
            inetAddress = inetAddress2;
        }
        return portUtil.getAvailablePort(inetAddress, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ProcessInfo> getProcessesUsingPort(int port) {
        String[] stringArray;
        Object findCommand;
        Object[] objectArray;
        Object $this$getProcessesUsingPort_u24lambda_u240;
        String errorMsg = null;
        errorMsg = "";
        Object object = this;
        try {
            void $this$mapTo$iv$iv;
            List list;
            Object $this$mapNotNullTo$iv$iv;
            Collection destination$iv$iv;
            List list2;
            $this$getProcessesUsingPort_u24lambda_u240 = object;
            boolean bl = false;
            if (OS.CURRENT == OS.Windows) {
                objectArray = new String[]{"cmd", "/c", "netstat -ano | findstr :" + port};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                objectArray = new String[]{"sh", "-c", "lsof -i :" + port + " -t"};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            }
            findCommand = list2;
            String prefix = "find-pid";
            ExecOutputRedirect.ToStdOutAndString stdoutRedirectFind = new ExecOutputRedirect.ToStdOutAndString(prefix);
            ExecOutputRedirect.ToStdOutAndString stderrRedirectFind = new ExecOutputRedirect.ToStdOutAndString(prefix);
            ProcessExecutor.start$default(new ProcessExecutor("Find Processes Using Port", null, 0L, null, (List)findCommand, null, stdoutRedirectFind, stderrRedirectFind, null, null, null, false, 0, false, false, 24364, null), false, 1, null);
            String processIdsRaw = ((Object)StringsKt.trim((CharSequence)stdoutRedirectFind.read())).toString();
            errorMsg = stderrRedirectFind.read();
            if (OS.CURRENT == OS.Windows) {
                stringArray = new String[]{"\n"};
                $this$mapNotNull$iv = StringsKt.split$default((CharSequence)processIdsRaw, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                $i$f$mapNotNull = false;
                Object object2 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var18_21 = $this$forEach$iv$iv$iv.iterator();
                while (var18_21.hasNext()) {
                    Integer it$iv$iv;
                    element$iv$iv = element$iv$iv$iv = var18_21.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    String line = (String)element$iv$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)prefix))).toString();
                    Regex regex = new Regex("\\s+");
                    int n = 0;
                    List tokens = regex.split(charSequence, n);
                    String string = (String)CollectionsKt.getOrNull((List)tokens, (int)4);
                    if ((string != null ? StringsKt.toIntOrNull((String)string) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                $this$mapNotNull$iv = new String[]{"\n"};
                $this$mapNotNull$iv = StringsKt.split$default((CharSequence)processIdsRaw, (String[])$this$mapNotNull$iv, (boolean)false, (int)0, (int)6, null);
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var18_21 = $this$forEach$iv$iv$iv.iterator();
                while (var18_21.hasNext()) {
                    Integer it$iv$iv;
                    element$iv$iv = element$iv$iv$iv = var18_21.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    String it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)it, (CharSequence)prefix))).toString()) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List pids = list;
            Iterable $this$map$iv = pids;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pid;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(ProcessInfo.Companion.create((long)pid, port));
            }
            $this$getProcessesUsingPort_u24lambda_u240 = Result.constructor-impl((Object)((List)destination$iv$iv));
        }
        catch (Throwable bl) {
            $this$getProcessesUsingPort_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getProcessesUsingPort_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            void $this$getProcessesUsingPort_u24lambda_u241_u240;
            Throwable it = throwable;
            boolean bl = false;
            objectArray = new StringBuilder();
            findCommand = objectArray;
            String string = "An error occurred while attempting to get processes using port.";
            CIServer cIServer = CIServer.Companion.getInstance();
            boolean bl7 = false;
            $this$getProcessesUsingPort_u24lambda_u241_u240.append("An error occurred while attempting to get processes using port " + port + ". ").append('\n');
            if (((CharSequence)errorMsg).length() > 0) {
                $this$getProcessesUsingPort_u24lambda_u241_u240.append("Error message: " + errorMsg).append('\n');
            }
            $this$getProcessesUsingPort_u24lambda_u241_u240.append("Exception: " + ExceptionsKt.stackTraceToString((Throwable)it)).append('\n');
            stringArray = Unit.INSTANCE;
            CIServer.reportTestFailure$default(cIServer, string, objectArray.toString(), "", null, 8, null);
            return null;
        }
        return (List)object;
    }

    public final boolean killProcessesUsingPort(int port) {
        List<ProcessInfo> processes;
        List<ProcessInfo> list = processes = this.getProcessesUsingPort(port);
        boolean bl = list != null ? !((Collection)list).isEmpty() : false;
        if (bl) {
            return ProcessKiller.killProcesses-SxA4cEA$default(ProcessKiller.INSTANCE, processes, null, 0L, 6, null);
        }
        if (processes == null) {
            CIServer.reportTestFailure$default(CIServer.Companion.getInstance(), "Failed to retrieve processes using port", "Failed to retrieve processes using port " + port, "", null, 8, null);
        } else {
            CIServer.reportTestFailure$default(CIServer.Companion.getInstance(), "No processes using port found", "No processes using port found " + port, "", null, 8, null);
        }
        return false;
    }

    private static final boolean isPortAvailable$lambda$0() {
        return true;
    }

    private static final boolean isPortAvailable$lambda$1(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final String getPortUnavailabilityReason$lambda$0() {
        return null;
    }

    private static final String getPortUnavailabilityReason$lambda$1(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ExceptionsKt.stackTraceToString((Throwable)it);
    }
}

