/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.buildTool;

import com.intellij.ide.starter.buildTool.BuildTool;
import com.intellij.ide.starter.buildTool.BuildToolType;
import com.intellij.ide.starter.ide.IDETestContext;
import com.intellij.ide.starter.utils.XmlBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0000J2\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0015H\u0002J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/starter/buildTool/JpsBuildTool;", "Lcom/intellij/ide/starter/buildTool/BuildTool;", "testContext", "Lcom/intellij/ide/starter/ide/IDETestContext;", "<init>", "(Lcom/intellij/ide/starter/ide/IDETestContext;)V", "ideaDir", "Ljava/nio/file/Path;", "getIdeaDir", "()Ljava/nio/file/Path;", "compilerXmlPath", "getCompilerXmlPath", "workspaceXmlPath", "getWorkspaceXmlPath", "setBuildProcessHeapSize", "heapSizeMb", "", "enableParallelCompilation", "patchXmlConfigFile", "configFile", "componentName", "", "optionName", "optionValue", "checkExpression", "addBuildVmOption", "key", "value", "intellij.tools.ide.starter"})
public final class JpsBuildTool
extends BuildTool {
    public JpsBuildTool(@NotNull IDETestContext testContext) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        super(BuildToolType.JPS, testContext);
    }

    private final Path getIdeaDir() {
        Path path = this.getTestContext().getResolvedProjectHome().resolve(".idea");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path getCompilerXmlPath() {
        Path path = this.getIdeaDir().resolve("compiler.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path getWorkspaceXmlPath() {
        Path path = this.getIdeaDir().resolve("workspace.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final JpsBuildTool setBuildProcessHeapSize(int heapSizeMb) {
        return JpsBuildTool.patchXmlConfigFile$default(this, this.getCompilerXmlPath(), "CompilerConfiguration", "BUILD_PROCESS_HEAP_SIZE", String.valueOf(heapSizeMb), null, 16, null);
    }

    @NotNull
    public final JpsBuildTool enableParallelCompilation() {
        return JpsBuildTool.patchXmlConfigFile$default(this, this.getWorkspaceXmlPath(), "CompilerWorkspaceConfiguration", "PARALLEL_COMPILATION", "true", null, 16, null);
    }

    private final JpsBuildTool patchXmlConfigFile(Path configFile, String componentName, String optionName, String optionValue, String checkExpression) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return this;
        }
        String content = PathsKt.readText$default((Path)configFile, null, (int)1, null);
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)checkExpression, (boolean)false, (int)2, null)) {
            return this;
        }
        Document xmlDoc = XmlBuilder.INSTANCE.parse(configFile);
        xmlDoc.getDocumentElement().normalize();
        XPath xPath = XPathFactory.newInstance().newXPath();
        Intrinsics.checkNotNullExpressionValue((Object)xPath, (String)"newXPath(...)");
        XPath xp = xPath;
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)componentName, (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)PathsKt.readText$default((Path)configFile, null, (int)1, null), (CharSequence)optionName, (boolean)false, (int)2, null)) {
                Object object = xp.evaluate("//component/option[@name='" + optionName + "']", xmlDoc, XPathConstants.NODE);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element node = (Element)object;
                node.removeAttribute("value");
                node.setAttribute("value", optionValue);
                v3 = Unit.INSTANCE;
            } else {
                Object object = xp.evaluate("//component[@name='" + componentName + "']", xmlDoc, XPathConstants.NODE);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element componentNode = (Element)object;
                Element optionElement = xmlDoc.createElement("option");
                optionElement.setAttribute("name", optionName);
                optionElement.setAttribute("value", optionValue);
                v3 = componentNode.appendChild(optionElement);
            }
        } else {
            Node firstNode = xmlDoc.getFirstChild();
            Element componentElement = xmlDoc.createElement("component");
            componentElement.setAttribute("name", componentName);
            Element optionElement = xmlDoc.createElement("option");
            optionElement.setAttribute("name", optionName);
            optionElement.setAttribute("value", optionValue);
            v3 = firstNode.appendChild(componentElement).appendChild(optionElement);
        }
        XmlBuilder.INSTANCE.writeDocument(xmlDoc, configFile);
        return this;
    }

    static /* synthetic */ JpsBuildTool patchXmlConfigFile$default(JpsBuildTool jpsBuildTool, Path path, String string, String string2, String string3, String object, int n, Object object2) {
        if ((n & 0x10) != 0) {
            object = "option name=\"" + string2 + "\" value=\"" + string3 + "\"";
        }
        return jpsBuildTool.patchXmlConfigFile(path, string, string2, string3, (String)object);
    }

    @NotNull
    public final JpsBuildTool addBuildVmOption(@NotNull String key, @NotNull String value) {
        String newOption;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.getCompilerXmlPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return this;
        }
        String content = PathsKt.readText$default((Path)this.getCompilerXmlPath(), null, (int)1, null);
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)(newOption = "-D" + key + "=" + value), (boolean)false, (int)2, null)) {
            return this;
        }
        Document xmlDoc = XmlBuilder.INSTANCE.parse(this.getCompilerXmlPath());
        xmlDoc.getDocumentElement().normalize();
        XPath xPath = XPathFactory.newInstance().newXPath();
        Intrinsics.checkNotNullExpressionValue((Object)xPath, (String)"newXPath(...)");
        XPath xp = xPath;
        if (StringsKt.contains$default((CharSequence)content, (CharSequence)"CompilerConfiguration", (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)PathsKt.readText$default((Path)this.getCompilerXmlPath(), null, (int)1, null), (CharSequence)"BUILD_PROCESS_ADDITIONAL_VM_OPTIONS", (boolean)false, (int)2, null)) {
                Object object = xp.evaluate("//component/option[@name='BUILD_PROCESS_ADDITIONAL_VM_OPTIONS']", xmlDoc, XPathConstants.NODE);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element optionNode = (Element)object;
                String oldValue = optionNode.getAttribute("value");
                String newValue = oldValue + " " + newOption;
                optionNode.removeAttribute("value");
                optionNode.setAttribute("value", newValue);
                v3 = Unit.INSTANCE;
            } else {
                Object object = xp.evaluate("//component[@name='CompilerConfiguration']", xmlDoc, XPathConstants.NODE);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                Element componentNode = (Element)object;
                Element optionElement = xmlDoc.createElement("option");
                optionElement.setAttribute("name", "BUILD_PROCESS_ADDITIONAL_VM_OPTIONS");
                optionElement.setAttribute("value", newOption);
                v3 = componentNode.appendChild(optionElement);
            }
        } else {
            Node firstNode = xmlDoc.getFirstChild();
            Element componentElement = xmlDoc.createElement("component");
            componentElement.setAttribute("name", "CompilerConfiguration");
            Element optionElement = xmlDoc.createElement("option");
            optionElement.setAttribute("name", "BUILD_PROCESS_ADDITIONAL_VM_OPTIONS");
            optionElement.setAttribute("value", newOption);
            v3 = firstNode.appendChild(componentElement).appendChild(optionElement);
        }
        XmlBuilder.INSTANCE.writeDocument(xmlDoc, this.getCompilerXmlPath());
        return this;
    }
}

