/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.buildTool;

import com.intellij.ide.starter.buildTool.BuildTool;
import com.intellij.ide.starter.buildTool.BuildToolType;
import com.intellij.ide.starter.ide.IDETestContext;
import com.intellij.ide.starter.models.VMOptions;
import com.intellij.ide.starter.process.ProcessUtilsKt;
import com.intellij.ide.starter.runner.events.IdeAfterLaunchEvent;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.tools.ide.performanceTesting.commands.dto.MavenArchetypeInfo;
import com.intellij.tools.ide.starter.bus.EventsBus;
import com.intellij.tools.ide.starter.bus.shared.events.SharedEvent;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.io.PathKt;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsMavenSettings;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0007J\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/starter/buildTool/MavenBuildTool;", "Lcom/intellij/ide/starter/buildTool/BuildTool;", "testContext", "Lcom/intellij/ide/starter/ide/IDETestContext;", "<init>", "(Lcom/intellij/ide/starter/ide/IDETestContext;)V", "temporaryMavenM3CachePath", "Ljava/nio/file/Path;", "getTemporaryMavenM3CachePath", "()Ljava/nio/file/Path;", "temporaryMavenM3UserSettingsPath", "getTemporaryMavenM3UserSettingsPath", "temporaryMavenM3RepoPath", "getTemporaryMavenM3RepoPath", "useNewMavenLocalRepository", "removeMavenConfigFiles", "setLogLevel", "", "logLevel", "Lcom/intellij/openapi/diagnostic/LogLevel;", "setPropertyInPomXml", "propertyName", "", "propertyValue", "modulePath", "downloadArtifactFromMavenCentral", "data", "Lcom/intellij/tools/ide/performanceTesting/commands/dto/MavenArchetypeInfo;", "repoPath", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nMavenBuildTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenBuildTool.kt\ncom/intellij/ide/starter/buildTool/MavenBuildTool\n+ 2 EventsBus.kt\ncom/intellij/tools/ide/starter/bus/EventsBus\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n51#2,16:129\n1#3:145\n1915#4,2:146\n*S KotlinDebug\n*F\n+ 1 MavenBuildTool.kt\ncom/intellij/ide/starter/buildTool/MavenBuildTool\n*L\n41#1:129,16\n112#1:146,2\n*E\n"})
public class MavenBuildTool
extends BuildTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MAVEN_DAEMON_NAME = "MavenServerIndexerMain";

    /*
     * WARNING - void declaration
     */
    public MavenBuildTool(@NotNull IDETestContext testContext) {
        void timeout$iv;
        void subscriber$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        super(BuildToolType.MAVEN, testContext);
        EventsBus eventsBus = EventsBus.INSTANCE;
        1 var3_3 = 1.INSTANCE;
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        Function2 callback$iv = (Function2)new Function2<IdeAfterLaunchEvent, Continuation<? super Unit>, Object>(testContext, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ IDETestContext $testContext;
            {
                this.$testContext = $testContext;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IdeAfterLaunchEvent ideAfterLaunchEvent = (IdeAfterLaunchEvent)((Object)this.L$0);
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void event;
                        ResultKt.throwOnFailure((Object)$result);
                        if (event.getRunContext().getTestContext() == this.$testContext) {
                            Companion.destroyMavenIndexerProcessIfExists();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(IdeAfterLaunchEvent p1, Continuation<? super Unit> p2) {
                return (this.create((Object)p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
        boolean ignoreExceptions$iv = true;
        boolean sequential$iv = false;
        boolean bl = false;
        $this$iv.executeWithExceptionHandling(ignoreExceptions$iv, (Function0)new Function0<Unit>((Object)subscriber$iv, (long)timeout$iv, sequential$iv, callback$iv){
            final /* synthetic */ Object $subscriber;
            final /* synthetic */ long $timeout;
            final /* synthetic */ boolean $sequential;
            final /* synthetic */ Function2 $callback;
            {
                this.$subscriber = $subscriber;
                this.$timeout = $timeout;
                this.$sequential = $sequential;
                this.$callback = $callback;
            }

            public final void invoke() {
                if (SharedEvent.class.isAssignableFrom(IdeAfterLaunchEvent.class)) {
                    EventsBus.INSTANCE.getSHARED_EVENTS_FLOW().subscribe-1Y68eR8(IdeAfterLaunchEvent.class, this.$subscriber, this.$timeout, this.$sequential, this.$callback);
                    EventsBus.INSTANCE.getSHARED_EVENTS_FLOW().startServerPolling();
                } else {
                    EventsBus.INSTANCE.getEVENTS_FLOW().subscribe-1Y68eR8(IdeAfterLaunchEvent.class, this.$subscriber, this.$timeout, this.$sequential, this.$callback);
                }
            }
        });
    }

    private final Path getTemporaryMavenM3CachePath() {
        Path path = this.getTestContext().getPaths().getTempDir().resolve(".m3");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getTemporaryMavenM3UserSettingsPath() {
        Path path = this.getTemporaryMavenM3CachePath().resolve("settings.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getTemporaryMavenM3RepoPath() {
        Path path = this.getTemporaryMavenM3CachePath().resolve("repository");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final MavenBuildTool useNewMavenLocalRepository() {
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(this.getTemporaryMavenM3RepoPath(), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        this.getTestContext().applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)arg_0 -> MavenBuildTool.useNewMavenLocalRepository$lambda$0(this, arg_0)));
        return this;
    }

    @NotNull
    public final MavenBuildTool removeMavenConfigFiles() {
        LoggingKt.logOutput((String)("Removing Maven config files in " + this.getTestContext().getResolvedProjectHome() + " ..."));
        for (Path file : PathsKt.walk((Path)this.getTestContext().getResolvedProjectHome(), (PathWalkOption[])new PathWalkOption[0])) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || !Intrinsics.areEqual((Object)PathsKt.getName((Path)file), (Object)"pom.xml")) continue;
            PathKt.delete$default((Path)file, (boolean)false, (int)1, null);
            LoggingKt.logOutput((String)("File " + file + " is deleted"));
        }
        return this;
    }

    public final void setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        this.getTestContext().applyVMOptionsPatch((Function1<? super VMOptions, Unit>)((Function1)arg_0 -> MavenBuildTool.setLogLevel$lambda$0(logLevel, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MavenBuildTool setPropertyInPomXml(@NotNull String propertyName, @NotNull String propertyValue, @NotNull Path modulePath) {
        String string;
        Object it;
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Path pomXml = modulePath.resolve("pom.xml");
        String propertiesTag = "<properties>";
        String closePropertiesTag = "</properties>";
        String newProperty = "<" + propertyName + ">" + propertyValue + "</" + propertyName + ">";
        Intrinsics.checkNotNull((Object)pomXml);
        Object object = pomXml;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            it = (BufferedReader)object;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)((Reader)it));
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object $this$setPropertyInPomXml_u24lambda_u241 = it;
        int n2 = 0;
        if (StringsKt.contains$default((CharSequence)((CharSequence)$this$setPropertyInPomXml_u24lambda_u241), (CharSequence)propertiesTag, (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)((CharSequence)$this$setPropertyInPomXml_u24lambda_u241), (CharSequence)propertyName, (boolean)false, (int)2, null)) {
                CharSequence bl = (CharSequence)$this$setPropertyInPomXml_u24lambda_u241;
                String string2 = "(?<=<" + propertyName + ">)(.*)(?=</" + propertyName + ">)";
                string = new Regex(string2).replace(bl, propertyValue);
            } else {
                string = StringsKt.replace$default((String)$this$setPropertyInPomXml_u24lambda_u241, (String)propertiesTag, (String)(propertiesTag + "\n" + newProperty), (boolean)false, (int)4, null);
            }
        } else {
            String closeModelVersionTag = "</modelVersion>";
            string = StringsKt.replace$default((String)$this$setPropertyInPomXml_u24lambda_u241, (String)closeModelVersionTag, (String)(closeModelVersionTag + "\n" + propertiesTag + "\n" + newProperty + closePropertiesTag), (boolean)false, (int)4, null);
        }
        String text = string;
        object = pomXml;
        OpenOption[] closeModelVersionTag = new OpenOption[]{};
        object2 = Charsets.UTF_8;
        n2 = 8192;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(closeModelVersionTag, closeModelVersionTag.length)), (Charset)object2), n2);
        object2 = null;
        try {
            BufferedWriter it2 = (BufferedWriter)object;
            boolean bl = false;
            it2.write(text);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return this;
    }

    public static /* synthetic */ MavenBuildTool setPropertyInPomXml$default(MavenBuildTool mavenBuildTool, String string, String string2, Path path, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setPropertyInPomXml");
        }
        if ((n & 4) != 0) {
            path = mavenBuildTool.getTestContext().getResolvedProjectHome();
        }
        return mavenBuildTool.setPropertyInPomXml(string, string2, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadArtifactFromMavenCentral(@NotNull MavenArchetypeInfo data, @NotNull Path repoPath) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        try {
            Object[] objectArray = new String[]{"pom", "jar"};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path path;
                String it = (String)element$iv;
                boolean bl = false;
                String fileName = data.getArtefactId() + "-" + data.getVersion() + "." + it;
                String filePath = StringsKt.replace$default((String)data.getGroupId(), (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + data.getArtefactId() + "/" + data.getVersion();
                Path path2 = repoPath.resolve(filePath);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                Intrinsics.checkNotNullExpressionValue((Object)NioPathUtil.findOrCreateDirectory((Path)path2).resolve(fileName), (String)"resolve(...)");
                Object object = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createFile(...)");
                String url = "https://repo1.maven.org/maven2/" + filePath + "/" + fileName;
                object = new BufferedInputStream(new URL(url).openStream());
                Throwable throwable = null;
                try {
                    Path file;
                    BufferedInputStream inputStream = (BufferedInputStream)object;
                    boolean bl2 = false;
                    Closeable closeable = new FileOutputStream(((Object)file).toString());
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream outputStream = (FileOutputStream)closeable;
                        boolean bl3 = false;
                        ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error downloading artifact: " + e.getMessage());
        }
    }

    private static final Unit useNewMavenLocalRepository$lambda$0(MavenBuildTool this$0, VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        $this$applyVMOptionsPatch.addSystemProperty("maven.repo.local", ((Object)this$0.getTemporaryMavenM3RepoPath()).toString());
        return Unit.INSTANCE;
    }

    private static final Unit setLogLevel$lambda$0(LogLevel $logLevel, VMOptions $this$applyVMOptionsPatch) {
        Intrinsics.checkNotNullParameter((Object)$this$applyVMOptionsPatch, (String)"$this$applyVMOptionsPatch");
        String[] stringArray = new String[]{"org.jetbrains.idea.maven"};
        $this$applyVMOptionsPatch.configureLoggers($logLevel, stringArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/starter/buildTool/MavenBuildTool$Companion;", "", "<init>", "()V", "MAVEN_M2_REPO_PATH", "Ljava/nio/file/Path;", "getMAVEN_M2_REPO_PATH", "()Ljava/nio/file/Path;", "MAVEN_DAEMON_NAME", "", "destroyMavenIndexerProcessIfExists", "", "intellij.tools.ide.starter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getMAVEN_M2_REPO_PATH() {
            Path path = Path.of(JpsMavenSettings.getMavenRepositoryPath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }

        private final void destroyMavenIndexerProcessIfExists() {
            String[] stringArray = new String[]{MavenBuildTool.MAVEN_DAEMON_NAME};
            ProcessUtilsKt.findAndKillProcessesBySubstring$default(stringArray, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

