/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.community;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.ide.starter.community.LocalDateDeserializer;
import com.intellij.ide.starter.community.ProductInfoRequestParameters;
import com.intellij.ide.starter.community.model.ReleaseInfo;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0005J \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u000e2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/starter/community/JetBrainsDataServiceClient;", "", "<init>", "()V", "DATA_SERVICE_URL", "", "RELEASES_REPO_URL", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getIdeaIUAnnotations", "", "libVersion", "getReleases", "", "Lcom/intellij/ide/starter/community/model/ReleaseInfo;", "request", "Lcom/intellij/ide/starter/community/ProductInfoRequestParameters;", "fetchReleaseInfo", "getUrlToJbDataServices", "getLatestPublicReleases", "productType", "numberOfReleases", "", "maxReleaseBuild", "getLatestPublicReleaseVersions", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nJetBrainsDataServiceClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsDataServiceClient.kt\ncom/intellij/ide/starter/community/JetBrainsDataServiceClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n1586#2:95\n1661#2,3:96\n1586#2:99\n1661#2,3:100\n2829#2,5:103\n1266#2,4:110\n2835#2:114\n777#2:115\n873#2,2:116\n1586#2:118\n1661#2,3:119\n466#3:108\n415#3:109\n*S KotlinDebug\n*F\n+ 1 JetBrainsDataServiceClient.kt\ncom/intellij/ide/starter/community/JetBrainsDataServiceClient\n*L\n43#1:95\n43#1:96,3\n44#1:99\n44#1:100,3\n47#1:103,5\n48#1:110,4\n47#1:114\n70#1:115\n70#1:116,2\n89#1:118\n89#1:119,3\n48#1:108\n48#1:109\n*E\n"})
public final class JetBrainsDataServiceClient {
    @NotNull
    public static final JetBrainsDataServiceClient INSTANCE = new JetBrainsDataServiceClient();
    @NotNull
    private static final String DATA_SERVICE_URL = "https://data.services.jetbrains.com";
    @NotNull
    private static final String RELEASES_REPO_URL = "https://www.jetbrains.com/intellij-repository/releases/";
    private static final ObjectMapper jsonMapper = ExtensionsKt.jacksonObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new SimpleModule().addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer()));

    private JetBrainsDataServiceClient() {
    }

    @NotNull
    public final List<String> getIdeaIUAnnotations(@NotNull String libVersion) {
        Intrinsics.checkNotNullParameter((Object)libVersion, (String)"libVersion");
        String getUrlToJbDataServices = RELEASES_REPO_URL;
        Regex annotationRegex = new Regex("idea/ideaIU/" + libVersion + ".*?/ideaIU-" + libVersion + ".*?-annotations.zip");
        Regex versionRegex = new Regex("\\d{4}\\.\\d+(\\.\\d+)?");
        return (List)HttpClient.INSTANCE.sendRequest((HttpUriRequest)new HttpGet(getUrlToJbDataServices), arg_0 -> JetBrainsDataServiceClient.getIdeaIUAnnotations$lambda$0(annotationRegex, versionRegex, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<ReleaseInfo>> getReleases(@NotNull ProductInfoRequestParameters request) {
        void url;
        String uriQuery;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$map$iv = request.toUriQueries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("https://data.services.jetbrains.com/products/releases" + uriQuery);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            uriQuery = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            LoggingKt.logOutput((String)("Requesting JetBrains products by URL: " + (String)url));
            collection.add(INSTANCE.fetchReleaseInfo((String)url));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            void map;
            Map $i$f$mapTo2 = (Map)iterator$iv.next();
            Map acc = (Map)accumulator$iv;
            boolean bl = false;
            url = map;
            Map map2 = acc;
            boolean $i$f$mapValues = false;
            void var12_16 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable iterable2 = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                String key = (String)entry2.getKey();
                List value = (List)entry2.getValue();
                List list = CollectionsKt.plus((Collection)acc.getOrDefault(key, CollectionsKt.emptyList()), (Iterable)value);
                map4.put(k, list);
            }
            accumulator$iv = MapsKt.plus((Map)map2, (Map)destination$iv$iv$iv);
        }
        return (Map)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<ReleaseInfo>> fetchReleaseInfo(String getUrlToJbDataServices) {
        void $this$fetchReleaseInfo_u24lambda_u240;
        HttpGet httpGet;
        HttpGet httpGet2 = httpGet = new HttpGet(getUrlToJbDataServices);
        HttpClient httpClient = HttpClient.INSTANCE;
        boolean bl = false;
        $this$fetchReleaseInfo_u24lambda_u240.addHeader("Content-Type", "application/json");
        $this$fetchReleaseInfo_u24lambda_u240.addHeader("Accept", "application/json");
        Object y = httpClient.sendRequest((HttpUriRequest)httpGet, JetBrainsDataServiceClient::fetchReleaseInfo$lambda$1);
        Intrinsics.checkNotNullExpressionValue(y, (String)"sendRequest(...)");
        return (Map)y;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ReleaseInfo> getLatestPublicReleases(@NotNull String productType, int numberOfReleases, @Nullable String maxReleaseBuild) {
        List list;
        Intrinsics.checkNotNullParameter((Object)productType, (String)"productType");
        List it = (List)CollectionsKt.first((Iterable)this.getReleases(new ProductInfoRequestParameters(productType, null, null, null, null, 30, null)).values());
        boolean bl = false;
        if (maxReleaseBuild != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = it;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ReleaseInfo release = (ReleaseInfo)element$iv$iv;
                boolean bl2 = false;
                if (!(Integer.parseInt(StringsKt.substringBefore$default((String)release.getBuild(), (String)".", null, (int)2, null)) <= Integer.parseInt(maxReleaseBuild))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = it;
        }
        return CollectionsKt.take((Iterable)list, (int)numberOfReleases);
    }

    public static /* synthetic */ List getLatestPublicReleases$default(JetBrainsDataServiceClient jetBrainsDataServiceClient, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        return jetBrainsDataServiceClient.getLatestPublicReleases(string, n, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getLatestPublicReleaseVersions(@NotNull String productType, int numberOfReleases, @Nullable String maxReleaseBuild) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)productType, (String)"productType");
        Iterable iterable = this.getLatestPublicReleases(productType, Integer.MAX_VALUE, maxReleaseBuild);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReleaseInfo releaseInfo = (ReleaseInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMajorVersion());
        }
        return CollectionsKt.take((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (int)numberOfReleases);
    }

    public static /* synthetic */ List getLatestPublicReleaseVersions$default(JetBrainsDataServiceClient jetBrainsDataServiceClient, String string, int n, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        return jetBrainsDataServiceClient.getLatestPublicReleaseVersions(string, n, string2);
    }

    private static final String getIdeaIUAnnotations$lambda$0$0(Regex $versionRegex, MatchResult match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        MatchResult matchResult = Regex.find$default((Regex)$versionRegex, (CharSequence)match.getValue(), (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        return matchResult.getValue();
    }

    private static final List getIdeaIUAnnotations$lambda$0(Regex $annotationRegex, Regex $versionRegex, HttpResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InputStream inputStream = it.getEntity().getContent();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getContent(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        List result2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)$annotationRegex, (CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))), (int)0, (int)2, null), arg_0 -> JetBrainsDataServiceClient.getIdeaIUAnnotations$lambda$0$0($versionRegex, arg_0)));
        return result2;
    }

    private static final Map fetchReleaseInfo$lambda$1(HttpResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Map)jsonMapper.readValue(it.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, ? extends List<? extends ReleaseInfo>>>(){});
    }
}

