/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.ide.IDEStartConfig;
import com.intellij.ide.starter.ide.IdeDistribution;
import com.intellij.ide.starter.ide.InstalledBackedIDEStartConfig;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.models.VMOptions;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.JvmUtils;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/starter/ide/LinuxIdeDistribution;", "Lcom/intellij/ide/starter/ide/IdeDistribution;", "<init>", "()V", "installIde", "Lcom/intellij/ide/starter/ide/InstalledIde;", "unpackDir", "Ljava/nio/file/Path;", "executableFileName", "", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nLinuxIdeDistribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxIdeDistribution.kt\ncom/intellij/ide/starter/ide/LinuxIdeDistribution\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n672#3,11:114\n296#3,2:125\n*S KotlinDebug\n*F\n+ 1 LinuxIdeDistribution.kt\ncom/intellij/ide/starter/ide/LinuxIdeDistribution\n*L\n62#1:114,11\n66#1:125,2\n*E\n"})
public final class LinuxIdeDistribution
extends IdeDistribution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_DISPLAY_RESOLUTION = "1920x1080";
    @NotNull
    public static final String XVFB_TOOL_NAME = "xvfb-run";
    @NotNull
    private static final Lazy<String> xvfbRunTool$delegate = LazyKt.lazy(LinuxIdeDistribution::xvfbRunTool_delegate$lambda$0);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InstalledIde installIde(@NotNull Path unpackDir, @NotNull String executableFileName) {
        Object v7;
        String build;
        String productCode;
        Path appHome2;
        block10: {
            void $this$firstOrNull$iv;
            Iterable<Path> iterable;
            block12: {
                block11: {
                    Object v2;
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)unpackDir, (String)"unpackDir");
                        Intrinsics.checkNotNullParameter((Object)executableFileName, (String)"executableFileName");
                        if (!SystemInfo.isLinux) {
                            boolean bl = false;
                            String string = "Can only run on Linux, docker is possible, please PR";
                            throw new IllegalArgumentException(string.toString());
                        }
                        iterable = FileSystem.INSTANCE.listDirectoryEntriesQuietly(unpackDir);
                        if (iterable == null) break block11;
                        Iterable $this$singleOrNull$iv = iterable;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            Path it = (Path)element$iv;
                            boolean bl = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                            if (found$iv) {
                                v2 = null;
                                break block9;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v2 = !found$iv ? null : single$iv;
                    }
                    if ((iterable = (Path)v2) != null) break block12;
                }
                iterable = unpackDir;
            }
            appHome2 = iterable.toAbsolutePath();
            Path path = appHome2.resolve("build.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Pair<String, String> pair = IdeDistribution.Companion.readProductCodeAndBuildNumberFromBuildTxt(path);
            productCode = (String)pair.component1();
            build = (String)pair.component2();
            Object found$iv = new Path[2];
            Intrinsics.checkNotNull((Object)appHome2);
            Path path2 = appHome2.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Intrinsics.checkNotNullExpressionValue((Object)path2.resolve(executableFileName), (String)"resolve(...)");
            Path path3 = appHome2.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Intrinsics.checkNotNullExpressionValue((Object)path3.resolve(executableFileName + ".sh"), (String)"resolve(...)");
            found$iv = CollectionsKt.listOf((Object[])found$iv);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!(Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isExecutable(it))) continue;
                v7 = element$iv;
                break block10;
            }
            v7 = null;
        }
        Path path = v7;
        if (path == null) {
            Path path4 = appHome2.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Path path5 = path4.resolve(executableFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
            Path path6 = appHome2.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            Path path7 = path6.resolve(executableFileName + ".sh");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
            throw new IllegalStateException(("Neither " + path5 + " nor " + path7 + " is executable or exists").toString());
        }
        Path executablePath = path;
        return new InstalledIde(appHome2, build, productCode, executablePath, unpackDir){
            private final Path bundledPluginsDir;
            private final VMOptions vmOptionsFinal;
            private final Path patchedVMOptionsFile;
            private final String build;
            private final OS os;
            private final String productCode;
            private final boolean isFromSources;
            private final Path installationPath;
            final /* synthetic */ Path $appHome;
            final /* synthetic */ String $build;
            final /* synthetic */ String $productCode;
            final /* synthetic */ Path $executablePath;
            final /* synthetic */ Path $unpackDir;
            {
                this.$appHome = $appHome;
                this.$build = $build;
                this.$productCode = $productCode;
                this.$executablePath = $executablePath;
                this.$unpackDir = $unpackDir;
                this.bundledPluginsDir = $appHome.resolve("plugins");
                this.vmOptionsFinal = new VMOptions(this, CollectionsKt.emptyList(), MapsKt.emptyMap());
                this.patchedVMOptionsFile = $appHome.getParent().resolve($appHome.getFileName() + ".vmoptions");
                this.build = $build;
                this.os = OS.Linux;
                this.productCode = $productCode;
                Intrinsics.checkNotNull((Object)$appHome);
                this.installationPath = $appHome;
            }

            public Path getBundledPluginsDir() {
                return this.bundledPluginsDir;
            }

            public VMOptions getVmOptions() {
                return this.vmOptionsFinal;
            }

            public Path getPatchedVMOptionsFile() {
                return this.patchedVMOptionsFile;
            }

            public IDEStartConfig startConfig(VMOptions vmOptions, Path logsDir) {
                Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
                Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
                Path xvfbRunLog = LinuxIdeDistribution.Companion.createXvfbRunLog(logsDir);
                Path path = this.getPatchedVMOptionsFile();
                return new InstalledBackedIDEStartConfig(xvfbRunLog, this.$appHome, vmOptions, this.$executablePath, path){
                    private final List<Path> errorDiagnosticFiles;
                    private final Path workDir;
                    private final List<String> commandLine;
                    {
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($super_call_param$1, $vmOptions);
                        this.errorDiagnosticFiles = CollectionsKt.listOf((Object)$xvfbRunLog);
                        this.workDir = $appHome;
                        this.commandLine = CollectionsKt.plus((Collection)LinuxIdeDistribution.Companion.linuxCommandLine($xvfbRunLog, $vmOptions), (Object)((Object)$executablePath.toAbsolutePath()).toString());
                    }

                    public List<Path> getErrorDiagnosticFiles() {
                        return this.errorDiagnosticFiles;
                    }

                    public Path getWorkDir() {
                        return this.workDir;
                    }

                    public List<String> getCommandLine() {
                        return this.commandLine;
                    }
                };
            }

            public String getBuild() {
                return this.build;
            }

            public OS getOs() {
                return this.os;
            }

            public String getProductCode() {
                return this.productCode;
            }

            public boolean isFromSources() {
                return this.isFromSources;
            }

            public Path getInstallationPath() {
                return this.installationPath;
            }

            public String toString() {
                return "IDE{" + this.$productCode + ", " + this.$build + ", " + this.getOs() + ", home=" + this.$unpackDir + "}";
            }

            public Object resolveAndDownloadTheSameJDK(Continuation<? super Path> $completion) {
                Path jbrHome = this.$appHome.resolve("jbr");
                Intrinsics.checkNotNull((Object)jbrHome);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(jbrHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    boolean bl = false;
                    String string = "JbrHome is not found under " + jbrHome;
                    throw new IllegalArgumentException(string.toString());
                }
                String jbrFullVersion = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)JvmUtils.INSTANCE.callJavaVersion(jbrHome), (String)"build ", null, (int)2, null), (String)")", null, (int)2, null);
                LoggingKt.logOutput((String)("Found following " + jbrFullVersion + " in the product: " + this.$productCode + " " + this.$build));
                return jbrHome;
            }
        };
    }

    private static final String xvfbRunTool_delegate$lambda$0() {
        String string = System.getProperty("user.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path homePath = path.toAbsolutePath();
        Object[] objectArray = new String[]{"which", XVFB_TOOL_NAME};
        ProcessExecutor.start$default(new ProcessExecutor(XVFB_TOOL_NAME, homePath, DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS), null, CollectionsKt.listOf((Object[])objectArray), null, new ExecOutputRedirect.ToStdOut("xvfb-run-out"), new ExecOutputRedirect.ToStdOut("xvfb-run-err"), null, null, null, false, 0, false, false, 32552, null), false, 1, null);
        return XVFB_TOOL_NAME;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/starter/ide/LinuxIdeDistribution$Companion;", "", "<init>", "()V", "DEFAULT_DISPLAY_RESOLUTION", "", "XVFB_TOOL_NAME", "xvfbRunTool", "getXvfbRunTool", "()Ljava/lang/String;", "xvfbRunTool$delegate", "Lkotlin/Lazy;", "linuxCommandLine", "", "xvfbRunLog", "Ljava/nio/file/Path;", "vmOptions", "Lcom/intellij/ide/starter/models/VMOptions;", "createXvfbRunLog", "logsDir", "intellij.tools.ide.starter"})
    public static final class Companion {
        private Companion() {
        }

        private final String getXvfbRunTool() {
            Lazy lazy = xvfbRunTool$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final List<String> linuxCommandLine(@NotNull Path xvfbRunLog, @NotNull VMOptions vmOptions) {
            List list;
            Intrinsics.checkNotNullParameter((Object)xvfbRunLog, (String)"xvfbRunLog");
            Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
            if (System.getenv("DISPLAY") != null || vmOptions.getEnvironmentVariables().get("DISPLAY") != null || vmOptions.hasHeadlessMode()) {
                list = CollectionsKt.emptyList();
            } else {
                Object[] objectArray = new String[]{this.getXvfbRunTool(), "--error-file=" + xvfbRunLog.toAbsolutePath(), "--server-args=-ac -screen 0 1920x1080x24", "--auto-servernum", "--server-num=88"};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
            return list;
        }

        @NotNull
        public final Path createXvfbRunLog(@NotNull Path logsDir) {
            Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
            Path logTxt = logsDir.resolve("xvfb-log.txt");
            Intrinsics.checkNotNull((Object)logTxt);
            Files.deleteIfExists(logTxt);
            Path path = Files.createFile(logTxt, new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createFile(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

