/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide.installer;

import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.ide.IdeArchiveExtractor;
import com.intellij.ide.starter.ide.IdeDistributionFactory;
import com.intellij.ide.starter.ide.IdeInstaller;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.ide.installer.AndroidStudioReleaseInfo;
import com.intellij.ide.starter.models.IdeInfo;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.ide.starter.utils.XmlBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;
import org.w3c.dom.Document;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010\u00b2\u0006\n\u0010\u0011\u001a\u00020\u0012X\u008a\u0084\u0002"}, d2={"Lcom/intellij/ide/starter/ide/installer/AndroidInstaller;", "Lcom/intellij/ide/starter/ide/IdeInstaller;", "<init>", "()V", "downloadAndroidStudio", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Ljava/io/File;", "buildNumber", "", "install", "Lcom/intellij/ide/starter/ide/InstalledIde;", "ideInfo", "Lcom/intellij/ide/starter/models/IdeInfo;", "(Lcom/intellij/ide/starter/models/IdeInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.tools.ide.starter", "globalPaths", "Lcom/intellij/ide/starter/path/GlobalPaths;"})
@SourceDebugExtension(value={"SMAP\nAndroidInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidInstaller.kt\ncom/intellij/ide/starter/ide/installer/AndroidInstaller\n+ 2 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 3 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,119:1\n180#2:120\n527#2:122\n83#3:121\n83#3:123\n*S KotlinDebug\n*F\n+ 1 AndroidInstaller.kt\ncom/intellij/ide/starter/ide/installer/AndroidInstaller\n*L\n87#1:120\n116#1:122\n87#1:121\n116#1:123\n*E\n"})
public final class AndroidInstaller
implements IdeInstaller {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

    @NotNull
    public final Pair<Path, File> downloadAndroidStudio(@NotNull String buildNumber) {
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        OS oS = OS.CURRENT;
        Intrinsics.checkNotNullExpressionValue((Object)oS, (String)"CURRENT");
        String downloadUrl = Companion.createDownloadableUrl(buildNumber, oS);
        String[] stringArray = new String[]{"/"};
        String asFileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)downloadUrl, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        DIAware $this$instance_u24default$iv = (DIAware)DiContainerKt.getDi();
        Object tag$iv = null;
        boolean $i$f$instance = false;
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<GlobalPaths>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        Lazy globalPaths$delegate = DIAwareKt.Instance((DIAware)$this$instance_u24default$iv, (TypeToken)((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, GlobalPaths.class)), tag$iv).provideDelegate(null, $$delegatedProperties[0]);
        Path zipFile = AndroidInstaller.downloadAndroidStudio$lambda$0((Lazy<? extends GlobalPaths>)globalPaths$delegate).getLocalCacheDirectoryFor("android-studio").resolve(asFileName);
        Intrinsics.checkNotNull((Object)zipFile);
        HttpClient.downloadIfMissing-Wn2Vu4Y$default(HttpClient.INSTANCE, downloadUrl, zipFile, 0L, 0L, 12, null);
        Path path = AndroidInstaller.downloadAndroidStudio$lambda$0((Lazy<? extends GlobalPaths>)globalPaths$delegate).getLocalCacheDirectoryFor("builds").resolve("AI-" + buildNumber);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path installDir = path;
        FileSystem.INSTANCE.deleteRecursivelyQuietly(installDir);
        File installerFile = zipFile.toFile();
        return new Pair((Object)installDir, (Object)installerFile);
    }

    @Override
    @Nullable
    public Object install(@NotNull IdeInfo ideInfo, @NotNull Continuation<? super Pair<String, ? extends InstalledIde>> $completion) {
        Path path;
        Pair<Path, File> pair;
        Object installDir = null;
        Object installerFile = null;
        if (StringsKt.isBlank((CharSequence)ideInfo.getBuildNumber())) {
            throw new IllegalArgumentException("Build is not specified, please, provide buildNumber as IdeProductProvider.AI.copy(buildNumber = \"2023.1.1.28\")");
        }
        Pair<Path, File> it = pair = this.downloadAndroidStudio(ideInfo.getBuildNumber());
        boolean bl = false;
        installDir = it.getFirst();
        installerFile = it.getSecond();
        File file = (File)installerFile;
        File file2 = ((Path)installDir).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        IdeArchiveExtractor.INSTANCE.unpackIdeIfNeeded(file, file2);
        boolean bl2 = it = !SystemInfo.isMac;
        if (it) {
            path = ((Path)installDir).resolve("android-studio");
        } else if (!it) {
            path = (Path)installDir;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Path installationPath = path;
        DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
        Object tag$iv = null;
        boolean $i$f$instance = false;
        DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<IdeDistributionFactory>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        IdeDistributionFactory ideDistributionFactory = (IdeDistributionFactory)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, IdeDistributionFactory.class), tag$iv);
        File file3 = installationPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        InstalledIde ide = ideDistributionFactory.installIDE(file3, ideInfo.getExecutableFileName());
        return new Pair((Object)ide.getBuild(), (Object)ide);
    }

    private static final GlobalPaths downloadAndroidStudio$lambda$0(Lazy<? extends GlobalPaths> $globalPaths$delegate) {
        Lazy<? extends GlobalPaths> lazy = $globalPaths$delegate;
        return (GlobalPaths)lazy.getValue();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(AndroidInstaller.class, "globalPaths", "<v#0>", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/starter/ide/installer/AndroidInstaller$Companion;", "", "<init>", "()V", "fetchLatestMajorReleaseVersion", "Lcom/intellij/ide/starter/ide/installer/AndroidStudioReleaseInfo;", "createDownloadableUrl", "", "buildNumber", "os", "Lcom/intellij/util/system/OS;", "intellij.tools.ide.starter"})
    @SourceDebugExtension(value={"SMAP\nAndroidInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidInstaller.kt\ncom/intellij/ide/starter/ide/installer/AndroidInstaller$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final AndroidStudioReleaseInfo fetchLatestMajorReleaseVersion() {
            URI uri = URI.create("https://dl.google.com/android/studio/patches/updates.xml");
            Closeable closeable = uri.toURL().openStream();
            Throwable throwable = null;
            try {
                String string;
                Integer patchNumber;
                Object object3;
                Object it;
                String rawVersion;
                XPath xPath;
                Document doc;
                block12: {
                    block11: {
                        Object $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240;
                        InputStream input = (InputStream)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)input);
                        doc = XmlBuilder.INSTANCE.parse(input);
                        xPath = XPathFactory.newInstance().newXPath();
                        Object object2 = Companion;
                        try {
                            String string2;
                            $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240 = object2;
                            boolean object3 = false;
                            String it2 = string2 = xPath.evaluate("/products/product/channel[@status='release']/build[1]/@version", doc);
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)it2);
                            $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240 = Result.constructor-impl((Object)(!StringsKt.isBlank((CharSequence)it2) ? string2 : null));
                        }
                        catch (Throwable object3) {
                            $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object3));
                        }
                        object2 = $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240;
                        rawVersion = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                        if (rawVersion == null) break block11;
                        it = rawVersion;
                        boolean bl3 = false;
                        MatchResult matchResult = Regex.find$default((Regex)new Regex("\\d+\\.\\d+\\.\\d+"), (CharSequence)((CharSequence)it), (int)0, (int)2, null);
                        $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240 = matchResult != null ? matchResult.getValue() : null;
                        if ($this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240 == null) break block11;
                        Object it3 = it = $this$fetchLatestMajorReleaseVersion_u24lambda_u240_u240;
                        boolean bl4 = false;
                        Object object4 = object3 = ((CharSequence)it3).length() > 0 ? it : null;
                        if (object3 != null) break block12;
                    }
                    throw new IllegalStateException("Failed to get Android Studio build number".toString());
                }
                Object majorVersion = object3;
                object3 = Regex.find$default((Regex)new Regex("Patch (\\d+)", RegexOption.IGNORE_CASE), (CharSequence)rawVersion, (int)0, (int)2, null);
                Integer n = patchNumber = object3 != null && (it = object3.getGroupValues()) != null && (string = (String)CollectionsKt.getOrNull((List)it, (int)1)) != null ? StringsKt.toIntOrNull((String)string) : null;
                Object version = n == null ? majorVersion : (String)majorVersion + "." + n;
                String it4 = string = xPath.evaluate("/products/product/channel[@status='release']/build[1]/@number", doc);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it4);
                String string3 = !StringsKt.isBlank((CharSequence)it4) ? string : null;
                if (string3 == null) {
                    boolean bl5 = false;
                    String string4 = "Build number is not specified for Android Studio " + (String)version;
                    throw new IllegalArgumentException(string4.toString());
                }
                String buildNumber = string3;
                AndroidStudioReleaseInfo androidStudioReleaseInfo = new AndroidStudioReleaseInfo((String)version, (String)majorVersion, buildNumber);
                return androidStudioReleaseInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        public final String createDownloadableUrl(@NotNull String buildNumber, @NotNull OS os) {
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            Intrinsics.checkNotNullParameter((Object)os, (String)"os");
            String ext = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
                case 1 -> "-windows.zip";
                case 2 -> {
                    if (CpuArch.isArm64()) {
                        yield "-mac_arm.dmg";
                    }
                    yield "-mac.dmg";
                }
                case 3 -> "-linux.tar.gz";
                default -> throw new IllegalStateException("Not supported OS".toString());
            };
            String path = WhenMappings.$EnumSwitchMapping$0[os.ordinal()] == 2 ? "install" : "ide-zips";
            return "https://redirector.gvt1.com/edgedl/android/studio/" + path + "/" + buildNumber + "/android-studio-" + buildNumber + ext;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OS.values().length];
                try {
                    nArray[OS.Windows.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OS.macOS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OS.Linux.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

