/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide.installer;

import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.ide.IdeDistributionFactory;
import com.intellij.ide.starter.ide.IdeInstaller;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.ide.installer.IdeInstallerFile;
import com.intellij.ide.starter.models.IdeInfo;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/ide/installer/ExistingIdeInstaller;", "Lcom/intellij/ide/starter/ide/IdeInstaller;", "installedIdePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "install", "Lkotlin/Pair;", "", "Lcom/intellij/ide/starter/ide/InstalledIde;", "ideInfo", "Lcom/intellij/ide/starter/models/IdeInfo;", "(Lcom/intellij/ide/starter/models/IdeInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nExistingIdeInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExistingIdeInstaller.kt\ncom/intellij/ide/starter/ide/installer/ExistingIdeInstaller\n+ 2 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 3 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,57:1\n527#2:58\n83#3:59\n*S KotlinDebug\n*F\n+ 1 ExistingIdeInstaller.kt\ncom/intellij/ide/starter/ide/installer/ExistingIdeInstaller\n*L\n53#1:58\n53#1:59\n*E\n"})
public final class ExistingIdeInstaller
implements IdeInstaller {
    @NotNull
    private final Path installedIdePath;

    public ExistingIdeInstaller(@NotNull Path installedIdePath) {
        Intrinsics.checkNotNullParameter((Object)installedIdePath, (String)"installedIdePath");
        this.installedIdePath = installedIdePath;
    }

    @Override
    @Nullable
    public Object install(@NotNull IdeInfo ideInfo, @NotNull Continuation<? super Pair<String, ? extends InstalledIde>> $completion) {
        IdeInstallerFile ideInstaller = new IdeInstallerFile(this.installedIdePath, "locally-installed-ide");
        Path installDir = GlobalPaths.Companion.getInstance().getLocalCacheDirectoryFor("builds").resolve(ideInfo.getProductCode() + "-" + ideInstaller.getBuildNumber());
        Intrinsics.checkNotNull((Object)installDir);
        FileSystem.INSTANCE.deleteRecursivelyQuietly(installDir);
        Path destDir = installDir.resolve(PathsKt.getName((Path)this.installedIdePath));
        if (SystemInfo.isMac) {
            String taskName = "copy app";
            long l = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
            Map map = MapsKt.emptyMap();
            ExecOutputRedirect.ToStdOut toStdOut = new ExecOutputRedirect.ToStdOut(taskName);
            ExecOutputRedirect.ToStdOut toStdOut2 = new ExecOutputRedirect.ToStdOut(taskName);
            Object[] objectArray = new String[3];
            objectArray[0] = "ditto";
            Path path = this.installedIdePath.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            objectArray[1] = ((Object)path).toString();
            Intrinsics.checkNotNull((Object)destDir);
            Path path2 = destDir.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
            objectArray[2] = ((Object)path2).toString();
            List list = CollectionsKt.listOf((Object[])objectArray);
            ProcessExecutor.start$default(new ProcessExecutor(taskName, null, l, map, list, null, toStdOut2, toStdOut, null, null, null, false, 0, false, false, 32544, null), false, 1, null);
        } else {
            Intrinsics.checkNotNull((Object)destDir);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path = Files.createDirectories(destDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
            PathsKt.copyToRecursively$default((Path)this.installedIdePath, (Path)path, null, (boolean)false, (boolean)true, (int)2, null);
        }
        String string = ideInstaller.getBuildNumber();
        DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
        Object tag$iv = null;
        boolean $i$f$instance = false;
        DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<IdeDistributionFactory>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        IdeDistributionFactory ideDistributionFactory = (IdeDistributionFactory)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, IdeDistributionFactory.class), tag$iv);
        File file = installDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return new Pair((Object)string, (Object)ideDistributionFactory.installIDE(file, ideInfo.getExecutableFileName()));
    }
}

