/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide.installer;

import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.ide.IdeArchiveExtractor;
import com.intellij.ide.starter.ide.IdeDistributionFactory;
import com.intellij.ide.starter.ide.IdeDownloader;
import com.intellij.ide.starter.ide.IdeInstaller;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.ide.installer.IdeInstallerFile;
import com.intellij.ide.starter.models.IdeInfo;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/starter/ide/installer/StandardInstaller;", "Lcom/intellij/ide/starter/ide/IdeInstaller;", "downloader", "Lcom/intellij/ide/starter/ide/IdeDownloader;", "customInstallersDownloadDirectory", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/ide/starter/ide/IdeDownloader;Ljava/nio/file/Path;)V", "getDownloader", "()Lcom/intellij/ide/starter/ide/IdeDownloader;", "getCustomInstallersDownloadDirectory", "()Ljava/nio/file/Path;", "install", "Lkotlin/Pair;", "", "Lcom/intellij/ide/starter/ide/InstalledIde;", "ideInfo", "Lcom/intellij/ide/starter/models/IdeInfo;", "(Lcom/intellij/ide/starter/models/IdeInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nStandardInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardInstaller.kt\ncom/intellij/ide/starter/ide/installer/StandardInstaller\n+ 2 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 3 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,44:1\n527#2:45\n527#2:47\n83#3:46\n83#3:48\n*S KotlinDebug\n*F\n+ 1 StandardInstaller.kt\ncom/intellij/ide/starter/ide/installer/StandardInstaller\n*L\n21#1:45\n42#1:47\n21#1:46\n42#1:48\n*E\n"})
public final class StandardInstaller
implements IdeInstaller {
    @NotNull
    private final IdeDownloader downloader;
    @Nullable
    private final Path customInstallersDownloadDirectory;

    public StandardInstaller(@NotNull IdeDownloader downloader, @Nullable Path customInstallersDownloadDirectory) {
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        this.downloader = downloader;
        this.customInstallersDownloadDirectory = customInstallersDownloadDirectory;
    }

    public /* synthetic */ StandardInstaller(IdeDownloader ideDownloader, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
            Object tag$iv = null;
            boolean $i$f$instance = false;
            DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
            boolean $i$f$generic = false;
            JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<IdeDownloader>(){}.getSuperType());
            Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
            ideDownloader = (IdeDownloader)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, IdeDownloader.class), tag$iv);
        }
        if ((n & 2) != 0) {
            path = null;
        }
        this(ideDownloader, path);
    }

    @Override
    @NotNull
    public IdeDownloader getDownloader() {
        return this.downloader;
    }

    @Nullable
    public final Path getCustomInstallersDownloadDirectory() {
        return this.customInstallersDownloadDirectory;
    }

    @Override
    @Nullable
    public Object install(@NotNull IdeInfo ideInfo, @NotNull Continuation<? super Pair<String, ? extends InstalledIde>> $completion) {
        Path path = GlobalPaths.Companion.getInstance().getInstallersDirectory().resolve(ideInfo.getProductCode());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
        Path installersDirectory = path2;
        Path path3 = this.customInstallersDownloadDirectory;
        if (path3 == null) {
            path3 = installersDirectory;
        }
        Path installersDownloadDirectory = path3;
        IdeInstallerFile ideInstaller = this.getDownloader().downloadIdeInstaller(ideInfo, installersDownloadDirectory);
        Path path4 = GlobalPaths.Companion.getInstance().getLocalCacheDirectoryFor("builds").resolve(ideInfo.getProductCode() + "-" + ideInstaller.getBuildNumber());
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        Path installDir = path4;
        if (Intrinsics.areEqual((Object)ideInstaller.getBuildNumber(), (Object)"SNAPSHOT")) {
            LoggingKt.logOutput((String)("Cleaning up SNAPSHOT IDE installation " + installDir));
            FileSystem.INSTANCE.deleteRecursivelyQuietly(installDir);
        }
        File file = ideInstaller.getInstallerFile().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = installDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        IdeArchiveExtractor.INSTANCE.unpackIdeIfNeeded(file, file2);
        String string = ideInstaller.getBuildNumber();
        DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
        Object tag$iv = null;
        boolean $i$f$instance = false;
        DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<IdeDistributionFactory>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        IdeDistributionFactory ideDistributionFactory = (IdeDistributionFactory)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, IdeDistributionFactory.class), tag$iv);
        File file3 = installDir.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        return new Pair((Object)string, (Object)ideDistributionFactory.installIDE(file3, ideInfo.getExecutableFileName()));
    }

    public StandardInstaller() {
        this(null, null, 3, null);
    }
}

