/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0011\u001a\u00020\u0007H\u0096\u0080\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/starter/models/IDEStartupReports;", "", "startupReportsDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "time", "", "getTime", "()Ljava/lang/String;", "statsJSON", "getStatsJSON", "()Ljava/nio/file/Path;", "statsObject", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getStatsObject", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "toString", "intellij.tools.ide.starter"})
public final class IDEStartupReports {
    @NotNull
    private final String time;
    @NotNull
    private final Path statsJSON;

    public IDEStartupReports(@NotNull Path startupReportsDir) {
        Intrinsics.checkNotNullParameter((Object)startupReportsDir, (String)"startupReportsDir");
        String string = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        this.time = string;
        Path path = startupReportsDir.resolve("startup-stats-" + this.time + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.statsJSON = path;
    }

    @NotNull
    public final String getTime() {
        return this.time;
    }

    @NotNull
    public final Path getStatsJSON() {
        return this.statsJSON;
    }

    @NotNull
    public final ObjectNode getStatsObject() {
        JsonNode jsonNode = new ObjectMapper().readTree(this.statsJSON.toFile());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        return (ObjectNode)jsonNode;
    }

    @NotNull
    public String toString() {
        return "IDEStartupReports(statsJSON=" + this.statsJSON + ")";
    }
}

