/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.models;

import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.models.IDEStartupReports;
import com.intellij.ide.starter.models.VMOptionsDiff;
import com.intellij.ide.starter.models.VMTrace;
import com.intellij.ide.starter.path.IDEDataPaths;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.JvmUtils;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.tools.ide.performanceTesting.commands.MarshallableCommand;
import com.intellij.tools.ide.performanceTesting.commands.SdkObject;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b>\b\u0086\b\u0018\u0000 \u0098\u00012\u00020\u0001:\u0002\u0098\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\n\u0010\u000b\u001a\u00020\u0006H\u0096\u0080\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0014J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0015J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u001a\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00062\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010\u001f\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020\u0010J\u001c\u0010!\u001a\u00020\u00102\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130#H\u0002J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0016\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0016J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010-\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0016J\u000e\u00106\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0016J\u000e\u00107\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0016J\u0006\u00108\u001a\u00020\u0010J'\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;2\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060=\"\u00020\u0006\u00a2\u0006\u0002\u0010>J'\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u00062\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060=\"\u00020\u0006\u00a2\u0006\u0002\u0010?J\u0006\u0010@\u001a\u00020\u0010J\u001a\u0010A\u001a\u00020\u00102\b\b\u0002\u0010B\u001a\u00020\u00142\b\b\u0002\u0010C\u001a\u00020\u0013J\u0006\u0010D\u001a\u00020\u0010J\u0006\u0010E\u001a\u00020\u0010J\u0006\u0010F\u001a\u00020\u0010J\u0006\u0010G\u001a\u00020\u0013J\u0006\u0010H\u001a\u00020\u0010J\u0006\u0010I\u001a\u00020\u0013J\u0006\u0010J\u001a\u00020\u0010J\u0006\u0010K\u001a\u00020\u0010J\u0015\u0010L\u001a\u00020\u00102\u0006\u0010M\u001a\u00020N\u00a2\u0006\u0004\bO\u0010PJ\u0006\u0010Q\u001a\u00020\u0010J\u0006\u0010R\u001a\u00020\u0010J\u0006\u0010S\u001a\u00020\u0010J\u0006\u0010T\u001a\u00020\u0010J\u000e\u0010U\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\u0014J$\u0010W\u001a\u00020\u00102\u0006\u0010X\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZJ\u001e\u0010W\u001a\u00020\u00102\u0006\u0010X\u001a\u00020\u00062\u0006\u0010/\u001a\u0002002\u0006\u0010\\\u001a\u00020\u0006J\u0006\u0010]\u001a\u00020\u0010J\u0010\u0010^\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0006\u0010_\u001a\u00020\u0010J\u0006\u0010`\u001a\u00020\u0010J\u000e\u0010a\u001a\u00020\u00102\u0006\u0010b\u001a\u00020\u0016J\u000e\u0010c\u001a\u00020\u00102\u0006\u0010d\u001a\u00020\u0016J\u000e\u0010e\u001a\u00020\u00102\u0006\u0010d\u001a\u00020\u0016J\u000e\u0010f\u001a\u00020\u00102\u0006\u0010g\u001a\u00020\u0014J\u000e\u0010h\u001a\u00020\u00102\u0006\u0010i\u001a\u00020\u0014J\u0006\u0010j\u001a\u00020\u0010J\u0006\u0010k\u001a\u00020\u0010J\u000e\u0010l\u001a\u00020\u00102\u0006\u0010m\u001a\u00020\u0016J\u0006\u0010n\u001a\u00020\u0010J\u0006\u0010o\u001a\u00020\u0010J\u0006\u0010p\u001a\u00020\u0010J\u0006\u0010q\u001a\u00020\u0010J\u000e\u0010r\u001a\u00020\u00102\u0006\u0010i\u001a\u00020\u0014J\u000e\u0010s\u001a\u00020\u00102\u0006\u0010t\u001a\u00020\u0014J\u0010\u0010u\u001a\u00020\u00102\u0006\u0010v\u001a\u00020\u0006H\u0007J\u0006\u0010w\u001a\u00020\u0010J\u0010\u0010x\u001a\u00020\u00102\b\b\u0002\u0010y\u001a\u00020\u0014J\u0010\u0010z\u001a\u00020\u00102\b\b\u0002\u0010{\u001a\u00020\u0013J\u0010\u0010|\u001a\u00020\u00102\b\b\u0002\u0010{\u001a\u00020\u0013J\u0010\u0010}\u001a\u00020\u00102\b\b\u0002\u0010}\u001a\u00020\u0013J\u0010\u0010~\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u007f\u001a\u00020\u0010J\u0011\u0010\u0080\u0001\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0081\u0001\u001a\u00020\u00102\u0007\u0010\u0082\u0001\u001a\u00020\u0016J\u0010\u0010\u0083\u0001\u001a\u00020\u00132\u0007\u0010\u0084\u0001\u001a\u00020\u0006J\u0010\u0010\u0085\u0001\u001a\u00020\u00062\u0007\u0010\u0084\u0001\u001a\u00020\u0006J\u0007\u0010\u0086\u0001\u001a\u00020\u0013J\u0007\u0010\u0087\u0001\u001a\u00020\u0010J\u0007\u0010\u0088\u0001\u001a\u00020\u0010J\u0007\u0010\u0089\u0001\u001a\u00020\u0010J\u0007\u0010\u008a\u0001\u001a\u00020\u0010J\u0010\u0010\u008b\u0001\u001a\u00020\u00102\u0007\u0010\u008c\u0001\u001a\u00020\u0014J\u0010\u0010\u008d\u0001\u001a\u00020\u00102\u0007\u0010\u008e\u0001\u001a\u00020\u0016J\u0007\u0010\u008f\u0001\u001a\u00020\u0010J\u0007\u0010\u0090\u0001\u001a\u00020\u0010J\n\u0010\u0091\u0001\u001a\u00020\u0003H\u00c2\u0003J\u0010\u0010\u0092\u0001\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J\u0016\u0010\u0093\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bH\u00c2\u0003J:\u0010\u0094\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0001J\u0016\u0010\u0095\u0001\u001a\u00020\u00132\t\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\u000b\u0010\u0097\u0001\u001a\u00020\u0014H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0099\u0001"}, d2={"Lcom/intellij/ide/starter/models/VMOptions;", "", "ide", "Lcom/intellij/ide/starter/ide/InstalledIde;", "data", "", "", "env", "", "<init>", "(Lcom/intellij/ide/starter/ide/InstalledIde;Ljava/util/List;Ljava/util/Map;)V", "toString", "environmentVariables", "getEnvironmentVariables", "()Ljava/util/Map;", "addSystemProperty", "", "key", "value", "", "", "", "Ljava/nio/file/Path;", "addSystemPropertyValue", "removeSystemProperty", "clearSystemProperty", "addLine", "line", "filterPrefix", "removeLine", "removeProfilerAgents", "removeAsyncAgent", "removeYourkitAgent", "filterKeys", "toRemove", "Lkotlin/Function1;", "setJavaHome", "sdkObject", "Lcom/intellij/tools/ide/performanceTesting/commands/SdkObject;", "withEnv", "writeIntelliJVmOptionFile", "path", "diffIntelliJVmOptionFile", "Lcom/intellij/ide/starter/models/VMOptionsDiff;", "theFile", "writeJavaArgsFile", "overrideDirectories", "paths", "Lcom/intellij/ide/starter/path/IDEDataPaths;", "enableStartupPerformanceLog", "perf", "Lcom/intellij/ide/starter/models/IDEStartupReports;", "enableClassLoadingReport", "filePath", "enableVmTraceClassLoadingReport", "enableExitMetrics", "enableVerboseOpenTelemetry", "configureLoggers", "logLevel", "Lcom/intellij/openapi/diagnostic/LogLevel;", "categories", "", "(Lcom/intellij/openapi/diagnostic/LogLevel;[Ljava/lang/String;)V", "(Ljava/lang/String;[Ljava/lang/String;)V", "dropDebug", "debug", "port", "suspend", "profileBuildToolDaemon", "collectingGradleDaemonThreadDump", "inHeadlessMode", "hasHeadlessMode", "inUnitTestMode", "hasUnitTestMode", "disableStartupDialogs", "disableNewUsersOnboardingDialogue", "setFreezeReportingInterval", "interval", "Lkotlin/time/Duration;", "setFreezeReportingInterval-LRDsOJo", "(J)V", "disableFreezeReportingProfiling", "takeScreenshotsPeriodically", "setAdditionalRegistryKeysIfNeeded", "skipRefactoringDialogs", "setJcefJsQueryPoolSize", "size", "installTestScript", "testName", "commands", "", "Lcom/intellij/tools/ide/performanceTesting/commands/MarshallableCommand;", "scriptText", "setFlagIntegrationTests", "setIdeStartupDialogEnabled", "setNeverShowInitConfigModal", "setFatalErrorNotificationEnabled", "setSnapshotPath", "snapshotsDir", "withJvmCrashLogDirectory", "directory", "withHeapDumpOnOutOfMemoryDirectory", "withXmx", "sizeMb", "withActiveProcessorCount", "count", "withClassFileVerification", "withG1GC", "withGCLogs", "gcLogFile", "withEpsilonGC", "withJitCompilationLog", "withTieredCompilation", "withNoTieredCompilation", "withCICompilerCount", "withTier0ProfilingStartPercentage", "percentage", "withC1OnlyBeforeCall", "name", "withCompilationLogs", "setOpenTelemetryMaxFilesNumber", "maxFilesNumber", "disableAutoImport", "disabled", "disableLoadShellEnv", "executeRightAfterIdeOpened", "skipIndicesInitialization", "doNotDisablePaidPluginsOnStartup", "doRefreshAfterJpsLibraryDownloaded", "setRuntimeModuleRepository", "installationDirectory", "hasOption", "option", "getOptionValue", "isUnderDebug", "enforceSplash", "enforceNoSplash", "removeSystemClassLoader", "addArchiveClassesAtExitIfNecessary", "setLockingMode", "mode", "addSharedArchiveFile", "pathToArchive", "disableGotItTooltips", "disableNativeFileChooser", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nVMOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMOptions.kt\ncom/intellij/ide/starter/models/VMOptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,461:1\n777#2:462\n873#2,2:463\n777#2:465\n873#2,2:466\n832#2:468\n862#2:469\n863#2:471\n832#2:472\n862#2,2:473\n832#2:475\n862#2,2:476\n832#2:478\n862#2,2:479\n832#2:481\n862#2,2:482\n832#2:484\n862#2,2:485\n1807#2,3:487\n1807#2,3:490\n1915#2,2:493\n1807#2,3:495\n1915#2,2:498\n1807#2,3:500\n296#2,2:503\n1#3:470\n*S KotlinDebug\n*F\n+ 1 VMOptions.kt\ncom/intellij/ide/starter/models/VMOptions\n*L\n74#1:462\n74#1:463,2\n75#1:465\n75#1:466,2\n96#1:468\n96#1:469\n96#1:471\n104#1:472\n104#1:473,2\n119#1:475\n119#1:476,2\n123#1:478\n123#1:479,2\n127#1:481\n127#1:482,2\n193#1:484\n193#1:485,2\n221#1:487,3\n224#1:490,3\n253#1:493,2\n410#1:495,3\n413#1:498,2\n421#1:500,3\n436#1:503,2\n*E\n"})
public final class VMOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InstalledIde ide;
    @NotNull
    private List<String> data;
    @NotNull
    private Map<String, String> env;
    @NotNull
    public static final String ALLOW_SKIPPING_FULL_SCANNING_ON_STARTUP_OPTION = "full.scanning.on.startup.can.be.skipped";

    public VMOptions(@NotNull InstalledIde ide, @NotNull List<String> data, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)ide, (String)"ide");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        this.ide = ide;
        this.data = data;
        this.env = env;
    }

    @NotNull
    public final List<String> data() {
        return CollectionsKt.toList((Iterable)this.data);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("VMOptions{").append('\n');
        $this$toString_u24lambda_u240.append("  env=" + this.env).append('\n');
        for (String line : this.data) {
            $this$toString_u24lambda_u240.append("  " + line).append('\n');
        }
        $this$toString_u24lambda_u240.append("} // VMOptions").append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public final Map<String, String> getEnvironmentVariables() {
        return this.env;
    }

    public final void addSystemProperty(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addSystemProperty(key, String.valueOf(value));
    }

    public final void addSystemProperty(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addSystemProperty(key, String.valueOf(value));
    }

    public final void addSystemProperty(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.addSystemProperty(key, String.valueOf(value));
    }

    public final void addSystemProperty(@NotNull String key, @NotNull Path value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addSystemProperty(key, ((Object)value.toAbsolutePath()).toString());
    }

    public final void addSystemProperty(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LoggingKt.logOutput((String)("Setting IDE system property: [" + key + "=" + value + "]"));
        this.addLine("-D" + key + "=" + value, "-D" + key + "=");
    }

    /*
     * WARNING - void declaration
     */
    private final void addSystemPropertyValue(String key, String value) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.data;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("-D" + key), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (((List)destination$iv$iv).size() == 1) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = this.data;
            boolean $i$f$filter22 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)("-D" + key), (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            String oldLine = (String)((List)destination$iv$iv2).get(0);
            String[] $i$f$filter22 = new String[]{"="};
            String oldValue = (String)StringsKt.split$default((CharSequence)oldLine, (String[])$i$f$filter22, (boolean)false, (int)0, (int)6, null).get(1);
            String updatedValue = oldValue + "," + value;
            LoggingKt.logOutput((String)("Updating system property: [" + key + "=" + updatedValue + "]"));
            this.addSystemProperty(key, updatedValue);
        } else {
            this.addSystemProperty(key, value);
        }
    }

    public final void removeSystemProperty(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        LoggingKt.logOutput((String)("Removing system property: [" + key + "=" + value + "]"));
        System.clearProperty(key);
        this.removeLine("-D" + key + "=" + value);
    }

    /*
     * WARNING - void declaration
     */
    public final void clearSystemProperty(@NotNull String key) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Iterable iterable = this.data;
        VMOptions vMOptions = this;
        boolean $i$f$filterNot = false;
        void var4_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            boolean match = bl = StringsKt.startsWith$default((String)it, (String)("-D" + key + "="), (boolean)false, (int)2, null);
            boolean bl3 = false;
            if (match) {
                LoggingKt.logOutput((String)("Removing system property: " + StringsKt.removePrefix((String)it, (CharSequence)"-D")));
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vMOptions.data = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void addLine(@NotNull String line, @Nullable String filterPrefix) {
        List list;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (this.data.contains(line)) {
            return;
        }
        VMOptions vMOptions = this;
        if (filterPrefix == null) {
            list = this.data;
        } else {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Iterable iterable = this.data;
            VMOptions vMOptions2 = vMOptions;
            boolean $i$f$filterNot = false;
            void var5_6 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)filterPrefix, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            vMOptions = vMOptions2;
        }
        vMOptions.data = CollectionsKt.plus((Collection)list, (Object)line);
    }

    public static /* synthetic */ void addLine$default(VMOptions vMOptions, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        vMOptions.addLine(string, string2);
    }

    public final void removeLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!this.data.contains(line)) {
            return;
        }
        this.data = CollectionsKt.minus((Iterable)this.data, (Object)line);
    }

    public final void removeProfilerAgents() {
        this.removeAsyncAgent();
        this.removeYourkitAgent();
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAsyncAgent() {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable iterable = this.data;
        VMOptions vMOptions = this;
        boolean $i$f$filterNot = false;
        void var3_4 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"-agentpath:", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"async/libasyncProfiler", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vMOptions.data = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeYourkitAgent() {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable iterable = this.data;
        VMOptions vMOptions = this;
        boolean $i$f$filterNot = false;
        void var3_4 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"-agentpath:", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"yourkit/bin/libyjpagent", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vMOptions.data = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void filterKeys(Function1<? super String, Boolean> toRemove) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable iterable = this.data;
        VMOptions vMOptions = this;
        boolean $i$f$filterNot = false;
        void var4_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            if (((Boolean)toRemove.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vMOptions.data = (List)destination$iv$iv;
    }

    @NotNull
    public final VMOptions setJavaHome(@NotNull SdkObject sdkObject) {
        VMOptions vMOptions;
        Intrinsics.checkNotNullParameter((Object)sdkObject, (String)"sdkObject");
        VMOptions $this$setJavaHome_u24lambda_u240 = vMOptions = this;
        boolean bl = false;
        $this$setJavaHome_u24lambda_u240.withEnv("JAVA_HOME", ((Object)sdkObject.getSdkPath()).toString());
        return vMOptions;
    }

    public final void withEnv(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.env = MapsKt.plus(this.env, (Pair)TuplesKt.to((Object)key, (Object)value));
    }

    public final void writeIntelliJVmOptionFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path;
        Iterable iterable = this.data;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(path2, (Iterable<? extends CharSequence>)iterable, charset, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
        LoggingKt.logOutput((String)("Write vmoptions patch to " + path));
    }

    @NotNull
    public final VMOptionsDiff diffIntelliJVmOptionFile(@NotNull Path theFile) {
        Intrinsics.checkNotNullParameter((Object)theFile, (String)"theFile");
        List<String> loadedOptions = VMOptions.Companion.readIdeVMOptions((InstalledIde)this.ide, (Path)theFile).data;
        return new VMOptionsDiff(this.data, loadedOptions);
    }

    public final void writeJavaArgsFile(@NotNull Path theFile) {
        Intrinsics.checkNotNullParameter((Object)theFile, (String)"theFile");
        JvmUtils.writeJvmArgsFile$default(JvmUtils.INSTANCE, theFile, this.data, null, null, 12, null);
    }

    public final void overrideDirectories(@NotNull IDEDataPaths paths) {
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        this.addSystemProperty("idea.config.path", paths.getConfigDir());
        this.addSystemProperty("idea.system.path", paths.getSystemDir());
        this.addSystemProperty("idea.plugins.path", paths.getPluginsDir());
    }

    public final void enableStartupPerformanceLog(@NotNull IDEStartupReports perf) {
        Intrinsics.checkNotNullParameter((Object)perf, (String)"perf");
        this.addSystemProperty("idea.log.perf.stats.file", perf.getStatsJSON());
    }

    public final void enableClassLoadingReport(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.addSystemProperty("idea.log.class.list.file", filePath);
        this.addSystemProperty("idea.record.classpath.info", "true");
    }

    public final void enableVmTraceClassLoadingReport(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!VMTrace.INSTANCE.isSupported()) {
            return;
        }
        Path vmTraceFile = VMTrace.INSTANCE.getVmTraceFile();
        this.addSystemProperty("idea.log.vmtrace.file", filePath);
        VMOptions.addLine$default(this, "-agentpath:" + vmTraceFile.toAbsolutePath() + "=" + filePath.toAbsolutePath(), null, 2, null);
    }

    public final void enableExitMetrics(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.addSystemProperty("idea.log.exit.metrics.file", filePath);
    }

    public final void enableVerboseOpenTelemetry() {
        this.addSystemProperty("idea.diagnostic.opentelemetry.verbose", true);
    }

    public final void configureLoggers(@NotNull LogLevel logLevel, String ... categories) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)categories, (String)"categories");
        String string = logLevel.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.configureLoggers(string, Arrays.copyOf(categories, categories.length));
    }

    public final void configureLoggers(@NotNull String logLevel, String ... categories) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)categories, (String)"categories");
        if (!(categories.length == 0)) {
            String string = logLevel.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String logLevelName = string;
            this.addSystemPropertyValue("idea.log." + logLevelName + ".categories", ArraysKt.joinToString$default((Object[])categories, (CharSequence)",", null, null, (int)0, null, VMOptions::configureLoggers$lambda$0, (int)30, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dropDebug() {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable iterable = this.data;
        VMOptions vMOptions = this;
        boolean $i$f$filterNot = false;
        void var3_4 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (new Regex("-agentlib:jdwp=transport=dt_socket,server=y,suspend=.,address=.*").matches(charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vMOptions.data = (List)destination$iv$iv;
    }

    public final void debug(int port, boolean suspend) {
        this.dropDebug();
        String suspendKey = suspend ? "y" : "n";
        String configLine = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspendKey + ",address=*:" + port;
        this.addLine(configLine, "-agentlib:jdwp");
    }

    public static /* synthetic */ void debug$default(VMOptions vMOptions, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 5005;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        vMOptions.debug(n, bl);
    }

    public final void profileBuildToolDaemon() {
        this.addSystemProperty("test.build_tool.daemon.profiler", true);
    }

    public final void collectingGradleDaemonThreadDump() {
        this.addSystemProperty("test.build_tool.daemon.threads_dump", true);
    }

    public final void inHeadlessMode() {
        this.addSystemProperty("java.awt.headless", true);
    }

    public final boolean hasHeadlessMode() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.data;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"-Djava.awt.headless=true", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void inUnitTestMode() {
        this.addSystemProperty("idea.is.unit.test", true);
    }

    public final boolean hasUnitTestMode() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.data;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"-Didea.is.unit.test=true", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void disableStartupDialogs() {
        this.addSystemProperty("jb.consents.confirmation.enabled", false);
        this.addSystemProperty("jb.privacy.policy.text", "<!--999.999-->");
        this.addSystemProperty("jb.privacy.policy.ai.assistant.text", "<!--999.999-->");
        this.addSystemProperty("marketplace.eula.reviewed.and.accepted", true);
        this.addSystemProperty("writerside.eula.reviewed.and.accepted", true);
    }

    public final void disableNewUsersOnboardingDialogue() {
        this.addSystemProperty("ide.newUsersOnboarding", false);
    }

    public final void setFreezeReportingInterval-LRDsOJo(long interval) {
        this.addSystemProperty("performance.watcher.unresponsive.interval.ms", Duration.getInWholeMilliseconds-impl((long)interval));
    }

    public final void disableFreezeReportingProfiling() {
        this.addSystemProperty("freeze.reporter.profiling", false);
    }

    public final void takeScreenshotsPeriodically() {
        this.addSystemProperty("ide.performance.screenshot", "heartbeat");
    }

    public final void setAdditionalRegistryKeysIfNeeded() {
        String additionalRegistryKeys = System.getProperty("additional.registry.keys");
        String[] stringArray = (String[])additionalRegistryKeys;
        if (!(stringArray == null || stringArray.length() == 0)) {
            stringArray = new String[]{";"};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)additionalRegistryKeys, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String keyValue = (String)element$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                String key = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)keyValue, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
                String[] stringArray3 = new String[]{"="};
                String value = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)keyValue, (String[])stringArray3, (boolean)false, (int)0, (int)6, null));
                LoggingKt.logOutput((String)("Setting additional registry key: [" + key + "=" + value + "]"));
                this.addSystemProperty(key, value);
            }
        }
    }

    public final void skipRefactoringDialogs() {
        this.addSystemProperty("ide.performance.skip.refactoring.dialogs", "true");
    }

    public final void setJcefJsQueryPoolSize(int size) {
        this.addSystemProperty("ide.browser.jcef.jsQueryPoolSize", String.valueOf(size));
    }

    public final void installTestScript(@NotNull String testName, @NotNull IDEDataPaths paths, @NotNull Iterable<? extends MarshallableCommand> commands) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        String scriptText = CollectionsKt.joinToString$default(commands, (CharSequence)string, null, null, (int)0, null, VMOptions::installTestScript$lambda$0, (int)30, null);
        this.installTestScript(testName, paths, scriptText);
    }

    public final void installTestScript(@NotNull String testName, @NotNull IDEDataPaths paths, @NotNull String scriptText) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)scriptText, (String)"scriptText");
        String scriptFileName = FileSystem.INSTANCE.cleanPathFromSlashes(testName, "_") + ".text";
        Path $this$installTestScript_u24lambda_u241 = path = paths.getSystemDir().resolve(scriptFileName);
        boolean bl = false;
        Path path2 = $this$installTestScript_u24lambda_u241.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Path path3 = path2;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path scriptFile = path;
        Intrinsics.checkNotNull((Object)scriptFile);
        PathsKt.writeText$default((Path)scriptFile, (CharSequence)scriptText, null, (OpenOption[])new OpenOption[0], (int)2, null);
        LoggingKt.logOutput((String)("Test commands to be executed: " + System.lineSeparator() + scriptText));
        this.addSystemProperty("testscript.filename", scriptFile);
        this.addSystemProperty("testscript.must.exist.process.with.non.success.code.on.ide.error", "true");
    }

    public final void setFlagIntegrationTests() {
        this.addSystemProperty("idea.is.integration.test", true);
    }

    public final void setIdeStartupDialogEnabled(boolean value) {
        this.addSystemProperty("intellij.startup.wizard", value);
    }

    public static /* synthetic */ void setIdeStartupDialogEnabled$default(VMOptions vMOptions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        vMOptions.setIdeStartupDialogEnabled(bl);
    }

    public final void setNeverShowInitConfigModal() {
        this.addSystemProperty("idea.initially.ask.config", "never");
    }

    public final void setFatalErrorNotificationEnabled() {
        this.addSystemProperty("idea.fatal.error.notification", true);
    }

    public final void setSnapshotPath(@NotNull Path snapshotsDir) {
        Intrinsics.checkNotNullParameter((Object)snapshotsDir, (String)"snapshotsDir");
        this.addSystemProperty("snapshots.path", snapshotsDir);
    }

    public final void withJvmCrashLogDirectory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.addLine("-XX:ErrorFile=" + directory.toAbsolutePath().resolve("java_error_in_idea_%p.log"), "-XX:ErrorFile=");
    }

    public final void withHeapDumpOnOutOfMemoryDirectory(@NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.addLine("-XX:HeapDumpPath=" + directory.toAbsolutePath().resolve("heap-dump.hprof"), "-XX:HeapDumpPath=");
    }

    public final void withXmx(int sizeMb) {
        this.addLine("-Xmx" + sizeMb + "m", "-Xmx");
    }

    public final void withActiveProcessorCount(int count) {
        this.addLine("-XX:ActiveProcessorCount=" + count, "-XX:ActiveProcessorCount");
    }

    public final void withClassFileVerification() {
        VMOptions.addLine$default(this, "-XX:+UnlockDiagnosticVMOptions", null, 2, null);
        VMOptions.addLine$default(this, "-XX:+BytecodeVerificationLocal", null, 2, null);
    }

    public final void withG1GC() {
        this.filterKeys((Function1<? super String, Boolean>)((Function1)VMOptions::withG1GC$lambda$0));
        this.filterKeys((Function1<? super String, Boolean>)((Function1)VMOptions::withG1GC$lambda$1));
        VMOptions.addLine$default(this, "-XX:+UseG1GC", null, 2, null);
    }

    public final void withGCLogs(@NotNull Path gcLogFile) {
        Intrinsics.checkNotNullParameter((Object)gcLogFile, (String)"gcLogFile");
        VMOptions.addLine$default(this, "-Xlog:gc*:file=" + gcLogFile.toAbsolutePath(), null, 2, null);
    }

    public final void withEpsilonGC() {
        this.filterKeys((Function1<? super String, Boolean>)((Function1)VMOptions::withEpsilonGC$lambda$0));
        this.filterKeys((Function1<? super String, Boolean>)((Function1)VMOptions::withEpsilonGC$lambda$1));
        VMOptions.addLine$default(this, "-XX:+UnlockExperimentalVMOptions", null, 2, null);
        VMOptions.addLine$default(this, "-XX:+UseEpsilonGC", null, 2, null);
        this.addLine("-Xmx16g", "-Xmx");
    }

    public final void withJitCompilationLog() {
        VMOptions.addLine$default(this, "-XX:+UnlockDiagnosticVMOptions", null, 2, null);
        VMOptions.addLine$default(this, "-XX:+LogCompilation", null, 2, null);
    }

    public final void withTieredCompilation() {
        VMOptions.addLine$default(this, "-XX:+TieredCompilation", null, 2, null);
    }

    public final void withNoTieredCompilation() {
        VMOptions.addLine$default(this, "-XX:-TieredCompilation", null, 2, null);
    }

    public final void withCICompilerCount(int count) {
        this.removeLine("-XX:CICompilerCount=2");
        VMOptions.addLine$default(this, "-XX:CICompilerCount=" + count, null, 2, null);
    }

    public final void withTier0ProfilingStartPercentage(int percentage) {
        VMOptions.addLine$default(this, "-XX:Tier0ProfilingStartPercentage=" + percentage, null, 2, null);
    }

    @ApiStatus.Experimental
    public final void withC1OnlyBeforeCall(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        VMOptions.addLine$default(this, "-XX:C1OnlyBeforeCall=" + name, null, 2, null);
    }

    public final void withCompilationLogs() {
        VMOptions.addLine$default(this, "-XX:+UnlockDiagnosticVMOptions", null, 2, null);
        VMOptions.addLine$default(this, "-XX:+LogCompilation", null, 2, null);
    }

    public final void setOpenTelemetryMaxFilesNumber(int maxFilesNumber) {
        this.addSystemProperty("idea.diagnostic.opentelemetry.metrics.max-files-to-keep", maxFilesNumber);
    }

    public static /* synthetic */ void setOpenTelemetryMaxFilesNumber$default(VMOptions vMOptions, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 120;
        }
        vMOptions.setOpenTelemetryMaxFilesNumber(n);
    }

    public final void disableAutoImport(boolean disabled) {
        this.addSystemProperty("external.system.auto.import.disabled", disabled);
    }

    public static /* synthetic */ void disableAutoImport$default(VMOptions vMOptions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        vMOptions.disableAutoImport(bl);
    }

    public final void disableLoadShellEnv(boolean disabled) {
        this.addSystemProperty("ij.load.shell.env", !disabled);
    }

    public static /* synthetic */ void disableLoadShellEnv$default(VMOptions vMOptions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        vMOptions.disableLoadShellEnv(bl);
    }

    public final void executeRightAfterIdeOpened(boolean executeRightAfterIdeOpened) {
        this.addSystemProperty("performance.execute.script.right.after.ide.opened", executeRightAfterIdeOpened);
    }

    public static /* synthetic */ void executeRightAfterIdeOpened$default(VMOptions vMOptions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        vMOptions.executeRightAfterIdeOpened(bl);
    }

    public final void skipIndicesInitialization(boolean value) {
        this.addSystemProperty("idea.skip.indices.initialization", value);
    }

    public static /* synthetic */ void skipIndicesInitialization$default(VMOptions vMOptions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        vMOptions.skipIndicesInitialization(bl);
    }

    public final void doNotDisablePaidPluginsOnStartup() {
        this.addSystemProperty("ide.do.not.disable.paid.plugins.on.startup", true);
    }

    public final void doRefreshAfterJpsLibraryDownloaded(boolean value) {
        this.addSystemProperty("idea.do.refresh.after.jps.library.downloaded", value);
    }

    public static /* synthetic */ void doRefreshAfterJpsLibraryDownloaded$default(VMOptions vMOptions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        vMOptions.doRefreshAfterJpsLibraryDownloaded(bl);
    }

    public final void setRuntimeModuleRepository(@NotNull Path installationDirectory) {
        Intrinsics.checkNotNullParameter((Object)installationDirectory, (String)"installationDirectory");
        Path path = installationDirectory.resolve("modules/module-descriptors.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.addSystemProperty("intellij.platform.runtime.repository.path", ((Object)path).toString());
    }

    public final boolean hasOption(@NotNull String option) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            Iterable $this$any$iv = this.data;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)option, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String getOptionValue(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Iterable $this$forEach$iv = this.data;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)option, (boolean)false, (int)2, null)) continue;
            return StringsKt.replace$default((String)line, (String)("-D" + option + "="), (String)"", (boolean)false, (int)4, null);
        }
        throw new IllegalStateException("There is no such option".toString());
    }

    public final boolean isUnderDebug() {
        boolean bl;
        block3: {
            List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getInputArguments(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.startsWith$default((String)it, (String)"-agentlib:jdwp", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void enforceSplash() {
        VMOptions.addLine$default(this, "-Dsplash=true", null, 2, null);
        VMOptions.addLine$default(this, "-Didea.show.splash.longer=true", null, 2, null);
    }

    public final void enforceNoSplash() {
        VMOptions.addLine$default(this, "-Dnosplash=true", null, 2, null);
    }

    public final void removeSystemClassLoader() {
        this.removeLine("-Djava.system.class.loader=com.intellij.util.lang.PathClassLoader");
    }

    public final void addArchiveClassesAtExitIfNecessary() {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.data;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"-XX:SharedArchiveFile=", (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) {
            return;
        }
        String line = string;
        this.removeLine(line);
        this.dropDebug();
        VMOptions.addLine$default(this, StringsKt.replace$default((String)line, (String)"SharedArchiveFile", (String)"ArchiveClassesAtExit", (boolean)false, (int)4, null), null, 2, null);
    }

    public final void setLockingMode(int mode) {
        VMOptions.addLine$default(this, "-XX:+UnlockExperimentalVMOptions", null, 2, null);
        VMOptions.addLine$default(this, "-XX:LockingMode=" + mode, null, 2, null);
    }

    public final void addSharedArchiveFile(@NotNull Path pathToArchive) {
        Intrinsics.checkNotNullParameter((Object)pathToArchive, (String)"pathToArchive");
        VMOptions.addLine$default(this, "-XX:SharedArchiveFile=" + pathToArchive, null, 2, null);
    }

    public final void disableGotItTooltips() {
        this.addSystemProperty("ide.integration.test.disable.got.it.tooltips", true);
    }

    public final void disableNativeFileChooser() {
        this.addSystemProperty("ide.mac.file.chooser.native", false);
        this.addSystemProperty("ide.win.file.chooser.native", false);
    }

    private final InstalledIde component1() {
        return this.ide;
    }

    private final List<String> component2() {
        return this.data;
    }

    private final Map<String, String> component3() {
        return this.env;
    }

    @NotNull
    public final VMOptions copy(@NotNull InstalledIde ide, @NotNull List<String> data, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)ide, (String)"ide");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        return new VMOptions(ide, data, env);
    }

    public static /* synthetic */ VMOptions copy$default(VMOptions vMOptions, InstalledIde installedIde, List list, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            installedIde = vMOptions.ide;
        }
        if ((n & 2) != 0) {
            list = vMOptions.data;
        }
        if ((n & 4) != 0) {
            map = vMOptions.env;
        }
        return vMOptions.copy(installedIde, list, map);
    }

    public int hashCode() {
        int result2 = this.ide.hashCode();
        result2 = result2 * 31 + ((Object)this.data).hashCode();
        result2 = result2 * 31 + ((Object)this.env).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VMOptions)) {
            return false;
        }
        VMOptions vMOptions = (VMOptions)other;
        if (!Intrinsics.areEqual((Object)this.ide, (Object)vMOptions.ide)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.data, vMOptions.data)) {
            return false;
        }
        return Intrinsics.areEqual(this.env, vMOptions.env);
    }

    private static final CharSequence configureLoggers$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "#" + StringsKt.removePrefix((String)it, (CharSequence)"#");
    }

    private static final CharSequence installTestScript$lambda$0(MarshallableCommand it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.storeToString();
    }

    private static final boolean withG1GC$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"-XX:+UseConcMarkSweepGC");
    }

    private static final boolean withG1GC$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"-XX:+UseG1GC");
    }

    private static final boolean withEpsilonGC$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"-XX:+UseConcMarkSweepGC");
    }

    private static final boolean withEpsilonGC$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"-XX:+UseG1GC");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/starter/models/VMOptions$Companion;", "", "<init>", "()V", "ALLOW_SKIPPING_FULL_SCANNING_ON_STARTUP_OPTION", "", "readIdeVMOptions", "Lcom/intellij/ide/starter/models/VMOptions;", "ide", "Lcom/intellij/ide/starter/ide/InstalledIde;", "file", "Ljava/nio/file/Path;", "intellij.tools.ide.starter"})
    @SourceDebugExtension(value={"SMAP\nVMOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VMOptions.kt\ncom/intellij/ide/starter/models/VMOptions$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,461:1\n1586#2:462\n1661#2,3:463\n777#2:466\n873#2,2:467\n*S KotlinDebug\n*F\n+ 1 VMOptions.kt\ncom/intellij/ide/starter/models/VMOptions$Companion\n*L\n33#1:462\n33#1:463,3\n33#1:466\n33#1:467,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VMOptions readIdeVMOptions(@NotNull InstalledIde ide, @NotNull Path file) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)ide, (String)"ide");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Iterable<Path> iterable = file;
            List<String> list = Files.readAllLines(iterable, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            iterable = list;
            InstalledIde installedIde = ide;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Map map = MapsKt.emptyMap();
            List list2 = (List)destination$iv$iv;
            InstalledIde installedIde2 = installedIde;
            return new VMOptions(installedIde2, list2, map);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

