/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.path;

import com.intellij.ide.starter.ci.CIServer;
import com.intellij.ide.starter.di.DiContainerKt;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0014\u0010\u0016\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0014\u0010\u001c\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/starter/path/GlobalPaths;", "", "checkoutDir", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getCheckoutDir", "()Ljava/nio/file/Path;", "intelliJOutDirectory", "getIntelliJOutDirectory", "artifactsDirectory", "getArtifactsDirectory", "compiledRootDirectory", "getCompiledRootDirectory", "testHomePath", "getTestHomePath", "devServerDirectory", "getDevServerDirectory", "installersDirectory", "getInstallersDirectory", "testsDirectory", "getTestsDirectory", "localCacheDirectory", "getLocalCacheDirectory", "getLocalCacheDirectoryFor", "entity", "", "getCacheDirectoryFor", "cacheDirForProjects", "getCacheDirForProjects", "Companion", "intellij.tools.ide.starter"})
public abstract class GlobalPaths {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path checkoutDir;
    @NotNull
    private final Path intelliJOutDirectory;
    @NotNull
    private final Path artifactsDirectory;
    @NotNull
    private final Path compiledRootDirectory;
    @NotNull
    private final Path testHomePath;
    @NotNull
    private final Path devServerDirectory;
    @NotNull
    private final Path installersDirectory;
    @NotNull
    private final Path testsDirectory;
    @NotNull
    private final Path localCacheDirectory;

    public GlobalPaths(@NotNull Path checkoutDir) {
        Path path;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)checkoutDir, (String)"checkoutDir");
        this.checkoutDir = checkoutDir;
        Path path3 = this.checkoutDir.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        Path path4 = path3;
        Path path5 = path4.resolve("out");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        this.intelliJOutDirectory = path5;
        Path path6 = this.intelliJOutDirectory.resolve("artifacts");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        this.artifactsDirectory = path6;
        boolean bl = CIServer.Companion.getInstance().isBuildRunningOnCI();
        if (bl) {
            Path path7 = this.intelliJOutDirectory.resolve("tests");
            path2 = path7;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
        } else if (!bl) {
            path2 = this.intelliJOutDirectory;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.compiledRootDirectory = path2;
        Path path8 = this.intelliJOutDirectory.resolve("ide-tests");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
        Object object = path8;
        Object[] objectArray = new FileAttribute[]{};
        Path path9 = Files.createDirectories((Path)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"createDirectories(...)");
        this.testHomePath = path9;
        Path path10 = this.intelliJOutDirectory.resolve("dev-run");
        Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"resolve(...)");
        object = path10;
        objectArray = new FileAttribute[]{};
        Path path11 = Files.createDirectories((Path)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"createDirectories(...)");
        this.devServerDirectory = path11;
        Path path12 = this.getTestHomePath().resolve("installers");
        Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path13 = Files.createDirectories(path12, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"createDirectories(...)");
        this.installersDirectory = path13;
        Path path14 = this.getTestHomePath().resolve("tests");
        Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
        Path path15 = Files.createDirectories(path14, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path15, (String)"createDirectories(...)");
        this.testsDirectory = path15;
        if (CIServer.Companion.getInstance().isBuildRunningOnCI() && !((object = (CharSequence)System.getProperty("agent.persistent.cache")) == null || object.length() == 0)) {
            objectArray = new String[]{"test-data-cache"};
            Path path16 = Paths.get(System.getProperty("agent.persistent.cache"), (String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)path16, (String)"get(...)");
            object = path16;
            objectArray = new FileAttribute[]{};
            Path path17 = Files.createDirectories((Path)object, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length));
            path = path17;
            Intrinsics.checkNotNullExpressionValue((Object)path17, (String)"createDirectories(...)");
        } else {
            Path path18 = this.getTestHomePath().resolve("cache");
            Intrinsics.checkNotNullExpressionValue((Object)path18, (String)"resolve(...)");
            FileAttribute[] fileAttributeArray3 = new FileAttribute[]{};
            Path path19 = Files.createDirectories(path18, Arrays.copyOf(fileAttributeArray3, fileAttributeArray3.length));
            path = path19;
            Intrinsics.checkNotNullExpressionValue((Object)path19, (String)"createDirectories(...)");
        }
        this.localCacheDirectory = path;
    }

    @NotNull
    public final Path getCheckoutDir() {
        return this.checkoutDir;
    }

    @NotNull
    public final Path getIntelliJOutDirectory() {
        return this.intelliJOutDirectory;
    }

    @NotNull
    public final Path getArtifactsDirectory() {
        return this.artifactsDirectory;
    }

    @NotNull
    public final Path getCompiledRootDirectory() {
        return this.compiledRootDirectory;
    }

    @NotNull
    public Path getTestHomePath() {
        return this.testHomePath;
    }

    @NotNull
    public Path getDevServerDirectory() {
        return this.devServerDirectory;
    }

    @NotNull
    public final Path getInstallersDirectory() {
        return this.installersDirectory;
    }

    @NotNull
    public final Path getTestsDirectory() {
        return this.testsDirectory;
    }

    @NotNull
    public Path getLocalCacheDirectory() {
        return this.localCacheDirectory;
    }

    @NotNull
    public final Path getLocalCacheDirectoryFor(@NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Path path = this.getLocalCacheDirectory().resolve(entity);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
        return path2;
    }

    @NotNull
    public Path getCacheDirectoryFor(@NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return this.getLocalCacheDirectoryFor(entity);
    }

    @NotNull
    public Path getCacheDirForProjects() {
        return this.getCacheDirectoryFor("projects");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/starter/path/GlobalPaths$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/ide/starter/path/GlobalPaths;", "getInstance", "()Lcom/intellij/ide/starter/path/GlobalPaths;", "intellij.tools.ide.starter"})
    @SourceDebugExtension(value={"SMAP\nGlobalPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPaths.kt\ncom/intellij/ide/starter/path/GlobalPaths$Companion\n+ 2 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 3 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,58:1\n527#2:59\n83#3:60\n*S KotlinDebug\n*F\n+ 1 GlobalPaths.kt\ncom/intellij/ide/starter/path/GlobalPaths$Companion\n*L\n56#1:59\n56#1:60\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GlobalPaths getInstance() {
            DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
            Object tag$iv = null;
            boolean $i$f$instance = false;
            DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
            boolean $i$f$generic = false;
            JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<GlobalPaths>(){}.getSuperType());
            Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
            return (GlobalPaths)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, GlobalPaths.class), tag$iv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

