/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.ci.CIServer;
import com.intellij.ide.starter.ci.teamcity.TeamCityCIServer;
import com.intellij.ide.starter.ci.teamcity.TeamCityClient;
import com.intellij.ide.starter.report.Error;
import com.intellij.ide.starter.report.ErrorType;
import com.intellij.ide.starter.runner.IDERunContext;
import com.intellij.ide.starter.utils.GenerifyKt;
import com.intellij.ide.starter.utils.threadDumpParser.ThreadDumpParser;
import com.intellij.ide.starter.utils.threadDumpParser.ThreadState;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/starter/report/TimeoutAnalyzer;", "", "<init>", "()V", "dialogMethodCalls", "", "", "analyzeTimeout", "Lcom/intellij/ide/starter/report/Error;", "runContext", "Lcom/intellij/ide/starter/runner/IDERunContext;", "detectDialog", "detectIdeNotStarted", "detectIndicatorsNotFinished", "postLastScreenshots", "", "getLastScreenshots", "Ljava/nio/file/Path;", "getLastThreadDump", "getLastCommand", "getIdeaLogs", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nTimeoutAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeoutAnalyzer.kt\ncom/intellij/ide/starter/report/TimeoutAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,163:1\n231#2,2:164\n1807#2,3:166\n1915#2:170\n1916#2:173\n1915#2,2:181\n2045#2,14:183\n1068#2:197\n546#2,6:198\n2045#2,14:204\n1068#2:218\n1#3:169\n1342#4,2:171\n540#5:174\n525#5,6:175\n*S KotlinDebug\n*F\n+ 1 TimeoutAnalyzer.kt\ncom/intellij/ide/starter/report/TimeoutAnalyzer\n*L\n35#1:164,2\n37#1:166,3\n62#1:170\n62#1:173\n89#1:181,2\n119#1:183,14\n128#1:197\n128#1:198,6\n141#1:204,14\n159#1:218\n66#1:171,2\n73#1:174\n73#1:175,6\n*E\n"})
public final class TimeoutAnalyzer {
    @NotNull
    public static final TimeoutAnalyzer INSTANCE = new TimeoutAnalyzer();
    @NotNull
    private static final List<String> dialogMethodCalls;

    private TimeoutAnalyzer() {
    }

    @Nullable
    public final Error analyzeTimeout(@NotNull IDERunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        this.postLastScreenshots(runContext);
        Error error = this.detectIdeNotStarted(runContext);
        if (error == null && (error = this.detectDialog(runContext)) == null) {
            error = this.detectIndicatorsNotFinished(runContext);
        }
        return error;
    }

    private final Error detectDialog(IDERunContext runContext) {
        block11: {
            Object object;
            ThreadState edtThread;
            String threadDump;
            block13: {
                block12: {
                    boolean bl;
                    Object it;
                    block10: {
                        Object element$iv2;
                        block9: {
                            String string = this.getLastThreadDump(runContext);
                            if (string == null) {
                                return null;
                            }
                            threadDump = string;
                            List<ThreadState> threadDumpParsed = ThreadDumpParser.INSTANCE.parse(threadDump);
                            Iterable $this$first$iv = threadDumpParsed;
                            boolean $i$f$first = false;
                            for (Object element$iv2 : $this$first$iv) {
                                it = (ThreadState)element$iv2;
                                boolean bl2 = false;
                                if (!((ThreadState)it).isEDT()) continue;
                                break block9;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        edtThread = (ThreadState)element$iv2;
                        Iterable $this$any$iv = dialogMethodCalls;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                String call = (String)element$iv2;
                                boolean bl3 = false;
                                if (!StringsKt.contains$default((CharSequence)edtThread.getStackTrace(), (CharSequence)call, (boolean)false, (int)2, null)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block11;
                    object = this.getLastCommand(runContext);
                    if (object == null) break block12;
                    it = object;
                    boolean bl4 = false;
                    String string = System.lineSeparator() + "Last executed command was: " + (String)it;
                    object = string;
                    if (string != null) break block13;
                }
                object = "";
            }
            String lastCommandNote = object;
            String errorMessage = "Timeout of IDE run '" + runContext.getContextName() + "' for " + Duration.toString-impl((long)runContext.getRunTimeout-UwyO8pc()) + " due to a dialog being shown." + lastCommandNote;
            Error error = new Error(errorMessage, edtThread.getStackTrace(), threadDump, ErrorType.TIMEOUT, null, 16, null);
            return error;
        }
        return null;
    }

    private final Error detectIdeNotStarted(IDERunContext runContext) {
        if (this.getIdeaLogs(runContext).isEmpty()) {
            return new Error("Timeout of IDE run '" + runContext.getContextName() + "' for " + Duration.toString-impl((long)runContext.getRunTimeout-UwyO8pc()) + ". No idea.log file present in log directory", "", "", ErrorType.TIMEOUT, null, 16, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Error detectIndicatorsNotFinished(IDERunContext runContext) {
        block7: {
            Object object;
            Map remainingIndicators;
            block9: {
                block8: {
                    void $this$filterTo$iv$iv;
                    Iterator $this$forEach$iv;
                    Object element$iv2;
                    List<Path> logs = this.getIdeaLogs(runContext);
                    Map runningIndicators = new LinkedHashMap();
                    Regex indicatorMessagePattern = new Regex("- Progress indicator:(started|finished):(.+)$");
                    Iterable $this$forEach$iv2 = CollectionsKt.reversed((Iterable)logs);
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Path logFile = (Path)element$iv2;
                        boolean bl = false;
                        String string = Files.readString(logFile);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
                        Sequence sequence = SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)string), arg_0 -> TimeoutAnalyzer.detectIndicatorsNotFinished$lambda$0$0(indicatorMessagePattern, arg_0));
                        boolean $i$f$forEach2 = false;
                        Iterator iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            Integer n;
                            Map map;
                            Object element$iv3 = iterator.next();
                            MatchResult.Destructured destructured = (MatchResult.Destructured)element$iv3;
                            boolean bl2 = false;
                            String indicatorState = (String)destructured.getMatch().getGroupValues().get(1);
                            String indicatorName = (String)destructured.getMatch().getGroupValues().get(2);
                            String string2 = indicatorState;
                            if (Intrinsics.areEqual((Object)string2, (Object)"started")) {
                                map = runningIndicators;
                                Integer n2 = (Integer)runningIndicators.get(indicatorName);
                                n = (n2 != null ? n2 : 0) + 1;
                                map.put(indicatorName, n);
                                continue;
                            }
                            if (!Intrinsics.areEqual((Object)string2, (Object)"finished")) continue;
                            map = runningIndicators;
                            Integer n3 = (Integer)runningIndicators.get(indicatorName);
                            n = (n3 != null ? n3 : 0) - 1;
                            map.put(indicatorName, n);
                        }
                    }
                    Map $this$filter$iv = runningIndicators;
                    boolean $i$f$filter = false;
                    element$iv2 = $this$filter$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$filterTo = false;
                    $this$forEach$iv = $this$filterTo$iv$iv.entrySet().iterator();
                    while ($this$forEach$iv.hasNext()) {
                        Map.Entry element$iv$iv;
                        Map.Entry it = element$iv$iv = $this$forEach$iv.next();
                        boolean bl = false;
                        if (!(((Number)it.getValue()).intValue() != 0)) continue;
                        destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                    }
                    remainingIndicators = destination$iv$iv;
                    if (!(!remainingIndicators.isEmpty())) break block7;
                    object = this.getLastCommand(runContext);
                    if (object == null) break block8;
                    String it = object;
                    boolean bl = false;
                    String string = System.lineSeparator() + " during `%" + it + "` execution";
                    object = string;
                    if (string != null) break block9;
                }
                object = "";
            }
            String lastCommandNote = object;
            String string = "Timeout of IDE run '" + runContext.getContextName() + "' for " + Duration.toString-impl((long)runContext.getRunTimeout-UwyO8pc()) + lastCommandNote + " because some indicators haven't finished:";
            Iterable iterable = remainingIndicators.keySet();
            String string3 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator(...)");
            return new Error(string, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null), "", ErrorType.TIMEOUT, null, 16, null);
        }
        return null;
    }

    private final void postLastScreenshots(IDERunContext runContext) {
        if (!CIServer.Companion.getInstance().isBuildRunningOnCI()) {
            return;
        }
        Iterable $this$forEach$iv = this.getLastScreenshots(runContext);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path screenshot = (Path)element$iv;
            boolean bl = false;
            LoggingKt.logOutput((String)("Adding screenshot to metadata: " + ((Object)screenshot).toString()));
            TeamCityClient.publishTeamCityArtifacts$default(TeamCityClient.INSTANCE, screenshot, GenerifyKt.replaceSpecialCharactersWithHyphens$default(runContext.getContextName(), null, 1, null) + "/timeout-screenshots", PathsKt.getName((Path)screenshot), false, null, 16, null);
            TeamCityCIServer.Companion.addTestMetadata(null, TeamCityCIServer.TeamCityMetadataType.IMAGE, null, null, GenerifyKt.replaceSpecialCharactersWithHyphens$default(runContext.getContextName(), null, 1, null) + "/timeout-screenshots/" + PathsKt.getName((Path)screenshot));
        }
    }

    private final List<Path> getLastScreenshots(IDERunContext runContext) {
        Object v6;
        block11: {
            Path path;
            Path it;
            Iterator iterator$iv;
            Path beforeIdeClosedScreenshotDir;
            LoggingKt.logOutput((String)("Try to find the latest screenshot at " + ((Object)runContext.getLogsDir()).toString()));
            Path beforeKillScreenshot = Files.find(runContext.getLogsDir(), 10, TimeoutAnalyzer::getLastScreenshots$lambda$0, new FileVisitOption[0]).findFirst().orElse(null);
            if (beforeKillScreenshot != null) {
                return CollectionsKt.listOf((Object)beforeKillScreenshot);
            }
            Path path2 = beforeIdeClosedScreenshotDir = (Path)Files.find(runContext.getLogsDir(), 10, TimeoutAnalyzer::getLastScreenshots$lambda$1, new FileVisitOption[0]).findFirst().orElse(null);
            if (path2 != null) {
                Object v1;
                Path it2 = path2;
                boolean bl = false;
                Iterable $this$maxByOrNull$iv = PathsKt.listDirectoryEntries((Path)it2, (String)"*");
                boolean $i$f$maxByOrNull = false;
                iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = maxElem$iv;
                    } else {
                        it = (Path)maxElem$iv;
                        boolean bl2 = false;
                        Comparable maxValue$iv = (Comparable)((Object)PathsKt.getName((Path)it));
                        do {
                            Object e$iv = iterator$iv.next();
                            Path it3 = (Path)e$iv;
                            $i$a$-maxByOrNull-TimeoutAnalyzer$getLastScreenshots$1$1 = false;
                            Comparable v$iv = (Comparable)((Object)PathsKt.getName((Path)it3));
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = maxElem$iv;
                    }
                }
                Path path3 = v1;
                if (path3 != null) {
                    Path it4 = path3;
                    boolean bl3 = false;
                    return CollectionsKt.listOf((Object)it4);
                }
            }
            LoggingKt.logOutput((String)"Try to find latest screenshot from heartbit");
            Path it5 = path = runContext.getLogsDir().resolve("screenshots");
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it5);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            Path path4 = Files.exists(it5, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
            if (path4 == null) {
                return CollectionsKt.emptyList();
            }
            Path screenshotsFolder = path4;
            Iterable $this$sortedBy$iv = PathsKt.listDirectoryEntries((Path)screenshotsFolder, (String)"heartbeat*");
            boolean $i$f$sortedBy = false;
            List $this$lastOrNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Path it = (Path)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)PathsKt.getName((Path)it));
                    it = (Path)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)PathsKt.getName((Path)it))));
                }
            });
            boolean $i$f$lastOrNull = false;
            iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                it = (Path)element$iv;
                boolean bl4 = false;
                boolean bl5 = !((Collection)PathsKt.listDirectoryEntries$default((Path)it, null, (int)1, null)).isEmpty();
                if (!bl5) continue;
                v6 = element$iv;
                break block11;
            }
            v6 = null;
        }
        Path path = v6;
        if (path == null) {
            return CollectionsKt.emptyList();
        }
        Path lastHeartbeat = path;
        return PathsKt.listDirectoryEntries$default((Path)lastHeartbeat, null, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getLastThreadDump(IDERunContext runContext) {
        String string;
        Path path;
        Path lastThreadDump;
        Path path2;
        Path threadDumpsDirectory;
        Iterable<Path> iterable;
        Path killThreadDump = (Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)runContext.getLogsDir(), (String)"threadDump-before-kill*.txt"));
        Iterable<Path> it = iterable = (threadDumpsDirectory = runContext.getLogsDir().resolve("monitoring-thread-dumps-ide"));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path3 = path2 = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? iterable : null;
        if (path2 != null && (iterable = PathsKt.listDirectoryEntries((Path)path2, (String)"threadDump*.txt")) != null) {
            Object v2;
            void $this$maxByOrNull$iv;
            it = iterable;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = maxElem$iv;
                } else {
                    Path it2 = (Path)maxElem$iv;
                    boolean bl2 = false;
                    Comparable maxValue$iv = (Comparable)((Object)PathsKt.getName((Path)it2));
                    do {
                        Object e$iv = iterator$iv.next();
                        Path it3 = (Path)e$iv;
                        $i$a$-maxByOrNull-TimeoutAnalyzer$getLastThreadDump$lastThreadDump$2 = false;
                        Comparable v$iv = (Comparable)((Object)PathsKt.getName((Path)it3));
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = maxElem$iv;
                }
            }
            v3 = v2;
        } else {
            v3 = lastThreadDump = null;
        }
        if ((path = killThreadDump) == null) {
            path = lastThreadDump;
        }
        if (path != null) {
            Path p0 = path;
            boolean bl3 = false;
            string = Files.readString(p0);
        } else {
            string = null;
        }
        return string;
    }

    private final String getLastCommand(IDERunContext runContext) {
        String string;
        block1: {
            for (Path logFile : (Iterable)this.getIdeaLogs(runContext)) {
                boolean bl = false;
                String string2 = Files.readString(logFile);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
                String string3 = (String)SequencesKt.lastOrNull((Sequence)SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)string2), TimeoutAnalyzer::getLastCommand$lambda$0$0));
                String string4 = string3 != null ? StringsKt.substringAfterLast$default((String)string3, (String)"CommandLogger - %", null, (int)2, null) : null;
                if (string4 == null) continue;
                string = string4;
                break block1;
            }
            string = null;
        }
        return string;
    }

    private final List<Path> getIdeaLogs(IDERunContext runContext) {
        Path lastLog = runContext.getLogsDir().resolve("idea.log");
        Intrinsics.checkNotNull((Object)lastLog);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(lastLog, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedBy$iv = PathsKt.listDirectoryEntries((Path)runContext.getLogsDir(), (String)"idea.*.log");
        boolean $i$f$sortedBy = false;
        List allLogs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)lastLog), (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)PathsKt.getName((Path)it));
                it = (Path)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)PathsKt.getName((Path)it))));
            }
        }));
        return allLogs;
    }

    private static final MatchResult.Destructured detectIndicatorsNotFinished$lambda$0$0(Regex $indicatorMessagePattern, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult matchResult = Regex.find$default((Regex)$indicatorMessagePattern, (CharSequence)line, (int)0, (int)2, null);
        return matchResult != null ? matchResult.getDestructured() : null;
    }

    private static final boolean getLastScreenshots$lambda$0(Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNull((Object)path);
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)"screenshotBeforeKill.jpg");
    }

    private static final boolean getLastScreenshots$lambda$1(Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNull((Object)path);
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)"beforeIdeClosed");
    }

    private static final boolean getLastCommand$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)it, (CharSequence)"CommandLogger - %", (boolean)false, (int)2, null);
    }

    static {
        Object[] objectArray = new String[]{"com.intellij.openapi.ui.DialogWrapper.doShow", "java.awt.Dialog.show"};
        dialogMethodCalls = CollectionsKt.listOf((Object[])objectArray);
    }
}

