/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.screenRecorder;

import com.intellij.ide.starter.coroutine.CommonScope;
import com.intellij.ide.starter.models.VMOptions;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.runner.IDERunContext;
import com.intellij.ide.starter.screenRecorder.IDEScreenRecorder;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.OS;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.screenrecorder.ScreenRecorder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015J2\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0003H\u0082@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/intellij/ide/starter/screenRecorder/IDEScreenRecorder;", "", "runContext", "Lcom/intellij/ide/starter/runner/IDERunContext;", "<init>", "(Lcom/intellij/ide/starter/runner/IDERunContext;)V", "javaScreenRecorder", "Lorg/monte/screenrecorder/ScreenRecorder;", "getJavaScreenRecorder", "()Lorg/monte/screenrecorder/ScreenRecorder;", "javaScreenRecorder$delegate", "Lkotlin/Lazy;", "ffmpegProcessJob", "Lkotlinx/coroutines/Job;", "getFfmpegProcessJob", "()Lkotlinx/coroutines/Job;", "setFfmpegProcessJob", "(Lkotlinx/coroutines/Job;)V", "start", "", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDisplaySize", "Lkotlin/Pair;", "", "displayWithColumn", "", "defaultValue", "startFFMpegRecording", "ideRunContext", "(Lcom/intellij/ide/starter/runner/IDERunContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nIDEScreenRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDEScreenRecorder.kt\ncom/intellij/ide/starter/screenRecorder/IDEScreenRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n1#2:194\n110#3:195\n125#3,4:196\n*S KotlinDebug\n*F\n+ 1 IDEScreenRecorder.kt\ncom/intellij/ide/starter/screenRecorder/IDEScreenRecorder\n*L\n100#1:195\n100#1:196,4\n*E\n"})
public final class IDEScreenRecorder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDERunContext runContext;
    @NotNull
    private final Lazy javaScreenRecorder$delegate;
    @Nullable
    private Job ffmpegProcessJob;

    public IDEScreenRecorder(@NotNull IDERunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        this.runContext = runContext;
        this.javaScreenRecorder$delegate = LazyKt.lazy(() -> IDEScreenRecorder.javaScreenRecorder_delegate$lambda$0(this));
    }

    @Nullable
    public final ScreenRecorder getJavaScreenRecorder() {
        Lazy lazy = this.javaScreenRecorder$delegate;
        return (ScreenRecorder)lazy.getValue();
    }

    @Nullable
    public final Job getFfmpegProcessJob() {
        return this.ffmpegProcessJob;
    }

    public final void setFfmpegProcessJob(@Nullable Job job) {
        this.ffmpegProcessJob = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        if (StartupUiUtil.isWayland()) {
            LoggingKt.logOutput((String)"Screen recording is disabled because on Wayland it triggers system dialog about granting permissions each time, and it can't be disabled.");
            return;
        }
        if (this.runContext.calculateVmOptions().hasHeadlessMode()) {
            LoggingKt.logOutput((String)"Screen recording is disabled because IDE is started in headless mode.");
            return;
        }
        LoggingKt.logOutput((String)"Screen recorder: starting");
        IDEScreenRecorder iDEScreenRecorder = this;
        synchronized (iDEScreenRecorder) {
            boolean bl = false;
            if (this.getJavaScreenRecorder() != null) {
                ScreenRecorder screenRecorder = this.getJavaScreenRecorder();
                if (screenRecorder != null) {
                    screenRecorder.start();
                }
            } else if (OS.CURRENT == OS.Linux && this.ffmpegProcessJob == null) {
                this.ffmpegProcessJob = BuildersKt.launch$default((CoroutineScope)CommonScope.INSTANCE.getTestSuiteSupervisorScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ IDEScreenRecorder this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = IDEScreenRecorder.access$startFFMpegRecording(this.this$0, IDEScreenRecorder.access$getRunContext$p(this.this$0), (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        if (this.getJavaScreenRecorder() == null && this.ffmpegProcessJob == null) {
            LoggingKt.logOutput((String)"Screen recorder was not started");
        }
        LoggingKt.logOutput((String)"Screen recorder: stopping");
        ScreenRecorder screenRecorder = this.getJavaScreenRecorder();
        if (screenRecorder != null) {
            screenRecorder.stop();
        }
        Job job = this.ffmpegProcessJob;
        if (job != null) {
            Object object = JobKt.cancelAndJoin((Job)job, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Pair<Integer, Integer> getDisplaySize(String displayWithColumn, Pair<Integer, Integer> defaultValue) {
        try {
            String commandName = "xdpyinfo";
            LoggingKt.logOutput((String)("Getting a size for a display " + displayWithColumn));
            ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
            String string = commandName + " -display " + displayWithColumn;
            Object object = new String[]{commandName, "-display", displayWithColumn};
            List list = CollectionsKt.listOf((Object[])object);
            object = new ExecOutputRedirect.ToStdOut("[" + commandName + "-err]");
            ProcessExecutor.start$default(new ProcessExecutor(string, null, 0L, null, list, null, stdout, (ExecOutputRedirect)object, null, null, null, false, 0, false, false, 28460, null), false, 1, null);
            String screenDataOutput = ((Object)StringsKt.trim((CharSequence)stdout.read())).toString();
            Regex regex = new Regex("dimensions:\\s*(\\d+)x(\\d+)\\s*pixels");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)screenDataOutput, (int)0, (int)2, null);
            Object object2 = matchResult;
            if (object2 == null || (object2 = object2.getGroupValues()) == null) {
                throw new IllegalStateException("Could not determine screen data".toString());
            }
            Object it = object2;
            boolean bl = false;
            Pair pair = new Pair((Object)Integer.parseInt((String)it.get(1)), (Object)Integer.parseInt((String)it.get(2)));
            int width = ((Number)pair.component1()).intValue();
            int height = ((Number)pair.component2()).intValue();
            LoggingKt.logOutput((String)("Getting a size for a display " + displayWithColumn + " finished with " + width + " x " + height));
            return TuplesKt.to((Object)width, (Object)height);
        }
        catch (Exception e) {
            LoggingKt.logOutput((String)("Failed to get a size for a display " + displayWithColumn + ": " + e.getMessage()));
            return defaultValue;
        }
    }

    static /* synthetic */ Pair getDisplaySize$default(IDEScreenRecorder iDEScreenRecorder, String string, Pair pair, int n, Object object) {
        if ((n & 2) != 0) {
            pair = TuplesKt.to((Object)1920, (Object)1080);
        }
        return iDEScreenRecorder.getDisplaySize(string, (Pair<Integer, Integer>)pair);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object startFFMpegRecording(IDERunContext ideRunContext, Continuation<? super Unit> $completion) {
        if (!($completion instanceof startFFMpegRecording.1)) ** GOTO lbl-1000
        var18_3 = $completion;
        if ((var18_3.label & -2147483648) != 0) {
            var18_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ IDEScreenRecorder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IDEScreenRecorder.access$startFFMpegRecording(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                processVmOptions = ideRunContext.calculateVmOptions();
                v0 = processVmOptions.getEnvironmentVariables().get("DISPLAY");
                if (v0 == null && (v0 = System.getenv("DISPLAY")) == null) {
                    v0 = ":88";
                }
                processDisplay = v0;
                v1 = ideRunContext.getLogsDir().resolve("screen-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH_mm_ss_SSS")) + ".mkv");
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                recordingFile = v1;
                v2 = ideRunContext.getLogsDir().resolve("ffmpeg-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH_mm_ss_SSS")) + ".log");
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resolve(...)");
                it /* !! */  = var7_12 = v2;
                $i$a$-also-IDEScreenRecorder$startFFMpegRecording$ffmpegLogFile$1 = false;
                v3 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile((Path)it /* !! */ , Arrays.copyOf(v3, v3.length)), (String)"createFile(...)");
                ffmpegLogFile = var7_12;
                it /* !! */  = new String[14];
                it /* !! */ [0] = "/usr/bin/ffmpeg";
                it /* !! */ [1] = "-f";
                it /* !! */ [2] = "x11grab";
                it /* !! */ [3] = "-video_size";
                var10_21 /* !! */  = IDEScreenRecorder.getDisplaySize$default(this, processDisplay, null, 2, null);
                var15_22 = 4;
                var14_23 = it /* !! */ ;
                $i$a$-let-IDEScreenRecorder$startFFMpegRecording$args$1 = false;
                var16_26 = it.getFirst() + "x" + it.getSecond();
                var14_23[var15_22] = var16_26;
                it /* !! */ [5] = "-framerate";
                it /* !! */ [6] = "24";
                it /* !! */ [7] = "-i";
                it /* !! */ [8] = processDisplay;
                it /* !! */ [9] = "-codec:v";
                it /* !! */ [10] = "libx264";
                it /* !! */ [11] = "-preset";
                it /* !! */ [12] = "superfast";
                it /* !! */ [13] = recordingFile.toString();
                args = CollectionsKt.listOf((Object[])it /* !! */ );
                LoggingKt.logOutput((String)("Start screen recording to " + recordingFile + "\nArgs: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                it /* !! */  = CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                var9_18 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"DISPLAY", (Object)processDisplay));
                v4 = ffmpegLogFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toFile(...)");
                var10_21 /* !! */  = new ExecOutputRedirect.ToFile(v4, false, 2, null);
                v5 = ffmpegLogFile.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toFile(...)");
                var11_25 = new ExecOutputRedirect.ToFile(v5, false, 2, null);
                var12_27 = ideRunContext.getRunTimeout-UwyO8pc();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)ideRunContext);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)processVmOptions);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)processDisplay);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)recordingFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)ffmpegLogFile);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)args);
                $continuation.label = 1;
                v6 = ProcessExecutor.startCancellable$default(new ProcessExecutor((String)it /* !! */ , null, var12_27, var9_18, args, null, (ExecOutputRedirect)var10_21 /* !! */ , var11_25, null, null, null, false, 0, false, false, 28448, null), false, (Continuation)$continuation, 1, null);
                ** if (v6 != var19_5) goto lbl72
lbl71:
                // 1 sources

                return var19_5;
lbl72:
                // 1 sources

                ** GOTO lbl89
            }
            case 1: {
                args = (List)$continuation.L$5;
                ffmpegLogFile = (Path)$continuation.L$4;
                recordingFile = (Path)$continuation.L$3;
                processDisplay = (String)$continuation.L$2;
                processVmOptions = (VMOptions)$continuation.L$1;
                ideRunContext = (IDERunContext)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LoggingKt.logOutput((String)("Failed to start ffmpeg recording: " + e.getMessage()));
                }
lbl89:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final ScreenRecorder javaScreenRecorder_delegate$lambda$0(IDEScreenRecorder this$0) {
        ScreenRecorder screenRecorder;
        if (OS.CURRENT != OS.Linux) {
            Object $this$javaScreenRecorder_delegate_u24lambda_u240_u240;
            IDEScreenRecorder iDEScreenRecorder = this$0;
            try {
                $this$javaScreenRecorder_delegate_u24lambda_u240_u240 = iDEScreenRecorder;
                boolean bl = false;
                Path path = ((IDEScreenRecorder)$this$javaScreenRecorder_delegate_u24lambda_u240_u240).runContext.getLogsDir().resolve("screenRecording");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                $this$javaScreenRecorder_delegate_u24lambda_u240_u240 = Result.constructor-impl((Object)com.intellij.ide.starter.screenRecorder.IDEScreenRecorder$Companion.getScreenRecorder$default(Companion, file, null, 2, null));
            }
            catch (Throwable bl) {
                $this$javaScreenRecorder_delegate_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            Object $this$getOrLogException$iv = $this$javaScreenRecorder_delegate_u24lambda_u240_u240;
            boolean $i$f$getOrLogException = false;
            Object $this$getOrHandleException$iv$iv = $this$getOrLogException$iv;
            boolean $i$f$getOrHandleException = false;
            Object object = $this$getOrHandleException$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl = false;
                LoggerKt.rethrowControlFlowException((Throwable)e$iv$iv);
                Throwable it = e$iv$iv;
                boolean bl2 = false;
                LoggingKt.logOutput((String)("Can't create screen recorder: " + ExceptionsKt.stackTraceToString((Throwable)it)));
            }
            screenRecorder = (ScreenRecorder)(Result.isFailure-impl((Object)object) ? null : object);
        } else {
            screenRecorder = null;
        }
        return screenRecorder;
    }

    public static final /* synthetic */ Object access$startFFMpegRecording(IDEScreenRecorder $this, IDERunContext ideRunContext, Continuation $completion) {
        return $this.startFFMpegRecording(ideRunContext, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ IDERunContext access$getRunContext$p(IDEScreenRecorder $this) {
        return $this.runContext;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\u001c\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/screenRecorder/IDEScreenRecorder$Companion;", "", "<init>", "()V", "getScreenRecorder", "Lorg/monte/screenrecorder/ScreenRecorder;", "movieFolder", "Ljava/io/File;", "filePrefix", "", "getMovieName", "fileFormat", "Lorg/monte/media/Format;", "intellij.tools.ide.starter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScreenRecorder getScreenRecorder(@NotNull File movieFolder, @Nullable String filePrefix) {
            Intrinsics.checkNotNullParameter((Object)movieFolder, (String)"movieFolder");
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Rectangle rectangle = new Rectangle(0, 0, Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height);
            Object[] objectArray = new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, "video/avi"};
            Format format = new Format(objectArray);
            Object[] objectArray2 = new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "tscc", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.FrameRateKey, Rational.valueOf((double)15.0), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), VideoFormatKeys.KeyFrameIntervalKey, 900};
            objectArray = new Format(objectArray2);
            Object[] objectArray3 = new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "black", VideoFormatKeys.FrameRateKey, Rational.valueOf((double)30.0)};
            objectArray2 = new Format(objectArray3);
            return new ScreenRecorder(movieFolder, filePrefix, graphicsConfiguration, rectangle, format, (Format)objectArray, (Format)objectArray2){
                final /* synthetic */ File $movieFolder;
                final /* synthetic */ String $filePrefix;
                {
                    this.$movieFolder = $movieFolder;
                    this.$filePrefix = $filePrefix;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5, null, $movieFolder);
                }

                protected File createMovieFile(Format fileFormat) {
                    Intrinsics.checkNotNullParameter((Object)fileFormat, (String)"fileFormat");
                    if (this.$filePrefix == null) {
                        File file = super.createMovieFile(fileFormat);
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createMovieFile(...)");
                        return file;
                    }
                    return FilesKt.resolve((File)this.$movieFolder, (String)com.intellij.ide.starter.screenRecorder.IDEScreenRecorder$Companion.access$getMovieName(IDEScreenRecorder.Companion, fileFormat, this.$filePrefix));
                }
            };
        }

        public static /* synthetic */ ScreenRecorder getScreenRecorder$default(Companion companion, File file, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.getScreenRecorder(file, string);
        }

        private final String getMovieName(Format fileFormat, String filePrefix) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
            String string = filePrefix;
            if (string == null) {
                string = "ScreenRecording";
            }
            String prefix = string;
            String extension = Registry.getInstance().getExtension(fileFormat);
            String timestamp = dateFormat.format(new Date());
            return prefix + " " + timestamp + "." + extension;
        }

        public static final /* synthetic */ String access$getMovieName(Companion $this, Format fileFormat, String filePrefix) {
            return $this.getMovieName(fileFormat, filePrefix);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

