/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.sdk;

import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.runner.targets.TargetIdentifier;
import com.intellij.ide.starter.runner.targets.TargetIdentifierKt;
import com.intellij.ide.starter.sdk.DownloadJDKException;
import com.intellij.ide.starter.sdk.JdkDownloadItem;
import com.intellij.ide.starter.sdk.JdkItemPaths;
import com.intellij.ide.starter.sdk.JdkVersion;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerWSL;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.OsAbstractionForJdkInstaller;
import com.intellij.platform.eel.EelApi;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.tools.ide.util.common.RetryKt;
import com.intellij.util.io.Decompressor;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0018\u0010/\u001a\u00020-2\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u00100\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020-2\u0006\u00101\u001a\u00020-H\u0002J \u00102\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010.\u001a\u00020-2\u0006\u00101\u001a\u00020-H\u0002J\u0018\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020-H\u0002J\u001c\u00106\u001a\u00020+*\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020-H\u0002R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006;"}, d2={"Lcom/intellij/ide/starter/sdk/JdkDownloaderFacade;", "", "<init>", "()V", "jdk8", "Lcom/intellij/ide/starter/sdk/JdkDownloadItem;", "getJdk8", "()Lcom/intellij/ide/starter/sdk/JdkDownloadItem;", "jdk11", "getJdk11", "jdk17", "getJdk17", "jbrJcef17", "getJbrJcef17", "jdk20", "getJdk20", "jdk21", "getJdk21", "jbr21", "getJbr21", "jdk25", "getJdk25", "MINIMUM_JDK_FILES_COUNT", "", "jdkDownloader", "version", "", "jdks", "", "jbr", "", "allJdks", "", "getAllJdks", "()Ljava/util/List;", "listJDKs", "predicate", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkPredicate;", "downloadJdkItem", "Lcom/intellij/ide/starter/sdk/JdkItemPaths;", "jdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "checkDownloadedJdk", "", "javaHome", "Ljava/nio/file/Path;", "targetJdkHome", "determineTargetJdkHome", "shouldDownloadJdk", "targetHomeMarker", "downloadAndInstallJdk", "downloadFileFromUrl", "urlString", "destinationPath", "installJdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "markerFile", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nJdkDownloaderFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkDownloaderFacade.kt\ncom/intellij/ide/starter/sdk/JdkDownloaderFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n672#2,11:169\n1586#2:180\n1661#2,3:181\n1586#2:184\n1661#2,3:185\n1586#2:188\n1661#2,3:189\n296#2,2:192\n*S KotlinDebug\n*F\n+ 1 JdkDownloaderFacade.kt\ncom/intellij/ide/starter/sdk/JdkDownloaderFacade\n*L\n50#1:169,11\n61#1:180\n61#1:181,3\n63#1:184\n63#1:185,3\n66#1:188\n66#1:189,3\n89#1:192,2\n*E\n"})
public final class JdkDownloaderFacade {
    @NotNull
    public static final JdkDownloaderFacade INSTANCE = new JdkDownloaderFacade();
    public static final int MINIMUM_JDK_FILES_COUNT = 42;

    private JdkDownloaderFacade() {
    }

    @NotNull
    public final JdkDownloadItem getJdk8() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_8.toString(), null, false, 6, null);
    }

    @NotNull
    public final JdkDownloadItem getJdk11() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_11.toString(), null, false, 6, null);
    }

    @NotNull
    public final JdkDownloadItem getJdk17() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_17.toString(), null, false, 6, null);
    }

    @NotNull
    public final JdkDownloadItem getJbrJcef17() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_17.toString(), null, true, 2, null);
    }

    @NotNull
    public final JdkDownloadItem getJdk20() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_20.toString(), null, false, 6, null);
    }

    @NotNull
    public final JdkDownloadItem getJdk21() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_21.toString(), null, false, 6, null);
    }

    @NotNull
    public final JdkDownloadItem getJbr21() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_21.toString(), null, true, 2, null);
    }

    @NotNull
    public final JdkDownloadItem getJdk25() {
        return JdkDownloaderFacade.jdkDownloader$default(this, JdkVersion.JDK_25.toString(), null, false, 6, null);
    }

    @NotNull
    public final JdkDownloadItem jdkDownloader(@NotNull String version, @NotNull Iterable<JdkDownloadItem> jdks, boolean jbr) {
        JdkDownloadItem jdkDownloadItem;
        block3: {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(jdks, (String)"jdks");
            String jdkName = jbr ? "jbr" : "corretto";
            Iterable<JdkDownloadItem> $this$singleOrNull$iv = jdks;
            boolean $i$f$singleOrNull = false;
            JdkDownloadItem single$iv = null;
            boolean found$iv = false;
            Iterator<JdkDownloadItem> iterator = $this$singleOrNull$iv.iterator();
            while (iterator.hasNext()) {
                JdkDownloadItem element$iv;
                JdkDownloadItem it = element$iv = iterator.next();
                boolean bl = false;
                if (!it.jdk.getSharedIndexAliases().contains(jdkName + "-" + version)) continue;
                if (found$iv) {
                    jdkDownloadItem = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            jdkDownloadItem = !found$iv ? null : single$iv;
        }
        JdkDownloadItem jdkDownloadItem2 = jdkDownloadItem;
        if (jdkDownloadItem2 == null) {
            throw new DownloadJDKException();
        }
        return jdkDownloadItem2;
    }

    public static /* synthetic */ JdkDownloadItem jdkDownloader$default(JdkDownloaderFacade jdkDownloaderFacade, String string, Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            iterable = jdkDownloaderFacade.getAllJdks();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return jdkDownloaderFacade.jdkDownloader(string, iterable, bl);
    }

    @NotNull
    public final List<JdkDownloadItem> getAllJdks() {
        return TargetIdentifierKt.isLocal(TargetIdentifier.Companion.getCurrent()) ? this.listJDKs(JdkPredicate.Companion.forCurrentProcess()) : this.listJDKs(JdkPredicate.Companion.forEel$default((JdkPredicate.Companion)JdkPredicate.Companion, (EelApi)TargetIdentifier.Companion.getCurrent().getEelApi(), null, (int)2, null));
    }

    /*
     * WARNING - void declaration
     */
    private final List<JdkDownloadItem> listJDKs(JdkPredicate predicate) {
        Iterable $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List allJDKs = new JdkListDownloader().downloadModelForJdkInstaller(null, predicate);
        Iterable $this$map$iv = allJDKs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            JdkItem jdkItem = (JdkItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFullPresentationText());
        }
        LoggingKt.logOutput((String)("Total JDKs: " + (List)destination$iv$iv));
        Iterable $this$map$iv2 = allJDKs;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JdkItem bl = (JdkItem)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getJdkVersion());
        }
        SortedSet allVersions = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv2));
        LoggingKt.logOutput((String)("JDK versions: " + allVersions));
        $this$map$iv2 = allJDKs;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void jdk;
            JdkItem it = (JdkItem)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new JdkDownloadItem((JdkItem)jdk, (Function0<JdkItemPaths>)((Function0)() -> JdkDownloaderFacade.listJDKs$lambda$2$0((JdkItem)jdk, predicate))));
        }
        return (List)destination$iv$iv2;
    }

    private final JdkItemPaths downloadJdkItem(JdkItem jdk, JdkPredicate predicate) {
        Path targetJdkHome = this.determineTargetJdkHome(predicate, jdk);
        Path targetHomeMarker = targetJdkHome.resolve("home.link");
        LoggingKt.logOutput((String)("Checking JDK at " + targetJdkHome));
        Intrinsics.checkNotNull((Object)targetHomeMarker);
        if (this.shouldDownloadJdk(targetJdkHome, targetHomeMarker)) {
            this.downloadAndInstallJdk(jdk, targetJdkHome, targetHomeMarker);
        }
        Path javaHome = Path.of(Files.readString(targetHomeMarker), new String[0]);
        Intrinsics.checkNotNull((Object)javaHome);
        this.checkDownloadedJdk(javaHome, targetJdkHome);
        return new JdkItemPaths(javaHome, targetJdkHome);
    }

    private final void checkDownloadedJdk(Path javaHome, Path targetJdkHome) {
        Object $this$checkDownloadedJdk_u24lambda_u241;
        Object v1;
        block6: {
            Path path = javaHome.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Iterable $this$firstOrNull$iv = CollectionsKt.sorted((Iterable)PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)"java", (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        Path javaBinary = v1;
        Object object = this;
        try {
            Object object2;
            $this$checkDownloadedJdk_u24lambda_u241 = object;
            boolean bl = false;
            Path path = javaBinary;
            if (path == null) {
                object2 = "Required value was null.";
                throw new IllegalArgumentException(object2.toString());
            }
            object2 = path;
            Object object3 = new LinkOption[0];
            if (!Files.isRegularFile((Path)object2, Arrays.copyOf(object3, ((LinkOption[])object3).length))) {
                object3 = "Failed requirement.";
                throw new IllegalArgumentException(object3.toString());
            }
            $this$checkDownloadedJdk_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$checkDownloadedJdk_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$checkDownloadedJdk_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            PathsKt.deleteRecursively((Path)targetJdkHome);
            throw new IllegalStateException(("corrupted JDK home: " + targetJdkHome + " (now deleted)").toString());
        }
    }

    private final Path determineTargetJdkHome(JdkPredicate predicate, JdkItem jdk) {
        Path path = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("jdks").resolve(jdk.getInstallFolderName());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final boolean shouldDownloadJdk(Path targetJdkHome, Path targetHomeMarker) {
        return !Files.isRegularFile(targetHomeMarker, new LinkOption[0]) || SequencesKt.count((Sequence)PathsKt.walk((Path)targetJdkHome, (PathWalkOption[])new PathWalkOption[0])) < 42;
    }

    private final void downloadAndInstallJdk(JdkItem jdk, Path targetJdkHome, Path targetHomeMarker) {
        RetryKt.withRetryBlocking-zkXUZaI$default((String)"Failure on downloading/installing JDK", (long)5L, null, (long)0L, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(targetJdkHome, jdk, targetHomeMarker, null){
            int label;
            final /* synthetic */ Path $targetJdkHome;
            final /* synthetic */ JdkItem $jdk;
            final /* synthetic */ Path $targetHomeMarker;
            {
                this.$targetJdkHome = $targetJdkHome;
                this.$jdk = $jdk;
                this.$targetHomeMarker = $targetHomeMarker;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LoggingKt.logOutput((String)("Downloading JDK at " + this.$targetJdkHome));
                        PathsKt.deleteRecursively((Path)this.$targetJdkHome);
                        JdkInstaller jdkInstaller = new JdkInstaller();
                        JdkInstallRequest request = jdkInstaller.prepareJdkInstallationDirect(this.$jdk, this.$targetJdkHome);
                        JdkDownloaderFacade.access$installJdk(JdkDownloaderFacade.INSTANCE, jdkInstaller, request, this.$targetHomeMarker);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadFileFromUrl(String urlString, Path destinationPath) {
        PathsKt.createParentDirectories((Path)destinationPath, (FileAttribute[])new FileAttribute[0]);
        Closeable closeable = new URL(urlString).openStream();
        Throwable throwable = null;
        try {
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(inputStream, destinationPath, copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installJdk(JdkInstaller $this$installJdk, JdkInstallRequest request, Path markerFile) {
        JdkItem item = request.getItem();
        Path targetDir = request.getInstallDir();
        OsAbstractionForJdkInstaller.Wsl wslDistribution = $this$installJdk.wslDistributionFromPath(targetDir);
        if (wslDistribution != null && !Intrinsics.areEqual((Object)item.getOs(), (Object)"linux")) {
            throw new IllegalStateException(("Cannot install non-linux JDK into WSL environment to " + targetDir + " from " + item).toString());
        }
        String temp = ((Object)GlobalPaths.Companion.getInstance().getTestHomePath().resolve("tmp/jdk").toAbsolutePath()).toString();
        String[] stringArray = new String[]{"jdk-" + System.nanoTime() + "-" + item.getArchiveFileName()};
        Path downloadFile = Path.of(temp, stringArray);
        try {
            try {
                String string = item.getUrl();
                Intrinsics.checkNotNull((Object)downloadFile);
                this.downloadFileFromUrl(string, downloadFile);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(downloadFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    throw new RuntimeException("Downloaded file does not exist: " + downloadFile);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + item.getUrl() + ": " + t.getMessage(), t);
            }
            try {
                if (wslDistribution != null) {
                    JdkInstallerWSL.INSTANCE.unpackJdkOnWsl(wslDistribution, item.getPackageType(), downloadFile, targetDir, item.getPackageRootPrefix());
                } else {
                    Decompressor it = item.getPackageType().openDecompressor(downloadFile);
                    boolean bl = false;
                    char[] cArray = new char[]{'/'};
                    String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])cArray);
                    (StringsKt.isBlank((CharSequence)fullMatchPath) ? it : it.removePrefixPath(fullMatchPath)).extract(targetDir);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
            }
            Files.writeString(markerFile, (CharSequence)((Object)request.getJavaHome().toRealPath(new LinkOption[0])).toString(), Charsets.UTF_8, new OpenOption[0]);
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNull((Object)downloadFile);
            Files.deleteIfExists(downloadFile);
            throw throwable;
        }
        Files.deleteIfExists(downloadFile);
    }

    private static final JdkItemPaths listJDKs$lambda$2$0(JdkItem $jdk, JdkPredicate $predicate) {
        return INSTANCE.downloadJdkItem($jdk, $predicate);
    }

    public static final /* synthetic */ void access$installJdk(JdkDownloaderFacade $this, JdkInstaller $receiver, JdkInstallRequest request, Path markerFile) {
        $this.installJdk($receiver, request, markerFile);
    }
}

