/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.runner.SetupException;
import com.intellij.ide.starter.utils.RetryKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u0005JC\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u000bJ\u000e\u0010.\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u00100\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u00101\u001a\u00020\u000bJ\u0016\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u000bJ\u000e\u00105\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u0005J\u000e\u00106\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u0005J\u000e\u00109\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u0005J\u001e\u0010:\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u000bJ\u001e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u000b0>2\u0006\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010+\u001a\u00020\u000bJ\u0016\u0010?\u001a\u00020\u000b2\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u0005J \u0010B\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010C\u001a\u00020'2\b\b\u0002\u0010D\u001a\u00020\u000bJ\"\u0010E\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u00052\b\b\u0002\u00104\u001a\u00020\u000b2\b\b\u0002\u0010D\u001a\u00020\u000bJ(\u0010F\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020\u000b2\b\b\u0002\u0010H\u001a\u00020\u000bJ\u001e\u0010I\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u000bJ\u001e\u0010I\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020 J\u001e\u0010L\u001a\u00020\u001b2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u0005J\u000e\u0010P\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010Q\u001a\u00020'2\u0006\u0010A\u001a\u00020\u0005J\u000e\u0010R\u001a\u00020S2\u0006\u0010A\u001a\u00020\u0005R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\t\u001a\u0004\b\u0010\u0010\rR\u001b\u0010\u0012\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0013\u0010\r\u00a8\u0006T"}, d2={"Lcom/intellij/ide/starter/utils/Git;", "", "<init>", "()V", "homeDir", "Ljava/nio/file/Path;", "getHomeDir", "()Ljava/nio/file/Path;", "homeDir$delegate", "Lkotlin/Lazy;", "branch", "", "getBranch", "()Ljava/lang/String;", "branch$delegate", "localBranch", "getLocalBranch", "localBranch$delegate", "getDefaultBranch", "getGetDefaultBranch", "getDefaultBranch$delegate", "getLocalGitBranch", "repositoryDirectory", "getLocalCurrentCommitHash", "getShortBranchName", "getRepoRoot", "clone", "", "repoUrl", "destinationDir", "branchName", "shallow", "", "withSubmodules", "timeout", "Lkotlin/time/Duration;", "clone-17CK4j0", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;ZZJ)V", "status", "", "projectDir", "ensureRepository", "reset", "commitHash", "clean", "checkout", "fetch", "pull", "rebase", "newBase", "deleteBranch", "workDir", "targetBranch", "init", "addAll", "pruneWorktree", "pathToDir", "getStatus", "getDiff", "diffStart", "diffEnd", "getLocalBranches", "", "getRandomCommitInThePast", "date", "dir", "getRandomCommit", "limit", "format", "getLastCommit", "createWorktree", "worktree_dir", "commit", "setConfigProperty", "propertyName", "value", "buildDiff", "file", "Ljava/io/File;", "outputFile", "verifyBranch", "countTotalNumberOfCommits", "buildCommitGraph", "", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nGit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Git.kt\ncom/intellij/ide/starter/utils/Git\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,520:1\n1#2:521\n1586#3:522\n1661#3,3:523\n*S KotlinDebug\n*F\n+ 1 Git.kt\ncom/intellij/ide/starter/utils/Git\n*L\n371#1:522\n371#1:523,3\n*E\n"})
public final class Git {
    @NotNull
    public static final Git INSTANCE = new Git();
    @NotNull
    private static final Lazy homeDir$delegate = LazyKt.lazy(Git::homeDir_delegate$lambda$0);
    @NotNull
    private static final Lazy branch$delegate = LazyKt.lazy(Git::branch_delegate$lambda$0);
    @NotNull
    private static final Lazy localBranch$delegate = LazyKt.lazy(Git::localBranch_delegate$lambda$0);
    @NotNull
    private static final Lazy getDefaultBranch$delegate = LazyKt.lazy(Git::getDefaultBranch_delegate$lambda$0);

    private Git() {
    }

    private final Path getHomeDir() {
        Lazy lazy = homeDir$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Path)object;
    }

    @NotNull
    public final String getBranch() {
        Lazy lazy = branch$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getLocalBranch() {
        Lazy lazy = localBranch$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getGetDefaultBranch() {
        Lazy lazy = getDefaultBranch$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getLocalGitBranch(@NotNull Path repositoryDirectory) throws IOException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "rev-parse", "--abbrev-ref", "HEAD"};
        ProcessExecutor.start$default(new ProcessExecutor("git-local-branch-get", repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        return ((Object)StringsKt.trim((CharSequence)stdout.read())).toString();
    }

    @NotNull
    public final String getLocalCurrentCommitHash(@NotNull Path repositoryDirectory) throws IOException, InterruptedException {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "rev-parse", "HEAD"};
        ProcessExecutor.start$default(new ProcessExecutor("git-local-current-commit-get", repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        return ((Object)StringsKt.trim((CharSequence)stdout.read())).toString();
    }

    private final String getShortBranchName(Path repositoryDirectory) {
        String master = "master";
        Object object = this;
        try {
            Git $this$getShortBranchName_u24lambda_u240 = object;
            boolean bl = false;
            String branch = StringsKt.substringBefore$default((String)$this$getShortBranchName_u24lambda_u240.getLocalGitBranch(repositoryDirectory), (String)".", null, (int)2, null);
            if (Intrinsics.areEqual((Object)branch, (Object)master)) {
                return branch;
            }
            if (StringsKt.toIntOrNull((String)branch) == null) {
                return master;
            }
            return "IjPlatform" + branch;
        }
        catch (Throwable bl) {
            Object object2;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                object2 = object;
            } else {
                Throwable it = throwable;
                boolean bl2 = false;
                object2 = master;
            }
            return (String)object2;
        }
    }

    @NotNull
    public final Path getRepoRoot() {
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        try {
            Object[] objectArray = new String[]{"git", "rev-parse", "--show-toplevel", "HEAD"};
            ProcessExecutor.start$default(new ProcessExecutor("git-repo-root-get", null, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        }
        catch (Exception e) {
            Path workDir = Paths.get("", new String[0]).toAbsolutePath();
            LoggingKt.logError((String)("There is a problem in detecting git repo root. Trying to acquire working dir path: '" + workDir + "'"));
            Intrinsics.checkNotNull((Object)workDir);
            return workDir;
        }
        String[] stringArray = new String[]{"\n"};
        Path path = Paths.get(((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)stdout.read(), (String[])stringArray, (boolean)false, (int)0, (int)6, null))))).toString(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        return path2;
    }

    public final void clone-17CK4j0(@NotNull String repoUrl, @NotNull Path destinationDir, @NotNull String branchName, boolean shallow, boolean withSubmodules, long timeout) {
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        String cmdName = "git-clone";
        Object[] objectArray = new String[]{"git", "clone", repoUrl, ((Object)destinationDir).toString()};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)branchName).length() > 0) {
            objectArray = new String[]{"-b", branchName};
            arguments.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (shallow) {
            objectArray = new String[]{"--depth", "1"};
            arguments.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        if (withSubmodules) {
            arguments.add("--recurse-submodules");
        }
        if ((Unit)RetryKt.withRetryBlocking-1Y68eR8$default("Git clone " + repoUrl + " failed", 0L, 0L, (Function1)new Function1<Continuation<? super Unit>, Object>(destinationDir, null){
            int label;
            final /* synthetic */ Path $destinationDir;
            {
                this.$destinationDir = $destinationDir;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LoggingKt.logOutput((String)("Deleting " + this.$destinationDir + " ..."));
                        this.label = 1;
                        Object object2 = com.intellij.tools.ide.util.common.RetryKt.withRetry-gwCluXo$default((String)("Failed to delete " + this.$destinationDir), (long)0L, null, (long)0L, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this.$destinationDir, null){
                            int label;
                            final /* synthetic */ Path $destinationDir;
                            {
                                this.$destinationDir = $destinationDir;
                                super(1, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        PathsKt.deleteRecursively((Path)this.$destinationDir);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)14, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, (Function1)new Function1<Continuation<? super Unit>, Object>(cmdName, destinationDir, timeout, (List<String>)arguments, null){
            int label;
            final /* synthetic */ String $cmdName;
            final /* synthetic */ Path $destinationDir;
            final /* synthetic */ long $timeout;
            final /* synthetic */ List<String> $arguments;
            {
                this.$cmdName = $cmdName;
                this.$destinationDir = $destinationDir;
                this.$timeout = $timeout;
                this.$arguments = $arguments;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ProcessExecutor.start$default(new ProcessExecutor(this.$cmdName, this.$destinationDir.getParent().toAbsolutePath(), this.$timeout, null, this.$arguments, null, new ExecOutputRedirect.ToStdOut("[" + this.$cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + this.$cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, 6, null) == null) {
            throw new SetupException("Git clone " + repoUrl + " failed", null, 2, null);
        }
    }

    public static /* synthetic */ void clone-17CK4j0$default(Git git, String string, Path path, String string2, boolean bl, boolean bl2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
        }
        git.clone-17CK4j0(string, path, string2, bl, bl2, l);
    }

    public final int status(@NotNull Path projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Object[] objectArray = new String[]{"git", "-c", "core.fsmonitor=false", "status"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        long startTimer = System.currentTimeMillis();
        ExecOutputRedirect.ToString execOutStatus = new ExecOutputRedirect.ToString();
        ProcessExecutor.start$default(new ProcessExecutor("git-status", projectDir, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), null, arguments, null, execOutStatus, new ExecOutputRedirect.ToString(), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
        long endTimer = System.currentTimeMillis();
        int duration = (int)(endTimer - startTimer);
        System.out.println((Object)("Git status took " + duration));
        System.out.println((Object)("Git status output: " + execOutStatus.read()));
        ExecOutputRedirect.ToString execOutVersion = new ExecOutputRedirect.ToString();
        Object[] objectArray2 = new String[]{"git", "--version"};
        ProcessExecutor.start$default(new ProcessExecutor("git-version", projectDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray2), null, execOutVersion, new ExecOutputRedirect.ToString(), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
        System.out.println((Object)("Git version: " + execOutVersion.read()));
        ExecOutputRedirect.ToString execOutConfig = new ExecOutputRedirect.ToString();
        Object[] objectArray3 = new String[]{"git", "config", "-l", "--show-scope"};
        ProcessExecutor.start$default(new ProcessExecutor("git-config", projectDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray3), null, execOutConfig, new ExecOutputRedirect.ToString(), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
        System.out.println((Object)("Git config: " + execOutConfig.read()));
        return duration;
    }

    public final void ensureRepository(@NotNull Path repositoryDirectory) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        String cmdName = "git-rev-parse-show-prefix";
        Object[] objectArray = new String[]{"git", "rev-parse", "--show-prefix"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        ExecOutputRedirect.ToString stdoutRedirect = new ExecOutputRedirect.ToString();
        ExecOutputRedirect.ToStdOutAndString stderrRedirect = new ExecOutputRedirect.ToStdOutAndString("[" + cmdName + "]");
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), null, arguments, null, stdoutRedirect, stderrRedirect, null, null, null, true, 0, false, false, 30504, null), false, 1, null);
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)stdoutRedirect.read())).toString()).length() > 0) {
            throw new IllegalStateException(("Not a root of a git repository: " + repositoryDirectory + ". " + cmdName + " output: " + stdoutRedirect.read()).toString());
        }
    }

    public final void reset(@NotNull Path repositoryDirectory, @NotNull String commitHash) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        this.ensureRepository(repositoryDirectory);
        String cmdName = "git-reset";
        Object[] objectArray = new String[]{"git", "reset", "--hard"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)commitHash).length() > 0) {
            arguments.add(commitHash);
        }
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), null, arguments, null, new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
    }

    public static /* synthetic */ void reset$default(Git git, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        git.reset(path, string);
    }

    public final void clean(@NotNull Path repositoryDirectory) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        String cmdName = "git-clean";
        Object[] objectArray = new String[]{"git", "clean", "-fd"};
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
    }

    public final void checkout(@NotNull Path repositoryDirectory, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        String cmdName = "git-checkout";
        Object[] objectArray = new String[]{"git", "checkout"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)branchName).length() > 0) {
            arguments.add(branchName);
        }
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), null, arguments, null, new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
    }

    public static /* synthetic */ void checkout$default(Git git, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        git.checkout(path, string);
    }

    public final void fetch(@NotNull Path repositoryDirectory) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        String cmdName = "git-fetch";
        Object[] objectArray = new String[]{"git", "fetch"};
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
    }

    public final void pull(@NotNull Path repositoryDirectory) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        String cmdName = "git-pull";
        Object[] objectArray = new String[]{"git", "pull"};
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
    }

    public final void rebase(@NotNull Path repositoryDirectory, @NotNull String newBase) {
        Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        String cmdName = "git-rebase";
        Object[] objectArray = new String[]{"git", "rebase", newBase};
        ProcessExecutor.start$default(new ProcessExecutor(cmdName, repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), new ExecOutputRedirect.ToStdOut("[" + cmdName + "]"), null, null, null, true, 0, false, false, 30504, null), false, 1, null);
    }

    public static /* synthetic */ void rebase$default(Git git, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "master";
        }
        git.rebase(path, string);
    }

    public final void deleteBranch(@NotNull Path workDir, @NotNull String targetBranch) {
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        Intrinsics.checkNotNullParameter((Object)targetBranch, (String)"targetBranch");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "branch", "-D", targetBranch};
        ProcessExecutor.start$default(new ProcessExecutor("git-delete-branch", workDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
    }

    public final void init(@NotNull Path workDir) {
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "init"};
        ProcessExecutor.start$default(new ProcessExecutor("git-init", workDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
    }

    public final void addAll(@NotNull Path workDir) {
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "add", "*"};
        ProcessExecutor.start$default(new ProcessExecutor("git-add-all", workDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
    }

    public final void pruneWorktree(@NotNull Path pathToDir) {
        Intrinsics.checkNotNullParameter((Object)pathToDir, (String)"pathToDir");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "worktree", "prune"};
        ProcessExecutor.start$default(new ProcessExecutor("git-prune-worktree", pathToDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
    }

    @NotNull
    public final String getStatus(@NotNull Path pathToDir) {
        Intrinsics.checkNotNullParameter((Object)pathToDir, (String)"pathToDir");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "status"};
        ProcessExecutor.start$default(new ProcessExecutor("git-status", pathToDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        return stdout.read();
    }

    @NotNull
    public final String getDiff(@NotNull Path pathToDir, @NotNull String diffStart, @NotNull String diffEnd) {
        Intrinsics.checkNotNullParameter((Object)pathToDir, (String)"pathToDir");
        Intrinsics.checkNotNullParameter((Object)diffStart, (String)"diffStart");
        Intrinsics.checkNotNullParameter((Object)diffEnd, (String)"diffEnd");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "diff", diffStart, diffEnd, "--unified=0", "--no-renames"};
        ProcessExecutor.start$default(new ProcessExecutor("git-diff", pathToDir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        return stdout.read();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getLocalBranches(@NotNull Path repositoryDirectory, @NotNull String commitHash) {
        void $this$mapTo$iv$iv;
        ExecOutputRedirect.ToString stdout;
        block4: {
            Intrinsics.checkNotNullParameter((Object)repositoryDirectory, (String)"repositoryDirectory");
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Object[] objectArray = new String[]{"git", "for-each-ref", "--format='%(refname:short)'", "refs/heads/"};
            List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
            if (((CharSequence)commitHash).length() > 0) {
                objectArray = new String[]{"--contains", commitHash};
                arguments.addAll(CollectionsKt.listOf((Object[])objectArray));
            }
            stdout = new ExecOutputRedirect.ToString();
            try {
                ProcessExecutor.start$default(new ProcessExecutor("git-local-branches", repositoryDirectory.toAbsolutePath(), DurationKt.toDuration((int)8, (DurationUnit)DurationUnit.MINUTES), null, arguments, null, stdout, new ExecOutputRedirect.ToStdOut("git-local-branches"), null, null, null, false, 0, false, false, 32552, null), false, 1, null);
            }
            catch (IllegalStateException e) {
                String string = e.getMessage();
                boolean bl = string != null ? !StringsKt.contains$default((CharSequence)string, (CharSequence)"no such commit", (boolean)false, (int)2, null) : false;
                if (!bl) break block4;
                throw new IllegalStateException(e);
            }
        }
        String[] e = new String[]{"\n"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)stdout.read())).toString(), (String[])e, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"'", (String)"", (boolean)false, (int)4, null));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getLocalBranches$default(Git git, Path path, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return git.getLocalBranches(path, string);
    }

    @NotNull
    public final String getRandomCommitInThePast(@NotNull String date, @NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "log", "--after=\\\"" + date + " 00:00\\\"", "--before=\\\"" + date + " 23:59\\\"", "--format=%h"};
        ProcessExecutor.start$default(new ProcessExecutor("git-get-commits-on-specific-day", dir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        String[] stringArray = new String[]{"\n"};
        List commits = StringsKt.split$default((CharSequence)stdout.read(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return (String)commits.get(new Random().nextInt(commits.size()));
    }

    @NotNull
    public final String getRandomCommit(@NotNull Path dir, int limit, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "log", "-n" + limit, format};
        ProcessExecutor.start$default(new ProcessExecutor("git-get-random-commit", dir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        String[] stringArray = new String[]{"\n"};
        List commits = StringsKt.split$default((CharSequence)stdout.read(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return (String)commits.get(new Random().nextInt(commits.size()));
    }

    public static /* synthetic */ String getRandomCommit$default(Git git, Path path, int n, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = "--format=%h";
        }
        return git.getRandomCommit(path, n, string);
    }

    @NotNull
    public final String getLastCommit(@NotNull Path dir, @NotNull String targetBranch, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)targetBranch, (String)"targetBranch");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "log"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (((CharSequence)targetBranch).length() > 0) {
            objectArray = new String[]{"-b", targetBranch};
            arguments.addAll(CollectionsKt.listOf((Object[])objectArray));
        }
        objectArray = new String[]{"-n1", format};
        arguments.addAll(CollectionsKt.listOf((Object[])objectArray));
        ProcessExecutor.start$default(new ProcessExecutor("git-last-commit-get", dir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, arguments, null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        return ((Object)StringsKt.trim((CharSequence)stdout.read())).toString();
    }

    public static /* synthetic */ String getLastCommit$default(Git git, Path path, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "--format=%h";
        }
        return git.getLastCommit(path, string, string2);
    }

    @NotNull
    public final String createWorktree(@NotNull Path dir, @NotNull String targetBranch, @NotNull String worktree_dir, @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)targetBranch, (String)"targetBranch");
        Intrinsics.checkNotNullParameter((Object)worktree_dir, (String)"worktree_dir");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        ExecOutputRedirect.ToString stderr = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "worktree", "add", "-f"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        boolean isBranchCreated = Git.getLocalBranches$default(this, dir, null, 2, null).contains(targetBranch);
        this.pruneWorktree(dir);
        boolean bl = isBranchCreated;
        if (!bl) {
            Object[] objectArray2 = new String[]{"-b", targetBranch, worktree_dir};
            arguments.addAll(CollectionsKt.listOf((Object[])objectArray2));
            if (((CharSequence)commit).length() > 0) {
                arguments.add(commit);
            }
        } else if (bl) {
            Object[] objectArray3 = new String[]{worktree_dir, targetBranch};
            arguments.addAll(CollectionsKt.listOf((Object[])objectArray3));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ProcessExecutor.start$default(new ProcessExecutor("git-create-worktree", dir, DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MINUTES), null, arguments, null, stdout, stderr, null, null, null, false, 0, false, false, 32552, null), false, 1, null);
        return ((Object)StringsKt.trim((CharSequence)stdout.read())).toString();
    }

    public static /* synthetic */ String createWorktree$default(Git git, Path path, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = "";
        }
        return git.createWorktree(path, string, string2, string3);
    }

    public final void setConfigProperty(@NotNull Path dir, @NotNull String propertyName, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "config", "--local", propertyName, "\"" + value + "\""};
        ProcessExecutor.start$default(new ProcessExecutor("git config", dir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
    }

    public final void setConfigProperty(@NotNull Path dir, @NotNull String propertyName, boolean value) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "config", "--local", propertyName, String.valueOf(value)};
        ProcessExecutor.start$default(new ProcessExecutor("git config", dir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
    }

    public final void buildDiff(@NotNull Path dir, @NotNull File file, @NotNull Path outputFile) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Object[] objectArray = new String[]{"git", "diff", "--output=" + outputFile.toFile().getAbsolutePath(), file.getAbsolutePath()};
        ProcessExecutor.start$default(new ProcessExecutor("git-build-diff", dir, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), false, 1, null);
    }

    public final boolean verifyBranch(@NotNull String branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Git git = this;
        try {
            Git $this$verifyBranch_u24lambda_u240 = git;
            boolean bl = false;
            Object[] objectArray = new String[]{"git", "show-ref", "refs/heads/" + branch};
            ProcessExecutor.start$default(new ProcessExecutor("git verify branch", $this$verifyBranch_u24lambda_u240.getHomeDir(), DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return ((CharSequence)stdout.read()).length() > 0;
    }

    public final int countTotalNumberOfCommits(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        ExecOutputRedirect.ToString stdout = new ExecOutputRedirect.ToString();
        Object[] objectArray = new String[]{"git", "rev-list", "--count", "--all"};
        ProcessExecutor.start$default(new ProcessExecutor("git-revlist-all", dir.toAbsolutePath(), DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, stdout, null, null, null, null, false, 0, false, false, 32680, null), false, 1, null);
        return Integer.parseInt(((Object)StringsKt.trim((CharSequence)stdout.read())).toString());
    }

    public final long buildCommitGraph(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        long start2 = System.currentTimeMillis();
        Object[] objectArray = new String[]{"git", "commit-graph", "write", "--reachable", "--changed-paths"};
        ProcessExecutor.start$default(new ProcessExecutor("git-commit-graph", dir.toAbsolutePath(), DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES), null, CollectionsKt.listOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), false, 1, null);
        return System.currentTimeMillis() - start2;
    }

    private static final Path homeDir_delegate$lambda$0() {
        return Paths.get(PathManager.getHomePath(), new String[0]);
    }

    private static final String branch_delegate$lambda$0() {
        return INSTANCE.getShortBranchName(INSTANCE.getHomeDir());
    }

    private static final String localBranch_delegate$lambda$0() {
        return INSTANCE.getLocalGitBranch(INSTANCE.getHomeDir());
    }

    /*
     * WARNING - void declaration
     */
    private static final String getDefaultBranch_delegate$lambda$0() {
        void var0;
        String majorBranch = StringsKt.substringBefore$default((String)INSTANCE.getLocalBranch(), (String)".", null, (int)2, null);
        return Intrinsics.areEqual((Object)majorBranch, (Object)"HEAD") || Intrinsics.areEqual((Object)majorBranch, (Object)"master") ? "master" : var0;
    }
}

