/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/starter/utils/JarUtils;", "", "<init>", "()V", "extractResource", "Ljava/nio/file/Path;", "resourceName", "", "tempDir", "extractFromJar", "", "resourceUrl", "Ljava/net/URL;", "resourcePath", "targetDir", "intellij.tools.ide.starter"})
public final class JarUtils {
    @NotNull
    public static final JarUtils INSTANCE = new JarUtils();

    private JarUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Path extractResource(@NotNull String resourceName, @NotNull Path tempDir) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Path targetDir = tempDir.resolve(resourceName);
        URL uRL = JarUtils.class.getClassLoader().getResource(resourceName);
        if (uRL == null) {
            throw new IllegalStateException("Resource not found: " + resourceName);
        }
        URL resourceUrl = uRL;
        Files.createDirectories(targetDir, new FileAttribute[0]);
        String string = resourceUrl.getProtocol();
        if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
            Intrinsics.checkNotNull((Object)targetDir);
            this.extractFromJar(resourceUrl, resourceName, targetDir);
        } else {
            if (!Intrinsics.areEqual((Object)string, (Object)"file")) throw new IllegalStateException("Unsupported protocol: " + resourceUrl.getProtocol());
            Path resourceDir = Path.of(resourceUrl.toURI());
            if (!Files.isDirectory(resourceDir, new LinkOption[0])) throw new IllegalStateException("Resource is not a directory: " + resourceName);
            Files.walk(resourceDir, new FileVisitOption[0]).filter(arg_0 -> JarUtils.extractResource$lambda$1(JarUtils::extractResource$lambda$0, arg_0)).forEach(arg_0 -> JarUtils.extractResource$lambda$3(arg_0 -> JarUtils.extractResource$lambda$2(resourceDir, targetDir, arg_0), arg_0));
        }
        Intrinsics.checkNotNull((Object)targetDir);
        return targetDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void extractFromJar(URL resourceUrl, String resourcePath, Path targetDir) {
        String externalForm = resourceUrl.toExternalForm();
        Intrinsics.checkNotNull((Object)externalForm);
        int bangIndex = StringsKt.indexOf$default((CharSequence)externalForm, (String)"!/", (int)0, (boolean)false, (int)6, null);
        URI fsUri = URI.create(StringsKt.take((String)externalForm, (int)(bangIndex + 2)));
        Closeable closeable = FileSystems.newFileSystem(fsUri, MapsKt.emptyMap());
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            char[] cArray = new char[]{'/'};
            String entryPath = StringsKt.trimStart((String)resourcePath, (char[])cArray);
            Path basePath = fs.getPath(entryPath, new String[0]);
            Files.walk(basePath, new FileVisitOption[0]).filter(arg_0 -> JarUtils.extractFromJar$lambda$0$1(JarUtils::extractFromJar$lambda$0$0, arg_0)).forEach(arg_0 -> JarUtils.extractFromJar$lambda$0$3(arg_0 -> JarUtils.extractFromJar$lambda$0$2(basePath, targetDir, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final boolean extractResource$lambda$0(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean extractResource$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractResource$lambda$2(Path $resourceDir, Path $targetDir, Path filePath) {
        Path relativePath = $resourceDir.relativize(filePath);
        Path targetFile = $targetDir.resolve(relativePath);
        Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(filePath, targetFile, copyOptionArray);
        return Unit.INSTANCE;
    }

    private static final void extractResource$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean extractFromJar$lambda$0$0(Path it) {
        return Files.isRegularFile(it, new LinkOption[0]);
    }

    private static final boolean extractFromJar$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit extractFromJar$lambda$0$2(Path $basePath, Path $targetDir, Path pathInJar) {
        Path relative = $basePath.relativize(pathInJar);
        Path target = $targetDir.resolve(((Object)relative).toString());
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(pathInJar, target, copyOptionArray);
        return Unit.INSTANCE;
    }

    private static final void extractFromJar$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

