/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.util.JavaXmlDocumentKt;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ(\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00160\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/starter/utils/XmlBuilder;", "", "<init>", "()V", "parse", "Lorg/w3c/dom/Document;", "inputStream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "Ljavax/xml/parsers/DocumentBuilder;", "writeDocument", "", "xmlDoc", "outputPath", "findNode", "Ljava/util/Optional;", "Lorg/w3c/dom/Element;", "nodes", "Lorg/w3c/dom/NodeList;", "filter", "Lkotlin/Function1;", "", "intellij.tools.ide.starter"})
public final class XmlBuilder {
    @NotNull
    public static final XmlBuilder INSTANCE = new XmlBuilder();

    private XmlBuilder() {
    }

    @NotNull
    public final Document parse(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        DocumentBuilder documentBuilder = JavaXmlDocumentKt.createDocumentBuilder$default((boolean)false, (int)1, null);
        Document xmlDoc = documentBuilder.parse(inputStream);
        xmlDoc.getDocumentElement().normalize();
        Intrinsics.checkNotNull((Object)xmlDoc);
        return xmlDoc;
    }

    @NotNull
    public final Document parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DocumentBuilder documentBuilder = JavaXmlDocumentKt.createDocumentBuilder$default((boolean)false, (int)1, null);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new FileNotFoundException(((Object)path).toString());
        }
        Document xmlDoc = this.parse(documentBuilder, path);
        xmlDoc.getDocumentElement().normalize();
        return xmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Document parse(DocumentBuilder $this$parse, Path path) {
        Document document;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputSource inputSource;
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            InputSource $this$parse_u24lambda_u240_u240 = inputSource = new InputSource(stream);
            boolean bl2 = false;
            $this$parse_u24lambda_u240_u240.setSystemId(path.toUri().toASCIIString());
            InputSource inputSource2 = inputSource;
            Document document2 = $this$parse.parse(inputSource2);
            document = document2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"use(...)");
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDocument(@NotNull Document xmlDoc, @NotNull Path outputPath) {
        Intrinsics.checkNotNullParameter((Object)xmlDoc, (String)"xmlDoc");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        DOMSource source = new DOMSource(xmlDoc);
        TransformerFactory transformerFactory = TransformerFactory.newDefaultInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(outputPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            transformer.transform(source, new StreamResult(it));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final Optional<Element> findNode(@NotNull NodeList nodes, @NotNull Function1<? super Element, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Optional<Object> optional = IntStream.range(0, nodes.getLength()).mapToObj(arg_0 -> XmlBuilder.findNode$lambda$0(nodes, arg_0)).filter(arg_0 -> XmlBuilder.findNode$lambda$1(filter, arg_0)).findAny();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findAny(...)");
        return optional;
    }

    private static final Element findNode$lambda$0(NodeList $nodes, int i) {
        Node node = $nodes.item(i);
        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
        return (Element)node;
    }

    private static final boolean findNode$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

