/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils.threadDumpParser;

import com.intellij.diagnostic.CoroutineDumperKt;
import com.intellij.ide.starter.utils.threadDumpParser.ThreadOperation;
import com.intellij.ide.starter.utils.threadDumpParser.ThreadState;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u000eJ,\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/ide/starter/utils/threadDumpParser/ThreadDumpParser;", "", "<init>", "()V", "ourThreadStartPattern", "Ljava/util/regex/Pattern;", "ourForcedThreadStartPattern", "ourYourkitThreadStartPattern", "ourYourkitThreadStartPattern2", "ourThreadStatePattern", "ourThreadStatePattern2", "ourWaitingForLockPattern", "ourParkingToWaitForLockPattern", "PUMP_EVENT", "", "Lorg/jetbrains/annotations/NonNls;", "ourIdleTimerThreadPattern", "ourIdleSwingTimerThreadPattern", "AT_JAVA_LANG_OBJECT_WAIT", "ourLockedOwnableSynchronizersPattern", "parse", "", "Lcom/intellij/ide/starter/utils/threadDumpParser/ThreadState;", "threadDump", "findLockOwner", "result", "lockId", "ignoreWaiting", "", "sortThreads", "", "findLockedOwnableSynchronizers", "stackTrace", "findWaitingForLock", "getInterestLevel", "", "state", "isKnownJdkThread", "inferThreadStateDetail", "threadState", "tryParseThreadStart", "line", "matchYourKit", "Ljava/util/regex/Matcher;", "tryParseThreadState", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nThreadDumpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadDumpParser.kt\ncom/intellij/ide/starter/utils/threadDumpParser/ThreadDumpParser\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,259:1\n106#2:260\n78#2,22:261\n106#2:283\n78#2,22:284\n106#2:306\n78#2,22:307\n*S KotlinDebug\n*F\n+ 1 ThreadDumpParser.kt\ncom/intellij/ide/starter/utils/threadDumpParser/ThreadDumpParser\n*L\n51#1:260\n51#1:261,22\n70#1:283\n70#1:284,22\n248#1:306\n248#1:307,22\n*E\n"})
public final class ThreadDumpParser {
    @NotNull
    public static final ThreadDumpParser INSTANCE = new ThreadDumpParser();
    @NotNull
    private static final Pattern ourThreadStartPattern;
    @NotNull
    private static final Pattern ourForcedThreadStartPattern;
    @NotNull
    private static final Pattern ourYourkitThreadStartPattern;
    @NotNull
    private static final Pattern ourYourkitThreadStartPattern2;
    @NotNull
    private static final Pattern ourThreadStatePattern;
    @NotNull
    private static final Pattern ourThreadStatePattern2;
    @NotNull
    private static final Pattern ourWaitingForLockPattern;
    @NotNull
    private static final Pattern ourParkingToWaitForLockPattern;
    @NotNull
    private static final String PUMP_EVENT = "java.awt.EventDispatchThread.pumpOneEventForFilters";
    @NotNull
    private static final Pattern ourIdleTimerThreadPattern;
    @NotNull
    private static final Pattern ourIdleSwingTimerThreadPattern;
    @NotNull
    private static final String AT_JAVA_LANG_OBJECT_WAIT = "at java.lang.Object.wait(";
    @NotNull
    private static final Pattern ourLockedOwnableSynchronizersPattern;

    private ThreadDumpParser() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ThreadState> parse(@NotNull String threadDump) {
        Intrinsics.checkNotNullParameter((Object)threadDump, (String)"threadDump");
        List result2 = new ArrayList();
        StringBuilder lastThreadStack = new StringBuilder();
        ThreadState lastThreadState = null;
        boolean expectingThreadState = false;
        boolean haveNonEmptyStackTrace = false;
        StringBuilder coroutineDump = null;
        for (Object t : StringUtil.tokenize((String)threadDump, (String)"\r\n")) {
            ThreadState state;
            void $this$trim$iv;
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            String line = (String)t;
            if (Intrinsics.areEqual((Object)"---------- Event counts ----------", (Object)line)) break;
            if (CoroutineDumperKt.isCoroutineDumpHeader((String)line)) {
                coroutineDump = new StringBuilder();
            }
            if (coroutineDump != null) {
                coroutineDump.append(line).append("\n");
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"============", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"Java-level deadlock", (boolean)false, (int)2, null)) break;
            String string = line;
            ThreadDumpParser threadDumpParser = this;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if ((state = threadDumpParser.tryParseThreadStart(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) != null) {
                if (lastThreadState != null) {
                    String string2 = lastThreadStack.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    lastThreadState.setStackTrace(string2, !haveNonEmptyStackTrace);
                }
                lastThreadState = state;
                result2.add(lastThreadState);
                lastThreadStack.setLength(0);
                haveNonEmptyStackTrace = false;
                lastThreadStack.append(line).append("\n");
                expectingThreadState = true;
                continue;
            }
            boolean parsedThreadState = false;
            if (expectingThreadState) {
                expectingThreadState = false;
                ThreadState threadState = lastThreadState;
                Intrinsics.checkNotNull((Object)threadState);
                parsedThreadState = this.tryParseThreadState(line, threadState);
            }
            lastThreadStack.append(line).append("\n");
            if (parsedThreadState) continue;
            String $this$trim$iv2 = line;
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            if (!StringsKt.startsWith$default((String)((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString(), (String)"at", (boolean)false, (int)2, null)) continue;
            haveNonEmptyStackTrace = true;
        }
        if (lastThreadState != null) {
            String string = lastThreadStack.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            lastThreadState.setStackTrace(string, !haveNonEmptyStackTrace);
        }
        for (ThreadState threadState : result2) {
            this.inferThreadStateDetail(threadState);
        }
        for (ThreadState threadState : result2) {
            String lockId = this.findWaitingForLock(threadState.getStackTrace());
            ThreadState lockOwner = this.findLockOwner(result2, lockId, true);
            if (lockOwner == null) {
                lockOwner = this.findLockOwner(result2, lockId, false);
            }
            if (lockOwner == null) continue;
            if (threadState.isAwaitedBy(lockOwner)) {
                threadState.addDeadlockedThread(lockOwner);
                lockOwner.addDeadlockedThread(threadState);
            }
            lockOwner.addWaitingThread(threadState);
        }
        this.sortThreads(result2);
        if (coroutineDump != null) {
            ThreadState coroutineState = new ThreadState("Coroutine dump", "undefined");
            String string = coroutineDump.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            coroutineState.setStackTrace(string, false);
            result2.add(coroutineState);
        }
        return result2;
    }

    private final ThreadState findLockOwner(List<? extends ThreadState> result2, String lockId, boolean ignoreWaiting) {
        if (lockId == null) {
            return null;
        }
        String marker = "- locked <" + lockId + ">";
        for (ThreadState threadState : result2) {
            String trace = threadState.getStackTrace();
            if (!StringsKt.contains$default((CharSequence)trace, (CharSequence)marker, (boolean)false, (int)2, null) || ignoreWaiting && StringsKt.contains$default((CharSequence)trace, (CharSequence)AT_JAVA_LANG_OBJECT_WAIT, (boolean)false, (int)2, null)) continue;
            return threadState;
        }
        for (ThreadState threadState : result2) {
            if (threadState.getOwnableSynchronizers() == null || !Intrinsics.areEqual((Object)threadState.getOwnableSynchronizers(), (Object)lockId)) continue;
            return threadState;
        }
        return null;
    }

    public final void sortThreads(@NotNull List<? extends ThreadState> result2) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        CollectionsKt.sortWith(result2, (arg_0, arg_1) -> ThreadDumpParser.sortThreads$lambda$1(ThreadDumpParser::sortThreads$lambda$0, arg_0, arg_1));
    }

    private final String findLockedOwnableSynchronizers(String stackTrace) {
        Matcher m = ourLockedOwnableSynchronizersPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private final String findWaitingForLock(String stackTrace) {
        Matcher m = ourWaitingForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(2);
        }
        m = ourParkingToWaitForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private final int getInterestLevel(ThreadState state) {
        if (state.isEmptyStackTrace()) {
            return -10;
        }
        if (state.isKnownJDKThread()) {
            return -5;
        }
        if (state.isSleeping()) {
            return -2;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return -1;
        }
        return state.getStackDepth();
    }

    public final boolean isKnownJdkThread(@NotNull String stackTrace) {
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        return StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"java.lang.ref.Reference$ReferenceHandler.run", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"java.lang.ref.Finalizer$FinalizerThread.run", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"sun.awt.AWTAutoShutdown.run", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"sun.java2d.Disposer.run", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"sun.awt.windows.WToolkit.eventLoop", (boolean)false, (int)2, null) || ourIdleTimerThreadPattern.matcher(stackTrace).find() || ourIdleSwingTimerThreadPattern.matcher(stackTrace).find();
    }

    public final void inferThreadStateDetail(@NotNull ThreadState threadState) {
        String javaThreadState;
        Intrinsics.checkNotNullParameter((Object)threadState, (String)"threadState");
        String stackTrace = threadState.getStackTrace();
        if (StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"at java.net.PlainSocketImpl.socketAccept", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"at java.net.PlainDatagramSocketImpl.receive", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"at java.net.SocketInputStream.socketRead", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"at java.net.PlainSocketImpl.socketConnect", (boolean)false, (int)2, null)) {
            threadState.setOperation(ThreadOperation.Socket);
        } else if (StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"at java.io.FileInputStream.readBytes", (boolean)false, (int)2, null)) {
            threadState.setOperation(ThreadOperation.IO);
        } else if (StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"at java.lang.Thread.sleep", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)"RUNNABLE", (Object)(javaThreadState = threadState.getJavaThreadState()))) {
            threadState.setThreadStateDetail("sleeping");
        }
        if (threadState.isEDT()) {
            if (StringsKt.contains$default((CharSequence)stackTrace, (CharSequence)"java.awt.EventQueue.getNextEvent", (boolean)false, (int)2, null)) {
                threadState.setThreadStateDetail("idle");
            }
            int modality = 0;
            int pos = 0;
            while ((pos = StringsKt.indexOf$default((CharSequence)stackTrace, (String)PUMP_EVENT, (int)pos, (boolean)false, (int)4, null)) >= 0) {
                ++modality;
                pos += 51;
            }
            threadState.setExtraState("modality level " + modality);
        }
        threadState.setOwnableSynchronizers(this.findLockedOwnableSynchronizers(threadState.getStackTrace()));
    }

    private final ThreadState tryParseThreadStart(String line) {
        String line2 = line;
        Matcher m = ourThreadStartPattern.matcher(line2);
        if (m.find()) {
            String string = m.group(1);
            String string2 = m.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            ThreadState state = new ThreadState(string, string2);
            if (StringsKt.contains$default((CharSequence)line2, (CharSequence)" daemon ", (boolean)false, (int)2, null)) {
                state.setDaemon(true);
            }
            return state;
        }
        m = ourForcedThreadStartPattern.matcher(line2);
        if (m.matches()) {
            String string = m.group(1);
            String string3 = m.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            return new ThreadState(string, string3);
        }
        boolean daemon = StringsKt.contains$default((CharSequence)line2, (CharSequence)" [DAEMON]", (boolean)false, (int)2, null);
        if (daemon) {
            String string = StringUtil.replace((String)line2, (String)" [DAEMON]", (String)"");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            line2 = string;
        }
        Matcher matcher = this.matchYourKit(line2);
        if (matcher == null) {
            return null;
        }
        m = matcher;
        String string = m.group(1);
        String string4 = m.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
        ThreadState state = new ThreadState(string, string4);
        state.setDaemon(daemon);
        return state;
    }

    private final Matcher matchYourKit(String line) {
        Matcher m;
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"[", (boolean)false, (int)2, null) && (m = ourYourkitThreadStartPattern.matcher(line)).matches()) {
            return m;
        }
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"CPU usage on sample:", (boolean)false, (int)2, null) && (m = ourYourkitThreadStartPattern2.matcher(line)).matches()) {
            return m;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryParseThreadState(String line, ThreadState threadState) {
        Matcher m = ourThreadStatePattern.matcher(line);
        if (m.find()) {
            void $this$trim$iv;
            threadState.setJavaThreadState(m.group(1));
            String string = m.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            String string2 = string;
            ThreadState threadState2 = threadState;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            threadState2.setThreadStateDetail(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            return true;
        }
        m = ourThreadStatePattern2.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            return true;
        }
        return false;
    }

    private static final int sortThreads$lambda$0(ThreadState o1, ThreadState o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return INSTANCE.getInterestLevel(o2) - INSTANCE.getInterestLevel(o1);
    }

    private static final int sortThreads$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        Pattern pattern = Pattern.compile("^\"(.+)\".+(prio=\\d+ (?:os_prio=[^\\s]+ )?.*tid=[^\\s]+ nid=[^\\s]+|[Ii][Dd]=\\d+) ([^\\[]+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        ourThreadStartPattern = pattern;
        Pattern pattern2 = Pattern.compile("^Thread (\\d+): \\(state = (.+)\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        ourForcedThreadStartPattern = pattern2;
        Pattern pattern3 = Pattern.compile("(.+) \\[([A-Z_, ]*)]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        ourYourkitThreadStartPattern = pattern3;
        Pattern pattern4 = Pattern.compile("(.+) (?:State:)? (.+) CPU usage on sample: .+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        ourYourkitThreadStartPattern2 = pattern4;
        Pattern pattern5 = Pattern.compile("java\\.lang\\.Thread\\.State: (.+) \\((.+)\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        ourThreadStatePattern = pattern5;
        Pattern pattern6 = Pattern.compile("java\\.lang\\.Thread\\.State: (.+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern6, (String)"compile(...)");
        ourThreadStatePattern2 = pattern6;
        Pattern pattern7 = Pattern.compile("- waiting (on|to lock) <(.+)>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern7, (String)"compile(...)");
        ourWaitingForLockPattern = pattern7;
        Pattern pattern8 = Pattern.compile("- parking to wait for {2}<(.+)>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern8, (String)"compile(...)");
        ourParkingToWaitForLockPattern = pattern8;
        Pattern pattern9 = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at java\\.util\\.TimerThread\\.mainLoop");
        Intrinsics.checkNotNullExpressionValue((Object)pattern9, (String)"compile(...)");
        ourIdleTimerThreadPattern = pattern9;
        Pattern pattern10 = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at javax\\.swing\\.TimerQueue\\.run");
        Intrinsics.checkNotNullExpressionValue((Object)pattern10, (String)"compile(...)");
        ourIdleSwingTimerThreadPattern = pattern10;
        Pattern pattern11 = Pattern.compile("- <(0x[\\da-f]+)> \\(.*\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern11, (String)"compile(...)");
        ourLockedOwnableSynchronizersPattern = pattern11;
    }
}

