/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter;

import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"downloadGoSdk", "Ljava/nio/file/Path;", "version", "", "intellij.tools.ide.starter"})
public final class GolangKt {
    @NotNull
    public static final Path downloadGoSdk(@NotNull String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (SystemInfo.isWindows) {
            string = "windows";
        } else if (SystemInfo.isLinux) {
            string = "linux";
        } else if (SystemInfo.isMac) {
            string = "darwin";
        } else {
            throw new IllegalStateException("Unknown OS".toString());
        }
        String os = string;
        String arch = SystemInfo.isAarch64 ? "arm64" : "amd64";
        String extension = SystemInfo.isWindows ? ".zip" : ".tar.gz";
        String sdkFileName = "go" + version + "." + os + "-" + arch + extension;
        String url = "https://cache-redirector.jetbrains.com/dl.google.com/go/" + sdkFileName;
        Path dirToDownload = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("go-sdk/" + version);
        Path downloadedFile = dirToDownload.resolve(sdkFileName);
        Path goRoot = dirToDownload.resolve("go-roots");
        Intrinsics.checkNotNull((Object)goRoot);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(goRoot, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path = goRoot.resolve("go");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }
        Intrinsics.checkNotNull((Object)downloadedFile);
        HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, url, downloadedFile, 0L, 0L, 12, null);
        FileSystem.INSTANCE.unpack(downloadedFile, goRoot);
        Path path = goRoot.resolve("go");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

