/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ci.teamcity;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.ide.starter.ci.CIServer;
import com.intellij.ide.starter.ci.teamcity.TeamCityClient;
import com.intellij.ide.starter.ci.teamcity.TeamCityClientKt;
import com.intellij.ide.starter.config.ConfigurationStorage;
import com.intellij.ide.starter.config.StarterConfigurationStorageKt;
import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.runner.CurrentTestMethod;
import com.intellij.ide.starter.runner.TestMethod;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.HttpRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\"\b\u0016\u0018\u0000 a2\u00020\u0001:\u0002abB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J2\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012J*\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J*\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\nJ\"\u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0 2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u001c\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\u0012H\u0002J\u0006\u0010[\u001a\u00020\nJ\u0018\u0010]\u001a\u00020\u00122\u0006\u0010^\u001a\u00020\n2\u0006\u0010_\u001a\u00020\u0012H\u0002J\u0006\u0010`\u001a\u00020\u0012R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R'\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001b\u001a\u0004\b$\u0010%R\u0014\u0010*\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001b\u0010,\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u001b\u001a\u0004\b-\u0010\u0019R\u001b\u0010/\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u001b\u001a\u0004\b0\u0010\u0019R\u001b\u00102\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u001b\u001a\u0004\b2\u0010+R\u001d\u00104\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u001b\u001a\u0004\b5\u0010\u0019R\u001b\u00107\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u001b\u001a\u0004\b8\u0010\u0019R\u001d\u0010:\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010\u001b\u001a\u0004\b;\u0010\u0019R'\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u001b\u001a\u0004\b>\u0010%R\u001b\u0010@\u001a\u00020A8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010\u001b\u001a\u0004\bB\u0010CR\u001b\u0010E\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010\u001b\u001a\u0004\bF\u0010\u0019R\u001b\u0010H\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u001b\u001a\u0004\bI\u0010\u0019R\u001b\u0010K\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010\u001b\u001a\u0004\bK\u0010+R\u001b\u0010M\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bN\u0010\u001b\u001a\u0004\bM\u0010+R\u001b\u0010O\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\u001b\u001a\u0004\bP\u0010\u0019R\u001b\u0010R\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010\u001b\u001a\u0004\bS\u0010\u0019R\u001d\u0010U\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u0010\u001b\u001a\u0004\bV\u0010\u0019R\u001d\u0010X\u001a\u0004\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bZ\u0010\u001b\u001a\u0004\bY\u0010\u0019R\u0011\u0010\\\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010+\u00a8\u0006c"}, d2={"Lcom/intellij/ide/starter/ci/teamcity/TeamCityCIServer;", "Lcom/intellij/ide/starter/ci/CIServer;", "systemPropertiesFilePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "publishArtifact", "", "source", "artifactPath", "", "artifactName", "reportTest", "testName", "message", "details", "linkToLogs", "isFailure", "", "reportTestFailure", "reportPassedTest", "ignoreTestFailure", "isTestFailureShouldBeIgnored", "buildStartTime", "getBuildStartTime", "()Ljava/lang/String;", "buildStartTime$delegate", "Lkotlin/Lazy;", "getListOfPatternsWhichShouldBeIgnored", "", "Lkotlin/text/Regex;", "loadProperties", "", "propertiesPath", "systemProperties", "", "getSystemProperties", "()Ljava/util/Map;", "systemProperties$delegate", "getBuildParam", "name", "impreciseNameMatch", "isBuildRunningOnCI", "()Z", "buildNumber", "getBuildNumber", "buildNumber$delegate", "branchName", "getBranchName", "branchName$delegate", "isJetbrainsBuildserver", "isJetbrainsBuildserver$delegate", "configurationName", "getConfigurationName", "configurationName$delegate", "buildVcsNumber", "getBuildVcsNumber", "buildVcsNumber$delegate", "buildConfigName", "getBuildConfigName", "buildConfigName$delegate", "buildParams", "getBuildParams", "buildParams$delegate", "serverUri", "Ljava/net/URI;", "getServerUri", "()Ljava/net/URI;", "serverUri$delegate", "userName", "getUserName", "userName$delegate", "password", "getPassword", "password$delegate", "isDefaultBranch", "isDefaultBranch$delegate", "isPersonalBuild", "isPersonalBuild$delegate", "buildId", "getBuildId", "buildId$delegate", "teamcityAgentName", "getTeamcityAgentName", "teamcityAgentName$delegate", "teamcityCloudProfile", "getTeamcityCloudProfile", "teamcityCloudProfile$delegate", "buildTypeId", "getBuildTypeId", "buildTypeId$delegate", "buildUrl", "isSpecialBuild", "hasBooleanProperty", "key", "default", "isSafePush", "Companion", "TeamCityMetadataType", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nTeamCityCIServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityCIServer.kt\ncom/intellij/ide/starter/ci/teamcity/TeamCityCIServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 7 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,341:1\n1#2:342\n1869#3,2:343\n1869#3,2:345\n295#3,2:354\n536#4:347\n521#4,6:348\n126#5:356\n153#5,3:357\n527#6:360\n83#7:361\n*S KotlinDebug\n*F\n+ 1 TeamCityCIServer.kt\ncom/intellij/ide/starter/ci/teamcity/TeamCityCIServer\n*L\n90#1:343,2\n129#1:345,2\n104#1:354,2\n171#1:347\n171#1:348,6\n160#1:356\n160#1:357,3\n197#1:360\n197#1:361\n*E\n"})
public class TeamCityCIServer
implements CIServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path systemPropertiesFilePath;
    @NotNull
    private final Lazy buildStartTime$delegate;
    @NotNull
    private final Lazy systemProperties$delegate;
    private final boolean isBuildRunningOnCI;
    @NotNull
    private final Lazy buildNumber$delegate;
    @NotNull
    private final Lazy branchName$delegate;
    @NotNull
    private final Lazy isJetbrainsBuildserver$delegate;
    @NotNull
    private final Lazy configurationName$delegate;
    @NotNull
    private final Lazy buildVcsNumber$delegate;
    @NotNull
    private final Lazy buildConfigName$delegate;
    @NotNull
    private final Lazy buildParams$delegate;
    @NotNull
    private final Lazy serverUri$delegate;
    @NotNull
    private final Lazy userName$delegate;
    @NotNull
    private final Lazy password$delegate;
    @NotNull
    private final Lazy isDefaultBranch$delegate;
    @NotNull
    private final Lazy isPersonalBuild$delegate;
    @NotNull
    private final Lazy buildId$delegate;
    @NotNull
    private final Lazy teamcityAgentName$delegate;
    @NotNull
    private final Lazy teamcityCloudProfile$delegate;
    @NotNull
    private final Lazy buildTypeId$delegate;
    @NotNull
    public static final String LOCAL_RUN_ID = "LOCAL_RUN_SNAPSHOT";

    public TeamCityCIServer(@Nullable Path systemPropertiesFilePath) {
        this.systemPropertiesFilePath = systemPropertiesFilePath;
        this.buildStartTime$delegate = LazyKt.lazy(() -> TeamCityCIServer.buildStartTime_delegate$lambda$0(this));
        this.systemProperties$delegate = LazyKt.lazy(() -> TeamCityCIServer.systemProperties_delegate$lambda$0(this));
        this.isBuildRunningOnCI = System.getenv("TEAMCITY_VERSION") != null;
        this.buildNumber$delegate = LazyKt.lazy(TeamCityCIServer::buildNumber_delegate$lambda$0);
        this.branchName$delegate = LazyKt.lazy(() -> TeamCityCIServer.branchName_delegate$lambda$0(this));
        this.isJetbrainsBuildserver$delegate = LazyKt.lazy(() -> TeamCityCIServer.isJetbrainsBuildserver_delegate$lambda$0(this));
        this.configurationName$delegate = LazyKt.lazy(() -> TeamCityCIServer.configurationName_delegate$lambda$0(this));
        this.buildVcsNumber$delegate = LazyKt.lazy(() -> TeamCityCIServer.buildVcsNumber_delegate$lambda$0(this));
        this.buildConfigName$delegate = LazyKt.lazy(() -> TeamCityCIServer.buildConfigName_delegate$lambda$0(this));
        this.buildParams$delegate = LazyKt.lazy(() -> TeamCityCIServer.buildParams_delegate$lambda$0(this));
        this.serverUri$delegate = LazyKt.lazy(TeamCityCIServer::serverUri_delegate$lambda$0);
        this.userName$delegate = LazyKt.lazy(() -> TeamCityCIServer.userName_delegate$lambda$0(this));
        this.password$delegate = LazyKt.lazy(() -> TeamCityCIServer.password_delegate$lambda$0(this));
        this.isDefaultBranch$delegate = LazyKt.lazy(() -> TeamCityCIServer.isDefaultBranch_delegate$lambda$0(this));
        this.isPersonalBuild$delegate = LazyKt.lazy(() -> TeamCityCIServer.isPersonalBuild_delegate$lambda$0(this));
        this.buildId$delegate = LazyKt.lazy(() -> TeamCityCIServer.buildId_delegate$lambda$0(this));
        this.teamcityAgentName$delegate = LazyKt.lazy(() -> TeamCityCIServer.teamcityAgentName_delegate$lambda$0(this));
        this.teamcityCloudProfile$delegate = LazyKt.lazy(() -> TeamCityCIServer.teamcityCloudProfile_delegate$lambda$0(this));
        this.buildTypeId$delegate = LazyKt.lazy(() -> TeamCityCIServer.buildTypeId_delegate$lambda$0(this));
    }

    public /* synthetic */ TeamCityCIServer(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Path path2;
            try {
                String string = System.getenv("TEAMCITY_BUILD_PROPERTIES_FILE");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
                Path path3 = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                path2 = path3;
            }
            catch (Exception exception) {
                path2 = null;
            }
            path = path2;
        }
        this(path);
    }

    @Override
    public void publishArtifact(@NotNull Path source, @NotNull String artifactPath, @NotNull String artifactName) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        TeamCityClient.publishTeamCityArtifacts$default(TeamCityClient.INSTANCE, source, artifactPath, artifactName, false, null, 24, null);
    }

    public final void reportTest(@NotNull String testName, @NotNull String message, @NotNull String details, @Nullable String linkToLogs, boolean isFailure) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String flowId = string;
        String generifiedTestName = Companion.processStringForTC(testName);
        String string2 = "##teamcity[testStarted name='%s' flowId='%s' nodeId='%s' parentNodeId='0']";
        Object[] objectArray = new Object[]{generifiedTestName, flowId, generifiedTestName};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        LoggingKt.logOutput((String)string3);
        if (isFailure) {
            string2 = "##teamcity[testFailed name='%s' message='%s' details='%s' flowId='%s' nodeId='%s' parentNodeId='0']";
            objectArray = new Object[]{generifiedTestName, Companion.processStringForTC(message), Companion.processStringForTC(details), flowId, generifiedTestName};
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            LoggingKt.logOutput((String)string4);
            if (this.isJetbrainsBuildserver()) {
                Companion.addTestMetadata(generifiedTestName, TeamCityMetadataType.LINK, flowId, "Start bisect", "https://ij-perf.labs.jb.gg/bisect/launcher?buildId=" + this.getBuildId());
            }
        }
        String string5 = linkToLogs;
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            Companion.addTestMetadata(generifiedTestName, TeamCityMetadataType.LINK, flowId, "Link to Logs and artifacts", it);
        }
        TestMethod testMethod = CurrentTestMethod.INSTANCE.get();
        if (testMethod != null) {
            TestMethod it = testMethod;
            boolean bl = false;
            Companion.addTestMetadata(generifiedTestName, TeamCityMetadataType.TEXT, flowId, "Test name", it.fullName());
        }
        string2 = "##teamcity[testFinished name='%s' flowId='%s' nodeId='%s' parentNodeId='0']";
        Object[] objectArray2 = new Object[]{generifiedTestName, flowId, generifiedTestName};
        String string6 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        LoggingKt.logOutput((String)string6);
    }

    public static /* synthetic */ void reportTest$default(TeamCityCIServer teamCityCIServer, String string, String string2, String string3, String string4, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportTest");
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        teamCityCIServer.reportTest(string, string2, string3, string4, bl);
    }

    @Override
    public void reportTestFailure(@NotNull String testName, @NotNull String message, @NotNull String details, @Nullable String linkToLogs) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.reportTest(testName, message, details, linkToLogs, true);
    }

    public final void reportPassedTest(@NotNull String testName, @NotNull String message, @NotNull String details, @Nullable String linkToLogs) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.reportTest(testName, message, details, linkToLogs, false);
    }

    public static /* synthetic */ void reportPassedTest$default(TeamCityCIServer teamCityCIServer, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportPassedTest");
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        teamCityCIServer.reportPassedTest(string, string2, string3, string4);
    }

    @Override
    public void ignoreTestFailure(@NotNull String testName, @NotNull String message, @Nullable String details) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String flowId = string;
        String generifiedTestName = Companion.processStringForTC(testName);
        String string2 = "##teamcity[testStarted name='%s' flowId='%s' nodeId='%s' parentNodeId='0']";
        Object[] objectArray = new Object[]{generifiedTestName, flowId, generifiedTestName};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        LoggingKt.logOutput((String)string3);
        string2 = "##teamcity[testIgnored name='%s' message='%s' flowId='%s' nodeId='%s']";
        objectArray = new Object[]{generifiedTestName, Companion.processStringForTC(message), flowId, generifiedTestName};
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        LoggingKt.logOutput((String)string4);
        String string5 = details;
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            Companion.addTestMetadataWithoutStringProcessing(generifiedTestName, TeamCityMetadataType.TEXT, flowId, "Details", details);
        }
        string2 = "##teamcity[testFinished name='%s' flowId='%s' nodeId='%s' parentNodeId='0']";
        Object[] objectArray2 = new Object[]{generifiedTestName, flowId, generifiedTestName};
        String string6 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        LoggingKt.logOutput((String)string6);
    }

    @Override
    public boolean isTestFailureShouldBeIgnored(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterable $this$forEach$iv = this.getListOfPatternsWhichShouldBeIgnored();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Regex pattern = (Regex)element$iv;
            boolean bl = false;
            if (!pattern.containsMatchIn((CharSequence)message)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final String getBuildStartTime() {
        Lazy lazy = this.buildStartTime$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    private final List<Regex> getListOfPatternsWhichShouldBeIgnored() {
        String ignoredPattern = StarterConfigurationStorageKt.ignoredTestFailuresPattern(ConfigurationStorage.Companion);
        LoggingKt.logOutput((String)("DEBUG: ignored patterns from ENV " + ignoredPattern));
        Object[] objectArray = new Regex[]{new Regex("No files have been downloaded for .+:.+"), new Regex("Library '.+' resolution failed"), new Regex("Too many IDE internal errors. Monitoring stopped."), new Regex("Invalid folding descriptor detected"), new Regex("Non-idempotent computation: it returns different results when invoked multiple times"), new Regex("current modality=ModalityState:.+com.intellij.openapi.ui.impl.DialogWrapperPeerImpl"), new Regex("Descriptions are missed for tools: DevContainerIdeSettings")};
        List patterns = CollectionsKt.mutableListOf((Object[])objectArray);
        if (ignoredPattern != null && !StringsKt.isBlank((CharSequence)ignoredPattern)) {
            String[] stringArray = new String[]{"\n"};
            List ignoredPatterns = StringsKt.split$default((CharSequence)ignoredPattern, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$forEach$iv = ignoredPatterns;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                LoggingKt.logOutput((String)("Add " + it + " ignored pattern from env"));
                patterns.add(new Regex(it));
            }
        }
        return patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> loadProperties(Path propertiesPath) {
        Object object;
        try {
            Map map;
            object = propertiesPath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                Map map2 = new LinkedHashMap();
                Properties ps = new Properties();
                ps.load(it);
                ps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> TeamCityCIServer.loadProperties$lambda$0$0(map2, arg_0, arg_1)));
                map = map2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = map;
        }
        catch (Throwable t) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final Map<String, String> getSystemProperties() {
        Lazy lazy = this.systemProperties$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final String getBuildParam(String name, boolean impreciseNameMatch) {
        String string;
        Map totalParams = MapsKt.plus(this.getSystemProperties(), this.getBuildParams());
        if (impreciseNameMatch) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = totalParams;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((CharSequence)it.getKey()), (CharSequence)name, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map paramCandidates = destination$iv$iv;
            if (paramCandidates.size() > 1) {
                System.err.println("Found many parameters matching " + name + ". Candidates: " + paramCandidates);
            }
            string = (String)paramCandidates.get(MapsKt.toSortedMap((Map)paramCandidates).firstKey());
        } else {
            string = (String)totalParams.get(name);
        }
        String paramValue = string;
        return paramValue;
    }

    static /* synthetic */ String getBuildParam$default(TeamCityCIServer teamCityCIServer, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getBuildParam");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return teamCityCIServer.getBuildParam(string, bl);
    }

    @Override
    public boolean isBuildRunningOnCI() {
        return this.isBuildRunningOnCI;
    }

    @Override
    @NotNull
    public String getBuildNumber() {
        Lazy lazy = this.buildNumber$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getBranchName() {
        Lazy lazy = this.branchName$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isJetbrainsBuildserver() {
        Lazy lazy = this.isJetbrainsBuildserver$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final String getConfigurationName() {
        Lazy lazy = this.configurationName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getBuildVcsNumber() {
        Lazy lazy = this.buildVcsNumber$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getBuildConfigName() {
        Lazy lazy = this.buildConfigName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Map<String, String> getBuildParams() {
        Lazy lazy = this.buildParams$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final URI getServerUri() {
        Lazy lazy = this.serverUri$delegate;
        return (URI)lazy.getValue();
    }

    @NotNull
    public final String getUserName() {
        Lazy lazy = this.userName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getPassword() {
        Lazy lazy = this.password$delegate;
        return (String)lazy.getValue();
    }

    private final boolean isDefaultBranch() {
        Lazy lazy = this.isDefaultBranch$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isPersonalBuild() {
        Lazy lazy = this.isPersonalBuild$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final String getBuildId() {
        Lazy lazy = this.buildId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getTeamcityAgentName() {
        Lazy lazy = this.teamcityAgentName$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getTeamcityCloudProfile() {
        Lazy lazy = this.teamcityCloudProfile$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getBuildTypeId() {
        Lazy lazy = this.buildTypeId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String buildUrl() {
        return this.getServerUri() + "/buildConfiguration/" + this.getBuildTypeId() + "/" + this.getBuildId() + "?buildTab=tests";
    }

    public final boolean isSpecialBuild() {
        if (!this.isBuildRunningOnCI()) {
            LoggingKt.logOutput((String)"[Metrics Publishing] Not running build on TeamCity => DISABLED");
            return true;
        }
        if (this.isPersonalBuild()) {
            LoggingKt.logOutput((String)"[Metrics Publishing] Personal builds are ignored => DISABLED");
            return true;
        }
        if (!this.isDefaultBranch()) {
            LoggingKt.logOutput((String)"[Metrics Publishing] Non default branches builds are ignored => DISABLED");
            return true;
        }
        return false;
    }

    private final boolean hasBooleanProperty(String key, boolean bl) {
        String string = TeamCityCIServer.getBuildParam$default(this, key, false, 2, null);
        return string != null ? StringsKt.equals((String)string, (String)"true", (boolean)true) : bl;
    }

    public final boolean isSafePush() {
        String isSafePush = System.getenv("SAFE_PUSH");
        return isSafePush != null && Intrinsics.areEqual((Object)isSafePush, (Object)"true");
    }

    private static final String buildStartTime_delegate$lambda$0(TeamCityCIServer this$0) {
        Object object;
        block7: {
            block8: {
                Object object2;
                Object v2;
                Object it;
                block5: {
                    block6: {
                        if (!Intrinsics.areEqual((Object)this$0.getBuildId(), (Object)LOCAL_RUN_ID)) break block6;
                        object = ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME);
                        break block7;
                    }
                    URI fullUrl = TeamCityClient.INSTANCE.getRestUri().resolve("builds/id:" + this$0.getBuildId() + "?fields=startDate");
                    Intrinsics.checkNotNull((Object)fullUrl);
                    Set set = TeamCityClient.INSTANCE.get(fullUrl, (Function1<? super HttpRequest, ? extends HttpRequest>)((Function1)TeamCityCIServer::buildStartTime_delegate$lambda$0$0)).properties();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
                    Iterable $this$firstOrNull$iv = set;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (Map.Entry)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getKey(), (Object)"startDate")) continue;
                        v2 = element$iv;
                        break block5;
                    }
                    v2 = null;
                }
                if ((object = (Map.Entry)v2) == null || (object = (JsonNode)object.getValue()) == null || (object = object.asText()) == null) break block8;
                it = object;
                boolean bl = false;
                Object object3 = this$0;
                try {
                    TeamCityCIServer $this$buildStartTime_delegate_u24lambda_u240_u242_u240 = object3;
                    boolean bl2 = false;
                    object2 = Result.constructor-impl((Object)ZonedDateTime.parse((CharSequence)it, DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssX")).format(DateTimeFormatter.RFC_1123_DATE_TIME));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object3 = object2;
                String string = (String)(Result.isFailure-impl((Object)object3) ? null : object3);
                object = string;
                if (string != null) break block7;
            }
            object = ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME);
        }
        return object;
    }

    private static final HttpRequest buildStartTime_delegate$lambda$0$0(HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TeamCityClientKt.withAuth(it);
    }

    private static final void loadProperties$lambda$0$0(Map $map, Object k, Object v) {
        if (k != null && v != null) {
            $map.put(k.toString(), v.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map systemProperties_delegate$lambda$0(TeamCityCIServer this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path it;
        Map props = new LinkedHashMap();
        Path path = this$0.systemPropertiesFilePath;
        if (path != null) {
            it = path;
            boolean bl = false;
            props.putAll(this$0.loadProperties(it));
        }
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        Map map = properties;
        Map map2 = props;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it2.getKey().toString(), (Object)it2.getValue().toString()));
        }
        MapsKt.putAll((Map)map2, (Iterable)((List)destination$iv$iv));
        return props;
    }

    private static final String buildNumber_delegate$lambda$0() {
        String string = System.getenv("BUILD_NUMBER");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String branchName_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = this$0.getBuildParams().get("teamcity.build.branch");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final boolean isJetbrainsBuildserver_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = TeamCityCIServer.getBuildParam$default(this$0, "teamcity.serverUrl", false, 2, null);
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"buildserver.labs.intellij.net", (boolean)false, (int)2, null) : false;
    }

    private static final String configurationName_delegate$lambda$0(TeamCityCIServer this$0) {
        return TeamCityCIServer.getBuildParam$default(this$0, "teamcity.buildConfName", false, 2, null);
    }

    private static final String buildVcsNumber_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = TeamCityCIServer.getBuildParam$default(this$0, "build.vcs.number", false, 2, null);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    private static final String buildConfigName_delegate$lambda$0(TeamCityCIServer this$0) {
        return TeamCityCIServer.getBuildParam$default(this$0, "teamcity.buildConfName", false, 2, null);
    }

    private static final Map buildParams_delegate$lambda$0(TeamCityCIServer this$0) {
        String configurationPropertiesFile = this$0.getSystemProperties().get("teamcity.configuration.properties.file");
        CharSequence charSequence = configurationPropertiesFile;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return MapsKt.emptyMap();
        }
        Path path = Paths.get(configurationPropertiesFile, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return this$0.loadProperties(path);
    }

    /*
     * WARNING - void declaration
     */
    private static final URI serverUri_delegate$lambda$0() {
        void $this$instance$iv;
        DirectDIAware directDIAware = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
        String tag$iv = "teamcity.uri";
        boolean $i$f$instance = false;
        DirectDI directDI = $this$instance$iv.getDirectDI();
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<URI>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        return (URI)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, URI.class), (Object)tag$iv);
    }

    private static final String userName_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = TeamCityCIServer.getBuildParam$default(this$0, "teamcity.auth.userId", false, 2, null);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final String password_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = TeamCityCIServer.getBuildParam$default(this$0, "teamcity.auth.password", false, 2, null);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final boolean isDefaultBranch_delegate$lambda$0(TeamCityCIServer this$0) {
        return this$0.hasBooleanProperty("teamcity.build.branch.is_default", false);
    }

    private static final boolean isPersonalBuild_delegate$lambda$0(TeamCityCIServer this$0) {
        return StringsKt.equals((String)TeamCityCIServer.getBuildParam$default(this$0, "build.is.personal", false, 2, null), (String)"true", (boolean)true);
    }

    private static final String buildId_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = TeamCityCIServer.getBuildParam$default(this$0, "teamcity.build.id", false, 2, null);
        if (string == null) {
            string = LOCAL_RUN_ID;
        }
        return string;
    }

    private static final String teamcityAgentName_delegate$lambda$0(TeamCityCIServer this$0) {
        String string = this$0.getBuildParams().get("teamcity.agent.name");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String teamcityCloudProfile_delegate$lambda$0(TeamCityCIServer this$0) {
        return TeamCityCIServer.getBuildParam$default(this$0, "system.cloud.profile_id", false, 2, null);
    }

    private static final String buildTypeId_delegate$lambda$0(TeamCityCIServer this$0) {
        return TeamCityCIServer.getBuildParam$default(this$0, "teamcity.buildType.id", false, 2, null);
    }

    public TeamCityCIServer() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u00020\u0005*\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u001e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u001e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J4\u0010\u001b\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005J4\u0010\u001f\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ide/starter/ci/teamcity/TeamCityCIServer$Companion;", "", "<init>", "()V", "LOCAL_RUN_ID", "", "processStringForTC", "setStatusTextPrefix", "", "text", "reportTeamCityStatistics", "key", "value", "", "", "reportTeamCityMessage", "testSuiteStarted", "suiteName", "flowId", "testSuiteFinished", "testStarted", "testName", "testFinished", "testIgnored", "message", "testFailed", "addTextMetadata", "addTestMetadata", "type", "Lcom/intellij/ide/starter/ci/teamcity/TeamCityCIServer$TeamCityMetadataType;", "name", "addTestMetadataWithoutStringProcessing", "progressStart", "activityName", "progressFinish", "intellij.tools.ide.starter"})
    @SourceDebugExtension(value={"SMAP\nTeamCityCIServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityCIServer.kt\ncom/intellij/ide/starter/ci/teamcity/TeamCityCIServer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,341:1\n1#2:342\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String processStringForTC(@NotNull String $this$processStringForTC) {
            Intrinsics.checkNotNullParameter((Object)$this$processStringForTC, (String)"<this>");
            String string = $this$processStringForTC.substring(0, Math.min(7000, $this$processStringForTC.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"\\|", (String)"||", (boolean)false, (int)4, null), (String)"\\[", (String)"|[", (boolean)false, (int)4, null), (String)"]", (String)"|]", (boolean)false, (int)4, null), (String)"\n", (String)"|n", (boolean)false, (int)4, null), (String)"'", (String)"|'", (boolean)false, (int)4, null), (String)"\r", (String)"|r", (boolean)false, (int)4, null);
        }

        public final void setStatusTextPrefix(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            LoggingKt.logOutput((String)(" ##teamcity[buildStatus text='" + text + " {build.status.text}'] "));
        }

        public final void reportTeamCityStatistics(@NotNull String key, int value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            LoggingKt.logOutput((String)(" ##teamcity[buildStatisticValue key='" + key + "' value='" + value + "']"));
        }

        public final void reportTeamCityStatistics(@NotNull String key, long value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            LoggingKt.logOutput((String)(" ##teamcity[buildStatisticValue key='" + key + "' value='" + value + "']"));
        }

        public final void reportTeamCityMessage(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            LoggingKt.logOutput((String)(" ##teamcity[message text='" + text + "']"));
        }

        public final void testSuiteStarted(@NotNull String suiteName, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)suiteName, (String)"suiteName");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            System.out.println((Object)("##teamcity[testSuiteStarted name='" + this.processStringForTC(suiteName) + "' flowId='" + flowId + "']"));
        }

        public final void testSuiteFinished(@NotNull String suiteName, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)suiteName, (String)"suiteName");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            System.out.println((Object)("##teamcity[testSuiteFinished name='" + this.processStringForTC(suiteName) + "' flowId='" + flowId + "']"));
        }

        public final void testStarted(@NotNull String testName, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            System.out.println((Object)("##teamcity[testStarted name='" + this.processStringForTC(testName) + "' flowId='" + flowId + "']"));
        }

        public final void testFinished(@NotNull String testName, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            System.out.println((Object)("##teamcity[testFinished name='" + this.processStringForTC(testName) + "' flowId='" + flowId + "']"));
        }

        public final void testIgnored(@NotNull String testName, @NotNull String message, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            System.out.println((Object)("##teamcity[testIgnored name='" + this.processStringForTC(testName) + "' message='" + this.processStringForTC(message) + "' flowId='" + flowId + "']"));
        }

        public final void testFailed(@NotNull String testName, @NotNull String message, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            System.out.println((Object)("##teamcity[testFailed name='" + this.processStringForTC(testName) + "' message='" + this.processStringForTC(message) + "' flowId='" + flowId + "']"));
        }

        public final void addTextMetadata(@NotNull String testName, @NotNull String value, @NotNull String flowId) {
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)flowId, (String)"flowId");
            this.addTestMetadata(testName, TeamCityMetadataType.TEXT, flowId, null, value);
        }

        public final void addTestMetadata(@Nullable String testName, @NotNull TeamCityMetadataType type, @Nullable String flowId, @Nullable String name, @NotNull String value) {
            Object object;
            String flow;
            String nameAttr;
            block11: {
                block10: {
                    block9: {
                        Object object2;
                        block8: {
                            block7: {
                                Object object3;
                                block6: {
                                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                    object3 = name;
                                    if (object3 == null) break block6;
                                    String it = object3;
                                    boolean bl = false;
                                    String string = "name='" + Companion.processStringForTC(it) + "'";
                                    object3 = string;
                                    if (string != null) break block7;
                                }
                                object3 = nameAttr = "";
                            }
                            if ((object2 = flowId) == null) break block8;
                            String it = object2;
                            boolean bl = false;
                            String string = "flowId='" + it + "'";
                            object2 = string;
                            if (string != null) break block9;
                        }
                        object2 = flow = "";
                    }
                    if ((object = testName) == null) break block10;
                    String it = object;
                    boolean bl = false;
                    String string = "testName='" + Companion.processStringForTC(it) + "'";
                    object = string;
                    if (string != null) break block11;
                }
                object = "";
            }
            String testName2 = object;
            String string = type.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            System.out.println((Object)("##teamcity[testMetadata " + testName2 + " type='" + string + "' " + nameAttr + " value='" + this.processStringForTC(value) + "' " + flow + "]"));
        }

        public final void addTestMetadataWithoutStringProcessing(@Nullable String testName, @NotNull TeamCityMetadataType type, @Nullable String flowId, @Nullable String name, @NotNull String value) {
            Object object;
            String flow;
            String nameAttr;
            block11: {
                block10: {
                    block9: {
                        Object object2;
                        block8: {
                            block7: {
                                Object object3;
                                block6: {
                                    Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                    object3 = name;
                                    if (object3 == null) break block6;
                                    String it = object3;
                                    boolean bl = false;
                                    String string = "name='" + it + "'";
                                    object3 = string;
                                    if (string != null) break block7;
                                }
                                object3 = nameAttr = "";
                            }
                            if ((object2 = flowId) == null) break block8;
                            String it = object2;
                            boolean bl = false;
                            String string = "flowId='" + it + "'";
                            object2 = string;
                            if (string != null) break block9;
                        }
                        object2 = flow = "";
                    }
                    if ((object = testName) == null) break block10;
                    String it = object;
                    boolean bl = false;
                    String string = "testName='" + it + "'";
                    object = string;
                    if (string != null) break block11;
                }
                object = "";
            }
            String testName2 = object;
            String string = type.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            System.out.println((Object)("##teamcity[testMetadata " + testName2 + " type='" + string + "' " + nameAttr + " value='" + this.processStringForTC(value) + "' " + flow + "]"));
        }

        public final void progressStart(@NotNull String activityName) {
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            System.out.println((Object)("##teamcity[progressStart '" + this.processStringForTC(activityName) + "']"));
        }

        public final void progressFinish(@NotNull String activityName) {
            Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
            System.out.println((Object)("##teamcity[progressFinish '" + this.processStringForTC(activityName) + "']"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/starter/ci/teamcity/TeamCityCIServer$TeamCityMetadataType;", "", "<init>", "(Ljava/lang/String;I)V", "NUMBER", "TEXT", "LINK", "ARTIFACT", "IMAGE", "intellij.tools.ide.starter"})
    public static final class TeamCityMetadataType
    extends Enum<TeamCityMetadataType> {
        public static final /* enum */ TeamCityMetadataType NUMBER = new TeamCityMetadataType();
        public static final /* enum */ TeamCityMetadataType TEXT = new TeamCityMetadataType();
        public static final /* enum */ TeamCityMetadataType LINK = new TeamCityMetadataType();
        public static final /* enum */ TeamCityMetadataType ARTIFACT = new TeamCityMetadataType();
        public static final /* enum */ TeamCityMetadataType IMAGE = new TeamCityMetadataType();
        private static final /* synthetic */ TeamCityMetadataType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TeamCityMetadataType[] values() {
            return (TeamCityMetadataType[])$VALUES.clone();
        }

        public static TeamCityMetadataType valueOf(String value) {
            return Enum.valueOf(TeamCityMetadataType.class, value);
        }

        @NotNull
        public static EnumEntries<TeamCityMetadataType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = teamCityMetadataTypeArray = new TeamCityMetadataType[]{TeamCityMetadataType.NUMBER, TeamCityMetadataType.TEXT, TeamCityMetadataType.LINK, TeamCityMetadataType.ARTIFACT, TeamCityMetadataType.IMAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

