/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ci.teamcity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.ide.starter.ci.teamcity.TeamCityClient;
import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.models.IdeInfo;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.GenerifyKt;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.tools.ide.util.common.RetryKt;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019J\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001dJ\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\rJ\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u001dH\u0002J4\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u001d2\b\b\u0002\u0010$\u001a\u00020\u001d2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0011\u0010\u0013\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006-"}, d2={"Lcom/intellij/ide/starter/ci/teamcity/TeamCityClient;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "teamCityURI", "Ljava/net/URI;", "getTeamCityURI", "()Ljava/net/URI;", "teamCityURI$delegate", "Lkotlin/Lazy;", "artifactForPublishingDir", "Ljava/nio/file/Path;", "getArtifactForPublishingDir", "()Ljava/nio/file/Path;", "artifactForPublishingDir$delegate", "restUri", "getRestUri", "guestAuthUri", "getGuestAuthUri", "get", "Lcom/fasterxml/jackson/databind/JsonNode;", "fullUrl", "additionalRequestActions", "Lkotlin/Function1;", "Lorg/apache/http/HttpRequest;", "getLastSuccessfulBuild", "Lkotlin/Pair;", "", "ideInfo", "Lcom/intellij/ide/starter/models/IdeInfo;", "getMasterMajorVersion", "downloadArtifact", "", "buildId", "artifactName", "outPath", "printTcArtifactsPublishMessage", "spec", "publishTeamCityArtifacts", "source", "artifactPath", "zipContent", "", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nTeamCityClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityClient.kt\ncom/intellij/ide/starter/ci/teamcity/TeamCityClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 5 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n1#2:165\n230#3,2:166\n527#4:168\n83#5:169\n13#6:170\n*S KotlinDebug\n*F\n+ 1 TeamCityClient.kt\ncom/intellij/ide/starter/ci/teamcity/TeamCityClient\n*L\n73#1:166,2\n36#1:168\n36#1:169\n35#1:170\n*E\n"})
public final class TeamCityClient {
    @NotNull
    public static final TeamCityClient INSTANCE = new TeamCityClient();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy teamCityURI$delegate;
    @NotNull
    private static final Lazy artifactForPublishingDir$delegate;
    @NotNull
    private static final URI restUri;
    @NotNull
    private static final URI guestAuthUri;

    private TeamCityClient() {
    }

    private final URI getTeamCityURI() {
        Lazy lazy = teamCityURI$delegate;
        return (URI)lazy.getValue();
    }

    @NotNull
    public final Path getArtifactForPublishingDir() {
        Lazy lazy = artifactForPublishingDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final URI getRestUri() {
        return restUri;
    }

    @NotNull
    public final URI getGuestAuthUri() {
        return guestAuthUri;
    }

    @NotNull
    public final JsonNode get(@NotNull URI fullUrl, @NotNull Function1<? super HttpRequest, ? extends HttpRequest> additionalRequestActions) {
        JsonNode result2;
        HttpGet httpGet;
        Intrinsics.checkNotNullParameter((Object)fullUrl, (String)"fullUrl");
        Intrinsics.checkNotNullParameter(additionalRequestActions, (String)"additionalRequestActions");
        HttpGet $this$get_u24lambda_u241 = httpGet = new HttpGet(fullUrl);
        boolean bl = false;
        $this$get_u24lambda_u241.addHeader("Content-Type", "application/json");
        $this$get_u24lambda_u241.addHeader("Accept", "application/json");
        additionalRequestActions.invoke((Object)$this$get_u24lambda_u241);
        HttpGet request = httpGet;
        logger.debug("Request to TeamCity: " + fullUrl);
        JsonNode jsonNode = result2 = (JsonNode)RetryKt.withRetryBlocking-zkXUZaI$default((String)"Failure during request to TeamCity", (long)0L, null, (long)0L, (Function1)((Function1)new Function1<Continuation<? super JsonNode>, Object>(request, null){
            int label;
            final /* synthetic */ HttpGet $request;
            {
                this.$request = $request;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return HttpClient.INSTANCE.sendRequest((HttpUriRequest)this.$request, get.result.1::invokeSuspend$lambda$0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super JsonNode> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final JsonNode invokeSuspend$lambda$0(HttpResponse it) {
                if (it.getStatusLine().getStatusCode() != 200) {
                    LoggingKt.logError((String)TextStreamsKt.readText((Reader)new InputStreamReader(it.getEntity().getContent())));
                    throw new RuntimeException("TeamCity returned not successful status code " + it.getStatusLine().getStatusCode());
                }
                return ExtensionsKt.jacksonObjectMapper().readTree(it.getEntity().getContent());
            }
        }), (int)14, null);
        if (jsonNode == null) {
            boolean bl2 = false;
            String string = "Request " + request.getURI() + " failed";
            throw new IllegalArgumentException(string.toString());
        }
        return jsonNode;
    }

    public static /* synthetic */ JsonNode get$default(TeamCityClient teamCityClient, URI uRI, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = TeamCityClient::get$lambda$0;
        }
        return teamCityClient.get(uRI, (Function1<? super HttpRequest, ? extends HttpRequest>)function1);
    }

    @NotNull
    public final Pair<String, String> getLastSuccessfulBuild(@NotNull IdeInfo ideInfo) {
        CharSequence charSequence;
        Object element$iv2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ideInfo, (String)"ideInfo");
            CharSequence charSequence2 = ideInfo.getTag();
            String tag = !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? "tag:" + ideInfo.getTag() + "," : "";
            String number = !StringsKt.isBlank((CharSequence)ideInfo.getBuildNumber()) ? "number:" + ideInfo.getBuildNumber() + "," : "";
            URI fullUrl = guestAuthUri.resolve("builds?locator=buildType:" + ideInfo.getBuildType() + "," + tag + number + "status:SUCCESS,state:(finished:true),count:1,history:false");
            Intrinsics.checkNotNull((Object)fullUrl);
            Set set = TeamCityClient.get$default(this, fullUrl, null, 2, null).properties();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
            Iterable $this$first$iv = set;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Map.Entry it = (Map.Entry)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)"build")) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        JsonNode build = (JsonNode)((Map.Entry)element$iv2).getValue();
        String buildId = build.findValue("id").asText();
        CharSequence charSequence3 = ideInfo.getBuildNumber();
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            boolean bl = false;
            charSequence = build.findValue("number").asText();
        } else {
            charSequence = charSequence3;
        }
        String buildNumber = (String)charSequence;
        return new Pair((Object)buildId, (Object)buildNumber);
    }

    @NotNull
    public final String getMasterMajorVersion() {
        URI url = guestAuthUri.resolve("builds?locator=buildType:ijplatform_master_IdeaInstallersBuildNumber,branch:master,status:SUCCESS,state:(finished:true),count:1");
        Intrinsics.checkNotNull((Object)url);
        String string = TeamCityClient.get$default(this, url, null, 2, null).findValue("number").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        String[] stringArray = new String[]{"."};
        return (String)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
    }

    public final void downloadArtifact(@NotNull String buildId, @NotNull String artifactName, @NotNull Path outPath) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        URI artifactUrl = guestAuthUri.resolve("builds/id:" + buildId + "/artifacts/content/" + artifactName);
        String string = artifactUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, string, outPath, 0L, 0L, 12, null);
    }

    private final void printTcArtifactsPublishMessage(String spec) {
        logger.debug(" !!teamcity[publishArtifacts '" + spec + "'] ");
        LoggingKt.logOutput((String)(" ##teamcity[publishArtifacts '" + spec + "'] "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void publishTeamCityArtifacts(@NotNull Path source, @NotNull String artifactPath, @NotNull String artifactName, boolean zipContent, @NotNull Path artifactForPublishingDir) {
        Object object;
        Object object2;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)artifactForPublishingDir, (String)"artifactForPublishingDir");
        logger.debug("TeamCity publishTeamCityArtifacts " + source.getFileName());
        String sanitizedArtifactPath = GenerifyKt.replaceSpecialCharactersWithHyphens$default(artifactPath, null, 1, null);
        String sanitizedArtifactName = GenerifyKt.replaceSpecialCharactersWithHyphens$default(artifactName, null, 1, null);
        Path path = source;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.debug("TeamCity artifact " + source + " does not exist");
            return;
        }
        Object suffix = null;
        int nextSuffix = 0;
        Path artifactDir = null;
        if (StringsKt.contains$default((CharSequence)sanitizedArtifactName, (char)'.', (boolean)false, (int)2, null)) {
            int dotIndex = StringsKt.indexOf$default((CharSequence)sanitizedArtifactName, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string = StringsKt.take((String)sanitizedArtifactName, (int)dotIndex);
            String string2 = sanitizedArtifactName.substring(dotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            pair = TuplesKt.to((Object)string, (Object)string2);
        } else {
            pair = TuplesKt.to((Object)sanitizedArtifactName, (Object)"");
        }
        Pair pair2 = pair;
        String artifactFullName = (String)pair2.component1();
        String artifactExtension = (String)pair2.component2();
        do {
            suffix = nextSuffix == 0 ? "" : "-" + nextSuffix;
            LinkOption[] linkOptionArray2 = artifactForPublishingDir.resolve(sanitizedArtifactPath);
            Intrinsics.checkNotNullExpressionValue((Object)linkOptionArray2, (String)"resolve(...)");
            object = linkOptionArray2;
            Path path2 = object.resolve(artifactFullName + (String)suffix + artifactExtension);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Intrinsics.checkNotNullExpressionValue((Object)path2.normalize().toAbsolutePath(), (String)"toAbsolutePath(...)");
            ++nextSuffix;
        } while (Files.exists((Path)(object2 = artifactDir), Arrays.copyOf(object = new LinkOption[0], ((LinkOption[])object).length)));
        logger.debug("Creating directories for artifact publishing " + artifactDir.toUri());
        FileSystem.INSTANCE.deleteRecursivelyQuietly(artifactDir);
        object2 = artifactDir;
        object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"createDirectories(...)");
        object2 = source;
        object = new LinkOption[]{};
        if (Files.isDirectory((Path)object2, (LinkOption[])Arrays.copyOf(object, ((Object[])object).length))) {
            object2 = Files.walk(source, new FileVisitOption[0]);
            object = null;
            try {
                Stream files = (Stream)object2;
                boolean bl = false;
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    Path path3;
                    Path path4 = (Path)iterator.next();
                    Intrinsics.checkNotNull((Object)path4);
                    Path path5 = path4;
                    Intrinsics.checkNotNullExpressionValue((Object)artifactDir.resolve(source.relativize(path4)), (String)"resolve(...)");
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path5, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object);
            }
            if (zipContent) {
                this.printTcArtifactsPublishMessage(artifactDir.toRealPath(new LinkOption[0]) + "/** => " + sanitizedArtifactPath + "/" + sanitizedArtifactName + (String)suffix + ".zip");
            } else {
                this.printTcArtifactsPublishMessage(artifactDir.toRealPath(new LinkOption[0]) + "/** => " + sanitizedArtifactPath + (String)suffix);
            }
        } else {
            Path tempFile = artifactDir;
            object = source;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, tempFile, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            if (zipContent) {
                this.printTcArtifactsPublishMessage(tempFile.toRealPath(new LinkOption[0]) + " => " + sanitizedArtifactPath + "/" + sanitizedArtifactName + (String)suffix + ".zip");
            } else {
                this.printTcArtifactsPublishMessage(tempFile.toRealPath(new LinkOption[0]) + " => " + sanitizedArtifactPath);
            }
        }
    }

    public static /* synthetic */ void publishTeamCityArtifacts$default(TeamCityClient teamCityClient, Path path, String string, String string2, boolean bl, Path path2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = ((Object)path.getFileName()).toString();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            path2 = INSTANCE.getArtifactForPublishingDir();
        }
        teamCityClient.publishTeamCityArtifacts(path, string, string2, bl, path2);
    }

    /*
     * WARNING - void declaration
     */
    private static final URI teamCityURI_delegate$lambda$0() {
        void $this$instance$iv;
        DirectDIAware directDIAware = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
        String tag$iv = "teamcity.uri";
        boolean $i$f$instance = false;
        DirectDI directDI = $this$instance$iv.getDirectDI();
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<URI>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        return (URI)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, URI.class), (Object)tag$iv);
    }

    private static final Path artifactForPublishingDir_delegate$lambda$0() {
        Path path = GlobalPaths.Companion.getInstance().getTestsDirectory().resolve("teamcity-artifacts-for-publish");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final HttpRequest get$lambda$0(HttpRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TeamCityClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TeamCityClient.logger = logger;
        teamCityURI$delegate = LazyKt.lazy(TeamCityClient::teamCityURI_delegate$lambda$0);
        artifactForPublishingDir$delegate = LazyKt.lazy(TeamCityClient::artifactForPublishingDir_delegate$lambda$0);
        URI uRI = INSTANCE.getTeamCityURI().resolve("/app/rest/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        restUri = uRI;
        URI uRI2 = INSTANCE.getTeamCityURI().resolve("/guestAuth/app/rest/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"resolve(...)");
        guestAuthUri = uRI2;
    }
}

