/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.community;

import com.intellij.ide.starter.ide.IdeDownloader;
import com.intellij.ide.starter.ide.installer.IdeInstallerFile;
import com.intellij.ide.starter.models.IdeInfo;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/starter/community/IdeByLinkDownloader;", "Lcom/intellij/ide/starter/ide/IdeDownloader;", "<init>", "()V", "downloadIdeInstaller", "Lcom/intellij/ide/starter/ide/installer/IdeInstallerFile;", "ideInfo", "Lcom/intellij/ide/starter/models/IdeInfo;", "installerDirectory", "Ljava/nio/file/Path;", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nIdeByLinkDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeByLinkDownloader.kt\ncom/intellij/ide/starter/community/IdeByLinkDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class IdeByLinkDownloader
implements IdeDownloader {
    @NotNull
    public static final IdeByLinkDownloader INSTANCE = new IdeByLinkDownloader();

    private IdeByLinkDownloader() {
    }

    @Override
    @NotNull
    public IdeInstallerFile downloadIdeInstaller(@NotNull IdeInfo ideInfo, @NotNull Path installerDirectory) {
        Intrinsics.checkNotNullParameter((Object)ideInfo, (String)"ideInfo");
        Intrinsics.checkNotNullParameter((Object)installerDirectory, (String)"installerDirectory");
        if (ideInfo.getDownloadURI() == null) {
            boolean bl = false;
            String string = "Download URI should not be null for " + ideInfo;
            throw new IllegalArgumentException(string.toString());
        }
        Path installerFile = installerDirectory.resolve(ideInfo.getInstallerFilePrefix() + "-" + ideInfo.getBuildNumber() + ideInfo.getInstallerFileExt());
        Intrinsics.checkNotNull((Object)installerFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(installerFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LoggingKt.logOutput((String)("Downloading " + ideInfo + " ..."));
            String string = ideInfo.getDownloadURI().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, string, installerFile, 0L, 0L, 12, null);
        } else {
            LoggingKt.logOutput((String)("Installer file " + installerFile + " already exists. Skipping download."));
        }
        return new IdeInstallerFile(installerFile, ideInfo.getBuildNumber());
    }
}

