/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.frameworks;

import com.intellij.ide.starter.frameworks.Framework;
import com.intellij.ide.starter.ide.IDETestContext;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.project.GitProjectInfo;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/starter/frameworks/AndroidFramework;", "Lcom/intellij/ide/starter/frameworks/Framework;", "testContext", "Lcom/intellij/ide/starter/ide/IDETestContext;", "<init>", "(Lcom/intellij/ide/starter/ide/IDETestContext;)V", "downloadAndroidPluginProjectForIJCommunity", "", "intellijCommunityVersion", "", "commit", "setupAndroidSdkToProject", "androidSdkPath", "Ljava/nio/file/Path;", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nAndroidFramework.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFramework.kt\ncom/intellij/ide/starter/frameworks/AndroidFramework\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class AndroidFramework
extends Framework {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AndroidFramework(@NotNull IDETestContext testContext) {
        Intrinsics.checkNotNullParameter((Object)testContext, (String)"testContext");
        super(testContext);
    }

    public final void downloadAndroidPluginProjectForIJCommunity(@NotNull String intellijCommunityVersion, @NotNull String commit) {
        GitProjectInfo gitProjectInfo;
        Intrinsics.checkNotNullParameter((Object)intellijCommunityVersion, (String)"intellijCommunityVersion");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        GitProjectInfo $this$downloadAndroidPluginProjectForIJCommunity_u24lambda_u240 = gitProjectInfo = new GitProjectInfo("ssh://git@git.jetbrains.team/ij/android.git", commit, intellijCommunityVersion, true, 0L, false, false, null, null, null, 1008, null);
        boolean bl = false;
        $this$downloadAndroidPluginProjectForIJCommunity_u24lambda_u240.downloadAndUnpackProject();
        GitProjectInfo androidProject = gitProjectInfo;
        Path communityProjectHome = this.getTestContext().getTestCase().getProjectInfo() instanceof GitProjectInfo ? ((GitProjectInfo)this.getTestContext().getTestCase().getProjectInfo()).getRepositoryRootDir() : this.getTestContext().getResolvedProjectHome();
        Path path = communityProjectHome.resolve("android");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path androidPluginPath = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(androidPluginPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        PathKt.copyRecursively((Path)androidProject.getRepositoryRootDir(), (Path)androidPluginPath);
    }

    public static /* synthetic */ void downloadAndroidPluginProjectForIJCommunity$default(AndroidFramework androidFramework, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        androidFramework.downloadAndroidPluginProjectForIJCommunity(string, string2);
    }

    public final void setupAndroidSdkToProject(@NotNull Path androidSdkPath) {
        Intrinsics.checkNotNullParameter((Object)androidSdkPath, (String)"androidSdkPath");
        Path path = this.getTestContext().getResolvedProjectHome().resolve("local.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path localPropertiesFile = path;
        File file = localPropertiesFile.toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        String string = androidSdkPath.toFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String path2 = StringsKt.replace$default((String)string, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)file);
        FilesKt.appendText$default((File)file, (String)(System.lineSeparator() + "sdk.dir=" + path2), null, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/starter/frameworks/AndroidFramework$Companion;", "", "<init>", "()V", "downloadLatestAndroidSdk", "Ljava/nio/file/Path;", "javaHome", "downloadSdkManager", "intellij.tools.ide.starter"})
    @SourceDebugExtension(value={"SMAP\nAndroidFramework.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidFramework.kt\ncom/intellij/ide/starter/frameworks/AndroidFramework$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,135:1\n127#2,2:136\n*S KotlinDebug\n*F\n+ 1 AndroidFramework.kt\ncom/intellij/ide/starter/frameworks/AndroidFramework$Companion\n*L\n101#1:136,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path downloadLatestAndroidSdk(@NotNull Path javaHome) {
            Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
            Object[] objectArray = new String[]{"build-tools;31.0.0", "platforms;android-28", "sources;android-28", "platform-tools"};
            List packages = CollectionsKt.listOf((Object[])objectArray);
            Path sdkManager = this.downloadSdkManager();
            HashCode hashCode = Hashing.sha1().hashString((CharSequence)CollectionsKt.joinToString$default((Iterable)packages, (CharSequence)"$", null, null, (int)0, null, null, (int)62, null));
            Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"hashString(...)");
            HashCode packagesHash = hashCode;
            Path path = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("android-sdk").resolve("sdk-roots");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = path.resolve("sdk-root-" + packagesHash);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path home = path2;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(home, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                File file = home.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                if (SequencesKt.count((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null))) > 10) {
                    return home;
                }
            }
            Map<String, String> map = System.getenv();
            Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
            Map envVariablesWithJavaHome = MapsKt.plus(map, (Pair)TuplesKt.to((Object)"JAVA_HOME", (Object)((Object)javaHome.toAbsolutePath()).toString()));
            try {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(home, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                Object object = new String[]{((Object)sdkManager).toString(), "--sdk_root=" + home, "--licenses"};
                List list = CollectionsKt.listOf((Object[])object);
                object = new ExecOutputRedirect.ToStdOut("[sdkmanager-err]");
                String string = StringsKt.repeat((CharSequence)"yes\n", (int)10);
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = byArray;
                long l = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES);
                ProcessExecutor.start$default(new ProcessExecutor("android-sdk-licenses", home, l, envVariablesWithJavaHome, list, null, null, (ExecOutputRedirect)object, null, null, byArray2, false, 0, false, false, 31584, null), false, 1, null);
                object = new String[]{((Object)sdkManager).toString(), "--sdk_root=" + home, "--list"};
                list = CollectionsKt.listOf((Object[])object);
                object = new ExecOutputRedirect.ToStdOut("[sdkmanager-err]");
                long l2 = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES);
                ProcessExecutor.start$default(new ProcessExecutor("android-sdk-loading", home, l2, envVariablesWithJavaHome, list, null, null, (ExecOutputRedirect)object, null, null, null, false, 0, false, false, 32608, null), false, 1, null);
                object = new String[]{((Object)sdkManager).toString(), "--sdk_root=" + home, "--install", "--verbose"};
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object), (Iterable)packages);
                object = new ExecOutputRedirect.ToStdOut("[sdkmanager-err]");
                l2 = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES);
                ProcessExecutor.start$default(new ProcessExecutor("android-sdk-installing", home, l2, envVariablesWithJavaHome, list, null, null, (ExecOutputRedirect)object, null, null, null, false, 0, false, false, 32608, null), false, 1, null);
                return home;
            }
            catch (Throwable t) {
                FileSystem.INSTANCE.deleteRecursivelyQuietly(home);
                throw new Exception("Failed to prepare Android SDK to " + home + ". " + t.getMessage(), t);
            }
        }

        private final Path downloadSdkManager() {
            Object element$iv2;
            block8: {
                String string;
                if (SystemInfo.isMac) {
                    string = "https://dl.google.com/android/repository/commandlinetools-mac-6200805_latest.zip";
                } else if (SystemInfo.isWindows) {
                    string = "https://dl.google.com/android/repository/commandlinetools-win-6200805_latest.zip";
                } else if (SystemInfo.isLinux) {
                    string = "https://dl.google.com/android/repository/commandlinetools-linux-6200805_latest.zip";
                } else {
                    throw new IllegalStateException(("Unsupported OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION).toString());
                }
                String url = string;
                String[] stringArray = new String[]{"/"};
                String name = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)url, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
                Path androidSdkCache = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("android-sdk");
                Path path = androidSdkCache.resolve("archives");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path path2 = path.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                Path targetArchive = path2;
                Path path3 = androidSdkCache.resolve("builds");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                Path path4 = path3.resolve(name);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                Path targetUnpack = path4;
                HttpClient.downloadIfMissing-Wn2Vu4Y$default(HttpClient.INSTANCE, url, targetArchive, 0L, 0L, 12, null);
                FileSystem.INSTANCE.unpackIfMissing(targetArchive, targetUnpack);
                String ext = SystemInfo.isWindows ? ".bat" : "";
                File file = targetUnpack.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                Sequence $this$first$iv = (Sequence)FilesKt.walk$default((File)file, null, (int)1, null);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    File it = (File)element$iv2;
                    boolean bl = false;
                    if (!FilesKt.endsWith((File)it, (String)("tools/bin/sdkmanager" + ext))) continue;
                    break block8;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            File sdkManager = (File)element$iv2;
            if (SystemInfo.isMac || SystemInfo.isLinux) {
                sdkManager.setExecutable(true);
            }
            Path path = sdkManager.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

