/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.ide.IdeDistribution;
import com.intellij.ide.starter.ide.IdeDistributionFactory;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.ide.LinuxIdeDistribution;
import com.intellij.ide.starter.ide.MacOsIdeDistribution;
import com.intellij.ide.starter.ide.WindowsIdeDistribution;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/starter/ide/DefaultIdeDistributionFactory;", "Lcom/intellij/ide/starter/ide/IdeDistributionFactory;", "<init>", "()V", "installIDE", "Lcom/intellij/ide/starter/ide/InstalledIde;", "unpackDir", "Ljava/io/File;", "executableFileName", "", "intellij.tools.ide.starter"})
public final class DefaultIdeDistributionFactory
implements IdeDistributionFactory {
    @NotNull
    public static final DefaultIdeDistributionFactory INSTANCE = new DefaultIdeDistributionFactory();

    private DefaultIdeDistributionFactory() {
    }

    @Override
    @NotNull
    public InstalledIde installIDE(@NotNull File unpackDir, @NotNull String executableFileName) {
        IdeDistribution ideDistribution;
        Intrinsics.checkNotNullParameter((Object)unpackDir, (String)"unpackDir");
        Intrinsics.checkNotNullParameter((Object)executableFileName, (String)"executableFileName");
        if (SystemInfo.isMac) {
            ideDistribution = new MacOsIdeDistribution();
        } else if (SystemInfo.isWindows) {
            ideDistribution = new WindowsIdeDistribution();
        } else if (SystemInfo.isLinux) {
            ideDistribution = new LinuxIdeDistribution();
        } else {
            throw new IllegalStateException(("Not supported ide distribution: " + unpackDir).toString());
        }
        IdeDistribution distribution = ideDistribution;
        Path path = unpackDir.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return distribution.installIde(path, executableFileName);
    }
}

