/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.SevenZipWindowsArchiver;
import com.intellij.ide.starter.utils.UtilsKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/ide/IdeArchiveExtractor;", "", "<init>", "()V", "unpackIdeIfNeeded", "", "ideInstallerFile", "Ljava/io/File;", "unpackDir", "unpackDmg", "Ljava/nio/file/Path;", "dmgFile", "target", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nIdeArchiveExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeArchiveExtractor.kt\ncom/intellij/ide/starter/ide/IdeArchiveExtractor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 utils.kt\ncom/intellij/ide/starter/utils/UtilsKt\n*L\n1#1,82:1\n3260#2,11:83\n39#3,9:94\n*S KotlinDebug\n*F\n+ 1 IdeArchiveExtractor.kt\ncom/intellij/ide/starter/ide/IdeArchiveExtractor\n*L\n55#1:83,11\n70#1:94,9\n*E\n"})
public final class IdeArchiveExtractor {
    @NotNull
    public static final IdeArchiveExtractor INSTANCE = new IdeArchiveExtractor();

    private IdeArchiveExtractor() {
    }

    public final void unpackIdeIfNeeded(@NotNull File ideInstallerFile, @NotNull File unpackDir) {
        Intrinsics.checkNotNullParameter((Object)ideInstallerFile, (String)"ideInstallerFile");
        Intrinsics.checkNotNullParameter((Object)unpackDir, (String)"unpackDir");
        if (unpackDir.isDirectory()) {
            File[] fileArray = unpackDir.listFiles();
            boolean bl = fileArray != null ? !(fileArray.length == 0) : false;
            if (bl) {
                LoggingKt.logOutput((String)("Build directory " + unpackDir + " already exists for the binary " + ideInstallerFile));
                return;
            }
        }
        LoggingKt.logOutput((String)("Extracting application into " + unpackDir));
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)ideInstallerFile), (Object)"dmg")) {
            Path path = unpackDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            this.unpackDmg(ideInstallerFile, path);
        } else if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)ideInstallerFile), (Object)"exe")) {
            SevenZipWindowsArchiver.unpackWinMsi-SxA4cEA$default(SevenZipWindowsArchiver.INSTANCE, ideInstallerFile, unpackDir, 0L, 4, null);
        } else if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)ideInstallerFile), (Object)"zip")) {
            Path path = ideInstallerFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path2 = unpackDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            FileSystem.INSTANCE.unpack(path, path2);
        } else {
            String string = ideInstallerFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".tar.gz", (boolean)false, (int)2, null)) {
                FileSystem.INSTANCE.unpackTarGz(ideInstallerFile, unpackDir);
            } else {
                throw new IllegalStateException(("Unsupported build file: " + ideInstallerFile).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path unpackDmg(File dmgFile, Path target) {
        Path path;
        Object object;
        FileSystem.INSTANCE.deleteRecursivelyQuietly(target);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(target, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        File mountDir = new File(dmgFile.getPath() + "-mount" + System.currentTimeMillis());
        try {
            long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
            object = new ExecOutputRedirect.ToStdOut("hdiutil");
            ExecOutputRedirect.ToStdOut toStdOut = new ExecOutputRedirect.ToStdOut("hdiutil");
            Object[] objectArray = new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", String.valueOf(mountDir), String.valueOf(dmgFile)};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ProcessExecutor.start$default(new ProcessExecutor("hdiutil", target, l, null, list, null, toStdOut, (ExecOutputRedirect)object, null, null, null, false, 0, false, false, 32552, null), false, 1, null);
        }
        catch (Throwable t) {
            dmgFile.delete();
            throw new Error("Failed to mount " + dmgFile + ". " + t.getMessage() + ".", t);
        }
        try {
            Object single$iv;
            File[] fileArray;
            block18: {
                block17: {
                    File[] fileArray2;
                    block16: {
                        fileArray = mountDir.listFiles();
                        if (fileArray == null) break block17;
                        File[] $this$singleOrNull$iv = fileArray;
                        boolean $i$f$singleOrNull = false;
                        single$iv = null;
                        boolean found$iv = false;
                        int n = $this$singleOrNull$iv.length;
                        for (int i = 0; i < n; ++i) {
                            File element$iv;
                            File it = element$iv = $this$singleOrNull$iv[i];
                            boolean bl = false;
                            String string = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                            if (!StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null)) continue;
                            if (found$iv) {
                                fileArray2 = null;
                                break block16;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        fileArray2 = fileArray = !found$iv ? null : single$iv;
                    }
                    if (fileArray2 != null) break block18;
                }
                throw new IllegalStateException(("Failed to find the only one .app folder in " + dmgFile).toString());
            }
            File[] appDir = fileArray;
            object = target;
            String string = appDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Path path2 = object.resolve(string);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path targetAppDir = path2;
            long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
            ExecOutputRedirect.ToStdOut $i$f$singleOrNull = new ExecOutputRedirect.ToStdOut("cp");
            Object[] objectArray = new String[]{"cp", "-R", String.valueOf(appDir), String.valueOf(targetAppDir)};
            single$iv = CollectionsKt.listOf((Object[])objectArray);
            ProcessExecutor.start$default(new ProcessExecutor("copy-dmg", target, l, null, (List)single$iv, null, null, $i$f$singleOrNull, null, null, null, false, 0, false, false, 32616, null), false, 1, null);
            path = targetAppDir;
        }
        catch (Throwable throwable) {
            String message$iv = "";
            boolean $i$f$catchAll = false;
            try {
                if (((CharSequence)message$iv).length() > 0) {
                    LoggingKt.logOutput((String)("Performing '" + message$iv + "' with catching all exceptions"));
                }
                boolean bl = false;
                long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
                ExecOutputRedirect.ToStdOut toStdOut = new ExecOutputRedirect.ToStdOut("hdiutil");
                ExecOutputRedirect.ToStdOut toStdOut2 = new ExecOutputRedirect.ToStdOut("hdiutil");
                Object[] objectArray = new String[]{"hdiutil", "detach", "-force", String.valueOf(mountDir)};
                List list = CollectionsKt.listOf((Object[])objectArray);
                ProcessExecutor.start$default(new ProcessExecutor("hdiutil", target, l, null, list, null, toStdOut, toStdOut2, null, null, null, false, 0, false, false, 32552, null), false, 1, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message$iv).length() > 0 ? "for '" + message$iv + "' " : "") + " swallowed error: " + t$iv.getMessage()));
                LoggingKt.logError((String)UtilsKt.getThrowableText(t$iv));
                Object var15_35 = null;
            }
            throw throwable;
        }
        String message$iv = "";
        boolean $i$f$catchAll = false;
        try {
            if (((CharSequence)message$iv).length() > 0) {
                LoggingKt.logOutput((String)("Performing '" + message$iv + "' with catching all exceptions"));
            }
            boolean bl = false;
            long l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES);
            ExecOutputRedirect.ToStdOut toStdOut = new ExecOutputRedirect.ToStdOut("hdiutil");
            ExecOutputRedirect.ToStdOut toStdOut3 = new ExecOutputRedirect.ToStdOut("hdiutil");
            Object[] objectArray = new String[]{"hdiutil", "detach", "-force", String.valueOf(mountDir)};
            List list = CollectionsKt.listOf((Object[])objectArray);
            ProcessExecutor.start$default(new ProcessExecutor("hdiutil", target, l, null, list, null, toStdOut, toStdOut3, null, null, null, false, 0, false, false, 32552, null), false, 1, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable t$iv) {
            LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message$iv).length() > 0 ? "for '" + message$iv + "' " : "") + " swallowed error: " + t$iv.getMessage()));
            LoggingKt.logError((String)UtilsKt.getThrowableText(t$iv));
            Object var16_39 = null;
        }
        return path;
    }
}

