/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.config.ConfigurationStorage;
import com.intellij.ide.starter.config.StarterConfigurationStorageKt;
import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.ide.JBRDownloader;
import com.intellij.ide.starter.ide.JBRResolver;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.runner.SetupException;
import com.intellij.ide.starter.telemetry.TestTelemetryService;
import com.intellij.ide.starter.utils.UtilsKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.tools.ide.util.common.LoggingKt;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.Closeable;
import java.io.FileReader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/starter/ide/JBRResolver;", "", "<init>", "()V", "getJBRVersionFromBuild", "Lcom/intellij/ide/starter/ide/JBRResolver$JBRVersion;", "jbrFullVersion", "", "getJBRVersionFromSources", "downloadAndUnpackJbrFromBuildIfNeeded", "Ljava/nio/file/Path;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadAndUnpackJbrFromSourcesIfNeeded", "downloadAndUnpackJbrIfNeeded", "jbrVersion", "(Lcom/intellij/ide/starter/ide/JBRResolver$JBRVersion;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRuntimeBuildVersion", "JBRVersion", "JBRDownloadException", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nJBRResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBRResolver.kt\ncom/intellij/ide/starter/ide/JBRResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 utils.kt\ncom/intellij/ide/starter/utils/UtilsKt\n+ 4 TestTelemetryService.kt\ncom/intellij/ide/starter/telemetry/TestTelemetryServiceKt\n*L\n1#1,102:1\n1#2:103\n39#3,9:104\n39#3,9:113\n24#4,13:122\n*S KotlinDebug\n*F\n+ 1 JBRResolver.kt\ncom/intellij/ide/starter/ide/JBRResolver\n*L\n60#1:104,9\n64#1:113,9\n67#1:122,13\n*E\n"})
public final class JBRResolver {
    @NotNull
    public static final JBRResolver INSTANCE = new JBRResolver();

    private JBRResolver() {
    }

    private final JBRVersion getJBRVersionFromBuild(String jbrFullVersion) {
        String[] stringArray = new String[]{"."};
        int jbrVersion = Integer.parseInt((String)StringsKt.split$default((CharSequence)jbrFullVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0));
        Ref.ObjectRef majorVersion = new Ref.ObjectRef();
        String[] stringArray2 = new String[]{"+"};
        majorVersion.element = CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)jbrFullVersion, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
        if (jbrVersion < 17) {
            String string = (String)majorVersion.element;
            Object object = majorVersion.element = string != null ? StringsKt.replace$default((String)string, (String)".", (String)"_", (boolean)false, (int)4, null) : null;
        }
        if (majorVersion.element == null) {
            boolean $i$a$-requireNotNull-JBRResolver$getJBRVersionFromBuild$32 = false;
            Function0 $i$a$-requireNotNull-JBRResolver$getJBRVersionFromBuild$32 = () -> JBRResolver.getJBRVersionFromBuild$lambda$0$0(majorVersion);
            throw new IllegalArgumentException($i$a$-requireNotNull-JBRResolver$getJBRVersionFromBuild$32.toString());
        }
        String[] $i$a$-requireNotNull-JBRResolver$getJBRVersionFromBuild$32 = new String[]{"-b"};
        String buildNumber = (String)CollectionsKt.singleOrNull((List)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)jbrFullVersion, (String[])$i$a$-requireNotNull-JBRResolver$getJBRVersionFromBuild$32, (boolean)false, (int)0, (int)6, null), (int)1));
        if (buildNumber == null) {
            boolean bl = false;
            Function0 function0 = () -> JBRResolver.getJBRVersionFromBuild$lambda$1$0(buildNumber);
            throw new IllegalArgumentException(function0.toString());
        }
        LoggingKt.logOutput((String)("Detected JBR version " + jbrFullVersion + " with parts: " + majorVersion.element + " and build " + buildNumber));
        return new JBRVersion((String)majorVersion.element, buildNumber);
    }

    private final JBRVersion getJBRVersionFromSources(String jbrFullVersion) {
        String buildNumber;
        Integer jbrVersion;
        Ref.ObjectRef majorVersion = new Ref.ObjectRef();
        String[] stringArray = new String[]{"b"};
        majorVersion.element = CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)jbrFullVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (majorVersion.element == null) {
            boolean $i$a$-requireNotNull-JBRResolver$getJBRVersionFromSources$42 = false;
            Function0 $i$a$-requireNotNull-JBRResolver$getJBRVersionFromSources$42 = () -> JBRResolver.getJBRVersionFromSources$lambda$0$0(majorVersion);
            throw new IllegalArgumentException($i$a$-requireNotNull-JBRResolver$getJBRVersionFromSources$42.toString());
        }
        String[] stringArray2 = new String[]{"."};
        Integer n = StringsKt.toIntOrNull((String)((String)StringsKt.split$default((CharSequence)jbrFullVersion, (String[])stringArray2, (boolean)false, (int)0, (int)6, null).get(0)));
        if (n == null) {
            n = StringsKt.toIntOrNull((String)((String)majorVersion.element));
        }
        if ((jbrVersion = n) == null) {
            boolean $i$a$-requireNotNull-JBRResolver$getJBRVersionFromSources$52 = false;
            String $i$a$-requireNotNull-JBRResolver$getJBRVersionFromSources$52 = "Cannot parse JBR version from: " + jbrFullVersion;
            throw new IllegalArgumentException($i$a$-requireNotNull-JBRResolver$getJBRVersionFromSources$52.toString());
        }
        if (jbrVersion < 17) {
            majorVersion.element = StringsKt.replace$default((String)((String)majorVersion.element), (String)".", (String)"_", (boolean)false, (int)4, null);
        }
        if ((buildNumber = (String)CollectionsKt.singleOrNull((List)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)jbrFullVersion, (String[])(stringArray2 = new String[]{"b"}), (boolean)false, (int)0, (int)6, null), (int)1))) == null) {
            boolean bl = false;
            Function0 function0 = () -> JBRResolver.getJBRVersionFromSources$lambda$2$0(buildNumber);
            throw new IllegalArgumentException(function0.toString());
        }
        LoggingKt.logOutput((String)("Detected JBR version " + jbrFullVersion + " with parts: " + majorVersion.element + " and build " + buildNumber));
        return new JBRVersion((String)majorVersion.element, buildNumber);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadAndUnpackJbrFromBuildIfNeeded(@NotNull String jbrFullVersion, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof downloadAndUnpackJbrFromBuildIfNeeded.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ JBRResolver this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadAndUnpackJbrFromBuildIfNeeded(null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                message$iv = "";
                $i$f$catchAll = 0;
                if (((CharSequence)message$iv).length() > 0) {
                    LoggingKt.logOutput((String)("Performing '" + message$iv + "' with catching all exceptions"));
                }
                $i$a$-catchAll$default-JBRResolver$downloadAndUnpackJbrFromBuildIfNeeded$2 = 0;
                $continuation.L$0 = jbrFullVersion;
                $continuation.L$1 = message$iv;
                $continuation.I$0 = $i$f$catchAll;
                $continuation.I$1 = $i$a$-catchAll$default-JBRResolver$downloadAndUnpackJbrFromBuildIfNeeded$2;
                $continuation.label = 1;
                v0 = JBRResolver.INSTANCE.downloadAndUnpackJbrIfNeeded(JBRResolver.INSTANCE.getJBRVersionFromBuild(jbrFullVersion), (Continuation<? super Path>)$continuation);
                ** if (v0 != var9_5) goto lbl28
lbl27:
                // 1 sources

                return var9_5;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                $i$a$-catchAll$default-JBRResolver$downloadAndUnpackJbrFromBuildIfNeeded$2 = $continuation.I$1;
                $i$f$catchAll = $continuation.I$0;
                message$iv = (String)$continuation.L$1;
                jbrFullVersion = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    var6_12 = (Path)v0;
                }
                catch (Throwable t$iv) {
                    LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message$iv).length() > 0 != false ? "for '" + message$iv + "' " : "") + " swallowed error: " + t$iv.getMessage()));
                    LoggingKt.logError((String)UtilsKt.getThrowableText(t$iv));
                    var6_12 = null;
                }
                v1 = var6_12;
                if (v1 == null) {
                    throw new JBRDownloadException(jbrFullVersion);
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadAndUnpackJbrFromSourcesIfNeeded(@NotNull String jbrFullVersion, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof downloadAndUnpackJbrFromSourcesIfNeeded.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ JBRResolver this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadAndUnpackJbrFromSourcesIfNeeded(null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                message$iv = "";
                $i$f$catchAll = 0;
                if (((CharSequence)message$iv).length() > 0) {
                    LoggingKt.logOutput((String)("Performing '" + message$iv + "' with catching all exceptions"));
                }
                $i$a$-catchAll$default-JBRResolver$downloadAndUnpackJbrFromSourcesIfNeeded$2 = 0;
                $continuation.L$0 = jbrFullVersion;
                $continuation.L$1 = message$iv;
                $continuation.I$0 = $i$f$catchAll;
                $continuation.I$1 = $i$a$-catchAll$default-JBRResolver$downloadAndUnpackJbrFromSourcesIfNeeded$2;
                $continuation.label = 1;
                v0 = JBRResolver.INSTANCE.downloadAndUnpackJbrIfNeeded(JBRResolver.INSTANCE.getJBRVersionFromSources(jbrFullVersion), (Continuation<? super Path>)$continuation);
                ** if (v0 != var9_5) goto lbl28
lbl27:
                // 1 sources

                return var9_5;
lbl28:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                $i$a$-catchAll$default-JBRResolver$downloadAndUnpackJbrFromSourcesIfNeeded$2 = $continuation.I$1;
                $i$f$catchAll = $continuation.I$0;
                message$iv = (String)$continuation.L$1;
                jbrFullVersion = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    var6_12 = (Path)v0;
                }
                catch (Throwable t$iv) {
                    LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message$iv).length() > 0 != false ? "for '" + message$iv + "' " : "") + " swallowed error: " + t$iv.getMessage()));
                    LoggingKt.logError((String)UtilsKt.getThrowableText(t$iv));
                    var6_12 = null;
                }
                v1 = var6_12;
                if (v1 == null) {
                    throw new JBRDownloadException(jbrFullVersion);
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadAndUnpackJbrIfNeeded(@NotNull JBRVersion jbrVersion, @NotNull Continuation<? super Path> $completion) {
        if (!($completion instanceof downloadAndUnpackJbrIfNeeded.1)) ** GOTO lbl-1000
        var22_3 = $completion;
        if ((var22_3.label & -2147483648) != 0) {
            var22_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ JBRResolver this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadAndUnpackJbrIfNeeded(null, (Continuation<? super Path>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                spanName$iv = "download and unpack JBR";
                $i$f$computeWithSpan = 0;
                span$iv = TestTelemetryService.Companion.spanBuilder(spanName$iv).startSpan();
                var6_11 = (AutoCloseable)span$iv.makeCurrent();
                var7_12 = null;
                it$iv = (Scope)var6_11;
                $i$a$-use-TestTelemetryServiceKt$computeWithSpan$1$iv = 0;
                Intrinsics.checkNotNull((Object)span$iv);
                it = span$iv;
                $i$a$-computeWithSpan-JBRResolver$downloadAndUnpackJbrIfNeeded$2 = 0;
                var12_25 = new String[]{jbrVersion.getMajorVersion(), jbrVersion.getBuildNumber()};
                var13_27 = CollectionsKt.listOf((Object[])var12_25);
                majorVersion = (String)var13_27.get(0);
                buildNumber = (String)var13_27.get(1);
                if (SystemInfo.isLinux) {
                    v0 = "linux";
                } else if (SystemInfo.isWindows) {
                    v0 = "windows";
                } else if (SystemInfo.isMac) {
                    v0 = "osx";
                } else {
                    throw new IllegalStateException("Unknown OS".toString());
                }
                os = v0;
                if (StarterConfigurationStorageKt.useDockerContainer(ConfigurationStorage.Companion)) {
                    os = "linux";
                }
                if (var16_32 = SystemInfo.isAarch64) {
                    v1 = "aarch64";
                } else if (!var16_32) {
                    v1 = "x64";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                arch = v1;
                jbrFileName = "jbrsdk_jcef-" + majorVersion + "-" + os + "-" + arch + "-b" + buildNumber + ".tar.gz";
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)jbrVersion);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)spanName$iv);
                $continuation.L$2 = span$iv;
                $continuation.L$3 = var6_11;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)it$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)majorVersion);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)buildNumber);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)os);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)jbrFileName);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)arch);
                $continuation.I$0 = $i$f$computeWithSpan;
                $continuation.I$1 = $i$a$-use-TestTelemetryServiceKt$computeWithSpan$1$iv;
                $continuation.I$2 = $i$a$-computeWithSpan-JBRResolver$downloadAndUnpackJbrIfNeeded$2;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(jbrFileName, null){
                    int label;
                    final /* synthetic */ String $jbrFileName;
                    {
                        this.$jbrFileName = $jbrFileName;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
                                Object tag$iv = null;
                                boolean $i$f$instance = false;
                                DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
                                boolean $i$f$generic = false;
                                JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<JBRDownloader>(){}.getSuperType());
                                Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
                                this.label = 1;
                                Object object2 = ((JBRDownloader)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, JBRDownloader.class), tag$iv)).downloadJbr(this.$jbrFileName, (Continuation<? super Path>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var23_5) goto lbl71
lbl70:
                // 1 sources

                return var23_5;
lbl71:
                // 1 sources

                ** GOTO lbl93
            }
            case 1: {
                $i$a$-computeWithSpan-JBRResolver$downloadAndUnpackJbrIfNeeded$2 = $continuation.I$2;
                $i$a$-use-TestTelemetryServiceKt$computeWithSpan$1$iv = $continuation.I$1;
                $i$f$computeWithSpan = $continuation.I$0;
                arch = (String)$continuation.L$10;
                jbrFileName = (String)$continuation.L$9;
                os = (String)$continuation.L$8;
                buildNumber = (String)$continuation.L$7;
                majorVersion = (String)$continuation.L$6;
                it = (Span)$continuation.L$5;
                it$iv = (Scope)$continuation.L$4;
                var7_12 = null;
                var6_11 = (AutoCloseable)$continuation.L$3;
                span$iv = (Span)$continuation.L$2;
                spanName$iv = (String)$continuation.L$1;
                jbrVersion = (JBRVersion)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl93:
                    // 2 sources

                    appHome = (Path)v2;
                    if (SystemInfo.isMac && !StarterConfigurationStorageKt.useDockerContainer(ConfigurationStorage.Companion)) {
                        v3 = appHome.resolve("Contents/Home");
                        v4 = v3;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"resolve(...)");
                    } else {
                        v4 = appHome;
                    }
                    var19_38 = v4;
                    AutoCloseableKt.closeFinally((AutoCloseable)var6_11, (Throwable)var7_12);
                    var20_39 = var19_38;
                    return var20_39;
                    {
                        catch (Throwable var9_19) {
                            try {
                                try {
                                    var7_12 = var9_19;
                                    throw var9_19;
                                }
                                catch (Throwable var9_20) {
                                    AutoCloseableKt.closeFinally((AutoCloseable)var6_11, var7_12);
                                    throw var9_20;
                                }
                            }
                            catch (Throwable e$iv) {
                                span$iv.recordException(e$iv);
                                span$iv.setStatus(StatusCode.ERROR);
                                throw e$iv;
                            }
                        }
                    }
                }
                finally {
                    span$iv.end();
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getRuntimeBuildVersion() {
        String string = StarterConfigurationStorageKt.jbrVersionForDevServer(ConfigurationStorage.Companion);
        if (string == null) {
            JBRResolver $this$getRuntimeBuildVersion_u24lambda_u240 = this;
            boolean bl = false;
            Path path = GlobalPaths.Companion.getInstance().getCheckoutDir().resolve("community");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path path2 = path.resolve("build");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path path3 = path2.resolve("dependencies");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            Path path4 = path3.resolve("dependencies.properties");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            Path jbrDependencyFile = path4;
            Properties props = new Properties();
            Closeable closeable = new FileReader(jbrDependencyFile.toFile());
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl2 = false;
                props.load(reader);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = props.getProperty("runtimeBuild");
        }
        String jbrVersion = string;
        Intrinsics.checkNotNull((Object)jbrVersion);
        return jbrVersion;
    }

    private static final String getJBRVersionFromBuild$lambda$0$0(Ref.ObjectRef $majorVersion) {
        return "majorVersion is: " + $majorVersion.element;
    }

    private static final String getJBRVersionFromBuild$lambda$1$0(String $buildNumber) {
        return "buildNumber is: " + $buildNumber;
    }

    private static final String getJBRVersionFromSources$lambda$0$0(Ref.ObjectRef $majorVersion) {
        return "majorVersion is: " + $majorVersion.element;
    }

    private static final String getJBRVersionFromSources$lambda$2$0(String $buildNumber) {
        return "buildNumber is: " + $buildNumber;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/starter/ide/JBRResolver$JBRDownloadException;", "Lcom/intellij/ide/starter/runner/SetupException;", "jbrFullVersion", "", "<init>", "(Ljava/lang/String;)V", "intellij.tools.ide.starter"})
    public static final class JBRDownloadException
    extends SetupException {
        public JBRDownloadException(@NotNull String jbrFullVersion) {
            Intrinsics.checkNotNullParameter((Object)jbrFullVersion, (String)"jbrFullVersion");
            super(jbrFullVersion + " can't be downloaded/unpacked", null, 2, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/starter/ide/JBRResolver$JBRVersion;", "", "majorVersion", "", "buildNumber", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getMajorVersion", "()Ljava/lang/String;", "getBuildNumber", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.tools.ide.starter"})
    public static final class JBRVersion {
        @NotNull
        private final String majorVersion;
        @NotNull
        private final String buildNumber;

        public JBRVersion(@NotNull String majorVersion, @NotNull String buildNumber) {
            Intrinsics.checkNotNullParameter((Object)majorVersion, (String)"majorVersion");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            this.majorVersion = majorVersion;
            this.buildNumber = buildNumber;
        }

        @NotNull
        public final String getMajorVersion() {
            return this.majorVersion;
        }

        @NotNull
        public final String getBuildNumber() {
            return this.buildNumber;
        }

        @NotNull
        public final String component1() {
            return this.majorVersion;
        }

        @NotNull
        public final String component2() {
            return this.buildNumber;
        }

        @NotNull
        public final JBRVersion copy(@NotNull String majorVersion, @NotNull String buildNumber) {
            Intrinsics.checkNotNullParameter((Object)majorVersion, (String)"majorVersion");
            Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
            return new JBRVersion(majorVersion, buildNumber);
        }

        public static /* synthetic */ JBRVersion copy$default(JBRVersion jBRVersion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = jBRVersion.majorVersion;
            }
            if ((n & 2) != 0) {
                string2 = jBRVersion.buildNumber;
            }
            return jBRVersion.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "JBRVersion(majorVersion=" + this.majorVersion + ", buildNumber=" + this.buildNumber + ")";
        }

        public int hashCode() {
            int result2 = this.majorVersion.hashCode();
            result2 = result2 * 31 + this.buildNumber.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JBRVersion)) {
                return false;
            }
            JBRVersion jBRVersion = (JBRVersion)other;
            if (!Intrinsics.areEqual((Object)this.majorVersion, (Object)jBRVersion.majorVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buildNumber, (Object)jBRVersion.buildNumber);
        }
    }
}

