/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.ide.JBRDownloader;
import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.runner.SetupException;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/starter/ide/StarterJBRDownloader;", "Lcom/intellij/ide/starter/ide/JBRDownloader;", "<init>", "()V", "downloadJbr", "Ljava/nio/file/Path;", "jbrFileName", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.tools.ide.starter"})
public final class StarterJBRDownloader
implements JBRDownloader {
    @NotNull
    public static final StarterJBRDownloader INSTANCE = new StarterJBRDownloader();

    private StarterJBRDownloader() {
    }

    @Override
    @Nullable
    public Object downloadJbr(@NotNull String jbrFileName, @NotNull Continuation<? super Path> $completion) {
        String downloadUrl = "https://cache-redirector.jetbrains.com/intellij-jbr/" + jbrFileName;
        Path jbrCacheDirectory = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("jbr");
        Path path = jbrCacheDirectory.resolve(jbrFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path localFile = path;
        Path path2 = jbrCacheDirectory.resolve(StringsKt.removeSuffix((String)jbrFileName, (CharSequence)".tar.gz"));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path localDir = path2;
        HttpClient.INSTANCE.downloadIfMissing-Wn2Vu4Y(downloadUrl, localFile, 1L, DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(localDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileSystem.INSTANCE.unpack(localFile, jbrCacheDirectory);
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(localDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new SetupException("Couldn't find the extracted JDK folder at " + localDir.toAbsolutePath(), null, 2, null);
        }
        return localDir;
    }
}

