/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.ide;

import com.intellij.ide.starter.ide.IdeDistribution;
import com.intellij.ide.starter.ide.InstalledBackedIDEStartConfig;
import com.intellij.ide.starter.ide.InstalledIde;
import com.intellij.ide.starter.ide.WindowsIdeDistribution;
import com.intellij.ide.starter.models.VMOptions;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.JvmUtils;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/starter/ide/WindowsIdeDistribution;", "Lcom/intellij/ide/starter/ide/IdeDistribution;", "<init>", "()V", "installIde", "Lcom/intellij/ide/starter/ide/InstalledIde;", "unpackDir", "Ljava/nio/file/Path;", "executableFileName", "", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nWindowsIdeDistribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsIdeDistribution.kt\ncom/intellij/ide/starter/ide/WindowsIdeDistribution\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n669#2,11:68\n669#2,11:79\n*S KotlinDebug\n*F\n+ 1 WindowsIdeDistribution.kt\ncom/intellij/ide/starter/ide/WindowsIdeDistribution\n*L\n15#1:68,11\n22#1:79,11\n*E\n"})
public final class WindowsIdeDistribution
extends IdeDistribution {
    @Override
    @NotNull
    public InstalledIde installIde(@NotNull Path unpackDir, @NotNull String executableFileName) {
        Object v5;
        List allBinFiles;
        String build;
        String productCode;
        Path appHome2;
        block10: {
            Iterable<Path> iterable;
            block12: {
                block11: {
                    Object v2;
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)unpackDir, (String)"unpackDir");
                        Intrinsics.checkNotNullParameter((Object)executableFileName, (String)"executableFileName");
                        iterable = FileSystem.INSTANCE.listDirectoryEntriesQuietly(unpackDir);
                        if (iterable == null) break block11;
                        Iterable $this$singleOrNull$iv = iterable;
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            Path it = (Path)element$iv;
                            boolean bl = false;
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                            if (found$iv) {
                                v2 = null;
                                break block9;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v2 = !found$iv ? null : single$iv;
                    }
                    if ((iterable = (Path)v2) != null) break block12;
                }
                iterable = unpackDir;
            }
            appHome2 = iterable.toAbsolutePath();
            Path path = appHome2.resolve("build.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Pair<String, String> pair = IdeDistribution.Companion.readProductCodeAndBuildNumberFromBuildTxt(path);
            productCode = (String)pair.component1();
            build = (String)pair.component2();
            Intrinsics.checkNotNull((Object)appHome2);
            Path path2 = appHome2.resolve("bin");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Path binDir = path2;
            allBinFiles = PathsKt.listDirectoryEntries$default((Path)binDir, null, (int)1, null);
            Iterable $this$singleOrNull$iv = allBinFiles;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Path file = (Path)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((Object)file.getFileName()).toString(), (Object)(executableFileName + "64.exe"))) continue;
                if (found$iv) {
                    v5 = null;
                    break block10;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v5 = !found$iv ? null : single$iv;
        }
        Path path = v5;
        if (path == null) {
            throw new IllegalStateException(("Failed to detect executable " + executableFileName + "64.exe:\n" + CollectionsKt.joinToString$default((Iterable)allBinFiles, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).toString());
        }
        Path executablePath = path;
        return new InstalledIde(appHome2, build, productCode, executablePath, unpackDir){
            private final Path bundledPluginsDir;
            private final VMOptions vmOptionsFinal;
            private final Path patchedVMOptionsFile;
            private final String build;
            private final OS os;
            private final String productCode;
            private final boolean isFromSources;
            private final Path installationPath;
            final /* synthetic */ Path $appHome;
            final /* synthetic */ String $build;
            final /* synthetic */ String $productCode;
            final /* synthetic */ Path $executablePath;
            final /* synthetic */ Path $unpackDir;
            {
                this.$appHome = $appHome;
                this.$build = $build;
                this.$productCode = $productCode;
                this.$executablePath = $executablePath;
                this.$unpackDir = $unpackDir;
                this.bundledPluginsDir = $appHome.resolve("plugins");
                this.vmOptionsFinal = new VMOptions(this, CollectionsKt.emptyList(), MapsKt.emptyMap());
                this.patchedVMOptionsFile = $appHome.getParent().resolve($appHome.getFileName() + ".vmoptions");
                this.build = $build;
                this.os = OS.Windows;
                this.productCode = $productCode;
                Path path = $appHome.toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
                this.installationPath = path;
            }

            public Path getBundledPluginsDir() {
                return this.bundledPluginsDir;
            }

            public VMOptions getVmOptions() {
                return this.vmOptionsFinal;
            }

            public Path getPatchedVMOptionsFile() {
                return this.patchedVMOptionsFile;
            }

            public installIde.startConfig.1 startConfig(VMOptions vmOptions, Path logsDir) {
                Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
                Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
                Path path = this.getPatchedVMOptionsFile();
                return new InstalledBackedIDEStartConfig(this.$appHome, this.$executablePath, vmOptions, path){
                    private final Path workDir;
                    private final List<String> commandLine;
                    {
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        super($super_call_param$1, $vmOptions);
                        this.workDir = $appHome;
                        this.commandLine = CollectionsKt.listOf((Object)((Object)$executablePath.toAbsolutePath()).toString());
                    }

                    public Path getWorkDir() {
                        return this.workDir;
                    }

                    public List<String> getCommandLine() {
                        return this.commandLine;
                    }
                };
            }

            public String getBuild() {
                return this.build;
            }

            public OS getOs() {
                return this.os;
            }

            public String getProductCode() {
                return this.productCode;
            }

            public boolean isFromSources() {
                return this.isFromSources;
            }

            public Path getInstallationPath() {
                return this.installationPath;
            }

            public String toString() {
                return "IDE{" + this.$productCode + ", " + this.$build + ", " + this.getOs() + ", home=" + this.$unpackDir + "}";
            }

            public Object resolveAndDownloadTheSameJDK(Continuation<? super Path> $completion) {
                Path path = this.$appHome;
                Intrinsics.checkNotNull((Object)path);
                Path path2 = path.resolve("jbr");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                Path jbrHome = path2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(jbrHome, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    boolean bl = false;
                    String string = "JbrHome is not found under " + jbrHome;
                    throw new IllegalArgumentException(string.toString());
                }
                String jbrFullVersion = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)JvmUtils.INSTANCE.callJavaVersion(jbrHome), (String)"build ", null, (int)2, null), (String)")", null, (int)2, null);
                LoggingKt.logOutput((String)("Found following " + jbrFullVersion + " in the product: " + this.$productCode + " " + this.$build));
                return jbrHome;
            }
        };
    }
}

