/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.models;

import com.intellij.ide.starter.community.model.BuildType;
import com.intellij.ide.starter.di.DiContainerKt;
import com.intellij.ide.starter.ide.IdeInstaller;
import com.intellij.ide.starter.ide.installer.IdeInstallerFactory;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 E2\u00020\u0001:\u0001EB\u009b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u00a5\u0001\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0001J\u0013\u0010@\u001a\u00020(2\b\u0010A\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010B\u001a\u00020CH\u00d6\u0001J\t\u0010D\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0017R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010)R\u0011\u0010*\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0017R\u0011\u0010,\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0017R\u0011\u0010.\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0017R\u0011\u00100\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0017\u00a8\u0006F"}, d2={"Lcom/intellij/ide/starter/models/IdeInfo;", "", "productCode", "", "platformPrefix", "executableFileName", "baseIdePlatformPrefixForFrontend", "buildType", "additionalModules", "", "buildNumber", "version", "tag", "downloadURI", "Ljava/net/URI;", "qodanaProductCode", "fullName", "getInstaller", "Lkotlin/Function1;", "Lcom/intellij/ide/starter/ide/IdeInstaller;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getProductCode", "()Ljava/lang/String;", "getPlatformPrefix", "getExecutableFileName", "getBaseIdePlatformPrefixForFrontend", "getBuildType", "getAdditionalModules", "()Ljava/util/List;", "getBuildNumber", "getVersion", "getTag", "getDownloadURI", "()Ljava/net/URI;", "getQodanaProductCode", "getFullName", "getGetInstaller", "()Lkotlin/jvm/functions/Function1;", "isFrontend", "", "()Z", "installerFilePrefix", "getInstallerFilePrefix", "installerProductName", "getInstallerProductName", "installerFileExt", "getInstallerFileExt", "identity", "getIdentity", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nIdeInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeInfo.kt\ncom/intellij/ide/starter/models/IdeInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Retrieving.kt\norg/kodein/di/RetrievingKt\n+ 4 typeTokensJVM.kt\norg/kodein/type/TypeTokensJVMKt\n*L\n1#1,130:1\n1#2:131\n527#3:132\n83#4:133\n*S KotlinDebug\n*F\n+ 1 IdeInfo.kt\ncom/intellij/ide/starter/models/IdeInfo\n*L\n50#1:132\n50#1:133\n*E\n"})
public final class IdeInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String productCode;
    @NotNull
    private final String platformPrefix;
    @NotNull
    private final String executableFileName;
    @Nullable
    private final String baseIdePlatformPrefixForFrontend;
    @NotNull
    private final String buildType;
    @NotNull
    private final List<String> additionalModules;
    @NotNull
    private final String buildNumber;
    @NotNull
    private final String version;
    @Nullable
    private final String tag;
    @Nullable
    private final URI downloadURI;
    @Nullable
    private final String qodanaProductCode;
    @NotNull
    private final String fullName;
    @NotNull
    private final Function1<IdeInfo, IdeInstaller> getInstaller;
    private final boolean isFrontend;

    public IdeInfo(@NotNull String productCode, @NotNull String platformPrefix, @NotNull String executableFileName, @Nullable String baseIdePlatformPrefixForFrontend, @NotNull String buildType, @NotNull List<String> additionalModules, @NotNull String buildNumber, @NotNull String version, @Nullable String tag, @Nullable URI downloadURI, @Nullable String qodanaProductCode, @NotNull String fullName, @NotNull Function1<? super IdeInfo, ? extends IdeInstaller> getInstaller) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)platformPrefix, (String)"platformPrefix");
        Intrinsics.checkNotNullParameter((Object)executableFileName, (String)"executableFileName");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        Intrinsics.checkNotNullParameter(additionalModules, (String)"additionalModules");
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        Intrinsics.checkNotNullParameter(getInstaller, (String)"getInstaller");
        this.productCode = productCode;
        this.platformPrefix = platformPrefix;
        this.executableFileName = executableFileName;
        this.baseIdePlatformPrefixForFrontend = baseIdePlatformPrefixForFrontend;
        this.buildType = buildType;
        this.additionalModules = additionalModules;
        this.buildNumber = buildNumber;
        this.version = version;
        this.tag = tag;
        this.downloadURI = downloadURI;
        this.qodanaProductCode = qodanaProductCode;
        this.fullName = fullName;
        this.getInstaller = getInstaller;
        this.isFrontend = Intrinsics.areEqual((Object)this.platformPrefix, (Object)"JetBrainsClient");
        if (this.isFrontend) {
            if (this.baseIdePlatformPrefixForFrontend == null) {
                boolean bl = false;
                String string = "baseIdePlatformPrefixForFrontend must be specified for JetBrainsClient";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ IdeInfo(String string, String string2, String string3, String string4, String string5, List list, String string6, String string7, String string8, URI uRI, String string9, String string10, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = BuildType.EAP.getType();
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            string6 = "";
        }
        if ((n & 0x80) != 0) {
            string7 = "";
        }
        if ((n & 0x100) != 0) {
            string8 = null;
        }
        if ((n & 0x200) != 0) {
            uRI = null;
        }
        if ((n & 0x400) != 0) {
            string9 = null;
        }
        if ((n & 0x1000) != 0) {
            function1 = IdeInfo::_init_$lambda$0;
        }
        this(string, string2, string3, string4, string5, list, string6, string7, string8, uRI, string9, string10, (Function1<? super IdeInfo, ? extends IdeInstaller>)function1);
    }

    @NotNull
    public final String getProductCode() {
        return this.productCode;
    }

    @NotNull
    public final String getPlatformPrefix() {
        return this.platformPrefix;
    }

    @NotNull
    public final String getExecutableFileName() {
        return this.executableFileName;
    }

    @Nullable
    public final String getBaseIdePlatformPrefixForFrontend() {
        return this.baseIdePlatformPrefixForFrontend;
    }

    @NotNull
    public final String getBuildType() {
        return this.buildType;
    }

    @NotNull
    public final List<String> getAdditionalModules() {
        return this.additionalModules;
    }

    @NotNull
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getTag() {
        return this.tag;
    }

    @Nullable
    public final URI getDownloadURI() {
        return this.downloadURI;
    }

    @Nullable
    public final String getQodanaProductCode() {
        return this.qodanaProductCode;
    }

    @NotNull
    public final String getFullName() {
        return this.fullName;
    }

    @NotNull
    public final Function1<IdeInfo, IdeInstaller> getGetInstaller() {
        return this.getInstaller;
    }

    public final boolean isFrontend() {
        return this.isFrontend;
    }

    @NotNull
    public final String getInstallerFilePrefix() {
        return switch (this.productCode) {
            case "IU" -> "ideaIU";
            case "IC" -> "ideaIC";
            case "WS" -> "WebStorm";
            case "PS" -> "PhpStorm";
            case "DB" -> "datagrip";
            case "GO" -> "goland";
            case "RM" -> "RubyMine";
            case "PY" -> "pycharmPY";
            case "CL" -> "CLion";
            case "DS" -> "dataspell";
            case "PC" -> "pycharmPC";
            case "QA" -> "aqua";
            case "RR" -> "RustRover";
            case "AI" -> "AndroidStudio";
            case "JBC" -> "JetBrainsClient";
            case "RD" -> "rider";
            case "WRS" -> "writerside";
            case "GW" -> "gateway";
            case "GIG" -> "GitClient";
            default -> throw new IllegalStateException(("Unknown product code: " + this.productCode).toString());
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String getInstallerProductName() {
        String string = this.productCode;
        switch (string.hashCode()) {
            case 2624: {
                if (string.equals("RR")) return "RustRover";
                break;
            }
            case 2569: {
                if (string.equals("PY")) return "pycharm";
                break;
            }
            case 2330: {
                if (string.equals("IC")) return "intellij.ce";
                break;
            }
            case 2619: {
                if (string.equals("RM")) return "rubymine";
                break;
            }
            case 2348: {
                if (!string.equals("IU")) break;
                return "intellij";
            }
        }
        String string2 = this.getInstallerFilePrefix();
        return string2;
    }

    @NotNull
    public final String getInstallerFileExt() {
        OS oS = OS.CURRENT;
        String ext = switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> ".exe";
            case 2 -> ".tar.gz";
            case 3 -> ".dmg";
            default -> throw new IllegalStateException(("Unknown OS " + System.getProperty("os.name")).toString());
        };
        CpuArch cpuArch = CpuArch.CURRENT;
        boolean aarch64 = switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cpuArch.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            default -> throw new IllegalStateException(("Unknown architecture " + CpuArch.CURRENT).toString());
        };
        return aarch64 ? "-aarch64" + ext : ext;
    }

    @NotNull
    public final String getIdentity() {
        String string;
        if (!StringsKt.isBlank((CharSequence)this.buildNumber)) {
            string = this.productCode + "-" + this.platformPrefix + "-" + this.buildNumber;
        } else {
            String suffix = StringsKt.contains$default((CharSequence)this.version, (CharSequence)"-EAP", (boolean)false, (int)2, null) ? "" : (Intrinsics.areEqual((Object)this.buildType, (Object)BuildType.EAP.getType()) ? "-EAP" : "");
            string = this.productCode + "-" + this.platformPrefix + "-" + this.version + suffix;
        }
        return string;
    }

    @NotNull
    public final String component1() {
        return this.productCode;
    }

    @NotNull
    public final String component2() {
        return this.platformPrefix;
    }

    @NotNull
    public final String component3() {
        return this.executableFileName;
    }

    @Nullable
    public final String component4() {
        return this.baseIdePlatformPrefixForFrontend;
    }

    @NotNull
    public final String component5() {
        return this.buildType;
    }

    @NotNull
    public final List<String> component6() {
        return this.additionalModules;
    }

    @NotNull
    public final String component7() {
        return this.buildNumber;
    }

    @NotNull
    public final String component8() {
        return this.version;
    }

    @Nullable
    public final String component9() {
        return this.tag;
    }

    @Nullable
    public final URI component10() {
        return this.downloadURI;
    }

    @Nullable
    public final String component11() {
        return this.qodanaProductCode;
    }

    @NotNull
    public final String component12() {
        return this.fullName;
    }

    @NotNull
    public final Function1<IdeInfo, IdeInstaller> component13() {
        return this.getInstaller;
    }

    @NotNull
    public final IdeInfo copy(@NotNull String productCode, @NotNull String platformPrefix, @NotNull String executableFileName, @Nullable String baseIdePlatformPrefixForFrontend, @NotNull String buildType, @NotNull List<String> additionalModules, @NotNull String buildNumber, @NotNull String version, @Nullable String tag, @Nullable URI downloadURI, @Nullable String qodanaProductCode, @NotNull String fullName, @NotNull Function1<? super IdeInfo, ? extends IdeInstaller> getInstaller) {
        Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
        Intrinsics.checkNotNullParameter((Object)platformPrefix, (String)"platformPrefix");
        Intrinsics.checkNotNullParameter((Object)executableFileName, (String)"executableFileName");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        Intrinsics.checkNotNullParameter(additionalModules, (String)"additionalModules");
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        Intrinsics.checkNotNullParameter(getInstaller, (String)"getInstaller");
        return new IdeInfo(productCode, platformPrefix, executableFileName, baseIdePlatformPrefixForFrontend, buildType, additionalModules, buildNumber, version, tag, downloadURI, qodanaProductCode, fullName, getInstaller);
    }

    public static /* synthetic */ IdeInfo copy$default(IdeInfo ideInfo, String string, String string2, String string3, String string4, String string5, List list, String string6, String string7, String string8, URI uRI, String string9, String string10, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = ideInfo.productCode;
        }
        if ((n & 2) != 0) {
            string2 = ideInfo.platformPrefix;
        }
        if ((n & 4) != 0) {
            string3 = ideInfo.executableFileName;
        }
        if ((n & 8) != 0) {
            string4 = ideInfo.baseIdePlatformPrefixForFrontend;
        }
        if ((n & 0x10) != 0) {
            string5 = ideInfo.buildType;
        }
        if ((n & 0x20) != 0) {
            list = ideInfo.additionalModules;
        }
        if ((n & 0x40) != 0) {
            string6 = ideInfo.buildNumber;
        }
        if ((n & 0x80) != 0) {
            string7 = ideInfo.version;
        }
        if ((n & 0x100) != 0) {
            string8 = ideInfo.tag;
        }
        if ((n & 0x200) != 0) {
            uRI = ideInfo.downloadURI;
        }
        if ((n & 0x400) != 0) {
            string9 = ideInfo.qodanaProductCode;
        }
        if ((n & 0x800) != 0) {
            string10 = ideInfo.fullName;
        }
        if ((n & 0x1000) != 0) {
            function1 = ideInfo.getInstaller;
        }
        return ideInfo.copy(string, string2, string3, string4, string5, list, string6, string7, string8, uRI, string9, string10, function1);
    }

    @NotNull
    public String toString() {
        return "IdeInfo(productCode=" + this.productCode + ", platformPrefix=" + this.platformPrefix + ", executableFileName=" + this.executableFileName + ", baseIdePlatformPrefixForFrontend=" + this.baseIdePlatformPrefixForFrontend + ", buildType=" + this.buildType + ", additionalModules=" + this.additionalModules + ", buildNumber=" + this.buildNumber + ", version=" + this.version + ", tag=" + this.tag + ", downloadURI=" + this.downloadURI + ", qodanaProductCode=" + this.qodanaProductCode + ", fullName=" + this.fullName + ", getInstaller=" + this.getInstaller + ")";
    }

    public int hashCode() {
        int result2 = this.productCode.hashCode();
        result2 = result2 * 31 + this.platformPrefix.hashCode();
        result2 = result2 * 31 + this.executableFileName.hashCode();
        result2 = result2 * 31 + (this.baseIdePlatformPrefixForFrontend == null ? 0 : this.baseIdePlatformPrefixForFrontend.hashCode());
        result2 = result2 * 31 + this.buildType.hashCode();
        result2 = result2 * 31 + ((Object)this.additionalModules).hashCode();
        result2 = result2 * 31 + this.buildNumber.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + (this.tag == null ? 0 : this.tag.hashCode());
        result2 = result2 * 31 + (this.downloadURI == null ? 0 : this.downloadURI.hashCode());
        result2 = result2 * 31 + (this.qodanaProductCode == null ? 0 : this.qodanaProductCode.hashCode());
        result2 = result2 * 31 + this.fullName.hashCode();
        result2 = result2 * 31 + this.getInstaller.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdeInfo)) {
            return false;
        }
        IdeInfo ideInfo = (IdeInfo)other;
        if (!Intrinsics.areEqual((Object)this.productCode, (Object)ideInfo.productCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.platformPrefix, (Object)ideInfo.platformPrefix)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.executableFileName, (Object)ideInfo.executableFileName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseIdePlatformPrefixForFrontend, (Object)ideInfo.baseIdePlatformPrefixForFrontend)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildType, (Object)ideInfo.buildType)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.additionalModules, ideInfo.additionalModules)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildNumber, (Object)ideInfo.buildNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)ideInfo.version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)ideInfo.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.downloadURI, (Object)ideInfo.downloadURI)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.qodanaProductCode, (Object)ideInfo.qodanaProductCode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fullName, (Object)ideInfo.fullName)) {
            return false;
        }
        return Intrinsics.areEqual(this.getInstaller, ideInfo.getInstaller);
    }

    private static final IdeInstaller _init_$lambda$0(IdeInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)DiContainerKt.getDi()));
        Object tag$iv = null;
        boolean $i$f$instance = false;
        DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<IdeInstallerFactory>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        return IdeInstallerFactory.createInstaller$default((IdeInstallerFactory)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, IdeInstallerFactory.class), tag$iv), it, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ide/starter/models/IdeInfo$Companion;", "", "<init>", "()V", "intellij.tools.ide.starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

