/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.path;

import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.MemoryFsKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/starter/path/IDEDataPaths;", "", "testHome", "Ljava/nio/file/Path;", "inMemoryRoot", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getTestHome", "()Ljava/nio/file/Path;", "tempDir", "getTempDir", "configDir", "getConfigDir", "systemDir", "getSystemDir", "pluginsDir", "getPluginsDir", "jbrDiagnostic", "getJbrDiagnostic", "eventLogMetadataDir", "getEventLogMetadataDir", "eventLogDataDir", "getEventLogDataDir", "finalize", "", "toString", "", "Companion", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nIDEDataPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDEDataPaths.kt\ncom/intellij/ide/starter/path/IDEDataPaths\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1869#2,2:56\n*S KotlinDebug\n*F\n+ 1 IDEDataPaths.kt\ncom/intellij/ide/starter/path/IDEDataPaths\n*L\n49#1:56,2\n*E\n"})
public class IDEDataPaths {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path testHome;
    @Nullable
    private final Path inMemoryRoot;
    @NotNull
    private final Path tempDir;
    @NotNull
    private final Path configDir;
    @NotNull
    private final Path systemDir;
    @NotNull
    private final Path pluginsDir;
    @NotNull
    private final Path jbrDiagnostic;
    @NotNull
    private final Path eventLogMetadataDir;
    @NotNull
    private final Path eventLogDataDir;

    public IDEDataPaths(@NotNull Path testHome, @Nullable Path inMemoryRoot) {
        Intrinsics.checkNotNullParameter((Object)testHome, (String)"testHome");
        this.testHome = testHome;
        this.inMemoryRoot = inMemoryRoot;
        Path path = this.getTestHome().resolve("temp");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(...)");
        this.tempDir = path2;
        Path path3 = this.inMemoryRoot;
        if (path3 == null) {
            path3 = this.getTestHome();
        }
        Path path4 = path3;
        Path path5 = path4.resolve("config");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        path4 = path5;
        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
        Path path6 = Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"createDirectories(...)");
        this.configDir = path6;
        Path path7 = this.inMemoryRoot;
        if (path7 == null) {
            path7 = this.getTestHome();
        }
        path4 = path7;
        Path path8 = path4.resolve("system");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"resolve(...)");
        path4 = path8;
        fileAttributeArray2 = new FileAttribute[]{};
        Path path9 = Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"createDirectories(...)");
        this.systemDir = path9;
        Path path10 = this.getTestHome().resolve("plugins");
        Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray3 = new FileAttribute[]{};
        Path path11 = Files.createDirectories(path10, Arrays.copyOf(fileAttributeArray3, fileAttributeArray3.length));
        Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"createDirectories(...)");
        this.pluginsDir = path11;
        Path path12 = this.getTestHome().resolve("jbrDiagnostic");
        Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray4 = new FileAttribute[]{};
        Path path13 = Files.createDirectories(path12, Arrays.copyOf(fileAttributeArray4, fileAttributeArray4.length));
        Intrinsics.checkNotNullExpressionValue((Object)path13, (String)"createDirectories(...)");
        this.jbrDiagnostic = path13;
        Path path14 = this.configDir.resolve("event-log-metadata");
        Intrinsics.checkNotNullExpressionValue((Object)path14, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray5 = new FileAttribute[]{};
        Path path15 = Files.createDirectories(path14, Arrays.copyOf(fileAttributeArray5, fileAttributeArray5.length));
        Intrinsics.checkNotNullExpressionValue((Object)path15, (String)"createDirectories(...)");
        this.eventLogMetadataDir = path15;
        Path path16 = this.systemDir.resolve("event-log-data");
        Intrinsics.checkNotNullExpressionValue((Object)path16, (String)"resolve(...)");
        FileAttribute[] fileAttributeArray6 = new FileAttribute[]{};
        Path path17 = Files.createDirectories(path16, Arrays.copyOf(fileAttributeArray6, fileAttributeArray6.length));
        Intrinsics.checkNotNullExpressionValue((Object)path17, (String)"createDirectories(...)");
        this.eventLogDataDir = path17;
    }

    @NotNull
    public Path getTestHome() {
        return this.testHome;
    }

    @NotNull
    public final Path getTempDir() {
        return this.tempDir;
    }

    @NotNull
    public final Path getConfigDir() {
        return this.configDir;
    }

    @NotNull
    public final Path getSystemDir() {
        return this.systemDir;
    }

    @NotNull
    public final Path getPluginsDir() {
        return this.pluginsDir;
    }

    @NotNull
    public final Path getJbrDiagnostic() {
        return this.jbrDiagnostic;
    }

    @NotNull
    public Path getEventLogMetadataDir() {
        return this.eventLogMetadataDir;
    }

    @NotNull
    public Path getEventLogDataDir() {
        return this.eventLogDataDir;
    }

    protected final void finalize() {
        if (this.inMemoryRoot != null) {
            try {
                FileSystem.INSTANCE.deleteRecursivelyQuietly(this.inMemoryRoot);
            }
            catch (Exception e) {
                LoggingKt.logOutput((String)("! Failed to unmount in-memory FS at " + this.inMemoryRoot));
                Iterable $this$forEach$iv = StringsKt.lines((CharSequence)ExceptionsKt.stackTraceToString((Throwable)e));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    LoggingKt.logOutput((String)("    " + it));
                }
            }
        }
    }

    @NotNull
    public String toString() {
        return "IDE Test Paths at " + this.getTestHome();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u0002H\u0005\"\n\b\u0000\u0010\u0005\u0018\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/path/IDEDataPaths$Companion;", "", "<init>", "()V", "createPaths", "T", "testName", "", "testHome", "Ljava/nio/file/Path;", "useInMemoryFs", "", "(Ljava/lang/String;Ljava/nio/file/Path;Z)Ljava/lang/Object;", "intellij.tools.ide.starter"})
    @SourceDebugExtension(value={"SMAP\nIDEDataPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IDEDataPaths.kt\ncom/intellij/ide/starter/path/IDEDataPaths$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,55:1\n1292#2,3:56\n*S KotlinDebug\n*F\n+ 1 IDEDataPaths.kt\ncom/intellij/ide/starter/path/IDEDataPaths$Companion\n*L\n18#1:56,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T> T createPaths(String testName, Path testHome, boolean useInMemoryFs) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
            Intrinsics.checkNotNullParameter((Object)testHome, (String)"testHome");
            boolean $i$f$createPaths = false;
            File file = testHome.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Sequence sequence = (Sequence)FilesKt.walkBottomUp((File)file);
            boolean initial$iv = true;
            boolean $i$f$fold = false;
            boolean accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void it;
                File file2 = (File)element$iv;
                boolean res = accumulator$iv;
                boolean bl = false;
                String string = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                Path path = testHome.resolve("system");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                String string2 = path.toFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                accumulator$iv = (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null) || it.delete() || !it.exists()) && res;
            }
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(testHome, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            Path inMemoryRoot = useInMemoryFs ? MemoryFsKt.createInMemoryDirectory("ide-integration-test-" + testName) : (Path)null;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            Object[] objectArray = new Class[]{Path.class, Path.class};
            Constructor constructor = Object.class.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{testHome, inMemoryRoot};
            Object t = constructor.newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
            return t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

