/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.process.exec;

import com.intellij.tools.ide.util.common.LoggingKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH&J\b\u0010\u000b\u001a\u00020\tH&J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0004\u0082\u0001\u0006\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "", "<init>", "()V", "open", "", "close", "redirectLine", "line", "", "read", "toString", "reportOnStdoutIfNecessary", "NoRedirect", "ToFile", "DelegatedWithPrefix", "ToStdOut", "ToStdOutAndString", "ToString", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$DelegatedWithPrefix;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$NoRedirect;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToFile;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToStdOut;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToStdOutAndString;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToString;", "intellij.tools.ide.starter"})
public abstract sealed class ExecOutputRedirect {
    private ExecOutputRedirect() {
    }

    public void open() {
    }

    public void close() {
    }

    public void redirectLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
    }

    @NotNull
    public abstract String read();

    @NotNull
    public abstract String toString();

    protected final void reportOnStdoutIfNecessary(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Listening for transport dt_socket", (boolean)false, (int)2, null)) {
            System.out.println((Object)line);
        }
    }

    public /* synthetic */ ExecOutputRedirect(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0001H\u00c2\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$DelegatedWithPrefix;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "prefix", "", "delegate", "<init>", "(Ljava/lang/String;Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;)V", "getPrefix", "()Ljava/lang/String;", "read", "open", "", "close", "redirectLine", "line", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "intellij.tools.ide.starter"})
    public static final class DelegatedWithPrefix
    extends ExecOutputRedirect {
        @NotNull
        private final String prefix;
        @NotNull
        private final ExecOutputRedirect delegate;

        public DelegatedWithPrefix(@NotNull String prefix, @NotNull ExecOutputRedirect delegate) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(null);
            this.prefix = prefix;
            this.delegate = delegate;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        @NotNull
        public String read() {
            return this.delegate.read();
        }

        @Override
        public void open() {
            this.delegate.open();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public void redirectLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.delegate.redirectLine(this.prefix + " " + line);
        }

        @Override
        @NotNull
        public String toString() {
            return this.delegate + " with prefix '" + this.prefix + "'";
        }

        @NotNull
        public final String component1() {
            return this.prefix;
        }

        private final ExecOutputRedirect component2() {
            return this.delegate;
        }

        @NotNull
        public final DelegatedWithPrefix copy(@NotNull String prefix, @NotNull ExecOutputRedirect delegate) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            return new DelegatedWithPrefix(prefix, delegate);
        }

        public static /* synthetic */ DelegatedWithPrefix copy$default(DelegatedWithPrefix delegatedWithPrefix, String string, ExecOutputRedirect execOutputRedirect, int n, Object object) {
            if ((n & 1) != 0) {
                string = delegatedWithPrefix.prefix;
            }
            if ((n & 2) != 0) {
                execOutputRedirect = delegatedWithPrefix.delegate;
            }
            return delegatedWithPrefix.copy(string, execOutputRedirect);
        }

        public int hashCode() {
            int result2 = this.prefix.hashCode();
            result2 = result2 * 31 + this.delegate.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DelegatedWithPrefix)) {
                return false;
            }
            DelegatedWithPrefix delegatedWithPrefix = (DelegatedWithPrefix)other;
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)delegatedWithPrefix.prefix)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.delegate, (Object)delegatedWithPrefix.delegate);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$NoRedirect;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "<init>", "()V", "redirectLine", "", "line", "", "read", "toString", "intellij.tools.ide.starter"})
    public static final class NoRedirect
    extends ExecOutputRedirect {
        @NotNull
        public static final NoRedirect INSTANCE = new NoRedirect();

        private NoRedirect() {
            super(null);
        }

        @Override
        public void redirectLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.reportOnStdoutIfNecessary(line);
        }

        @Override
        @NotNull
        public String read() {
            return "";
        }

        @Override
        @NotNull
        public String toString() {
            return "ignored";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\f\u0010\u0016\u001a\u00020\u0011*\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToFile;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "outputFile", "Ljava/io/File;", "reportDebugForAutoAttach", "", "<init>", "(Ljava/io/File;Z)V", "getOutputFile", "()Ljava/io/File;", "writer", "Ljava/io/PrintWriter;", "hasChanges", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "close", "", "redirectLine", "line", "", "initializeWriterIfNotInitialized", "flushPendingChanges", "read", "toString", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "intellij.tools.ide.starter"})
    public static final class ToFile
    extends ExecOutputRedirect {
        @NotNull
        private final File outputFile;
        private final boolean reportDebugForAutoAttach;
        @Nullable
        private PrintWriter writer;
        private boolean hasChanges;
        private final ScheduledExecutorService scheduler;

        public ToFile(@NotNull File outputFile, boolean reportDebugForAutoAttach) {
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            super(null);
            this.outputFile = outputFile;
            this.reportDebugForAutoAttach = reportDebugForAutoAttach;
            this.scheduler = Executors.newScheduledThreadPool(1);
        }

        public /* synthetic */ ToFile(File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(file, bl);
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @Override
        public void close() {
            block0: {
                PrintWriter printWriter;
                PrintWriter printWriter2 = this.writer;
                if (printWriter2 == null) break block0;
                PrintWriter $this$close_u24lambda_u240 = printWriter = printWriter2;
                boolean bl = false;
                this.flushPendingChanges($this$close_u24lambda_u240);
                this.scheduler.shutdown();
                $this$close_u24lambda_u240.close();
            }
        }

        @Override
        public void redirectLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            if (this.reportDebugForAutoAttach) {
                this.reportOnStdoutIfNecessary(line);
            }
            PrintWriter it = this.initializeWriterIfNotInitialized();
            boolean bl = false;
            it.println(line);
            this.hasChanges = true;
        }

        private final PrintWriter initializeWriterIfNotInitialized() {
            Object object = this.writer;
            if (object == null) {
                ToFile $this$initializeWriterIfNotInitialized_u24lambda_u240 = this;
                boolean bl = false;
                Object object2 = $this$initializeWriterIfNotInitialized_u24lambda_u240.outputFile;
                Comparable<File> $this$initializeWriterIfNotInitialized_u24lambda_u240_u240 = object2;
                boolean $i$a$-apply-ExecOutputRedirect$ToFile$initializeWriterIfNotInitialized$1$22 = false;
                Path path = $this$initializeWriterIfNotInitialized_u24lambda_u240_u240.toPath().getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                Path path2 = path;
                Object object3 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object3, ((FileAttribute[])object3).length)), (String)"createDirectories(...)");
                $this$initializeWriterIfNotInitialized_u24lambda_u240_u240.createNewFile();
                object2 = $this$initializeWriterIfNotInitialized_u24lambda_u240.outputFile;
                $this$initializeWriterIfNotInitialized_u24lambda_u240_u240 = Charsets.UTF_8;
                File $i$a$-apply-ExecOutputRedirect$ToFile$initializeWriterIfNotInitialized$1$22 = object2;
                int n = 8192;
                object3 = $i$a$-apply-ExecOutputRedirect$ToFile$initializeWriterIfNotInitialized$1$22;
                object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)$this$initializeWriterIfNotInitialized_u24lambda_u240_u240);
                Object it = object2 = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
                boolean bl2 = false;
                $this$initializeWriterIfNotInitialized_u24lambda_u240.writer = it;
                $this$initializeWriterIfNotInitialized_u24lambda_u240.scheduler.scheduleAtFixedRate(() -> ToFile.initializeWriterIfNotInitialized$lambda$0$1$0($this$initializeWriterIfNotInitialized_u24lambda_u240, (PrintWriter)it), 1L, 1L, TimeUnit.SECONDS);
                object = object2;
            }
            return object;
        }

        private final void flushPendingChanges(PrintWriter $this$flushPendingChanges) {
            if (this.hasChanges) {
                $this$flushPendingChanges.flush();
                this.hasChanges = false;
            }
        }

        @Override
        @NotNull
        public String read() {
            if (!this.outputFile.exists()) {
                LoggingKt.logOutput((String)("File " + this.outputFile + " doesn't exist"));
                return "";
            }
            return FilesKt.readText$default((File)this.outputFile, null, (int)1, null);
        }

        @Override
        @NotNull
        public String toString() {
            return "file " + this.outputFile;
        }

        @NotNull
        public final File component1() {
            return this.outputFile;
        }

        private final boolean component2() {
            return this.reportDebugForAutoAttach;
        }

        @NotNull
        public final ToFile copy(@NotNull File outputFile, boolean reportDebugForAutoAttach) {
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            return new ToFile(outputFile, reportDebugForAutoAttach);
        }

        public static /* synthetic */ ToFile copy$default(ToFile toFile, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                file = toFile.outputFile;
            }
            if ((n & 2) != 0) {
                bl = toFile.reportDebugForAutoAttach;
            }
            return toFile.copy(file, bl);
        }

        public int hashCode() {
            int result2 = this.outputFile.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.reportDebugForAutoAttach);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToFile)) {
                return false;
            }
            ToFile toFile = (ToFile)other;
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)toFile.outputFile)) {
                return false;
            }
            return this.reportDebugForAutoAttach == toFile.reportDebugForAutoAttach;
        }

        private static final void initializeWriterIfNotInitialized$lambda$0$1$0(ToFile $this_run, PrintWriter $it) {
            $this_run.flushPendingChanges($it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToStdOut;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "redirectLine", "", "line", "read", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.tools.ide.starter"})
    public static final class ToStdOut
    extends ExecOutputRedirect {
        @NotNull
        private final String prefix;

        public ToStdOut(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            super(null);
            this.prefix = prefix;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public void redirectLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.reportOnStdoutIfNecessary(line);
            LoggingKt.logOutput((String)("  " + this.prefix + " " + line));
        }

        @Override
        @NotNull
        public String read() {
            return "";
        }

        @Override
        @NotNull
        public String toString() {
            return "stdout";
        }

        @NotNull
        public final String component1() {
            return this.prefix;
        }

        @NotNull
        public final ToStdOut copy(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return new ToStdOut(prefix);
        }

        public static /* synthetic */ ToStdOut copy$default(ToStdOut toStdOut, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = toStdOut.prefix;
            }
            return toStdOut.copy(string);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToStdOut)) {
                return false;
            }
            ToStdOut toStdOut = (ToStdOut)other;
            return Intrinsics.areEqual((Object)this.prefix, (Object)toStdOut.prefix);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToStdOutAndString;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "redirectLine", "", "line", "read", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.tools.ide.starter"})
    public static final class ToStdOutAndString
    extends ExecOutputRedirect {
        @NotNull
        private final String prefix;
        @NotNull
        private final StringBuilder stringBuilder;

        public ToStdOutAndString(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            super(null);
            this.prefix = prefix;
            this.stringBuilder = new StringBuilder();
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public void redirectLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.reportOnStdoutIfNecessary(line);
            LoggingKt.logOutput((String)("  " + this.prefix + " " + line));
            this.stringBuilder.append(this.prefix + " " + line).append('\n');
        }

        @Override
        @NotNull
        public String read() {
            String string = this.stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            return "stdout";
        }

        @NotNull
        public final String component1() {
            return this.prefix;
        }

        @NotNull
        public final ToStdOutAndString copy(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return new ToStdOutAndString(prefix);
        }

        public static /* synthetic */ ToStdOutAndString copy$default(ToStdOutAndString toStdOutAndString, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = toStdOutAndString.prefix;
            }
            return toStdOutAndString.copy(string);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToStdOutAndString)) {
                return false;
            }
            ToStdOutAndString toStdOutAndString = (ToStdOutAndString)other;
            return Intrinsics.areEqual((Object)this.prefix, (Object)toStdOutAndString.prefix);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect$ToString;", "Lcom/intellij/ide/starter/process/exec/ExecOutputRedirect;", "<init>", "()V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "redirectLine", "", "line", "", "read", "toString", "intellij.tools.ide.starter"})
    public static final class ToString
    extends ExecOutputRedirect {
        @NotNull
        private final StringBuilder stringBuilder = new StringBuilder();

        public ToString() {
            super(null);
        }

        @Override
        public void redirectLine(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            this.reportOnStdoutIfNecessary(line);
            this.stringBuilder.append(line).append('\n');
        }

        @Override
        @NotNull
        public String read() {
            String string = this.stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            return "string";
        }
    }
}

