/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.telemetry.TestTelemetryService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tools.ide.util.common.LoggingKt;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.qameta.allure.Allure;
import io.qameta.allure.model.Status;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u001e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019J$\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00142\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001e0\u001dR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/intellij/ide/starter/report/AllureHelper;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "step", "T", "name", "", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "", "skippedStep", "attachFile", "file", "Ljava/io/File;", "Ljava/nio/file/Path;", "attachText", "value", "attach", "type", "Lcom/intellij/ide/starter/report/AllureHelper$MimeType;", "addAttachmentsFromDir", "dir", "filter", "Lkotlin/Function1;", "", "MimeType", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nAllureHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllureHelper.kt\ncom/intellij/ide/starter/report/AllureHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 TestTelemetryService.kt\ncom/intellij/ide/starter/telemetry/TestTelemetryServiceKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n13#2:94\n24#3,4:95\n36#3:101\n30#3,4:102\n1321#4,2:99\n*S KotlinDebug\n*F\n+ 1 AllureHelper.kt\ncom/intellij/ide/starter/report/AllureHelper\n*L\n37#1:94\n79#1:95,4\n79#1:101\n79#1:102,4\n83#1:99,2\n*E\n"})
public final class AllureHelper {
    @NotNull
    public static final AllureHelper INSTANCE = new AllureHelper();

    private AllureHelper() {
    }

    private final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AllureHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public final <T> T step(@NotNull String name, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.getLOG().info("Step: " + name);
        return (T)Allure.step((String)name, arg_0 -> AllureHelper.step$lambda$0(action, arg_0));
    }

    public final void step(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Allure.step((String)name);
    }

    public final void skippedStep(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Allure.step((String)name, (Status)Status.SKIPPED);
    }

    public final void attachFile(@NotNull String name, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MimeType mimeType = MimeType.Companion.getMimeTypeByExtension(file);
        Allure.getLifecycle().addAttachment(name, mimeType.getValue(), mimeType.getExt(), FilesKt.readBytes((File)file));
    }

    public final void attachFile(@NotNull String name, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        this.attachFile(name, file2);
    }

    public final void attachText(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.attach(name, value, MimeType.TEXT);
    }

    public final void attach(@NotNull String name, @NotNull Object value, @NotNull MimeType type) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (value instanceof byte[]) {
            byArray = (byte[])value;
        } else {
            String string = Objects.toString(value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray2 = string2.getBytes(charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        }
        byte[] bytes = byArray;
        Allure.getLifecycle().addAttachment(name, type.getValue(), type.getExt(), bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void addAttachmentsFromDir(@NotNull Path dir, @NotNull Function1<? super Path, Boolean> filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        String spanName$iv = "Attach files to Allure report";
        boolean $i$f$computeWithSpan = false;
        Span span$iv = TestTelemetryService.Companion.spanBuilder(spanName$iv).startSpan();
        try {
            Unit unit;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                Scope it$iv = (Scope)autoCloseable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)span$iv);
                Span span = span$iv;
                boolean bl2 = false;
                span.setAttribute("dir", ((Object)dir).toString());
                Sequence sequence = SequencesKt.filter((Sequence)PathsKt.walk((Path)dir, (PathWalkOption[])new PathWalkOption[0]), filter);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable throwable2;
                    Object object;
                    Path file = (Path)element$iv;
                    boolean bl3 = false;
                    try {
                        boolean bl4 = false;
                        String name = file.getParent().getFileName() + "/" + PathsKt.getName((Path)file);
                        INSTANCE.attachFile(name, file);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable3) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                    }
                    if (Result.exceptionOrNull-impl((Object)object) == null) continue;
                    Throwable it = throwable2;
                    boolean bl5 = false;
                    LoggingKt.logError((String)("Fail to attach file: " + file), (Throwable)it);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            autoCloseable = unit;
        }
        catch (Throwable e$iv) {
            span$iv.recordException(e$iv);
            span$iv.setStatus(StatusCode.ERROR);
            throw e$iv;
        }
        finally {
            span$iv.end();
        }
    }

    public static /* synthetic */ void addAttachmentsFromDir$default(AllureHelper allureHelper, Path path, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = AllureHelper::addAttachmentsFromDir$lambda$0;
        }
        allureHelper.addAttachmentsFromDir(path, (Function1<? super Path, Boolean>)function1);
    }

    private static final Object step$lambda$0(Function0 $action, Allure.StepContext it) {
        return $action.invoke();
    }

    private static final boolean addAttachmentsFromDir$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0081\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/starter/report/AllureHelper$MimeType;", "", "value", "", "ext", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "getExt", "TEXT", "JSON", "HTML", "JAVA", "PNG", "JPEG", "SVG", "XML", "PDF", "SQL", "CSV", "Companion", "intellij.tools.ide.starter"})
    public static final class MimeType
    extends Enum<MimeType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        @NotNull
        private final String ext;
        public static final /* enum */ MimeType TEXT;
        public static final /* enum */ MimeType JSON;
        public static final /* enum */ MimeType HTML;
        public static final /* enum */ MimeType JAVA;
        public static final /* enum */ MimeType PNG;
        public static final /* enum */ MimeType JPEG;
        public static final /* enum */ MimeType SVG;
        public static final /* enum */ MimeType XML;
        public static final /* enum */ MimeType PDF;
        public static final /* enum */ MimeType SQL;
        public static final /* enum */ MimeType CSV;
        private static final /* synthetic */ MimeType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MimeType(String value, String ext) {
            this.value = value;
            this.ext = ext;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String getExt() {
            return this.ext;
        }

        public static MimeType[] values() {
            return (MimeType[])$VALUES.clone();
        }

        public static MimeType valueOf(String value) {
            return Enum.valueOf(MimeType.class, value);
        }

        @NotNull
        public static EnumEntries<MimeType> getEntries() {
            return $ENTRIES;
        }

        static {
            TEXT = new MimeType("text/plain", ".txt");
            JSON = new MimeType("text/json", ".json");
            HTML = new MimeType("text/html", ".html");
            JAVA = new MimeType("text/x-java-source", ".java");
            PNG = new MimeType("image/jpeg", ".png");
            JPEG = new MimeType("image/jpeg", ".jpeg");
            SVG = new MimeType("image/svg+xml", ".svg");
            XML = new MimeType("application/xml", ".xml");
            PDF = new MimeType("application/pdf", ".pdf");
            SQL = new MimeType("text/x-sql", ".sql");
            CSV = new MimeType("text/csv", ".csv");
            $VALUES = mimeTypeArray = new MimeType[]{MimeType.TEXT, MimeType.JSON, MimeType.HTML, MimeType.JAVA, MimeType.PNG, MimeType.JPEG, MimeType.SVG, MimeType.XML, MimeType.PDF, MimeType.SQL, MimeType.CSV};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/starter/report/AllureHelper$MimeType$Companion;", "", "<init>", "()V", "getMimeTypeByExtension", "Lcom/intellij/ide/starter/report/AllureHelper$MimeType;", "file", "Ljava/io/File;", "intellij.tools.ide.starter"})
        @SourceDebugExtension(value={"SMAP\nAllureHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllureHelper.kt\ncom/intellij/ide/starter/report/AllureHelper$MimeType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n295#2,2:94\n*S KotlinDebug\n*F\n+ 1 AllureHelper.kt\ncom/intellij/ide/starter/report/AllureHelper$MimeType$Companion\n*L\n32#1:94,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MimeType getMimeTypeByExtension(@NotNull File file) {
                MimeType mimeType;
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Iterable $this$firstOrNull$iv = (Iterable)MimeType.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        MimeType it = (MimeType)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getExt(), (Object)("." + FilesKt.getExtension((File)file)))) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((mimeType = (MimeType)v0) == null) {
                    mimeType = TEXT;
                }
                return mimeType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

