/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.ci.teamcity.TeamCityCIServer;
import com.intellij.ide.starter.runner.CurrentTestMethod;
import com.intellij.ide.starter.runner.TestMethod;
import com.intellij.ide.starter.utils.GenerifyKt;
import com.intellij.tools.ide.util.common.LoggingKt;
import io.qameta.allure.Allure;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.model.TestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/starter/report/AllureReport;", "", "<init>", "()V", "ignoreLabels", "", "", "errorLink", "Lio/qameta/allure/model/Link;", "reportFailure", "", "contextName", "message", "originalStackTrace", "link", "suffix", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nAllureReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllureReport.kt\ncom/intellij/ide/starter/report/AllureReport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n774#2:73\n865#2,2:74\n1#3:76\n*S KotlinDebug\n*F\n+ 1 AllureReport.kt\ncom/intellij/ide/starter/report/AllureReport\n*L\n43#1:73\n43#1:74,2\n*E\n"})
public final class AllureReport {
    @NotNull
    public static final AllureReport INSTANCE = new AllureReport();
    @NotNull
    private static final Set<String> ignoreLabels;
    @NotNull
    private static final Link errorLink;

    private AllureReport() {
    }

    /*
     * WARNING - void declaration
     */
    public final void reportFailure(@NotNull String contextName, @NotNull String message, @NotNull String originalStackTrace, @Nullable String link, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)originalStackTrace, (String)"originalStackTrace");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        try {
            void $this$filterTo$iv$iv;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String uuid = string;
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
            TestMethod testMethod = CurrentTestMethod.INSTANCE.get();
            String stackTrace = originalStackTrace + StringsKt.repeat((CharSequence)string2, (int)2) + "ContextName: " + contextName + System.lineSeparator() + "TestName: " + (testMethod != null ? testMethod.fullName() : null);
            TestResult result2 = new TestResult();
            result2.setUuid(uuid);
            Ref.ObjectRef labels = new Ref.ObjectRef();
            labels.element = new ArrayList();
            Ref.ObjectRef testName = new Ref.ObjectRef();
            testName.element = "";
            Ref.ObjectRef fullName = new Ref.ObjectRef();
            fullName.element = "";
            Ref.ObjectRef testCaseName = new Ref.ObjectRef();
            testCaseName.element = "";
            Allure.getLifecycle().updateTestCase(arg_0 -> AllureReport.reportFailure$lambda$0(labels, testName, fullName, testCaseName, arg_0));
            Allure.getLifecycle().scheduleTestCase(result2);
            Allure.getLifecycle().startTestCase(uuid);
            Iterable $this$filter$iv = (Iterable)labels.element;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Label label = (Label)element$iv$iv;
                boolean bl = false;
                if (!(!ignoreLabels.contains(label.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List errorLabels = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Link linkToCi = new Link();
            if (link != null) {
                Allure.link((String)"CI server", (String)link);
                linkToCi.setName("CI server");
                linkToCi.setUrl(link);
            }
            Label label = new Label().setName("layer").setValue("Exception");
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"setValue(...)");
            errorLabels.add(label);
            Label label2 = new Label().setName("AS_ID").setValue("-1");
            Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"setValue(...)");
            errorLabels.add(label2);
            String hash = GenerifyKt.convertToHashCodeWithOnlyLetters(GenerifyKt.generifyErrorMessage(TeamCityCIServer.Companion.processStringForTC(stackTrace)).hashCode());
            Allure.getLifecycle().updateTestCase(arg_0 -> AllureReport.reportFailure$lambda$2(suffix, testName, message, stackTrace, fullName, hash, testCaseName, linkToCi, errorLabels, contextName, arg_0));
            Allure.getLifecycle().stopTestCase(uuid);
            Allure.getLifecycle().writeTestCase(uuid);
        }
        catch (Exception e) {
            LoggingKt.logError((String)"Fail to write allure", (Throwable)e);
        }
    }

    public static /* synthetic */ void reportFailure$default(AllureReport allureReport, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = "Exception";
        }
        allureReport.reportFailure(string, string2, string3, string4, string5);
    }

    private static final void reportFailure$lambda$0(Ref.ObjectRef $labels, Ref.ObjectRef $testName, Ref.ObjectRef $fullName, Ref.ObjectRef $testCaseName, TestResult it) {
        TestResult testResult = it;
        List list = testResult != null ? testResult.getLabels() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        $labels.element = list;
        TestResult testResult2 = it;
        String string = testResult2 != null ? testResult2.getName() : null;
        if (string == null) {
            string = "";
        }
        $testName.element = string;
        TestResult testResult3 = it;
        String string2 = testResult3 != null ? testResult3.getFullName() : null;
        if (string2 == null) {
            string2 = "";
        }
        $fullName.element = string2;
        TestResult testResult4 = it;
        String string3 = testResult4 != null ? testResult4.getTestCaseName() : null;
        if (string3 == null) {
            string3 = "";
        }
        $testCaseName.element = string3;
    }

    private static final void reportFailure$lambda$2(String $suffix, Ref.ObjectRef $testName, String $message, String $stackTrace, Ref.ObjectRef $fullName, String $hash, Ref.ObjectRef $testCaseName, Link $linkToCi, List $errorLabels, String $contextName, TestResult it) {
        Object[] objectArray;
        Object[] objectArray2;
        TestResult testResult;
        it.setStatus(Status.FAILED);
        TestResult testResult2 = it;
        String string = $suffix;
        Object[] objectArray3 = (Object[])$testName.element;
        if (StringsKt.isBlank((CharSequence)objectArray3)) {
            String string2 = string;
            testResult = testResult2;
            boolean bl = false;
            String string3 = $contextName;
            testResult2 = testResult;
            string = string2;
            objectArray2 = string3;
        } else {
            objectArray2 = objectArray3;
        }
        testResult2.setName(string + " in " + objectArray2);
        it.setStatusDetails(new StatusDetails().setMessage($message).setTrace($stackTrace));
        TestResult testResult3 = it;
        objectArray3 = (CharSequence)$fullName.element;
        if (StringsKt.isBlank((CharSequence)objectArray3)) {
            testResult = testResult3;
            boolean bl = false;
            objectArray = $contextName;
            testResult3 = testResult;
        } else {
            objectArray = objectArray3;
        }
        String string4 = $suffix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        testResult3.setFullName(objectArray + "." + $hash + "." + string4);
        it.setTestCaseName((String)$testCaseName.element);
        it.setHistoryId($hash);
        it.setDescription("IDE " + $suffix + " error that appears when running " + $fullName.element);
        objectArray3 = new Link[]{errorLink, $linkToCi};
        it.setLinks(CollectionsKt.listOf((Object[])objectArray3));
        it.setLabels($errorLabels);
    }

    static {
        Object[] objectArray = new String[]{"layer", "AS_ID"};
        ignoreLabels = SetsKt.setOf((Object[])objectArray);
        errorLink = new Link();
        errorLink.setName("How to process exception");
        errorLink.setUrl("https://jb.gg/ide-test-errors");
    }
}

