/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.report.ErrorType;
import com.intellij.ide.starter.utils.GenerifyKt;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J=\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/starter/report/Error;", "", "messageText", "", "stackTraceContent", "threadDump", "type", "Lcom/intellij/ide/starter/report/ErrorType;", "testName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/starter/report/ErrorType;Ljava/lang/String;)V", "getMessageText", "()Ljava/lang/String;", "getStackTraceContent", "getThreadDump", "getType", "()Lcom/intellij/ide/starter/report/ErrorType;", "getTestName", "generifiedStackTraceContent", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "copy", "toString", "intellij.tools.ide.starter"})
public final class Error {
    @NotNull
    private final String messageText;
    @NotNull
    private final String stackTraceContent;
    @NotNull
    private final String threadDump;
    @NotNull
    private final ErrorType type;
    @Nullable
    private final String testName;
    @NotNull
    private final String generifiedStackTraceContent;

    public Error(@NotNull String messageText, @NotNull String stackTraceContent, @NotNull String threadDump, @NotNull ErrorType type, @Nullable String testName) {
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter((Object)stackTraceContent, (String)"stackTraceContent");
        Intrinsics.checkNotNullParameter((Object)threadDump, (String)"threadDump");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.messageText = messageText;
        this.stackTraceContent = stackTraceContent;
        this.threadDump = threadDump;
        this.type = type;
        this.testName = testName;
        this.generifiedStackTraceContent = GenerifyKt.generifyErrorMessage(this.stackTraceContent);
    }

    public /* synthetic */ Error(String string, String string2, String string3, ErrorType errorType, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        this(string, string2, string3, errorType, string4);
    }

    @NotNull
    public final String getMessageText() {
        return this.messageText;
    }

    @NotNull
    public final String getStackTraceContent() {
        return this.stackTraceContent;
    }

    @NotNull
    public final String getThreadDump() {
        return this.threadDump;
    }

    @NotNull
    public final ErrorType getType() {
        return this.type;
    }

    @Nullable
    public final String getTestName() {
        return this.testName;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Error)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.messageText, (Object)((Error)other).messageText) && Intrinsics.areEqual((Object)this.generifiedStackTraceContent, (Object)((Error)other).generifiedStackTraceContent) && Intrinsics.areEqual((Object)this.threadDump, (Object)((Error)other).threadDump) && this.type == ((Error)other).type;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.messageText, this.generifiedStackTraceContent, this.threadDump, this.type};
        return Objects.hash(objectArray);
    }

    @NotNull
    public final String component1() {
        return this.messageText;
    }

    @NotNull
    public final String component2() {
        return this.stackTraceContent;
    }

    @NotNull
    public final String component3() {
        return this.threadDump;
    }

    @NotNull
    public final ErrorType component4() {
        return this.type;
    }

    @Nullable
    public final String component5() {
        return this.testName;
    }

    @NotNull
    public final Error copy(@NotNull String messageText, @NotNull String stackTraceContent, @NotNull String threadDump, @NotNull ErrorType type, @Nullable String testName) {
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter((Object)stackTraceContent, (String)"stackTraceContent");
        Intrinsics.checkNotNullParameter((Object)threadDump, (String)"threadDump");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new Error(messageText, stackTraceContent, threadDump, type, testName);
    }

    public static /* synthetic */ Error copy$default(Error error, String string, String string2, String string3, ErrorType errorType, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = error.messageText;
        }
        if ((n & 2) != 0) {
            string2 = error.stackTraceContent;
        }
        if ((n & 4) != 0) {
            string3 = error.threadDump;
        }
        if ((n & 8) != 0) {
            errorType = error.type;
        }
        if ((n & 0x10) != 0) {
            string4 = error.testName;
        }
        return error.copy(string, string2, string3, errorType, string4);
    }

    @NotNull
    public String toString() {
        return "Error(messageText=" + this.messageText + ", stackTraceContent=" + this.stackTraceContent + ", threadDump=" + this.threadDump + ", type=" + this.type + ", testName=" + this.testName + ")";
    }
}

