/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.ci.CIServer;
import com.intellij.ide.starter.report.AllureReport;
import com.intellij.ide.starter.report.Error;
import com.intellij.ide.starter.report.ErrorReporter;
import com.intellij.ide.starter.report.ErrorType;
import com.intellij.ide.starter.report.FailureDetailsOnCI;
import com.intellij.ide.starter.runner.IDERunContext;
import com.intellij.ide.starter.utils.GenerifyKt;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u001c\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/starter/report/ErrorReporterToCI;", "Lcom/intellij/ide/starter/report/ErrorReporter;", "<init>", "()V", "reportErrorsAsFailedTests", "", "runContext", "Lcom/intellij/ide/starter/runner/IDERunContext;", "collectErrors", "", "Lcom/intellij/ide/starter/report/Error;", "logsDir", "Ljava/nio/file/Path;", "collectScriptErrors", "collectExceptions", "rootErrorsDir", "inferClassMethodNamesFromFolderName", "", "path", "inferFallbackNameFromThreadDump", "dumpContent", "reportErrors", "errors", "generateTestNameFromException", "stackTraceContent", "messageText", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nErrorReporterToCI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorReporterToCI.kt\ncom/intellij/ide/starter/report/ErrorReporterToCI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class ErrorReporterToCI
implements ErrorReporter {
    @NotNull
    public static final ErrorReporterToCI INSTANCE = new ErrorReporterToCI();

    private ErrorReporterToCI() {
    }

    @Override
    public void reportErrorsAsFailedTests(@NotNull IDERunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        this.reportErrors(runContext, CollectionsKt.plus((Collection)this.collectErrors(runContext.getLogsDir()), (Iterable)this.collectScriptErrors(runContext.getLogsDir())));
    }

    @NotNull
    public final List<Error> collectErrors(@NotNull Path logsDir) {
        Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
        Optional<Path> optional = Files.find(logsDir, 3, ErrorReporterToCI::collectErrors$lambda$0, new FileVisitOption[0]).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        Path rootErrorsDir = (Path)OptionalsKt.getOrNull(optional);
        if (SystemProperties.getBooleanProperty((String)"DO_NOT_REPORT_ERRORS", (boolean)false)) {
            return CollectionsKt.emptyList();
        }
        return this.collectExceptions(rootErrorsDir);
    }

    @NotNull
    public final List<Error> collectScriptErrors(@NotNull Path logsDir) {
        Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
        Optional<Path> optional = Files.find(logsDir, 3, ErrorReporterToCI::collectScriptErrors$lambda$0, new FileVisitOption[0]).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        Path rootErrorsDir = (Path)OptionalsKt.getOrNull(optional);
        if (SystemProperties.getBooleanProperty((String)"DO_NOT_REPORT_ERRORS", (boolean)false)) {
            return CollectionsKt.emptyList();
        }
        return this.collectExceptions(rootErrorsDir);
    }

    private final List<Error> collectExceptions(Path rootErrorsDir) {
        block9: {
            block8: {
                if (rootErrorsDir == null) break block8;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(rootErrorsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block9;
            }
            return CollectionsKt.emptyList();
        }
        List errors = new ArrayList();
        List errorsDirectories = PathsKt.listDirectoryEntries$default((Path)rootErrorsDir, null, (int)1, null);
        for (Path errorDir : errorsDirectories) {
            Path threadDump;
            String string;
            File messageFile = errorDir.resolve("message.txt").toFile();
            if (!messageFile.exists()) continue;
            Intrinsics.checkNotNull((Object)messageFile);
            String messageText = GenerifyKt.generifyErrorMessage(((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)FilesKt.readText$default((File)messageFile, null, (int)1, null)))).toString());
            File testNameFile = errorDir.resolve("testName.txt").toFile();
            if (testNameFile.exists()) {
                Intrinsics.checkNotNull((Object)testNameFile);
                string = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)testNameFile, null, (int)1, null))).toString();
            } else {
                string = null;
            }
            String testName = string;
            ErrorType errorType = ErrorType.Companion.fromMessage(messageText);
            if (errorType == ErrorType.ERROR) {
                File stacktraceFile = errorDir.resolve("stacktrace.txt").toFile();
                if (!stacktraceFile.exists()) continue;
                Intrinsics.checkNotNull((Object)stacktraceFile);
                String stackTrace = ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)FilesKt.readText$default((File)stacktraceFile, null, (int)1, null)))).toString();
                errors.add(new Error(messageText, stackTrace, "", errorType, testName));
                continue;
            }
            if (errorType != ErrorType.FREEZE) continue;
            if ((Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)errorDir, (String)"dump*")) == null) continue;
            boolean bl = false;
            String dumpContent = Files.readString(threadDump);
            String string2 = INSTANCE.inferClassMethodNamesFromFolderName(threadDump);
            if (string2 == null) {
                Intrinsics.checkNotNull((Object)dumpContent);
                string2 = INSTANCE.inferFallbackNameFromThreadDump(dumpContent);
            }
            String fallbackName = "Not analyzed freeze: " + string2;
            Intrinsics.checkNotNull((Object)dumpContent);
            errors.add(new Error(fallbackName, "", dumpContent, ErrorType.FREEZE, null, 16, null));
        }
        return errors;
    }

    private final String inferClassMethodNamesFromFolderName(Path path) {
        String[] stringArray = new String[]{"-"};
        List nameParts = StringsKt.split$default((CharSequence)PathsKt.getName((Path)path), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return nameParts.size() == 8 ? (String)nameParts.get(7) : null;
    }

    private final String inferFallbackNameFromThreadDump(String dumpContent) {
        Regex regex = new Regex("at (.*)\\(.*:\\d+\\)");
        String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.lineSequence((CharSequence)dumpContent), arg_0 -> ErrorReporterToCI.inferFallbackNameFromThreadDump$lambda$0(regex, arg_0)));
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        throw new Exception("Thread dump file without methods!");
    }

    public final void reportErrors(@NotNull IDERunContext runContext, @NotNull List<Error> errors) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        for (Error error : errors) {
            String string;
            String messageText = error.getMessageText();
            String stackTraceContent = error.getStackTraceContent();
            switch (WhenMappings.$EnumSwitchMapping$0[error.getType().ordinal()]) {
                case 1: {
                    string = error.getTestName();
                    if (string != null) break;
                    string = this.generateTestNameFromException(stackTraceContent, messageText);
                    break;
                }
                case 2: 
                case 3: {
                    string = messageText;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String testName = string;
            FailureDetailsOnCI failureDetailsProvider = FailureDetailsOnCI.Companion.getInstance();
            String failureDetailsMessage = failureDetailsProvider.getFailureDetails(runContext);
            String urlToLogs = String.valueOf(failureDetailsProvider.getLinkToCIArtifacts(runContext));
            if (CIServer.Companion.getInstance().isTestFailureShouldBeIgnored(messageText) || CIServer.Companion.getInstance().isTestFailureShouldBeIgnored(stackTraceContent)) {
                CIServer.ignoreTestFailure$default(CIServer.Companion.getInstance(), "(" + GenerifyKt.generifyErrorMessage(testName) + ")", failureDetailsMessage, null, 4, null);
                continue;
            }
            CIServer.Companion.getInstance().reportTestFailure("(" + GenerifyKt.generifyErrorMessage(testName) + ")", failureDetailsMessage, stackTraceContent, urlToLogs);
            AllureReport.reportFailure$default(AllureReport.INSTANCE, runContext.getContextName(), messageText, stackTraceContent, failureDetailsProvider.getLinkToCIArtifacts(runContext), null, 16, null);
        }
    }

    private final String generateTestNameFromException(String stackTraceContent, String messageText) {
        String string;
        if (StringsKt.startsWith$default((String)stackTraceContent, (String)messageText, (boolean)false, (int)2, null)) {
            String extractedTestName;
            int maxLength = RangesKt.coerceAtMost((int)250, (int)stackTraceContent.length());
            String string2 = stackTraceContent.substring(0, maxLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = extractedTestName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            String string3 = messageText.substring(0, RangesKt.coerceAtMost((int)250, (int)messageText.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        }
        return string;
    }

    private static final boolean collectErrors$lambda$0(Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNull((Object)path);
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)"errors");
    }

    private static final boolean collectScriptErrors$lambda$0(Path path, BasicFileAttributes basicFileAttributes) {
        Intrinsics.checkNotNull((Object)path);
        return Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)"script-errors");
    }

    private static final String inferFallbackNameFromThreadDump$lambda$0(Regex $regex, String line) {
        String string;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult matchResult = Regex.find$default((Regex)$regex, (CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString(), (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult match = matchResult;
            boolean bl = false;
            String[] stringArray = new String[]{"."};
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)StringsKt.split$default((CharSequence)((CharSequence)match.getGroupValues().get(1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ErrorType.values().length];
            try {
                nArray[ErrorType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.FREEZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ErrorType.TIMEOUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

