/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.report;

import com.intellij.ide.starter.ci.CIServer;
import com.intellij.ide.starter.ci.teamcity.TeamCityCIServer;
import com.intellij.ide.starter.ci.teamcity.TeamCityCIServerKt;
import com.intellij.ide.starter.report.FailureDetailsOnCI;
import com.intellij.ide.starter.runner.IDERunContext;
import com.intellij.ide.starter.utils.GenerifyKt;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.LinkOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ide/starter/report/FailureDetailsForTeamcity;", "Lcom/intellij/ide/starter/report/FailureDetailsOnCI;", "<init>", "()V", "getFailureDetails", "", "runContext", "Lcom/intellij/ide/starter/runner/IDERunContext;", "getFailureDetailsForIgnoredTest", "getFailureDetailsWithBisectLinkForCI", "getFailureDetailsForCI", "getLinkToCIArtifacts", "getFailureDetailsForLocalRun", "intellij.tools.ide.starter"})
@SourceDebugExtension(value={"SMAP\nFailureDetailsForTeamcity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FailureDetailsForTeamcity.kt\ncom/intellij/ide/starter/report/FailureDetailsForTeamcity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class FailureDetailsForTeamcity
implements FailureDetailsOnCI {
    @NotNull
    public static final FailureDetailsForTeamcity INSTANCE = new FailureDetailsForTeamcity();

    private FailureDetailsForTeamcity() {
    }

    @Override
    @NotNull
    public String getFailureDetails(@NotNull IDERunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        return CIServer.Companion.getInstance().isBuildRunningOnCI() ? (TeamCityCIServerKt.asTeamCity(CIServer.Companion.getInstance()).isJetbrainsBuildserver() ? this.getFailureDetailsWithBisectLinkForCI(runContext) : this.getFailureDetailsForCI(runContext)) : this.getFailureDetailsForLocalRun(runContext);
    }

    @NotNull
    public final String getFailureDetailsForIgnoredTest(@NotNull IDERunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        return this.getFailureDetailsForCI(runContext);
    }

    /*
     * WARNING - void declaration
     */
    private final String getFailureDetailsWithBisectLinkForCI(IDERunContext runContext) {
        Object object;
        String string;
        block3: {
            block2: {
                void it;
                String string2;
                CIServer cIServer = CIServer.Companion.getInstance();
                TeamCityCIServer teamCityCIServer = cIServer instanceof TeamCityCIServer ? (TeamCityCIServer)cIServer : null;
                String it2 = string2 = teamCityCIServer != null ? teamCityCIServer.getBuildId() : null;
                boolean $i$a$-takeIf-FailureDetailsForTeamcity$getFailureDetailsWithBisectLinkForCI$buildId$22 = false;
                String buildId = !Intrinsics.areEqual((Object)it2, (Object)"LOCAL_RUN_SNAPSHOT") ? string2 : null;
                string = this.getFailureDetailsForCI(runContext);
                object = buildId;
                if (object == null) break block2;
                String $i$a$-takeIf-FailureDetailsForTeamcity$getFailureDetailsWithBisectLinkForCI$buildId$22 = object;
                String string3 = string;
                boolean bl = false;
                String string4 = System.lineSeparator() + "Link to bisect: https://ij-perf.labs.jb.gg/bisect/launcher?buildId=" + (String)it;
                string = string3;
                object = string4;
                if (string4 != null) break block3;
            }
            object = "";
        }
        return string + (String)object;
    }

    private final String getFailureDetailsForCI(IDERunContext runContext) {
        CharSequence charSequence;
        CharSequence charSequence2 = FailureDetailsOnCI.Companion.getTestMethodName();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = runContext.getContextName();
        } else {
            charSequence = charSequence2;
        }
        String testMethodName = (String)charSequence;
        String uri = this.getLinkToCIArtifacts(runContext);
        return "Test: " + testMethodName + System.lineSeparator() + "You can find logs and other info in CI artifacts under the path " + runContext.getContextName() + System.lineSeparator() + "Link on TC artifacts " + uri;
    }

    @Override
    @NotNull
    public String getLinkToCIArtifacts(@NotNull IDERunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        TeamCityCIServer teamCityCI = TeamCityCIServerKt.asTeamCity(CIServer.Companion.getInstance());
        String urlString = teamCityCI.getServerUri() + "/buildConfiguration/" + teamCityCI.getBuildTypeId() + "/" + teamCityCI.getBuildId() + "?buildTab=artifacts#" + URLEncoder.encode("/" + GenerifyKt.replaceSpecialCharactersWithHyphens$default(runContext.getContextName(), null, 1, null), "UTF-8");
        String string = new URI(urlString).normalize().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getFailureDetailsForLocalRun(IDERunContext runContext) {
        CharSequence charSequence;
        CharSequence charSequence2 = FailureDetailsOnCI.Companion.getTestMethodName();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = runContext.getContextName();
        } else {
            charSequence = charSequence2;
        }
        String testMethodName = (String)charSequence;
        return "Test: " + testMethodName + System.lineSeparator() + "You can find logs and other info under the path " + runContext.getLogsDir().toRealPath(new LinkOption[0]);
    }
}

