/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.sdk;

import com.intellij.ide.starter.sdk.JdkItemPaths;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.tools.ide.performanceTesting.commands.SdkObject;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J#\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/starter/sdk/JdkDownloadItem;", "", "jdk", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "download", "Lkotlin/Function0;", "Lcom/intellij/ide/starter/sdk/JdkItemPaths;", "<init>", "(Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;Lkotlin/jvm/functions/Function0;)V", "installJdk", "Lkotlin/Lazy;", "home", "Ljava/nio/file/Path;", "getHome", "()Ljava/nio/file/Path;", "installPath", "getInstallPath", "majorVersion", "", "toSdk", "Lcom/intellij/tools/ide/performanceTesting/commands/SdkObject;", "sdkName", "", "equals", "", "other", "hashCode", "toString", "component1", "component2", "copy", "intellij.tools.ide.starter"})
public final class JdkDownloadItem {
    @JvmField
    @NotNull
    public final JdkItem jdk;
    @NotNull
    private final Function0<JdkItemPaths> download;
    @NotNull
    private final Lazy<JdkItemPaths> installJdk;
    private final int majorVersion;

    public JdkDownloadItem(@NotNull JdkItem jdk, @NotNull Function0<JdkItemPaths> download2) {
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter(download2, (String)"download");
        this.jdk = jdk;
        this.download = download2;
        this.installJdk = LazyKt.lazy(() -> JdkDownloadItem.installJdk$lambda$0(this));
        this.majorVersion = this.jdk.getJdkMajorVersion();
    }

    @NotNull
    public final Path getHome() {
        return ((JdkItemPaths)this.installJdk.getValue()).homePath;
    }

    @NotNull
    public final Path getInstallPath() {
        return ((JdkItemPaths)this.installJdk.getValue()).installPath;
    }

    @NotNull
    public final SdkObject toSdk(@NotNull String sdkName) {
        Intrinsics.checkNotNullParameter((Object)sdkName, (String)"sdkName");
        return new SdkObject(sdkName, "JavaSDK", this.getHome());
    }

    @NotNull
    public final SdkObject toSdk() {
        return this.toSdk(String.valueOf(this.majorVersion));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof JdkDownloadItem && Intrinsics.areEqual((Object)((JdkDownloadItem)other).jdk, (Object)this.jdk);
    }

    public int hashCode() {
        return this.jdk.hashCode();
    }

    @NotNull
    public String toString() {
        return "JdkDownloadItem(" + this.jdk.getFullPresentationText() + ")";
    }

    @NotNull
    public final JdkItem component1() {
        return this.jdk;
    }

    private final Function0<JdkItemPaths> component2() {
        return this.download;
    }

    @NotNull
    public final JdkDownloadItem copy(@NotNull JdkItem jdk, @NotNull Function0<JdkItemPaths> download2) {
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter(download2, (String)"download");
        return new JdkDownloadItem(jdk, download2);
    }

    public static /* synthetic */ JdkDownloadItem copy$default(JdkDownloadItem jdkDownloadItem, JdkItem jdkItem, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            jdkItem = jdkDownloadItem.jdk;
        }
        if ((n & 2) != 0) {
            function0 = jdkDownloadItem.download;
        }
        return jdkDownloadItem.copy(jdkItem, function0);
    }

    private static final JdkItemPaths installJdk$lambda$0(JdkDownloadItem this$0) {
        return (JdkItemPaths)this$0.download.invoke();
    }
}

