/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starter.utils;

import com.intellij.ide.starter.path.GlobalPaths;
import com.intellij.ide.starter.process.exec.ExecOutputRedirect;
import com.intellij.ide.starter.process.exec.ProcessExecutor;
import com.intellij.ide.starter.runner.IDERunContext;
import com.intellij.ide.starter.utils.FileSystem;
import com.intellij.ide.starter.utils.HttpClient;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.tools.ide.util.common.LoggingKt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a1\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\b\b\u0002\u0010\n\u001a\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0002\u001a\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0002\u001a\u0016\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0001\u001a\n\u0010$\u001a\u00020\u0016*\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"beforeKillScreenshotName", "", "formatArtifactName", "artifactType", "testName", "getThrowableText", "t", "", "catchAll", "T", "message", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withIndent", "indent", "takeScreenshot", "", "logsDir", "Ljava/nio/file/Path;", "screenshotName", "ignoreExceptions", "", "startProfileNativeThreads", "pid", "givePermissionsToExecutables", "profiler", "stopProfileNativeThreads", "fileToStoreInfo", "downloadAsyncProfilerIfNeeded", "toolsDir", "pathInsideJarFile", "jarFile", "pathInsideJar", "dockerPathRegex", "Lkotlin/text/Regex;", "isOnDocker", "intellij.tools.ide.starter"})
public final class UtilsKt {
    @NotNull
    public static final String beforeKillScreenshotName = "screenshotBeforeKill.jpg";
    @NotNull
    private static final Regex dockerPathRegex = new Regex("^[\\\\/]+docker.*");

    @NotNull
    public static final String formatArtifactName(@NotNull String artifactType, @NotNull String testName) {
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        String testNameFormatted = StringsKt.replace$default((String)StringsKt.replace$default((String)testName, (String)"/", (String)"-", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null);
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        return artifactType + "-" + testNameFormatted + "-" + time;
    }

    @NotNull
    public static final String getThrowableText(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string = writer.getBuffer().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public static final <T> T catchAll(@NotNull String message, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$catchAll = false;
        try {
            if (((CharSequence)message).length() > 0) {
                LoggingKt.logOutput((String)("Performing '" + message + "' with catching all exceptions"));
            }
            object = action.invoke();
        }
        catch (Throwable t) {
            LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message).length() > 0 ? "for '" + message + "' " : "") + " swallowed error: " + t.getMessage()));
            LoggingKt.logError((String)UtilsKt.getThrowableText(t));
            object = null;
        }
        return (T)object;
    }

    public static /* synthetic */ Object catchAll$default(String message, Function0 action, int n, Object object) {
        if ((n & 1) != 0) {
            message = "";
        }
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        boolean $i$f$catchAll = false;
        try {
            if (((CharSequence)message).length() > 0) {
                LoggingKt.logOutput((String)("Performing '" + message + "' with catching all exceptions"));
            }
            object = action.invoke();
        }
        catch (Throwable t) {
            LoggingKt.logError((String)("CatchAll " + (String)(((CharSequence)message).length() > 0 ? "for '" + message + "' " : "") + " swallowed error: " + t.getMessage()));
            LoggingKt.logError((String)UtilsKt.getThrowableText(t));
            object = null;
        }
        return object;
    }

    @NotNull
    public static final String withIndent(@NotNull String $this$withIndent, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)$this$withIndent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Sequence sequence = SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), arg_0 -> UtilsKt.withIndent$lambda$0(indent, arg_0));
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return SequencesKt.joinToString$default((Sequence)sequence, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String withIndent$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "  ";
        }
        return UtilsKt.withIndent(string, string2);
    }

    public static final void takeScreenshot(@NotNull Path logsDir) {
        Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
        UtilsKt.takeScreenshot$default(logsDir, beforeKillScreenshotName, false, 4, null);
    }

    public static final void takeScreenshot(@NotNull Path logsDir, @NotNull String screenshotName, boolean ignoreExceptions) {
        Intrinsics.checkNotNullParameter((Object)logsDir, (String)"logsDir");
        Intrinsics.checkNotNullParameter((Object)screenshotName, (String)"screenshotName");
        Path screenshotFile = logsDir.resolve(screenshotName);
        Intrinsics.checkNotNull((Object)screenshotFile);
        LoggingKt.logOutput((String)("Taking screenshot into " + ((Object)screenshotFile).toString()));
        Path toolsDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("tools");
        String toolName = "TakeScreenshot";
        Path path = toolsDir.resolve(toolName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve(toolName + ".jar");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path screenshotTool = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(screenshotTool, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            InputStream inputStream = IDERunContext.class.getClassLoader().getResourceAsStream("tools/" + toolName + ".jar");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream screenshotJar = inputStream;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(PathKt.createParentDirectories((Path)screenshotTool), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            ByteStreamsKt.copyTo$default((InputStream)screenshotJar, (OutputStream)outputStream, (int)0, (int)2, null);
        }
        String javaPath = ProcessHandle.current().info().command().orElseThrow().toString();
        ExecOutputRedirect.ToStdOut stdOut = new ExecOutputRedirect.ToStdOut("[take-screenshot-out]");
        ExecOutputRedirect.ToStdOut stdErr = new ExecOutputRedirect.ToStdOut("[take-screenshot-err]");
        try {
            long l = DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS);
            Object object = new String[]{javaPath, "-jar", ((Object)screenshotTool.toAbsolutePath()).toString(), ((Object)screenshotFile).toString()};
            List list = CollectionsKt.mutableListOf((Object[])object);
            String string = System.getenv("DISPLAY");
            if (string == null) {
                string = ":88";
            }
            object = MapsKt.mapOf((Pair)TuplesKt.to((Object)"DISPLAY", (Object)string));
            ProcessExecutor.start$default(new ProcessExecutor("take-screenshot", toolsDir, l, (Map)object, list, null, stdOut, stdErr, null, null, null, true, 0, false, false, 30496, null), false, 1, null);
        }
        catch (Exception e) {
            if (!ignoreExceptions) {
                throw e;
            }
            LoggingKt.logOutput((String)("Exception while taking screenshot: " + e.getMessage()));
            return;
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(screenshotFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            throw new IllegalStateException("Couldn't take screenshot".toString());
        }
        LoggingKt.logOutput((String)("Screenshot saved in " + screenshotFile));
    }

    public static /* synthetic */ void takeScreenshot$default(Path path, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        UtilsKt.takeScreenshot(path, string, bl);
    }

    public static final void startProfileNativeThreads(@NotNull String pid) {
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        if (!SystemInfo.isWindows) {
            String string;
            Path toolsDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("tools");
            if (SystemInfo.isMac) {
                string = "async-profiler-2.7-macos";
            } else if (SystemInfo.isLinux) {
                string = "async-profiler-2.7-linux-x64";
            } else {
                throw new IllegalStateException("Not supported OS".toString());
            }
            String toolName = string;
            Path path = toolsDir.resolve(toolName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path profiler = path;
            UtilsKt.downloadAsyncProfilerIfNeeded(profiler, toolsDir);
            UtilsKt.givePermissionsToExecutables(profiler);
            Object[] objectArray = new String[]{"./profiler.sh", "start", pid};
            ProcessExecutor.start$default(new ProcessExecutor("start-profile", profiler, DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS), null, CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), false, 1, null);
        }
    }

    private static final void givePermissionsToExecutables(Path profiler) {
        Object[] objectArray = new String[]{"chmod", "+x", "jattach"};
        ProcessExecutor.start$default(new ProcessExecutor("give-permissions-to-jattach", profiler.resolve("build"), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), null, CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), false, 1, null);
        objectArray = new String[]{"chmod", "+x", "profiler.sh"};
        ProcessExecutor.start$default(new ProcessExecutor("give-permissions-to-profiler", profiler, DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), null, CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), false, 1, null);
    }

    public static final void stopProfileNativeThreads(@NotNull String pid, @NotNull String fileToStoreInfo) {
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        Intrinsics.checkNotNullParameter((Object)fileToStoreInfo, (String)"fileToStoreInfo");
        if (!SystemInfo.isWindows) {
            Path toolsDir = GlobalPaths.Companion.getInstance().getCacheDirectoryFor("tools");
            String toolName = "async-profiler-2.7-macos";
            Path path = toolsDir.resolve(toolName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path profiler = path;
            Object[] objectArray = new String[]{"./profiler.sh", "stop", pid, "-f", fileToStoreInfo};
            ProcessExecutor.start$default(new ProcessExecutor("stop-profile", profiler, DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS), null, CollectionsKt.mutableListOf((Object[])objectArray), null, null, null, null, null, null, false, 0, false, false, 32744, null), false, 1, null);
        }
    }

    private static final void downloadAsyncProfilerIfNeeded(Path profiler, Path toolsDir) {
        if (!new File(((Object)profiler).toString()).exists()) {
            String string;
            if (SystemInfo.isMac) {
                string = "async-profiler-2.7-macos.zip";
            } else if (SystemInfo.isLinux) {
                string = "async-profiler-2.7-linux-x64.tar.gz";
            } else {
                throw new IllegalStateException("Current OS is not supported".toString());
            }
            String profilerFileName = string;
            Path path = toolsDir.resolve(profilerFileName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path archivePath = path;
            HttpClient.download-Wn2Vu4Y$default(HttpClient.INSTANCE, "https://github.com/jvm-profiling-tools/async-profiler/releases/download/v2.7/" + profilerFileName, archivePath, 0L, 0L, 12, null);
            FileSystem.INSTANCE.unpack(archivePath, toolsDir);
        }
    }

    @NotNull
    public static final String pathInsideJarFile(@NotNull Path jarFile, @NotNull String pathInsideJar) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)pathInsideJar, (String)"pathInsideJar");
        char[] cArray = new char[]{'/'};
        return StringsKt.trimEnd((String)((Object)jarFile.toAbsolutePath()).toString(), (char[])cArray) + "!/" + pathInsideJar;
    }

    public static final boolean isOnDocker(@NotNull Path $this$isOnDocker) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnDocker, (String)"<this>");
        CharSequence charSequence = ((Object)$this$isOnDocker).toString();
        return dockerPathRegex.matches(charSequence);
    }

    private static final String withIndent$lambda$0(String $indent, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $indent + it;
    }
}

