/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public final class ExternalClasspathClassLoader {
    public static final String CLASSPATH_FILE_PROPERTY = "classpath.file";

    private static List<Path> loadFilesPaths(String classpathFilePath) {
        try {
            Path file = Paths.get(classpathFilePath, new String[0]);
            LinkedHashSet<Path> roots = new LinkedHashSet<Path>();
            try (BufferedReader reader = Files.newBufferedReader(file);){
                while (reader.ready()) {
                    roots.add(Paths.get(reader.readLine(), new String[0]));
                }
            }
            return new ArrayList<Path>(roots);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Path> getRoots() {
        String classPathFilePath = System.getProperty(CLASSPATH_FILE_PROPERTY);
        return classPathFilePath != null ? ExternalClasspathClassLoader.loadFilesPaths(classPathFilePath) : null;
    }

    public static List<Path> getExcludeRoots() {
        try {
            String classPathFilePath = System.getProperty("exclude.tests.roots.file");
            return classPathFilePath != null ? ExternalClasspathClassLoader.loadFilesPaths(classPathFilePath) : null;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static void install() {
        List<Path> files = ExternalClasspathClassLoader.getRoots();
        if (files == null) {
            return;
        }
        try {
            URL[] urls = (URL[])files.stream().map(path -> {
                try {
                    return path.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            URLClassLoader auxLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(auxLoader);
            Thread.currentThread().setContextClassLoader(ExternalClasspathClassLoader.loadOptimizedLoader(files, auxLoader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader loadOptimizedLoader(List<Path> files, URLClassLoader auxLoader) throws Exception {
        Object builder = auxLoader.loadClass("com.intellij.util.lang.UrlClassLoader").getMethod("build", new Class[0]).invoke(null, new Object[0]);
        builder.getClass().getMethod("files", List.class).invoke(builder, files);
        builder.getClass().getMethod("useCache", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("allowBootstrapResources", new Class[0]).invoke(builder, new Object[0]);
        builder.getClass().getMethod("parent", ClassLoader.class).invoke(builder, auxLoader.getParent());
        return (ClassLoader)builder.getClass().getMethod("get", new Class[0]).invoke(builder, new Object[0]);
    }
}

