/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.tests.JUnit5FilterOption;
import com.intellij.tests.JUnit5TeamCityRunnerForTestAllSuite;
import com.intellij.tests.bazel.BazelJUnitOutputListener;
import com.intellij.tests.bazel.IjSmTestExecutionListener;
import com.intellij.tests.bazel.bucketing.BucketsPostDiscoveryFilter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class JUnit5BazelRunner {
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_TEST_FAILURE_OTHER = 1;
    private static final int EXIT_CODE_TEST_RUNNER_FAILURE = 2;
    private static final int EXIT_CODE_TEST_FAILURE_OOM = 137;
    private static final String bazelEnvRunfilesManifestOnly = "RUNFILES_MANIFEST_ONLY";
    private static final String bazelEnvSelfLocation = "SELF_LOCATION";
    private static final String bazelEnvTestTmpDir = "TEST_TMPDIR";
    private static final String bazelEnvRunFilesDir = "RUNFILES_DIR";
    private static final String bazelEnvJavaRunFilesDir = "JAVA_RUNFILES";
    private static final String bazelEnvTestSrcDir = "TEST_SRCDIR";
    private static final String bazelEnvTestBridgeTestOnly = "TESTBRIDGE_TEST_ONLY";
    private static final String bazelEnvXmlOutputFile = "XML_OUTPUT_FILE";
    private static final String jbEnvPrintSortedClasspath = "JB_TEST_PRINT_SORTED_CLASSPATH";
    private static final String jbEnvPrintTestSrcDirContent = "JB_TEST_PRINT_TEST_SRCDIR_CONTENT";
    private static final String jbEnvPrintEnv = "JB_TEST_PRINT_ENV";
    private static final String jbEnvPrintSystemProperties = "JB_TEST_PRINT_SYSTEM_PROPERTIES";
    private static final String jbEnvSandbox = "JB_TEST_SANDBOX";
    private static final String jbEnvXmlOutputFile = "JB_XML_OUTPUT_FILE";
    private static final String jbEnvIdeSmRun = "JB_IDE_SM_RUN";
    private static final String jbEnvTestFilter = "JB_TEST_FILTER";
    private static final String jbEnvTestUniqueIds = "JB_TEST_UNIQUE_IDS";
    private static final String jbEnvJunit5TestFilter = "JB_TEST_JUNIT5_FILTERS";
    private static final ClassLoader ourClassLoader = Thread.currentThread().getContextClassLoader();
    private static final Launcher launcher = LauncherFactory.create();
    private static final BucketsPostDiscoveryFilter bucketingPostDiscoveryFilter = new BucketsPostDiscoveryFilter();
    private static final PostDiscoveryFilter performancePostDiscoveryFilter = new JUnit5TeamCityRunnerForTestAllSuite.PerformancePostDiscoveryFilter();

    private static LauncherDiscoveryRequest getDiscoveryRequest() throws Throwable {
        List<? extends DiscoverySelector> bazelTestSelectors = JUnit5BazelRunner.getTestsSelectors(ourClassLoader);
        return LauncherDiscoveryRequestBuilder.request().configurationParameter("junit.jupiter.extensions.autodetection.enabled", "true").selectors(bazelTestSelectors).filters(JUnit5BazelRunner.getTestFilters(bazelTestSelectors)).filters(JUnit5BazelRunner.generateFiltersFromJbEnv().toArray(new Filter[0])).build();
    }

    private static List<? extends DiscoverySelector> getTestSelectorsByClassPathRoots(ClassLoader classLoader) throws Throwable {
        Set<Path> classPathRoots = JUnit5BazelRunner.getClassPathRoots(classLoader);
        return JUnit5BazelRunner.getSelectors(classPathRoots);
    }

    private static TestPlan getTestPlan() throws Throwable {
        LauncherDiscoveryRequest discoveryRequest = JUnit5BazelRunner.getDiscoveryRequest();
        return launcher.discover(discoveryRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try {
            Path ideaHome;
            String testSrcDir;
            System.err.println("Running tests via " + JUnit5BazelRunner.class.getName());
            Boolean isBazelTestRun = JUnit5BazelRunner.isBazelTestRun();
            if (!isBazelTestRun.booleanValue()) {
                throw new RuntimeException("Missing expected env variable in bazel test environment.");
            }
            String bazelTestTestSrcDir = System.getenv(bazelEnvTestSrcDir);
            System.setProperty("intellij.test.jars.location", bazelTestTestSrcDir);
            System.setProperty("idea.is.unit.test", "true");
            if (Boolean.parseBoolean(System.getenv(jbEnvPrintSortedClasspath))) {
                Arrays.stream(System.getProperty("java.class.path").split(Pattern.quote(File.pathSeparator))).sorted().toList().forEach(x -> System.err.println("CLASSPATH " + x));
            }
            if (Boolean.parseBoolean(System.getenv(jbEnvPrintEnv))) {
                System.getenv().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> System.err.println("ENV " + (String)entry.getKey() + "=" + (String)entry.getValue()));
            }
            if (Boolean.parseBoolean(System.getenv(jbEnvPrintSystemProperties))) {
                System.getProperties().entrySet().stream().sorted(Comparator.comparing(o -> o.getKey().toString())).forEach(entry -> System.err.println("PROPERTY " + String.valueOf(entry.getKey()) + "=" + String.valueOf(entry.getValue())));
            }
            if ((testSrcDir = System.getenv(bazelEnvTestSrcDir)) == null) {
                throw new RuntimeException("Missing TEST_SRCDIR env variable in bazel test environment");
            }
            Path testSrcDirPath = Path.of(testSrcDir, new String[0]);
            if (!Files.isDirectory(testSrcDirPath, new LinkOption[0])) {
                throw new RuntimeException("$TEST_SRCDIR is not a directory: " + String.valueOf(testSrcDirPath));
            }
            if (Boolean.parseBoolean(System.getenv(jbEnvPrintTestSrcDirContent))) {
                try (Stream<Path> stream = Files.walk(testSrcDirPath, new FileVisitOption[0]);){
                    stream.forEach(path -> System.err.println("TEST_SRCDIR " + String.valueOf(testSrcDirPath.relativize((Path)path))));
                }
            }
            Path tempDir = JUnit5BazelRunner.getBazelTempDir();
            String jbEnvSandboxValue = System.getenv(jbEnvSandbox);
            if (jbEnvSandboxValue == null) {
                throw new RuntimeException("Missing JB_TEST_SANDBOX env variable in bazel test environment");
            }
            boolean sandbox = Boolean.parseBoolean(jbEnvSandboxValue);
            System.err.println("Use sandbox: " + sandbox);
            if (sandbox) {
                ideaHome = tempDir.resolve("home");
                Files.createDirectories(ideaHome.resolve(".idea"), new FileAttribute[0]);
                Files.writeString(ideaHome.resolve("intellij.idea.community.main.iml"), (CharSequence)"", new OpenOption[0]);
            } else {
                ideaHome = JUnit5BazelRunner.guessBazelWorkspaceDir();
            }
            System.err.println("Using ideaHome: " + String.valueOf(ideaHome));
            System.err.println("Using tempDir: " + String.valueOf(tempDir));
            JUnit5BazelRunner.setBazelSandboxPaths(ideaHome, tempDir);
            System.out.println("Number of test engines: " + ServiceLoader.load(TestEngine.class).stream().count());
            Path xmlOutputFile = JUnit5BazelRunner.getXmlOutputFile();
            TestPlan testPlan = JUnit5BazelRunner.getTestPlan();
            if (!testPlan.containsTests()) {
                if (!bucketingPostDiscoveryFilter.hasExcludedClasses().booleanValue() && !bucketingPostDiscoveryFilter.hasIncludedClasses().booleanValue()) {
                    System.err.println("No tests found");
                    System.exit(42);
                } else {
                    System.err.println("No tests executed: all tests were filtered out by bucketing.");
                    JUnit5BazelRunner.xmlReportBucketingTestsFilteringOut(xmlOutputFile);
                    System.exit(0);
                }
            }
            List<TestExecutionListener> testExecutionListeners = JUnit5BazelRunner.getTestExecutionListeners();
            IjSmTestExecutionListener smListener = null;
            for (TestExecutionListener l2 : testExecutionListeners) {
                if (!(l2 instanceof IjSmTestExecutionListener)) continue;
                smListener = (IjSmTestExecutionListener)l2;
                break;
            }
            if (smListener != null) {
                IjSmTestExecutionListener finalSmListener = smListener;
                Runtime.getRuntime().addShutdownHook(new Thread(() -> finalSmListener.closeForInterrupt(), "IjSmTestExecutionListenerShutdownHook"));
            }
            try (BazelJUnitOutputListener bazelJUnitOutputListener = new BazelJUnitOutputListener(xmlOutputFile);){
                Runtime.getRuntime().addShutdownHook(new Thread(() -> bazelJUnitOutputListener.closeForInterrupt(), "BazelJUnitOutputListenerShutdownHook"));
                testExecutionListeners.add(bazelJUnitOutputListener);
                launcher.registerTestExecutionListeners((TestExecutionListener[])testExecutionListeners.toArray(TestExecutionListener[]::new));
                launcher.execute(testPlan, new TestExecutionListener[0]);
            }
            if (testExecutionListeners.stream().anyMatch(l -> l instanceof BazelJUnitOutputListener && ((BazelJUnitOutputListener)l).hasTestsWithThrowableResults() != false)) {
                System.err.println("Some tests failed");
                System.exit(1);
            }
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            System.exit(137);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(2);
        }
        finally {
            System.exit(0);
        }
    }

    private static Path getXmlOutputFile() throws IOException {
        String jbXmlOutputFile = System.getenv(jbEnvXmlOutputFile);
        String xmlOutputFile = jbXmlOutputFile != null && !jbXmlOutputFile.isBlank() ? jbXmlOutputFile : System.getenv(bazelEnvXmlOutputFile);
        Path xmlOut = xmlOutputFile != null ? Paths.get(xmlOutputFile, new String[0]) : Files.createTempFile("test", ".xml", new FileAttribute[0]);
        Files.createDirectories(xmlOut.getParent(), new FileAttribute[0]);
        return xmlOut;
    }

    private static List<TestExecutionListener> getTestExecutionListeners() {
        ArrayList<TestExecutionListener> myListeners = new ArrayList<TestExecutionListener>();
        if (!JUnit5BazelRunner.isUnderTeamCity()) {
            if ("true".equals(System.getenv(jbEnvIdeSmRun))) {
                myListeners.add(new IjSmTestExecutionListener());
            } else {
                myListeners.add(new ConsoleTestLogger());
            }
        }
        return myListeners;
    }

    private static void addSelectorsFromJbEnv(ClassLoader classLoader, List<DiscoverySelector> out) {
        String methods;
        String uniqueIds = System.getenv(jbEnvTestUniqueIds);
        if (uniqueIds != null && !uniqueIds.isBlank()) {
            for (String uid : uniqueIds.split(";")) {
                if (uid.isEmpty()) continue;
                out.add((DiscoverySelector)DiscoverySelectors.selectUniqueId((String)uid));
            }
        }
        if ((methods = System.getenv(jbEnvTestFilter)) != null && !methods.isBlank()) {
            block6: for (String token : methods.split(";")) {
                if (token.isEmpty()) continue;
                String[] parts = token.split(":");
                switch (parts.length) {
                    case 1: {
                        out.add((DiscoverySelector)DiscoverySelectors.selectClass((ClassLoader)classLoader, (String)parts[0]));
                        continue block6;
                    }
                    case 2: {
                        out.add((DiscoverySelector)DiscoverySelectors.selectMethod((ClassLoader)classLoader, (String)parts[0], (String)parts[1]));
                        continue block6;
                    }
                    case 3: {
                        out.add((DiscoverySelector)DiscoverySelectors.selectMethod((ClassLoader)classLoader, (String)parts[0], (String)parts[1], (String)parts[2]));
                    }
                }
            }
        }
    }

    private static List<Filter<?>> generateFiltersFromJbEnv() {
        ArrayList out = new ArrayList();
        String junitFilters = System.getenv(jbEnvJunit5TestFilter);
        if (junitFilters != null && !junitFilters.isBlank()) {
            for (String filter : junitFilters.split(";")) {
                String[] parts = filter.split("=");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid JUnit5 filter: " + filter + ". Filter should be in format: <option>=<value>");
                }
                JUnit5FilterOption filterOption = JUnit5FilterOption.fromString(parts[0]);
                String filterString = parts[1];
                out.add(filterOption.toJunitFilter(filterString));
            }
        }
        return out;
    }

    private static Filter<?>[] getTestFilters(List<? extends DiscoverySelector> bazelTestSelectors) {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(bucketingPostDiscoveryFilter);
        filters.add(performancePostDiscoveryFilter);
        String testFilter = System.getenv(bazelEnvTestBridgeTestOnly);
        if (testFilter == null || testFilter.isBlank()) {
            return filters.toArray(new Filter[0]);
        }
        if (bazelTestSelectors.stream().allMatch(selector -> selector instanceof MethodSelector || selector instanceof UniqueIdSelector)) {
            return filters.toArray(new Filter[0]);
        }
        String[] parts = testFilter.split("#", 2);
        if (parts.length == 2) {
            throw new IllegalStateException("Method filters are not expected in name-based test filter");
        }
        String classNamePart = parts[0];
        ClassNameFilter classNameFilter = JUnit5BazelRunner.getClassNameFilter(classNamePart);
        filters.add(classNameFilter);
        return filters.toArray(new Filter[0]);
    }

    private static List<? extends DiscoverySelector> getTestsSelectors(ClassLoader classLoader) throws Throwable {
        ArrayList<DiscoverySelector> jbSelectors = new ArrayList<DiscoverySelector>();
        JUnit5BazelRunner.addSelectorsFromJbEnv(classLoader, jbSelectors);
        if (!jbSelectors.isEmpty()) {
            return jbSelectors;
        }
        List<MethodSelector> bazelTestClassSelector = JUnit5BazelRunner.getBazelTestMethodSelectors(classLoader);
        if (!bazelTestClassSelector.isEmpty()) {
            return bazelTestClassSelector;
        }
        return JUnit5BazelRunner.getTestSelectorsByClassPathRoots(classLoader);
    }

    private static boolean isUnderTeamCity() {
        String teamCityVersion = System.getenv("TEAMCITY_VERSION");
        return teamCityVersion != null && !teamCityVersion.isEmpty();
    }

    private static List<MethodSelector> getBazelTestMethodSelectors(ClassLoader classLoader) {
        String testFilter = System.getenv(bazelEnvTestBridgeTestOnly);
        if (testFilter == null || testFilter.isBlank()) {
            return Collections.emptyList();
        }
        System.err.println("Test filter: " + testFilter);
        String[] parts = testFilter.split("#", 2);
        if (parts.length == 2) {
            String className = parts[0];
            String methodName = parts[1];
            System.err.println("Selecting class: " + className);
            System.err.println("Selecting method: " + methodName);
            return List.of(DiscoverySelectors.selectMethod((ClassLoader)classLoader, (String)className, (String)methodName));
        }
        return Collections.emptyList();
    }

    private static ClassNameFilter getClassNameFilter(String filterClassName) {
        String filterClassNameFQN;
        String filterClassNameSimpleName;
        int lastFilterClassNamePartDotIndex = filterClassName.lastIndexOf(46);
        if (lastFilterClassNamePartDotIndex < 0) {
            filterClassNameSimpleName = filterClassName;
            filterClassNameFQN = null;
        } else {
            filterClassNameSimpleName = filterClassName.substring(lastFilterClassNamePartDotIndex + 1);
            filterClassNameFQN = filterClassName;
        }
        if (!Character.isUpperCase(filterClassNameSimpleName.charAt(0))) {
            throw new IllegalArgumentException("Class name should start with uppercase letter: " + filterClassNameSimpleName);
        }
        return new ClassNameFilter(){

            public FilterResult apply(String className) {
                if (filterClassNameFQN == null) {
                    int lastClassNamePartDotIndex = className.lastIndexOf(46);
                    String classNameSimpleName = className.substring(lastClassNamePartDotIndex + 1);
                    if (classNameSimpleName.startsWith(filterClassNameSimpleName)) {
                        return FilterResult.included(null);
                    }
                    return FilterResult.excluded(null);
                }
                if (className.startsWith(filterClassNameFQN)) {
                    return FilterResult.included(null);
                }
                return FilterResult.excluded(null);
            }
        };
    }

    private static Path getBazelTempDir() throws IOException {
        String tempDir = System.getenv(bazelEnvTestTmpDir);
        if (tempDir == null || tempDir.isBlank()) {
            throw new RuntimeException("Missing TEST_TMPDIR env variable in bazel test environment");
        }
        Path path = Path.of(tempDir, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        return path.toAbsolutePath();
    }

    private static Boolean isBazelTestRun() {
        return Stream.of(bazelEnvTestTmpDir, bazelEnvRunFilesDir, bazelEnvJavaRunFilesDir).allMatch(bazelTestEnv -> {
            String bazelTestEnvValue = System.getenv(bazelTestEnv);
            return bazelTestEnvValue != null && !bazelTestEnvValue.isBlank();
        }) && Stream.of(bazelEnvSelfLocation, bazelEnvRunfilesManifestOnly).anyMatch(bazelTestEnv -> {
            String bazelTestEnvValue = System.getenv(bazelTestEnv);
            return bazelTestEnvValue != null && !bazelTestEnvValue.isBlank();
        });
    }

    private static void setBazelSandboxPaths(Path ideaHomePath, Path tempDir) throws IOException {
        JUnit5BazelRunner.setSandboxPath("idea.home.path", ideaHomePath);
        JUnit5BazelRunner.setSandboxPath("idea.config.path", tempDir.resolve("config"));
        JUnit5BazelRunner.setSandboxPath("idea.system.path", tempDir.resolve("system"));
        String testUndeclaredOutputsDir = System.getenv("TEST_UNDECLARED_OUTPUTS_DIR");
        if (testUndeclaredOutputsDir != null) {
            JUnit5BazelRunner.setSandboxPath("idea.log.path", Path.of(testUndeclaredOutputsDir, new String[0]).resolve("logs"));
        } else {
            JUnit5BazelRunner.setSandboxPath("idea.log.path", tempDir.resolve("logs"));
        }
        JUnit5BazelRunner.setSandboxPath("java.util.prefs.userRoot", tempDir.resolve("userRoot"));
        JUnit5BazelRunner.setSandboxPath("java.util.prefs.systemRoot", tempDir.resolve("systemRoot"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path guessBazelWorkspaceDir() throws IOException {
        String communityMarkerFileName;
        Path workDirPath;
        block16: {
            String testSrcDir = System.getenv(bazelEnvTestSrcDir);
            if (testSrcDir == null) {
                throw new RuntimeException("Missing TEST_SRCDIR env variable in bazel test environment");
            }
            workDirPath = Path.of(testSrcDir, new String[0]);
            communityMarkerFileName = "intellij.idea.community.main.iml";
            String testWorkspace = System.getenv("TEST_WORKSPACE");
            String runfilesManifestOnly = System.getenv(bazelEnvRunfilesManifestOnly);
            String runfilesManifestFile = System.getenv("RUNFILES_MANIFEST_FILE");
            if (testWorkspace != null && !testWorkspace.isBlank() && "1".equals(runfilesManifestOnly) && runfilesManifestFile != null) {
                try {
                    String[] searchKeys;
                    Path manifestPath = Path.of(runfilesManifestFile, new String[0]);
                    if (!Files.exists(manifestPath, new LinkOption[0])) break block16;
                    for (String searchKey : searchKeys = new String[]{testWorkspace + "/external/community+/" + communityMarkerFileName, "community+/" + communityMarkerFileName, testWorkspace + "/" + communityMarkerFileName}) {
                        Stream<String> lines = Files.lines(manifestPath);
                        String realPath = lines.filter(line -> line.startsWith(searchKey + " ")).map(line -> line.substring(line.indexOf(32) + 1)).findFirst().orElse(null);
                        if (realPath != null) {
                            Path realMarkerFile;
                            try {
                                realMarkerFile = Path.of(realPath, new String[0]).toRealPath(new LinkOption[0]);
                            }
                            catch (FileSystemException e) {
                                if (lines == null) continue;
                                lines.close();
                                continue;
                            }
                            Path communityRoot = realMarkerFile.getParent();
                            Path parentPath = communityRoot.getParent();
                            if (parentPath == null) return communityRoot;
                            if (!Files.exists(parentPath.resolve(".ultimate.root.marker"), new LinkOption[0])) return communityRoot;
                            return parentPath;
                        }
                        if (lines == null) continue;
                        lines.close();
                    }
                }
                catch (IOException manifestPath) {
                    // empty catch block
                }
            }
        }
        Path ultimateMarkerFile = workDirPath.resolve("community+").resolve(communityMarkerFileName);
        Path communityMarkerFile = workDirPath.resolve("_main").resolve(communityMarkerFileName);
        if (Files.exists(ultimateMarkerFile, new LinkOption[0])) {
            Path realUltimatePath = ultimateMarkerFile.toRealPath(new LinkOption[0]).getParent().getParent();
            if (Files.exists(realUltimatePath.resolve(".ultimate.root.marker"), new LinkOption[0])) return realUltimatePath;
            throw new RuntimeException("Missing .ultimate.root.marker file in " + String.valueOf(realUltimatePath) + " directory candidate");
        }
        if (!Files.exists(communityMarkerFile, new LinkOption[0])) throw new RuntimeException("Cannot find marker files " + String.valueOf(ultimateMarkerFile) + " either " + String.valueOf(communityMarkerFile));
        return communityMarkerFile.toRealPath(new LinkOption[0]).getParent();
    }

    private static void setSandboxPath(String property, Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        JUnit5BazelRunner.setIfEmpty(property, path.toAbsolutePath().toString());
    }

    private static void setIfEmpty(String property, String value) {
        if (value == null) {
            return;
        }
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    public static Set<Path> getClassPathRoots(ClassLoader classLoader) throws Throwable {
        Method getBaseUrls = classLoader.getClass().getMethod("getBaseUrls", new Class[0]);
        List paths = (List)getBaseUrls.invoke((Object)classLoader, new Object[0]);
        String bazelTestSelfLocation = System.getenv(bazelEnvSelfLocation);
        if (bazelTestSelfLocation == null || bazelTestSelfLocation.isBlank()) {
            return new HashSet<Path>(paths);
        }
        Path bazelTestSelfLocationDir = Path.of(bazelTestSelfLocation, new String[0]).getParent().toAbsolutePath();
        return paths.stream().filter(p -> bazelTestSelfLocationDir.equals(p.toAbsolutePath().getParent())).collect(Collectors.toSet());
    }

    public static List<? extends DiscoverySelector> getSelectors(Set<Path> classPathRoots) {
        List<PackageSelector> selectors = classPathRoots != null ? DiscoverySelectors.selectClasspathRoots(classPathRoots) : Collections.singletonList(DiscoverySelectors.selectPackage((String)""));
        return selectors;
    }

    private static void xmlReportBucketingTestsFilteringOut(Path xmlOutputFile) {
        try {
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><testsuites><testsuite name=\"Bucketing\" tests=\"0\" failures=\"0\" errors=\"0\" skipped=\"0\"><system-out>No tests executed: all tests were filtered out by bucketing.</system-out></testsuite></testsuites>";
            Files.writeString(xmlOutputFile, (CharSequence)xml, new OpenOption[0]);
        }
        catch (IOException t) {
            System.err.println("Failed to write XML_OUTPUT_FILE for bucketing-empty plan: " + t.getMessage());
        }
    }

    private static class ConsoleTestLogger
    implements TestExecutionListener {
        private ConsoleTestLogger() {
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            System.out.println("Test plan started: " + testPlan.countTestIdentifiers(TestIdentifier::isTest) + " tests found.");
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isTest()) {
                System.out.println("Started: " + testIdentifier.getDisplayName());
            }
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testIdentifier.isTest()) {
                System.out.println("Finished: " + testIdentifier.getDisplayName() + " (" + String.valueOf(testExecutionResult.getStatus()) + ")");
            }
            if (testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL && testExecutionResult.getThrowable().isPresent()) {
                Throwable t = (Throwable)testExecutionResult.getThrowable().get();
                t.printStackTrace(System.err);
                String message = t.getMessage();
                if (message != null && !message.isBlank()) {
                    System.err.println(message);
                }
            }
        }

        public void executionSkipped(TestIdentifier testIdentifier, String reason) {
            if (testIdentifier.isTest()) {
                System.out.println("Skipped: " + testIdentifier.getDisplayName() + " (reason: " + reason + ")");
            }
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            System.out.println("Test plan finished with " + testPlan.countTestIdentifiers(TestIdentifier::isTest) + " tests.");
        }
    }
}

