/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.MethodFilter;
import org.junit.platform.launcher.TagFilter;

enum JUnit5FilterOption {
    includePackage("include-package"),
    excludePackage("exclude-package"),
    includeClassName("include-classname"),
    excludeClassName("exclude-classname"),
    includeMethodName("include-methodname"),
    excludeMethodName("exclude-methodname"),
    includeTag("include-tag"),
    excludeTag("exclude-tag");

    private final String value;

    private JUnit5FilterOption(String value) {
        this.value = value;
    }

    Filter<?> toJunitFilter(String filterString) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PackageNameFilter.includePackageNames((String[])new String[]{filterString});
            case 1 -> PackageNameFilter.excludePackageNames((String[])new String[]{filterString});
            case 2 -> ClassNameFilter.includeClassNamePatterns((String[])new String[]{filterString});
            case 3 -> ClassNameFilter.excludeClassNamePatterns((String[])new String[]{filterString});
            case 4 -> MethodFilter.includeMethodNamePatterns((String[])new String[]{filterString});
            case 5 -> MethodFilter.excludeMethodNamePatterns((String[])new String[]{filterString});
            case 6 -> TagFilter.includeTags((String[])new String[]{filterString});
            case 7 -> TagFilter.excludeTags((String[])new String[]{filterString});
        };
    }

    public static JUnit5FilterOption fromString(String value) {
        for (JUnit5FilterOption option : JUnit5FilterOption.values()) {
            if (!option.value.equals(value)) continue;
            return option;
        }
        throw new IllegalStateException("Unexpected filter option value: " + value + ". Must be one of JUnit5FilterOption values.");
    }
}

