/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel.bucketing;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.PostDiscoveryFilter;

public class BucketsPostDiscoveryFilter
implements PostDiscoveryFilter {
    private static final MethodHandle included;
    private final List<String> includedClasses = new ArrayList<String>();
    private final List<String> excludedClasses = new ArrayList<String>();
    private final Map<String, FilterResult> resultsCache = new HashMap<String, FilterResult>();

    public Boolean hasExcludedClasses() {
        return !this.excludedClasses.isEmpty();
    }

    public Boolean hasIncludedClasses() {
        return !this.includedClasses.isEmpty();
    }

    public FilterResult apply(TestDescriptor descriptor) {
        if (descriptor instanceof EngineDescriptor) {
            return FilterResult.included(null);
        }
        TestSource source = descriptor.getSource().orElse(null);
        if (source == null) {
            return FilterResult.included((String)"No source for descriptor");
        }
        if (source instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)source;
            return this.isIncluded(methodSource.getJavaClass());
        }
        if (source instanceof ClassSource) {
            ClassSource classSource = (ClassSource)source;
            return this.isIncluded(classSource.getJavaClass());
        }
        return FilterResult.included((String)("Unknown source type " + String.valueOf(source.getClass())));
    }

    private FilterResult isIncluded(Class<?> aClass) {
        FilterResult result = this.resultsCache.get(aClass.getName());
        if (result == null) {
            result = this.isIncludedImpl(aClass);
            this.resultsCache.put(aClass.getName(), result);
            if (result.included()) {
                this.includedClasses.add(aClass.getName());
            } else {
                this.excludedClasses.add(aClass.getName());
            }
        }
        return result;
    }

    private FilterResult isIncludedImpl(Class<?> aClass) {
        try {
            if (included.invokeExact(aClass)) {
                return FilterResult.included(null);
            }
            return FilterResult.excluded(null);
        }
        catch (Throwable e) {
            String message = e.getClass().getSimpleName() + (String)(e.getMessage() != null ? ": " + e.getMessage() : "");
            return FilterResult.excluded((String)message);
        }
    }

    static {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            included = MethodHandles.publicLookup().findStatic(Class.forName("com.intellij.TestCaseLoader", true, classLoader), "isClassIncluded", MethodType.methodType(Boolean.TYPE, Class.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

