/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.logging.Logger;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class TestLocationStorage {
    public static final Logger LOG = Logger.getLogger(TestLocationStorage.class.getName());
    private static final Path TEST_LOCATION_ARTIFACT = TestLocationStorage.getDefaultArtifactPath();

    private static Path getDefaultArtifactPath() {
        String customPath = System.getProperty("intellij.test.location.artifact");
        if (customPath != null) {
            return Paths.get(customPath, new String[0]);
        }
        Path parent = Paths.get("", new String[0]).getParent();
        if (parent != null) {
            Path grandParent = parent.getParent();
            if (grandParent != null && Files.exists(grandParent.resolve("out"), new LinkOption[0])) {
                return grandParent.resolve("out/test-artifacts/test-locations.ndjson");
            }
            if (Files.exists(parent.resolve("out"), new LinkOption[0])) {
                return parent.resolve("out/test-artifacts/test-locations.ndjson");
            }
        }
        return Paths.get("out/test-artifacts/test-locations.ndjson", new String[0]);
    }

    private TestLocationStorage() {
    }

    private static String getClassNameFromTestSource(TestSource testSource) {
        if (testSource instanceof ClassSource) {
            return ((ClassSource)testSource).getClassName();
        }
        if (testSource instanceof MethodSource) {
            return ((MethodSource)testSource).getClassName();
        }
        return null;
    }

    private static String getPackagePath(Class<?> testClass) {
        String string;
        block10: {
            if (testClass == null) {
                return "";
            }
            String resourcePath = "/" + testClass.getName().replace('.', '/') + ".class";
            InputStream is = testClass.getResourceAsStream(resourcePath);
            if (is == null) {
                return "";
            }
            InputStream inputStream = is;
            try {
                ClassReader classReader = new ClassReader(is);
                PackageExtractor extractor = new PackageExtractor();
                classReader.accept((ClassVisitor)extractor, 7);
                string = extractor.packagePath;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "";
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String getModuleName(Path jarPath) {
        if (jarPath == null || !Files.exists(jarPath, new LinkOption[0]) || !jarPath.toString().endsWith(".jar")) {
            return null;
        }
        Path parent = jarPath.getParent();
        if (parent != null) {
            return parent.getFileName().toString();
        }
        return null;
    }

    public static String getFileName(Class<?> testClass) {
        String string;
        block9: {
            String resourcePath = "/" + testClass.getName().replace('.', '/') + ".class";
            InputStream is = testClass.getResourceAsStream(resourcePath);
            if (is == null) {
                return null;
            }
            InputStream inputStream = is;
            try {
                ClassReader classReader = new ClassReader(is);
                SourceFileExtractor extractor = new SourceFileExtractor();
                classReader.accept((ClassVisitor)extractor, 0);
                string = extractor.sourceFile;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static String escapeJson(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recordTestLocation(TestIdentifier testIdentifier, TestExecutionResult.Status status, String testName) {
        block10: {
            TestSource source = testIdentifier.getSource().orElse(null);
            String className = TestLocationStorage.getClassNameFromTestSource(source);
            if (className == null) {
                LOG.info("Cannot find class name for " + testName);
                return;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    LOG.info("Could not find class loader for test " + testName);
                    return;
                }
                Class<?> testClass = Class.forName(className, false, classLoader);
                CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
                if (codeSource == null || codeSource.getLocation() == null) break block10;
                Path jarPath = Paths.get(codeSource.getLocation().toURI());
                String moduleName = TestLocationStorage.getModuleName(jarPath);
                if (moduleName == null) {
                    LOG.info("No module found for " + String.valueOf(codeSource.getLocation()));
                    return;
                }
                String packagePath = TestLocationStorage.getPackagePath(testClass);
                String fileName = TestLocationStorage.getFileName(testClass);
                if (fileName == null) {
                    LOG.info("No file found for " + String.valueOf(codeSource.getLocation()));
                    return;
                }
                boolean failed = status == TestExecutionResult.Status.FAILED;
                String json = String.format("{\"test\":\"%s\",\"module\":\"%s\",\"package\":\"%s\",\"file\":\"%s\",\"failed\":%s}%n", TestLocationStorage.escapeJson(testName), TestLocationStorage.escapeJson(moduleName), TestLocationStorage.escapeJson(packagePath), TestLocationStorage.escapeJson(fileName), failed);
                LOG.info("Writing to " + String.valueOf(TEST_LOCATION_ARTIFACT.toAbsolutePath()));
                Path path = TEST_LOCATION_ARTIFACT;
                synchronized (path) {
                    Path parentDir = TEST_LOCATION_ARTIFACT.getParent();
                    if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                        Files.createDirectories(parentDir, new FileAttribute[0]);
                    }
                    Files.writeString(TEST_LOCATION_ARTIFACT, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
            }
            catch (Exception e) {
                LOG.info(e.getMessage());
            }
        }
    }

    private static class PackageExtractor
    extends ClassVisitor {
        String packagePath = "";

        PackageExtractor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            int lastSlash;
            if (name != null && (lastSlash = name.lastIndexOf(47)) > 0) {
                this.packagePath = name.substring(0, lastSlash);
            }
        }
    }

    private static class SourceFileExtractor
    extends ClassVisitor {
        String sourceFile;

        SourceFileExtractor() {
            super(589824);
        }

        public void visitSource(String source, String debug) {
            this.sourceFile = source;
        }
    }
}

