/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.repo;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.project.ProjectIdKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.platform.vcs.impl.shared.RepositoryId;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import com.intellij.vcs.git.repo.GitRepositoryModelImpl;
import com.intellij.vcs.git.repo.GitRepositoryStateImpl;
import com.intellij.vcs.git.rpc.GitRepositoryApi;
import com.intellij.vcs.git.rpc.GitRepositoryDto;
import com.intellij.vcs.git.rpc.GitRepositoryEvent;
import com.intellij.vcs.git.rpc.GitRepositoryStateDto;
import fleet.rpc.client.DurableKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 (2\u00020\u0001:\u0002()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001fH\u0086@\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u001fH\u0082@\u00a2\u0006\u0002\u0010!J\u0016\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u001fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/intellij/vcs/git/repo/GitRepositoriesHolder;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "repositories", "", "Lcom/intellij/platform/vcs/impl/shared/RepositoryId;", "Lcom/intellij/vcs/git/repo/GitRepositoryModelImpl;", "initJob", "Lkotlinx/coroutines/Job;", "_updates", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/vcs/git/repo/GitRepositoriesHolder$UpdateType;", "initialized", "", "getInitialized", "()Z", "updates", "Lkotlinx/coroutines/flow/SharedFlow;", "getUpdates", "()Lkotlinx/coroutines/flow/SharedFlow;", "getAll", "", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "get", "repositoryId", "logErrorIfNotInitialized", "", "awaitInitialization", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribeToRepoEvents", "handleSingleRepoUpdate", "event", "Lcom/intellij/vcs/git/rpc/GitRepositoryEvent$SingleRepositoryUpdate;", "(Lcom/intellij/vcs/git/rpc/GitRepositoryEvent$SingleRepositoryUpdate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearRepositories", "Companion", "UpdateType", "intellij.vcs.git.shared"})
@ApiStatus.Internal
public final class GitRepositoriesHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Map<RepositoryId, GitRepositoryModelImpl> repositories;
    @NotNull
    private final Job initJob;
    @NotNull
    private final MutableSharedFlow<UpdateType> _updates;
    @NotNull
    private final SharedFlow<UpdateType> updates;
    @NotNull
    private static final Logger LOG;

    public GitRepositoriesHolder(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.repositories = new ConcurrentHashMap();
        this.initJob = BuildersKt.launch$default((CoroutineScope)this.cs, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitRepositoriesHolder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = GitRepositoriesHolder.access$subscribeToRepoEvents(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this._updates = SharedFlowKt.MutableSharedFlow((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        this.updates = FlowKt.asSharedFlow(this._updates);
    }

    public final boolean getInitialized() {
        return this.initJob.isCompleted();
    }

    @NotNull
    public final SharedFlow<UpdateType> getUpdates() {
        return this.updates;
    }

    @NotNull
    public final List<GitRepositoryModel> getAll() {
        this.logErrorIfNotInitialized();
        return CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)this.repositories.values()));
    }

    @Nullable
    public final GitRepositoryModel get(@NotNull RepositoryId repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        this.logErrorIfNotInitialized();
        return this.repositories.get(repositoryId);
    }

    private final void logErrorIfNotInitialized() {
        if (!this.getInitialized()) {
            LOG.error("Repositories state holder not initialized", new Throwable());
        }
    }

    @Nullable
    public final Object awaitInitialization(@NotNull Continuation<? super Unit> $completion) {
        this.initJob.start();
        Object object = this.initJob.join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object subscribeToRepoEvents(Continuation<? super Unit> $completion) {
        CompletableDeferred initSignal = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)this.cs, (String)"Git repository state synchronization", null, (boolean)false, (int)6, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (CompletableDeferred<Unit>)initSignal, null){
            int label;
            final /* synthetic */ GitRepositoriesHolder this$0;
            final /* synthetic */ CompletableDeferred<Unit> $initSignal;
            {
                this.this$0 = $receiver;
                this.$initSignal = $initSignal;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DurableKt.durable$default((boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$initSignal, null){
                            int label;
                            final /* synthetic */ GitRepositoriesHolder this$0;
                            final /* synthetic */ CompletableDeferred<Unit> $initSignal;
                            {
                                this.this$0 = $receiver;
                                this.$initSignal = $initSignal;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = GitRepositoryApi.Companion.getInstance((Continuation<? super GitRepositoryApi>)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = ((GitRepositoryApi)v0).getRepositoriesEvents(ProjectIdKt.projectId((Project)GitRepositoriesHolder.access$getProject$p(this.this$0)), (Continuation<? super Flow<? extends GitRepositoryEvent>>)((Continuation)this));
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        this.label = 3;
                                        v2 = ((Flow)v1).collect(new FlowCollector(this.this$0, this.$initSignal){
                                            final /* synthetic */ GitRepositoriesHolder this$0;
                                            final /* synthetic */ CompletableDeferred<Unit> $initSignal;
                                            {
                                                this.this$0 = $receiver;
                                                this.$initSignal = $initSignal;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            public final Object emit(GitRepositoryEvent event, Continuation<? super Unit> $completion) {
                                                block25: {
                                                    block20: {
                                                        block24: {
                                                            block23: {
                                                                block22: {
                                                                    block21: {
                                                                        if (!($completion instanceof subscribeToRepoEvents.emit.1)) ** GOTO lbl-1000
                                                                        var17_3 = $completion;
                                                                        if ((var17_3.label & -2147483648) != 0) {
                                                                            var17_3.label -= -2147483648;
                                                                        } else lbl-1000:
                                                                        // 2 sources

                                                                        {
                                                                            $continuation = new ContinuationImpl(this, $completion){
                                                                                Object L$0;
                                                                                Object L$1;
                                                                                int I$0;
                                                                                /* synthetic */ Object result;
                                                                                final /* synthetic */ subscribeToRepoEvents.1<T> this$0;
                                                                                int label;
                                                                                {
                                                                                    this.this$0 = this$0;
                                                                                    super($completion);
                                                                                }

                                                                                public final Object invokeSuspend(Object $result) {
                                                                                    this.result = $result;
                                                                                    this.label |= Integer.MIN_VALUE;
                                                                                    return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                                                                }
                                                                            };
                                                                        }
                                                                        $result = $continuation.result;
                                                                        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                        switch ($continuation.label) {
                                                                            case 0: {
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                GitRepositoriesHolder.access$getLOG$cp().debug("Received repository event: " + event);
                                                                                var3_6 = event;
                                                                                if (!(var3_6 instanceof GitRepositoryEvent.ReloadState)) ** GOTO lbl37
                                                                                $this$associate$iv = ((GitRepositoryEvent.ReloadState)event).getRepositories();
                                                                                $i$f$associate = false;
                                                                                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                                                                                var8_16 = $this$associate$iv;
                                                                                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                                                                                $i$f$associateTo = false;
                                                                                for (T element$iv$iv : $this$associateTo$iv$iv) {
                                                                                    var13_23 = destination$iv$iv;
                                                                                    it = (GitRepositoryDto)element$iv$iv;
                                                                                    $i$a$-associate-GitRepositoriesHolder$subscribeToRepoEvents$2$1$1$newState$1 = false;
                                                                                    var14_24 = TuplesKt.to((Object)it.getRepositoryId(), (Object)com.intellij.vcs.git.repo.GitRepositoriesHolder$Companion.access$convertToRepositoryInfo(GitRepositoriesHolder.Companion, it));
                                                                                    var13_23.put(var14_24.getFirst(), var14_24.getSecond());
                                                                                }
                                                                                newState = destination$iv$iv;
                                                                                GitRepositoriesHolder.access$getRepositories$p(this.this$0).keySet().retainAll((Collection)newState.keySet());
                                                                                GitRepositoriesHolder.access$getRepositories$p(this.this$0).putAll(newState);
                                                                                if (!this.$initSignal.isCompleted()) {
                                                                                    this.$initSignal.complete((Object)Unit.INSTANCE);
                                                                                }
                                                                                break block20;
lbl37:
                                                                                // 1 sources

                                                                                if (!(var3_6 instanceof GitRepositoryEvent.RepositoriesSync)) break block21;
                                                                                if (((GitRepositoryEvent.RepositoriesSync)event).getRepositories().size() == GitRepositoriesHolder.access$getRepositories$p(this.this$0).size() && GitRepositoriesHolder.access$getRepositories$p(this.this$0).keySet().containsAll((Collection)((GitRepositoryEvent.RepositoriesSync)event).getRepositories())) break;
                                                                                GitRepositoriesHolder.access$getLOG$cp().warn("State of repositories is not synchronized. Received repositories: " + CollectionsKt.joinToString$default((Iterable)((GitRepositoryEvent.RepositoriesSync)event).getRepositories(), null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, emit$lambda$1(com.intellij.platform.vcs.impl.shared.RepositoryId ), (Lcom/intellij/platform/vcs/impl/shared/RepositoryId;)Ljava/lang/CharSequence;)(), (int)31, null) + ". Known repositories are: " + CollectionsKt.joinToString$default((Iterable)GitRepositoriesHolder.access$getRepositories$p(this.this$0).keySet(), null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, emit$lambda$2(com.intellij.platform.vcs.impl.shared.RepositoryId ), (Lcom/intellij/platform/vcs/impl/shared/RepositoryId;)Ljava/lang/CharSequence;)(), (int)31, null));
                                                                                $continuation.L$0 = event;
                                                                                $continuation.label = 1;
                                                                                v0 = GitRepositoryApi.Companion.getInstance((Continuation<? super GitRepositoryApi>)$continuation);
                                                                                if (v0 == var18_5) {
                                                                                    return var18_5;
                                                                                }
                                                                                ** GOTO lbl50
                                                                            }
                                                                            case 1: {
                                                                                event = (GitRepositoryEvent)$continuation.L$0;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                v0 = $result;
lbl50:
                                                                                // 2 sources

                                                                                $continuation.L$0 = event;
                                                                                $continuation.label = 2;
                                                                                v1 = ((GitRepositoryApi)v0).forceSync(ProjectIdKt.projectId((Project)GitRepositoriesHolder.access$getProject$p(this.this$0)), (Continuation<? super Unit>)$continuation);
                                                                                if (v1 == var18_5) {
                                                                                    return var18_5;
                                                                                }
                                                                                break block20;
                                                                            }
                                                                            case 2: {
                                                                                event = (GitRepositoryEvent)$continuation.L$0;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                v1 = $result;
                                                                                break block20;
                                                                            }
                                                                        }
                                                                        GitRepositoriesHolder.access$getLOG$cp().debug("Repositories state is synchronized");
                                                                        break block20;
                                                                    }
                                                                    if (!(var3_6 instanceof GitRepositoryEvent.RepositoryCreated)) break block22;
                                                                    GitRepositoriesHolder.access$getRepositories$p(this.this$0).put(((GitRepositoryEvent.RepositoryCreated)event).getRepository().getRepositoryId(), com.intellij.vcs.git.repo.GitRepositoriesHolder$Companion.access$convertToRepositoryInfo(GitRepositoriesHolder.Companion, ((GitRepositoryEvent.RepositoryCreated)event).getRepository()));
                                                                    break block20;
                                                                }
                                                                if (!(var3_6 instanceof GitRepositoryEvent.RepositoryDeleted)) break block23;
                                                                GitRepositoriesHolder.access$getRepositories$p(this.this$0).remove(((GitRepositoryEvent.RepositoryDeleted)event).getRepositoryId());
                                                                break block20;
                                                            }
                                                            if (!(var3_6 instanceof GitRepositoryEvent.SingleRepositoryUpdate)) break block24;
                                                            $continuation.L$0 = event;
                                                            $continuation.label = 3;
                                                            v2 = GitRepositoriesHolder.access$handleSingleRepoUpdate(this.this$0, (GitRepositoryEvent.SingleRepositoryUpdate)event, (Continuation)$continuation);
                                                            if (v2 == var18_5) {
                                                                return var18_5;
                                                            }
                                                            break block20;
                                                            {
                                                                case 3: {
                                                                    event = (GitRepositoryEvent)$continuation.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v2 = $result;
                                                                    break block20;
                                                                }
                                                            }
                                                        }
                                                        if (Intrinsics.areEqual((Object)var3_6, (Object)GitRepositoryEvent.TagsHidden.INSTANCE)) {
                                                            $this$forEach$iv = GitRepositoriesHolder.access$getRepositories$p(this.this$0).values();
                                                            $i$f$forEach = false;
                                                            for (T element$iv : $this$forEach$iv) {
                                                                it = (GitRepositoryModelImpl)element$iv;
                                                                $i$a$-forEach-GitRepositoriesHolder$subscribeToRepoEvents$2$1$1$3 = false;
                                                                it.getState().setTags(SetsKt.emptySet());
                                                            }
                                                        } else {
                                                            throw new NoWhenBranchMatchedException();
                                                        }
                                                    }
                                                    if (this.this$0.getInitialized()) {
                                                        v3 = com.intellij.vcs.git.repo.GitRepositoriesHolder$Companion.access$getUpdateType(GitRepositoriesHolder.Companion, event);
                                                        if (v3 != null) {
                                                            var4_26 = v3;
                                                            var5_7 = this.this$0;
                                                            it = var4_26;
                                                            $i$a$-let-GitRepositoriesHolder$subscribeToRepoEvents$2$1$1$4 = 0;
                                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                                                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)it);
                                                            $continuation.I$0 = $i$a$-let-GitRepositoriesHolder$subscribeToRepoEvents$2$1$1$4;
                                                            $continuation.label = 4;
                                                            v4 = GitRepositoriesHolder.access$get_updates$p(var5_7).emit((Object)it, (Continuation)$continuation);
                                                            if (v4 == var18_5) {
                                                                return var18_5;
                                                            }
                                                        }
                                                    }
                                                    break block25;
                                                    {
                                                        case 4: {
                                                            $i$a$-let-GitRepositoriesHolder$subscribeToRepoEvents$2$1$1$4 = $continuation.I$0;
                                                            it = (UpdateType)$continuation.L$1;
                                                            event = (GitRepositoryEvent)$continuation.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v4 = $result;
                                                        }
                                                    }
                                                }
                                                return Unit.INSTANCE;
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            private static final CharSequence emit$lambda$1(RepositoryId it) {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                return it.toString();
                                            }

                                            private static final CharSequence emit$lambda$2(RepositoryId it) {
                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                return it.toString();
                                            }
                                        }, (Continuation)this);
                                        if (v2 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl29
                                    }
                                    case 3: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl29:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)1, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        Object object = initSignal.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleSingleRepoUpdate(GitRepositoryEvent.SingleRepositoryUpdate event, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleSingleRepoUpdate.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitRepositoriesHolder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GitRepositoriesHolder.access$handleSingleRepoUpdate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                repoId = event.getRepositoryId();
                repoInfo = this.repositories.computeIfPresent(repoId, (BiFunction<Object, Object, GitRepositoryModelImpl>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, handleSingleRepoUpdate$lambda$1(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/vcs/git/repo/GitRepositoryModelImpl;)((Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, handleSingleRepoUpdate$lambda$0(com.intellij.vcs.git.rpc.GitRepositoryEvent$SingleRepositoryUpdate com.intellij.platform.vcs.impl.shared.RepositoryId com.intellij.vcs.git.repo.GitRepositoryModelImpl ), (Lcom/intellij/platform/vcs/impl/shared/RepositoryId;Lcom/intellij/vcs/git/repo/GitRepositoryModelImpl;)Lcom/intellij/vcs/git/repo/GitRepositoryModelImpl;)((GitRepositoryEvent.SingleRepositoryUpdate)event)));
                if (repoInfo != null) break;
                GitRepositoriesHolder.LOG.warn("State of repository " + repoId + " is not synchronized. Known repositories are: " + CollectionsKt.joinToString$default((Iterable)this.repositories.keySet(), null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, handleSingleRepoUpdate$lambda$2(com.intellij.platform.vcs.impl.shared.RepositoryId ), (Lcom/intellij/platform/vcs/impl/shared/RepositoryId;)Ljava/lang/CharSequence;)(), (int)31, null));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)repoId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)repoInfo);
                $continuation.label = 1;
                v0 = GitRepositoryApi.Companion.getInstance((Continuation<? super GitRepositoryApi>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                repoInfo = (GitRepositoryModelImpl)$continuation.L$2;
                repoId = (RepositoryId)$continuation.L$1;
                event = (GitRepositoryEvent.SingleRepositoryUpdate)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)repoId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)repoInfo);
                $continuation.label = 2;
                v1 = ((GitRepositoryApi)v0).forceSync(ProjectIdKt.projectId((Project)this.project), (Continuation<? super Unit>)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl44
            }
            case 2: {
                repoInfo = (GitRepositoryModelImpl)$continuation.L$2;
                repoId = (RepositoryId)$continuation.L$1;
                event = (GitRepositoryEvent.SingleRepositoryUpdate)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @TestOnly
    @ApiStatus.Internal
    public final void clearRepositories() {
        this.repositories.clear();
    }

    private static final GitRepositoryModelImpl handleSingleRepoUpdate$lambda$0(GitRepositoryEvent.SingleRepositoryUpdate $event, RepositoryId repositoryId, GitRepositoryModelImpl info) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        GitRepositoryEvent.SingleRepositoryUpdate singleRepositoryUpdate = $event;
        if (singleRepositoryUpdate instanceof GitRepositoryEvent.FavoriteRefsUpdated) {
            info.setFavoriteRefs(((GitRepositoryEvent.FavoriteRefsUpdated)$event).getFavoriteRefs());
        } else if (singleRepositoryUpdate instanceof GitRepositoryEvent.RepositoryStateUpdated) {
            info.setState(GitRepositoriesHolder.Companion.convertToRepositoryState(((GitRepositoryEvent.RepositoryStateUpdated)$event).getNewState()));
        } else if (singleRepositoryUpdate instanceof GitRepositoryEvent.TagsLoaded) {
            info.getState().setTags(((GitRepositoryEvent.TagsLoaded)$event).getTags());
        } else if (singleRepositoryUpdate instanceof GitRepositoryEvent.WorkingTreesLoaded) {
            info.getState().setWorkingTrees(((GitRepositoryEvent.WorkingTreesLoaded)$event).getWorkingTrees());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return info;
    }

    private static final GitRepositoryModelImpl handleSingleRepoUpdate$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (GitRepositoryModelImpl)$tmp0.invoke(p0, p1);
    }

    private static final CharSequence handleSingleRepoUpdate$lambda$2(RepositoryId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public static final /* synthetic */ Object access$subscribeToRepoEvents(GitRepositoriesHolder $this, Continuation $completion) {
        return $this.subscribeToRepoEvents((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(GitRepositoriesHolder $this) {
        return $this.project;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Map access$getRepositories$p(GitRepositoriesHolder $this) {
        return $this.repositories;
    }

    public static final /* synthetic */ Object access$handleSingleRepoUpdate(GitRepositoriesHolder $this, GitRepositoryEvent.SingleRepositoryUpdate event, Continuation $completion) {
        return $this.handleSingleRepoUpdate(event, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ MutableSharedFlow access$get_updates$p(GitRepositoriesHolder $this) {
        return $this._updates;
    }

    static {
        Logger logger = Logger.getInstance(GitRepositoriesHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/git/repo/GitRepositoriesHolder$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/vcs/git/repo/GitRepositoriesHolder;", "project", "Lcom/intellij/openapi/project/Project;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "convertToRepositoryInfo", "Lcom/intellij/vcs/git/repo/GitRepositoryModelImpl;", "repositoryDto", "Lcom/intellij/vcs/git/rpc/GitRepositoryDto;", "convertToRepositoryState", "Lcom/intellij/vcs/git/repo/GitRepositoryStateImpl;", "repositoryStateDto", "Lcom/intellij/vcs/git/rpc/GitRepositoryStateDto;", "getUpdateType", "Lcom/intellij/vcs/git/repo/GitRepositoriesHolder$UpdateType;", "rpcEvent", "Lcom/intellij/vcs/git/rpc/GitRepositoryEvent;", "intellij.vcs.git.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitRepositoriesHolder getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitRepositoriesHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitRepositoriesHolder)object;
        }

        private final GitRepositoryModelImpl convertToRepositoryInfo(GitRepositoryDto repositoryDto) {
            return new GitRepositoryModelImpl(repositoryDto.getRepositoryId(), repositoryDto.getShortName(), this.convertToRepositoryState(repositoryDto.getState()), repositoryDto.getFavoriteRefs(), repositoryDto.getRoot().getFilePath());
        }

        private final GitRepositoryStateImpl convertToRepositoryState(GitRepositoryStateDto repositoryStateDto) {
            return new GitRepositoryStateImpl(repositoryStateDto.getCurrentRef(), repositoryStateDto.getRevision-yfegSRw(), repositoryStateDto.getLocalBranches(), repositoryStateDto.getRemoteBranches(), repositoryStateDto.getTags(), repositoryStateDto.getWorkingTrees(), repositoryStateDto.getRecentBranches(), repositoryStateDto.getOperationState(), repositoryStateDto.getTrackingInfo(), null);
        }

        private final UpdateType getUpdateType(GitRepositoryEvent rpcEvent) {
            UpdateType updateType;
            GitRepositoryEvent gitRepositoryEvent = rpcEvent;
            if (gitRepositoryEvent instanceof GitRepositoryEvent.FavoriteRefsUpdated) {
                updateType = UpdateType.FAVORITE_REFS_UPDATED;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.RepositoryCreated) {
                updateType = UpdateType.REPOSITORY_CREATED;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.RepositoryDeleted) {
                updateType = UpdateType.REPOSITORY_DELETED;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.RepositoryStateUpdated) {
                updateType = UpdateType.REPOSITORY_STATE_UPDATED;
            } else if (Intrinsics.areEqual((Object)gitRepositoryEvent, (Object)GitRepositoryEvent.TagsHidden.INSTANCE)) {
                updateType = UpdateType.TAGS_HIDDEN;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.TagsLoaded) {
                updateType = UpdateType.TAGS_LOADED;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.WorkingTreesLoaded) {
                updateType = UpdateType.WORKING_TREES_LOADED;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.ReloadState) {
                updateType = UpdateType.RELOAD_STATE;
            } else if (gitRepositoryEvent instanceof GitRepositoryEvent.RepositoriesSync) {
                updateType = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return updateType;
        }

        public static final /* synthetic */ GitRepositoryModelImpl access$convertToRepositoryInfo(Companion $this, GitRepositoryDto repositoryDto) {
            return $this.convertToRepositoryInfo(repositoryDto);
        }

        public static final /* synthetic */ UpdateType access$getUpdateType(Companion $this, GitRepositoryEvent rpcEvent) {
            return $this.getUpdateType(rpcEvent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0087\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/git/repo/GitRepositoriesHolder$UpdateType;", "", "<init>", "(Ljava/lang/String;I)V", "REPOSITORY_CREATED", "REPOSITORY_DELETED", "FAVORITE_REFS_UPDATED", "REPOSITORY_STATE_UPDATED", "TAGS_LOADED", "TAGS_HIDDEN", "WORKING_TREES_LOADED", "RELOAD_STATE", "intellij.vcs.git.shared"})
    @ApiStatus.Internal
    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType REPOSITORY_CREATED = new UpdateType();
        public static final /* enum */ UpdateType REPOSITORY_DELETED = new UpdateType();
        public static final /* enum */ UpdateType FAVORITE_REFS_UPDATED = new UpdateType();
        public static final /* enum */ UpdateType REPOSITORY_STATE_UPDATED = new UpdateType();
        public static final /* enum */ UpdateType TAGS_LOADED = new UpdateType();
        public static final /* enum */ UpdateType TAGS_HIDDEN = new UpdateType();
        public static final /* enum */ UpdateType WORKING_TREES_LOADED = new UpdateType();
        public static final /* enum */ UpdateType RELOAD_STATE = new UpdateType();
        private static final /* synthetic */ UpdateType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UpdateType[] values() {
            return (UpdateType[])$VALUES.clone();
        }

        public static UpdateType valueOf(String value) {
            return Enum.valueOf(UpdateType.class, value);
        }

        @NotNull
        public static EnumEntries<UpdateType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = updateTypeArray = new UpdateType[]{UpdateType.REPOSITORY_CREATED, UpdateType.REPOSITORY_DELETED, UpdateType.FAVORITE_REFS_UPDATED, UpdateType.REPOSITORY_STATE_UPDATED, UpdateType.TAGS_LOADED, UpdateType.TAGS_HIDDEN, UpdateType.WORKING_TREES_LOADED, UpdateType.RELOAD_STATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

