/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.checkin.GitCheckinHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lgit4idea/checkin/GitLargeFileCheckinHandler;", "Lgit4idea/checkin/GitCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runGitCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "committedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "GitLargeFileCommitProblem", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCheckinHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCheckinHandlerFactory.kt\ngit4idea/checkin/GitLargeFileCheckinHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,538:1\n1642#2,10:539\n1915#2:549\n1916#2:551\n1652#2:552\n777#2:553\n873#2,2:554\n1512#2:556\n1538#2,3:557\n1541#2,3:567\n777#2:570\n873#2,2:571\n777#2:573\n873#2,2:574\n1391#2:576\n1480#2,5:577\n1#3:550\n1#3:582\n383#4,7:560\n*S KotlinDebug\n*F\n+ 1 GitCheckinHandlerFactory.kt\ngit4idea/checkin/GitLargeFileCheckinHandler\n*L\n167#1:539,10\n167#1:549\n167#1:551\n167#1:552\n168#1:553\n168#1:554,2\n174#1:556\n174#1:557,3\n174#1:567,3\n177#1:570\n177#1:571,2\n178#1:573\n178#1:574,2\n181#1:576\n181#1:577,5\n167#1:550\n174#1:560,7\n*E\n"})
final class GitLargeFileCheckinHandler
extends GitCheckinHandler {
    public GitLargeFileCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    public boolean isEnabled() {
        return GitVcsSettings.getInstance((Project)this.getProject()).warnAboutLargeFiles();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object runGitCheck(@NotNull CommitInfo commitInfo, @NotNull List<? extends Change> committedChanges, @NotNull Continuation<? super CommitProblem> $completion) {
        long l;
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$groupByTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Change it;
        void $this$mapNotNullTo$iv$iv;
        int maxFileSize = GitVcsSettings.getInstance((Project)this.getProject()).getWarnAboutLargeFilesLimitMb() * 1024 * 1024;
        if (maxFileSize <= 0) {
            return null;
        }
        Iterable $this$mapNotNull$iv = committedChanges;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<VirtualFile> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            it = (Change)element$iv$iv;
            boolean bl2 = false;
            if (it.getVirtualFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List files = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = files;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VirtualFile it2 = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it2.getLength() > (long)maxFileSize)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List largeFiles = (List)destination$iv$iv2;
        if (largeFiles.isEmpty()) {
            return null;
        }
        GitVcs gitVcs = GitVcs.getInstance(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        GitVcs git = gitVcs;
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.Companion.getInstance(this.getProject());
        Iterable $this$groupBy$iv = largeFiles;
        boolean $i$f$groupBy22 = false;
        Iterable $i$f$forEach22 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VcsRoot key$iv$iv = vcsManager.getVcsRootObjectFor((VirtualFile)it);
            Map bl3 = destination$iv$iv3;
            VcsRoot key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map filesByRoot = destination$iv$iv3;
        Iterable $i$f$groupBy22 = CollectionsKt.distinct((Iterable)CollectionsKt.filterNotNull((Iterable)filesByRoot.keySet()));
        boolean $i$f$filter2 = false;
        destination$iv$iv3 = $this$filter$iv;
        Iterable destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsRoot root = (VcsRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)root.getVcs(), (Object)((Object)git))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        $i$f$filter2 = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv4 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsRoot root = (VcsRoot)element$iv$iv;
            boolean bl = false;
            if (!(GitConfigUtil.getValue(this.getProject(), root.getPath(), "lfs.repositoryformatversion") == null)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List affectedRoots = (List)destination$iv$iv4;
        if (affectedRoots.isEmpty()) {
            return null;
        }
        Iterable $this$flatMap$iv = affectedRoots;
        boolean $i$f$flatMap = false;
        destination$iv$iv4 = $this$flatMap$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VcsRoot root = (VcsRoot)element$iv$iv;
            boolean bl = false;
            List list = (List)filesByRoot.get(root);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
        }
        List affectedFiles = (List)destination$iv$iv5;
        Iterable iterable2 = affectedFiles;
        int n = affectedFiles.size();
        long l2 = 0L;
        for (Object t : iterable2) {
            Object element$iv$iv;
            element$iv$iv = (VirtualFile)t;
            l = l2;
            boolean bl = false;
            long l3 = it.getLength();
            l2 = l + l3;
        }
        long l4 = l = l2;
        int n2 = n;
        return new GitLargeFileCommitProblem(n2, l4);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lgit4idea/checkin/GitLargeFileCheckinHandler$GitLargeFileCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "fileCount", "", "totalSizeBytes", "", "<init>", "(IJ)V", "getFileCount", "()I", "getTotalSizeBytes", "()J", "text", "", "getText", "()Ljava/lang/String;", "intellij.vcs.git"})
    private static final class GitLargeFileCommitProblem
    implements CommitProblem {
        private final int fileCount;
        private final long totalSizeBytes;

        public GitLargeFileCommitProblem(int fileCount, long totalSizeBytes) {
            this.fileCount = fileCount;
            this.totalSizeBytes = totalSizeBytes;
        }

        public final int getFileCount() {
            return this.fileCount;
        }

        public final long getTotalSizeBytes() {
            return this.totalSizeBytes;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.fileCount, this.totalSizeBytes / (long)1024 / (long)1024};
            String string = GitBundle.message((String)"commit.check.warning.title.large.file", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

