/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelExecApiHelpersKt;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelProcessExecutionResult;
import com.intellij.platform.eel.provider.utils.EelProcessUtilsKt;
import com.intellij.vcs.VcsLocaleHelper;
import git4idea.commands.GitHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableContext;
import git4idea.config.GitExecutableDetector;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitConfigKey;
import git4idea.repo.GitConfigurationCache;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 &2\u00020\u0001:\u0005&'()*B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0010H&J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J)\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050 \"\u00020\u0005H&\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050#H&J\b\u0010$\u001a\u00020%H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\u0082\u0001\u0004+,-.\u00a8\u0006/"}, d2={"Lgit4idea/config/GitExecutable;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "exePath", "getExePath", "isLocal", "", "()Z", "isRemote", "convertFilePath", "file", "Ljava/nio/file/Path;", "convertFilePathBack", "path", "workingDir", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "executableContext", "Lgit4idea/config/GitExecutableContext;", "createBundledCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "getLocaleEnv", "", "getModificationTime", "", "Companion", "Local", "Eel", "Wsl", "Unknown", "Lgit4idea/config/GitExecutable$Eel;", "Lgit4idea/config/GitExecutable$Local;", "Lgit4idea/config/GitExecutable$Unknown;", "Lgit4idea/config/GitExecutable$Wsl;", "intellij.vcs.git"})
public abstract sealed class GitExecutable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CYGDRIVE_PREFIX = "/cygdrive/";
    @NotNull
    private static final String NICE_PATH = "/usr/bin/nice";
    @NotNull
    private static final Lazy<Boolean> hasNice$delegate = LazyKt.lazy(GitExecutable::hasNice_delegate$lambda$0);
    @NotNull
    private static final String SETSID_PATH = "/usr/bin/setsid";
    @NotNull
    private static final Lazy<Boolean> hasSetSid$delegate = LazyKt.lazy(GitExecutable::hasSetSid_delegate$lambda$0);

    private GitExecutable() {
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getExePath();

    public abstract boolean isLocal();

    public boolean isRemote() {
        return !this.isLocal();
    }

    @NotNull
    public abstract String convertFilePath(@NotNull Path var1);

    @NotNull
    public abstract Path convertFilePathBack(@NotNull String var1, @NotNull Path var2);

    public abstract void patchCommandLine(@NotNull GitHandler var1, @NotNull GeneralCommandLine var2, @NotNull GitExecutableContext var3) throws ExecutionException;

    @NotNull
    public abstract GeneralCommandLine createBundledCommandLine(@NotNull Project var1, String ... var2) throws ExecutionException;

    @NotNull
    public abstract Map<String, String> getLocaleEnv();

    public abstract long getModificationTime();

    private static final boolean hasNice_delegate$lambda$0() {
        return Files.exists(Path.of(NICE_PATH, new String[0]), new LinkOption[0]);
    }

    private static final boolean hasSetSid_delegate$lambda$0() {
        return Files.exists(Path.of(SETSID_PATH, new String[0]), new LinkOption[0]);
    }

    public /* synthetic */ GitExecutable(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0018H\u0002J(\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\t2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lgit4idea/config/GitExecutable$Companion;", "", "<init>", "()V", "CYGDRIVE_PREFIX", "", "getCYGDRIVE_PREFIX$annotations", "NICE_PATH", "hasNice", "", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "SETSID_PATH", "hasSetSid", "getHasSetSid", "hasSetSid$delegate", "setupLowPriorityExecution", "", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "isWindows", "nicePath", "Lkotlin/Function0;", "setupNoTtyExecution", "wait", "setSidPath", "intellij.vcs.git"})
    private static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getCYGDRIVE_PREFIX$annotations() {
        }

        private final boolean getHasNice() {
            Lazy lazy = hasNice$delegate;
            return (Boolean)lazy.getValue();
        }

        private final boolean getHasSetSid() {
            Lazy lazy = hasSetSid$delegate;
            return (Boolean)lazy.getValue();
        }

        private final void setupLowPriorityExecution(GeneralCommandLine commandLine, boolean isWindows, Function0<String> nicePath) {
            if (Registry.Companion.is("ide.allow.low.priority.process")) {
                if (isWindows) {
                    String[] stringArray = new String[]{"/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote((String)"")};
                    v0 = commandLine.withWrappingCommand(CommandLineUtil.getWinShellName(), stringArray);
                } else {
                    String string = (String)nicePath.invoke();
                    if (string != null) {
                        String nicePathValue = string;
                        boolean bl = false;
                        String[] stringArray = new String[]{"-n", "10"};
                        v0 = commandLine.withWrappingCommand(nicePathValue, stringArray);
                    } else {
                        v0 = null;
                    }
                }
            }
        }

        private final void setupNoTtyExecution(GeneralCommandLine commandLine, boolean wait, Function0<String> setSidPath) {
            String string = (String)setSidPath.invoke();
            if (string != null) {
                String setSidPathValue = string;
                boolean bl = false;
                if (wait) {
                    String[] stringArray = new String[]{"-w"};
                    v1 = commandLine.withWrappingCommand(setSidPathValue, stringArray);
                } else {
                    v1 = commandLine.withWrappingCommand(setSidPathValue, new String[0]);
                }
            } else {
                v1 = null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0003;<=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J)\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0,\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u0018\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u0013\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u00130/H\u0016J$\u00100\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010/2\u0006\u0010\u0004\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u00101J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0005H\u00c6\u0003J\u001d\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u00105\u001a\u00020\u00162\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0083\u0004J\n\u00108\u001a\u000209H\u00d6\u0081\u0004J\n\u0010:\u001a\u00020\rH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0017\u00a8\u0006>"}, d2={"Lgit4idea/config/GitExecutable$Eel;", "Lgit4idea/config/GitExecutable;", "exeEelPath", "Lcom/intellij/platform/eel/path/EelPath;", "eel", "Lcom/intellij/platform/eel/EelApi;", "<init>", "(Lcom/intellij/platform/eel/path/EelPath;Lcom/intellij/platform/eel/EelApi;)V", "getExeEelPath", "()Lcom/intellij/platform/eel/path/EelPath;", "getEel", "()Lcom/intellij/platform/eel/EelApi;", "exePath", "", "getExePath", "()Ljava/lang/String;", "delegate", "Lgit4idea/config/GitExecutable$Local;", "id", "Lorg/jetbrains/annotations/NonNls;", "getId", "isLocal", "", "()Z", "convertFilePath", "file", "Ljava/nio/file/Path;", "getModificationTime", "", "convertFilePathBack", "path", "workingDir", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "executableContext", "Lgit4idea/config/GitExecutableContext;", "createBundledCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "getLocaleEnv", "", "computeEelSupportedLocaleKey", "(Lcom/intellij/platform/eel/EelApi;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "NiceKey", "SetSidKey", "EelSupportedLocaleKey", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitExecutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutable$Eel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,407:1\n1586#2:408\n1661#2,3:409\n1642#2,10:412\n1915#2:422\n1916#2:424\n1652#2:425\n1#3:423\n1#3:426\n13#4:427\n13#4:428\n13#4:429\n*S KotlinDebug\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutable$Eel\n*L\n188#1:408\n188#1:409,3\n190#1:412,10\n190#1:422\n190#1:424\n190#1:425\n190#1:423\n253#1:427\n265#1:428\n271#1:429\n*E\n"})
    public static final class Eel
    extends GitExecutable {
        @NotNull
        private final EelPath exeEelPath;
        @NotNull
        private final EelApi eel;
        @NotNull
        private final String exePath;
        @NotNull
        private final Local delegate;
        @NotNull
        private final String id;
        private final boolean isLocal;

        public Eel(@NotNull EelPath exeEelPath, @NotNull EelApi eel) {
            Intrinsics.checkNotNullParameter((Object)exeEelPath, (String)"exeEelPath");
            Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
            super(null);
            this.exeEelPath = exeEelPath;
            this.eel = eel;
            this.exePath = this.exeEelPath.toString();
            this.delegate = new Local(this.getExePath());
            this.id = this.eel.getDescriptor().toString();
            this.isLocal = this.eel.getDescriptor() == LocalEelDescriptor.INSTANCE;
        }

        @NotNull
        public final EelPath getExeEelPath() {
            return this.exeEelPath;
        }

        @NotNull
        public final EelApi getEel() {
            return this.eel;
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return EelNioBridgeServiceKt.asEelPath((Path)file).toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getModificationTime() {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            List<String> list = GitExecutableDetector.getDependencyPaths(this.exeEelPath.toString(), this.eel.getPlatform() instanceof EelPlatform.Darwin);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencyPaths(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                EelFileSystemApi eelFileSystemApi = this.eel.getFs();
                Intrinsics.checkNotNull((Object)it);
                collection.add(EelFileSystemApiKt.getPath((EelFileSystemApi)eelFileSystemApi, (String)it));
            }
            List dependencies = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.exeEelPath), (Iterable)dependencies);
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long it$iv$iv;
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                EelPath path = (EelPath)element$iv$iv;
                boolean bl2 = false;
                Object object2 = this;
                try {
                    Eel $this$getModificationTime_u24lambda_u241_u240 = object2;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)Files.getLastModifiedTime(EelNioBridgeServiceKt.asNioPath((EelPath)path), new LinkOption[0]).toMillis());
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                if ((Long)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
            return l != null ? l : 0L;
        }

        @Override
        @NotNull
        public Path convertFilePathBack(@NotNull String path, @NotNull Path workingDir) {
            Path path2;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (this.isLocal()) {
                path2 = this.delegate.convertFilePathBack(path, workingDir);
            } else {
                Path path3 = workingDir.resolve(path);
                path2 = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            }
            return path2;
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            if (executableContext.isWithLowPriority()) {
                Companion.setupLowPriorityExecution(commandLine, this.eel.getPlatform() instanceof EelPlatform.Windows, (Function0<String>)() -> Eel.patchCommandLine$lambda$0(this));
            }
            if (this.isLocal() && executableContext.isWithNoTty()) {
                Companion.setupNoTtyExecution(commandLine, false, (Function0<String>)() -> Eel.patchCommandLine$lambda$1(this));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@NotNull Project project, String ... command) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            GeneralCommandLine generalCommandLine = this.delegate.doCreateBundledCommandLine$intellij_vcs_git(project, this.eel.getPlatform() instanceof EelPlatform.Windows, Arrays.copyOf(command, command.length));
            String string = project.getBasePath();
            if (string != null) {
                void it;
                String string2 = string;
                GeneralCommandLine generalCommandLine2 = generalCommandLine;
                boolean bl = false;
                Path path2 = Paths.get((String)it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                path = path2;
                generalCommandLine = generalCommandLine2;
            } else {
                path = null;
            }
            GeneralCommandLine generalCommandLine3 = generalCommandLine.withWorkingDirectory(path);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine3, (String)"withWorkingDirectory(...)");
            return generalCommandLine3;
        }

        @Override
        @NotNull
        public Map<String, String> getLocaleEnv() {
            Map userLocale = VcsLocaleHelper.INSTANCE.getEnvFromRegistry("git");
            if (userLocale != null) {
                return userLocale;
            }
            Map envMap2 = (Map)GitConfigurationCache.Companion.getInstance().computeCachedValue(new EelSupportedLocaleKey(this.eel.getDescriptor()), () -> Eel.getLocaleEnv$lambda$0(this));
            if (envMap2 != null) {
                return envMap2;
            }
            return VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"git");
        }

        /*
         * Unable to fully structure code
         */
        private final Object computeEelSupportedLocaleKey(EelApi eel, Continuation<? super Map<String, String>> $completion) {
            if (!($completion instanceof computeEelSupportedLocaleKey.1)) ** GOTO lbl-1000
            var12_3 = $completion;
            if ((var12_3.label & -2147483648) != 0) {
                var12_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Eel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Eel.access$computeEelSupportedLocaleKey(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_6 = new VcsLocaleHelper.Locale[]{VcsLocaleHelper.INSTANCE.getEN_UTF_LOCALE(), VcsLocaleHelper.INSTANCE.getC_UTF_LOCALE()};
                    knownLocales = CollectionsKt.listOf((Object[])var4_6);
                    $continuation.L$0 = eel;
                    $continuation.L$1 = knownLocales;
                    $continuation.label = 1;
                    v0 = EelExecApiHelpersKt.environmentVariables((EelExecApi)eel.getExec()).eelIt((Continuation)$continuation);
                    ** if (v0 != var13_5) goto lbl22
lbl21:
                    // 1 sources

                    return var13_5;
lbl22:
                    // 1 sources

                    ** GOTO lbl30
                }
                case 1: {
                    knownLocales = (List)$continuation.L$1;
                    eel = (EelApi)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    $continuation.L$0 = eel;
                    $continuation.L$1 = knownLocales;
                    $continuation.label = 2;
                    v1 = ((EelExecApi.EnvironmentVariablesDeferred)v0).await((Continuation)$continuation);
                    ** if (v1 != var13_5) goto lbl36
lbl35:
                    // 1 sources

                    return var13_5;
lbl36:
                    // 1 sources

                    ** GOTO lbl44
                }
                case 2: {
                    knownLocales = (List)$continuation.L$1;
                    eel = (EelApi)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl44:
                    // 2 sources

                    if ((env = (String)((Map)v1).get("LANG")) != null && (envLocale = VcsLocaleHelper.INSTANCE.findMatchingLocale(env, knownLocales)) != null) {
                        $i$f$logger = false;
                        v2 = Logger.getInstance(EelSupportedLocaleKey.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.debug("Detected locale by ENV: " + env);
                        return envLocale;
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eel);
                    $continuation.L$1 = knownLocales;
                    $continuation.L$2 = env;
                    $continuation.label = 3;
                    v3 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(eel, null){
                        int label;
                        final /* synthetic */ EelApi $eel;
                        {
                            this.$eel = $eel;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    var2_3 = new String[]{"-a"};
                                    this.label = 1;
                                    v0 = EelExecApiHelpersKt.spawnProcess((EelExecApi)this.$eel.getExec(), (String)"locale").args(var2_3).eelIt((Continuation)this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl14
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl14:
                                    // 2 sources

                                    this.label = 2;
                                    v1 = EelProcessUtilsKt.awaitProcessResult((EelProcess)((EelProcess)v0), (Continuation)((Continuation)this));
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl22
                                }
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl22:
                                    // 2 sources

                                    return ((EelProcessExecutionResult)v1).getStdout().toString();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v3 != var13_5) goto lbl57
lbl56:
                    // 1 sources

                    return var13_5;
lbl57:
                    // 1 sources

                    ** GOTO lbl66
                }
                case 3: {
                    env = (String)$continuation.L$2;
                    knownLocales = (List)$continuation.L$1;
                    eel = (EelApi)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl66:
                        // 2 sources

                        locales = (String)v3;
                        systemLocales = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)locales), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeEelSupportedLocaleKey$lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeEelSupportedLocaleKey$lambda$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)());
                        for (String locale : systemLocales) {
                            someLocale = VcsLocaleHelper.INSTANCE.findMatchingLocale(locale, knownLocales);
                            if (someLocale == null) continue;
                            $i$f$logger = false;
                            v4 = Logger.getInstance(EelSupportedLocaleKey.class);
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                            v4.debug("Detected locale from available: " + env);
                            return someLocale;
                        }
                    }
                    catch (IOException e) {
                        $i$f$logger = false;
                        v5 = Logger.getInstance(EelSupportedLocaleKey.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                        v5.warn((Throwable)e);
                        return null;
                    }
                    return null;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @NotNull
        public final EelPath component1() {
            return this.exeEelPath;
        }

        @NotNull
        public final EelApi component2() {
            return this.eel;
        }

        @NotNull
        public final Eel copy(@NotNull EelPath exeEelPath, @NotNull EelApi eel) {
            Intrinsics.checkNotNullParameter((Object)exeEelPath, (String)"exeEelPath");
            Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
            return new Eel(exeEelPath, eel);
        }

        public static /* synthetic */ Eel copy$default(Eel eel, EelPath eelPath, EelApi eelApi, int n, Object object) {
            if ((n & 1) != 0) {
                eelPath = eel.exeEelPath;
            }
            if ((n & 2) != 0) {
                eelApi = eel.eel;
            }
            return eel.copy(eelPath, eelApi);
        }

        @NotNull
        public String toString() {
            return "Eel(exeEelPath=" + this.exeEelPath + ", eel=" + this.eel + ")";
        }

        public int hashCode() {
            int result2 = this.exeEelPath.hashCode();
            result2 = result2 * 31 + this.eel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Eel)) {
                return false;
            }
            Eel eel = (Eel)other;
            if (!Intrinsics.areEqual((Object)this.exeEelPath, (Object)eel.exeEelPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eel, (Object)eel.eel);
        }

        private static final EelPath patchCommandLine$lambda$0$0(Eel this$0) {
            return (EelPath)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelPath>, Object>(this$0, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Eel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$runBlockingCancellable;
                            void $this$mapTo$iv$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            Object[] objectArray = new String[]{"nice", "/usr/bin/nice"};
                            Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                            Eel eel = this.this$0;
                            boolean $i$f$map = false;
                            Iterable iterable2 = iterable;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                String string = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(BuildersKt.async$default((CoroutineScope)$this$runBlockingCancellable, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends EelPath>>, Object>(eel, (String)it, null){
                                    int label;
                                    final /* synthetic */ Eel this$0;
                                    final /* synthetic */ String $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = this.this$0.getEel().getExec().findExeFilesInPath(this.$it, (Continuation)this);
                                                if (object2 != object) return object2;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return object2;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends EelPath>> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null));
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingCancellable);
                            this.label = 1;
                            Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                            if (object2 != object) return CollectionsKt.firstOrNull((List)CollectionsKt.flatten((Iterable)((Iterable)object2)));
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return CollectionsKt.firstOrNull((List)CollectionsKt.flatten((Iterable)((Iterable)object2)));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super EelPath> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private static final EelPath patchCommandLine$lambda$1$0(Eel this$0) {
            return (EelPath)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EelPath>, Object>(this$0, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Eel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$runBlockingCancellable;
                            void $this$mapTo$iv$iv;
                            ResultKt.throwOnFailure((Object)$result);
                            Object[] objectArray = new String[]{"setsid", "/usr/bin/setsid"};
                            Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                            Eel eel = this.this$0;
                            boolean $i$f$map = false;
                            Iterable iterable2 = iterable;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                String string = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(BuildersKt.async$default((CoroutineScope)$this$runBlockingCancellable, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends EelPath>>, Object>(eel, (String)it, null){
                                    int label;
                                    final /* synthetic */ Eel this$0;
                                    final /* synthetic */ String $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = this.this$0.getEel().getExec().findExeFilesInPath(this.$it, (Continuation)this);
                                                if (object2 != object) return object2;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return object2;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends EelPath>> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null));
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$runBlockingCancellable);
                            this.label = 1;
                            Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                            if (object2 != object) return CollectionsKt.firstOrNull((List)CollectionsKt.flatten((Iterable)((Iterable)object2)));
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return CollectionsKt.firstOrNull((List)CollectionsKt.flatten((Iterable)((Iterable)object2)));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super EelPath> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private static final String patchCommandLine$lambda$0(Eel this$0) {
            Path path;
            EelPath eelPath = (EelPath)GitConfigurationCache.Companion.getInstance().computeCachedValue(new NiceKey(this$0.eel.getDescriptor()), () -> Eel.patchCommandLine$lambda$0$0(this$0));
            return eelPath != null && (path = EelNioBridgeServiceKt.asNioPath((EelPath)eelPath)) != null ? ((Object)path).toString() : null;
        }

        private static final String patchCommandLine$lambda$1(Eel this$0) {
            Path path;
            EelPath eelPath = (EelPath)GitConfigurationCache.Companion.getInstance().computeCachedValue(new SetSidKey(this$0.eel.getDescriptor()), () -> Eel.patchCommandLine$lambda$1$0(this$0));
            return eelPath != null && (path = EelNioBridgeServiceKt.asNioPath((EelPath)eelPath)) != null ? ((Object)path).toString() : null;
        }

        private static final Map getLocaleEnv$lambda$0(Eel this$0) {
            return (Map)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends String>>, Object>(this$0, null){
                int label;
                final /* synthetic */ Eel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = Eel.access$computeEelSupportedLocaleKey(this.this$0, this.this$0.getEel(), (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, String>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private static final String computeEelSupportedLocaleKey$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((Object)StringsKt.trim((CharSequence)it)).toString();
        }

        private static final boolean computeEelSupportedLocaleKey$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !StringsKt.isBlank((CharSequence)it);
        }

        public static final /* synthetic */ Object access$computeEelSupportedLocaleKey(Eel $this, EelApi eel, Continuation $completion) {
            return $this.computeEelSupportedLocaleKey(eel, (Continuation<? super Map<String, String>>)$completion);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lgit4idea/config/GitExecutable$Eel$EelSupportedLocaleKey;", "Lgit4idea/repo/GitConfigKey;", "", "", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;)V", "getEelDescriptor", "()Lcom/intellij/platform/eel/EelDescriptor;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
        private static final class EelSupportedLocaleKey
        implements GitConfigKey<Map<String, ? extends String>> {
            @NotNull
            private final EelDescriptor eelDescriptor;

            public EelSupportedLocaleKey(@NotNull EelDescriptor eelDescriptor) {
                Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
                this.eelDescriptor = eelDescriptor;
            }

            @NotNull
            public final EelDescriptor getEelDescriptor() {
                return this.eelDescriptor;
            }

            @NotNull
            public final EelDescriptor component1() {
                return this.eelDescriptor;
            }

            @NotNull
            public final EelSupportedLocaleKey copy(@NotNull EelDescriptor eelDescriptor) {
                Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
                return new EelSupportedLocaleKey(eelDescriptor);
            }

            public static /* synthetic */ EelSupportedLocaleKey copy$default(EelSupportedLocaleKey eelSupportedLocaleKey, EelDescriptor eelDescriptor, int n, Object object) {
                if ((n & 1) != 0) {
                    eelDescriptor = eelSupportedLocaleKey.eelDescriptor;
                }
                return eelSupportedLocaleKey.copy(eelDescriptor);
            }

            @NotNull
            public String toString() {
                return "EelSupportedLocaleKey(eelDescriptor=" + this.eelDescriptor + ")";
            }

            public int hashCode() {
                return this.eelDescriptor.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EelSupportedLocaleKey)) {
                    return false;
                }
                EelSupportedLocaleKey eelSupportedLocaleKey = (EelSupportedLocaleKey)other;
                return Intrinsics.areEqual((Object)this.eelDescriptor, (Object)eelSupportedLocaleKey.eelDescriptor);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lgit4idea/config/GitExecutable$Eel$NiceKey;", "Lgit4idea/repo/GitConfigKey;", "Lcom/intellij/platform/eel/path/EelPath;", "eel", "Lcom/intellij/platform/eel/EelDescriptor;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;)V", "getEel", "()Lcom/intellij/platform/eel/EelDescriptor;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
        private static final class NiceKey
        implements GitConfigKey<EelPath> {
            @NotNull
            private final EelDescriptor eel;

            public NiceKey(@NotNull EelDescriptor eel) {
                Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
                this.eel = eel;
            }

            @NotNull
            public final EelDescriptor getEel() {
                return this.eel;
            }

            @NotNull
            public final EelDescriptor component1() {
                return this.eel;
            }

            @NotNull
            public final NiceKey copy(@NotNull EelDescriptor eel) {
                Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
                return new NiceKey(eel);
            }

            public static /* synthetic */ NiceKey copy$default(NiceKey niceKey, EelDescriptor eelDescriptor, int n, Object object) {
                if ((n & 1) != 0) {
                    eelDescriptor = niceKey.eel;
                }
                return niceKey.copy(eelDescriptor);
            }

            @NotNull
            public String toString() {
                return "NiceKey(eel=" + this.eel + ")";
            }

            public int hashCode() {
                return this.eel.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NiceKey)) {
                    return false;
                }
                NiceKey niceKey = (NiceKey)other;
                return Intrinsics.areEqual((Object)this.eel, (Object)niceKey.eel);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lgit4idea/config/GitExecutable$Eel$SetSidKey;", "Lgit4idea/repo/GitConfigKey;", "Lcom/intellij/platform/eel/path/EelPath;", "eel", "Lcom/intellij/platform/eel/EelDescriptor;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;)V", "getEel", "()Lcom/intellij/platform/eel/EelDescriptor;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.vcs.git"})
        private static final class SetSidKey
        implements GitConfigKey<EelPath> {
            @NotNull
            private final EelDescriptor eel;

            public SetSidKey(@NotNull EelDescriptor eel) {
                Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
                this.eel = eel;
            }

            @NotNull
            public final EelDescriptor getEel() {
                return this.eel;
            }

            @NotNull
            public final EelDescriptor component1() {
                return this.eel;
            }

            @NotNull
            public final SetSidKey copy(@NotNull EelDescriptor eel) {
                Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
                return new SetSidKey(eel);
            }

            public static /* synthetic */ SetSidKey copy$default(SetSidKey setSidKey, EelDescriptor eelDescriptor, int n, Object object) {
                if ((n & 1) != 0) {
                    eelDescriptor = setSidKey.eel;
                }
                return setSidKey.copy(eelDescriptor);
            }

            @NotNull
            public String toString() {
                return "SetSidKey(eel=" + this.eel + ")";
            }

            public int hashCode() {
                return this.eel.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SetSidKey)) {
                    return false;
                }
                SetSidKey setSidKey = (SetSidKey)other;
                return Intrinsics.areEqual((Object)this.eel, (Object)setSidKey.eel);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\r\u001a\u00020\u0003H\u0096\u0080\u0004J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J3\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020\u000b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100!H\u0000\u00a2\u0006\u0002\b\"J3\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000b2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030(\"\u00020\u0003H\u0000\u00a2\u0006\u0004\b)\u0010*J)\u0010+\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030(\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030.H\u0002J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000300H\u0016J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\u0013\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u00103\u001a\u00020\u000b2\b\u00104\u001a\u0004\u0018\u000105H\u00d6\u0083\u0004J\n\u00106\u001a\u000207H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\f\u00a8\u00068"}, d2={"Lgit4idea/config/GitExecutable$Local;", "Lgit4idea/config/GitExecutable;", "exePath", "", "<init>", "(Ljava/lang/String;)V", "getExePath", "()Ljava/lang/String;", "id", "getId", "isLocal", "", "()Z", "toString", "convertFilePath", "file", "Ljava/nio/file/Path;", "convertFilePathBack", "path", "workingDir", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "executableContext", "Lgit4idea/config/GitExecutableContext;", "getModificationTime", "", "pathVariable", "isMac", "toPath", "Lkotlin/Function1;", "getModificationTime$intellij_vcs_git", "doCreateBundledCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "isWindows", "command", "", "doCreateBundledCommandLine$intellij_vcs_git", "(Lcom/intellij/openapi/project/Project;Z[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "createBundledCommandLine", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "buildShellCommand", "", "getLocaleEnv", "", "component1", "copy", "equals", "other", "", "hashCode", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitExecutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutable$Local\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1586#2:408\n1661#2,3:409\n1#3:412\n*S KotlinDebug\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutable$Local\n*L\n139#1:408\n139#1:409,3\n*E\n"})
    public static final class Local
    extends GitExecutable {
        @NotNull
        private final String exePath;
        @NotNull
        private final String id;
        private final boolean isLocal;

        public Local(@NotNull String exePath) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            super(null);
            this.exePath = exePath;
            this.id = "local";
            this.isLocal = true;
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.getExePath();
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return ((Object)file.toAbsolutePath()).toString();
        }

        @Override
        @NotNull
        public Path convertFilePathBack(@NotNull String path, @NotNull Path workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            if (SystemInfo.isWindows && StringsKt.startsWith$default((String)path, (String)GitExecutable.CYGDRIVE_PREFIX, (boolean)false, (int)2, null)) {
                int prefixSize = 10;
                String string = path.substring(prefixSize, prefixSize + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = path.substring(prefixSize + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String localPath = string + ":" + string2;
                Path path2 = Paths.get(localPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                return path2;
            }
            Path path3 = workingDir.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            return path3;
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            if (executableContext.isWithLowPriority()) {
                Companion.setupLowPriorityExecution(commandLine, SystemInfo.isWindows, (Function0<String>)Local::patchCommandLine$lambda$0);
            }
            if (executableContext.isWithNoTty()) {
                Companion.setupNoTtyExecution(commandLine, false, (Function0<String>)Local::patchCommandLine$lambda$1);
            }
        }

        @Override
        public long getModificationTime() {
            return this.getModificationTime$intellij_vcs_git(PathEnvironmentVariableUtil.getPathVariableValue(), SystemInfo.isMac, (Function1<? super String, ? extends Path>)((Function1)getModificationTime.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        public final long getModificationTime$intellij_vcs_git(@Nullable String pathVariable, boolean isMac, @NotNull Function1<? super String, ? extends Path> toPath) {
            void $this$mapTo$iv$iv;
            File exeFile;
            Intrinsics.checkNotNullParameter(toPath, (String)"toPath");
            String filePath = this.getExePath();
            CharSequence charSequence = filePath;
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null) && (exeFile = PathEnvironmentVariableUtil.findInPath((String)filePath, (String)pathVariable, null)) != null) {
                String string2 = exeFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                filePath = string2;
            }
            Path executablePath = (Path)toPath.invoke((Object)filePath);
            long modificationTime = 0L;
            modificationTime = Files.getLastModifiedTime(executablePath, new LinkOption[0]).toMillis();
            List<String> list = GitExecutableDetector.getDependencyPaths(((Object)executablePath).toString(), isMac);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencyPaths(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(toPath.invoke(item$iv$iv));
            }
            for (Path dependencyPath : (List)destination$iv$iv) {
                Local local = this;
                try {
                    Local $this$getModificationTime_u24lambda_u240 = local;
                    boolean bl = false;
                    long depTime = Files.getLastModifiedTime(dependencyPath, new LinkOption[0]).toMillis();
                    modificationTime = RangesKt.coerceAtLeast((long)modificationTime, (long)depTime);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
            }
            return modificationTime;
        }

        @NotNull
        public final GeneralCommandLine doCreateBundledCommandLine$intellij_vcs_git(@NotNull Project project, boolean isWindows, String ... command) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (isWindows) {
                String string = GitExecutableDetector.getBashExecutablePath(project, this.getExePath());
                if (string == null) {
                    throw new ExecutionException(GitBundle.message((String)"git.executable.error.bash.not.found", (Object[])new Object[0]));
                }
                String bashPath = string;
                String[] stringArray = new String[]{"-c"};
                GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(bashPath).withParameters(stringArray);
                stringArray = new String[]{this.buildShellCommand(ArraysKt.toList((Object[])command))};
                GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParameters(...)");
                return generalCommandLine2;
            }
            return new GeneralCommandLine(Arrays.copyOf(command, command.length));
        }

        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@NotNull Project project, String ... command) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return this.doCreateBundledCommandLine$intellij_vcs_git(project, SystemInfo.isWindows, Arrays.copyOf(command, command.length));
        }

        private final String buildShellCommand(List<String> commandLine) {
            return CollectionsKt.joinToString$default((Iterable)commandLine, (CharSequence)" ", null, null, (int)0, null, Local::buildShellCommand$lambda$0, (int)30, null);
        }

        @Override
        @NotNull
        public Map<String, String> getLocaleEnv() {
            return VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"git");
        }

        @NotNull
        public final String component1() {
            return this.exePath;
        }

        @NotNull
        public final Local copy(@NotNull String exePath) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            return new Local(exePath);
        }

        public static /* synthetic */ Local copy$default(Local local, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = local.exePath;
            }
            return local.copy(string);
        }

        public int hashCode() {
            return this.exePath.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            return Intrinsics.areEqual((Object)this.exePath, (Object)local.exePath);
        }

        private static final String patchCommandLine$lambda$0() {
            String string;
            String it = string = GitExecutable.NICE_PATH;
            boolean bl = false;
            return Companion.getHasNice() ? string : null;
        }

        private static final String patchCommandLine$lambda$1() {
            String string;
            String it = string = GitExecutable.SETSID_PATH;
            boolean bl = false;
            return SystemInfo.isLinux && Companion.getHasSetSid() ? string : null;
        }

        private static final CharSequence buildShellCommand$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = CommandLineUtil.posixQuote((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixQuote(...)");
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u0011\u001a\u00020\u0003H\u0096\u0080\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J)\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030&\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010'J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030)H\u0016J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010,\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J,\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0014\u0010.\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0083\u0004J\n\u00101\u001a\u000202H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u00063"}, d2={"Lgit4idea/config/GitExecutable$Unknown;", "Lgit4idea/config/GitExecutable;", "id", "", "exePath", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getExePath", "getErrorMessage", "isLocal", "", "()Z", "isRemote", "toString", "getModificationTime", "", "convertFilePath", "file", "Ljava/nio/file/Path;", "convertFilePathBack", "path", "workingDir", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "executableContext", "Lgit4idea/config/GitExecutableContext;", "createBundledCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "getLocaleEnv", "", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "intellij.vcs.git"})
    public static final class Unknown
    extends GitExecutable {
        @NotNull
        private final String id;
        @NotNull
        private final String exePath;
        @NotNull
        private final String errorMessage;
        private final boolean isLocal;
        private final boolean isRemote;

        public Unknown(@NotNull String id, @NotNull String exePath, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            super(null);
            this.id = id;
            this.exePath = exePath;
            this.errorMessage = errorMessage;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @Override
        public boolean isRemote() {
            return this.isRemote;
        }

        @NotNull
        public String toString() {
            return this.getId() + ": " + this.getExePath();
        }

        @Override
        public long getModificationTime() {
            return 0L;
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return ((Object)file.toAbsolutePath()).toString();
        }

        @Override
        @NotNull
        public Path convertFilePathBack(@NotNull String path, @NotNull Path workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            return path2;
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            throw new ExecutionException(this.errorMessage);
        }

        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@NotNull Project project, String ... command) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            throw new ExecutionException(this.errorMessage);
        }

        @Override
        @NotNull
        public Map<String, String> getLocaleEnv() {
            return MapsKt.emptyMap();
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.exePath;
        }

        @NotNull
        public final String component3() {
            return this.errorMessage;
        }

        @NotNull
        public final Unknown copy(@NotNull String id, @NotNull String exePath, @NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            return new Unknown(id, exePath, errorMessage);
        }

        public static /* synthetic */ Unknown copy$default(Unknown unknown, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = unknown.id;
            }
            if ((n & 2) != 0) {
                string2 = unknown.exePath;
            }
            if ((n & 4) != 0) {
                string3 = unknown.errorMessage;
            }
            return unknown.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.exePath.hashCode();
            result2 = result2 * 31 + this.errorMessage.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unknown)) {
                return false;
            }
            Unknown unknown = (Unknown)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)unknown.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.exePath, (Object)unknown.exePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)unknown.errorMessage);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0011\u001a\u00020\u0003H\u0096\u0080\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J)\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030&\"\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010'J$\u0010(\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030,H\u0016J\u001e\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010,2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\u001d\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u00101\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0083\u0004J\n\u00104\u001a\u000205H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010\u00a8\u00067"}, d2={"Lgit4idea/config/GitExecutable$Wsl;", "Lgit4idea/config/GitExecutable;", "exePath", "", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/wsl/WSLDistribution;)V", "getExePath", "()Ljava/lang/String;", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "id", "getId", "isLocal", "", "()Z", "toString", "getModificationTime", "", "convertFilePath", "file", "Ljava/nio/file/Path;", "convertFilePathBack", "path", "workingDir", "patchCommandLine", "", "handler", "Lgit4idea/commands/GitHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "executableContext", "Lgit4idea/config/GitExecutableContext;", "createBundledCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "command", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "patchWslExecutable", "wslOptions", "Lcom/intellij/execution/wsl/WSLCommandLineOptions;", "getLocaleEnv", "", "computeWslSupportedLocaleKey", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "WslSupportedLocaleKey", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitExecutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutable$Wsl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n13#2:408\n13#2:409\n13#2:410\n1#3:411\n*S KotlinDebug\n*F\n+ 1 GitExecutable.kt\ngit4idea/config/GitExecutable$Wsl\n*L\n358#1:408\n370#1:409\n376#1:410\n*E\n"})
    public static final class Wsl
    extends GitExecutable {
        @NotNull
        private final String exePath;
        @NotNull
        private final WSLDistribution distribution;
        @NotNull
        private final String id;
        private final boolean isLocal;

        public Wsl(@NotNull String exePath, @NotNull WSLDistribution distribution) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            super(null);
            this.exePath = exePath;
            this.distribution = distribution;
            this.id = "wsl-" + this.distribution.getId();
        }

        @Override
        @NotNull
        public String getExePath() {
            return this.exePath;
        }

        @NotNull
        public final WSLDistribution getDistribution() {
            return this.distribution;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isLocal() {
            return this.isLocal;
        }

        @NotNull
        public String toString() {
            return this.distribution.getPresentableName() + ": " + this.getExePath();
        }

        @Override
        public long getModificationTime() {
            return 0L;
        }

        @Override
        @NotNull
        public String convertFilePath(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String path = ((Object)file.toAbsolutePath()).toString();
            String wslPath = this.distribution.getWslPath(file.toAbsolutePath());
            String string = wslPath;
            if (string == null) {
                string = path;
            }
            return string;
        }

        @Override
        @NotNull
        public Path convertFilePathBack(@NotNull String path, @NotNull Path workingDir) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            String string = this.distribution.getWindowsPath(path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWindowsPath(...)");
            Path path2 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            return path2;
        }

        @Override
        public void patchCommandLine(@NotNull GitHandler handler, @NotNull GeneralCommandLine commandLine, @NotNull GitExecutableContext executableContext) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)executableContext), (String)"executableContext");
            if (executableContext.isWithNoTty()) {
                Companion.setupNoTtyExecution(commandLine, Registry.Companion.is("git.use.setsid.wait.for.wsl.ssh"), (Function0<String>)Wsl::patchCommandLine$lambda$0);
            }
            this.patchWslExecutable(handler.project(), commandLine, executableContext.getWslOptions());
        }

        @Override
        @NotNull
        public GeneralCommandLine createBundledCommandLine(@NotNull Project project, String ... command) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            GeneralCommandLine commandLine = new GeneralCommandLine(Arrays.copyOf(command, command.length));
            this.patchWslExecutable(project, commandLine, null);
            return commandLine;
        }

        private final void patchWslExecutable(Project project, GeneralCommandLine commandLine, WSLCommandLineOptions wslOptions) {
            WSLCommandLineOptions options2;
            WSLCommandLineOptions wSLCommandLineOptions = wslOptions;
            if (wSLCommandLineOptions == null) {
                wSLCommandLineOptions = options2 = new WSLCommandLineOptions();
            }
            if (Registry.Companion.is("git.wsl.exe.executable.no.shell")) {
                options2.setLaunchWithWslExe(true);
                options2.setExecuteCommandInShell(false);
                options2.setPassEnvVarsUsingInterop(true);
            } else {
                options2.setExecuteCommandInLoginShell(Registry.Companion.is("git.wsl.exe.executable.login.shell"));
            }
            this.distribution.patchCommandLine(commandLine, project, options2);
        }

        @Override
        @NotNull
        public Map<String, String> getLocaleEnv() {
            if (Registry.Companion.is("git.wsl.exe.executable.detect.lang.by.env")) {
                Map userLocale = VcsLocaleHelper.INSTANCE.getEnvFromRegistry("git");
                if (userLocale != null) {
                    return userLocale;
                }
                Map envMap2 = (Map)GitConfigurationCache.Companion.getInstance().computeCachedValue(new WslSupportedLocaleKey(this.distribution), () -> Wsl.getLocaleEnv$lambda$0(this));
                if (envMap2 != null) {
                    return envMap2;
                }
            }
            return VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"git");
        }

        private final Map<String, String> computeWslSupportedLocaleKey(WSLDistribution distribution) {
            Map envLocale;
            Object[] objectArray = new VcsLocaleHelper.Locale[]{VcsLocaleHelper.INSTANCE.getEN_UTF_LOCALE(), VcsLocaleHelper.INSTANCE.getC_UTF_LOCALE()};
            List knownLocales = CollectionsKt.listOf((Object[])objectArray);
            String env = distribution.getEnvironmentVariable("LANG");
            if (env != null && (envLocale = VcsLocaleHelper.INSTANCE.findMatchingLocale(env, knownLocales)) != null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(WslSupportedLocaleKey.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Detected locale by ENV: " + env);
                return envLocale;
            }
            try {
                WSLCommandLineOptions wSLCommandLineOptions = new WSLCommandLineOptions().setExecuteCommandInLoginShell(false);
                Intrinsics.checkNotNullExpressionValue((Object)wSLCommandLineOptions, (String)"setExecuteCommandInLoginShell(...)");
                WSLCommandLineOptions wslCommandLineOptions = wSLCommandLineOptions;
                String[] stringArray = new String[]{"locale", "-a"};
                String string = distribution.executeOnWsl(CollectionsKt.listOf((Object[])stringArray), wslCommandLineOptions, 10000, null).getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
                String locales2 = string;
                Sequence systemLocales = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)locales2), Wsl::computeWslSupportedLocaleKey$lambda$0), Wsl::computeWslSupportedLocaleKey$lambda$1);
                for (String locale : systemLocales) {
                    Map someLocale = VcsLocaleHelper.INSTANCE.findMatchingLocale(locale, knownLocales);
                    if (someLocale == null) continue;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(WslSupportedLocaleKey.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("Detected locale from available: " + env);
                    return someLocale;
                }
            }
            catch (ExecutionException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitConfigurationCache.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
                return null;
            }
            return null;
        }

        @NotNull
        public final String component1() {
            return this.exePath;
        }

        @NotNull
        public final WSLDistribution component2() {
            return this.distribution;
        }

        @NotNull
        public final Wsl copy(@NotNull String exePath, @NotNull WSLDistribution distribution) {
            Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
            Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
            return new Wsl(exePath, distribution);
        }

        public static /* synthetic */ Wsl copy$default(Wsl wsl, String string, WSLDistribution wSLDistribution, int n, Object object) {
            if ((n & 1) != 0) {
                string = wsl.exePath;
            }
            if ((n & 2) != 0) {
                wSLDistribution = wsl.distribution;
            }
            return wsl.copy(string, wSLDistribution);
        }

        public int hashCode() {
            int result2 = this.exePath.hashCode();
            result2 = result2 * 31 + this.distribution.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Wsl)) {
                return false;
            }
            Wsl wsl = (Wsl)other;
            if (!Intrinsics.areEqual((Object)this.exePath, (Object)wsl.exePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.distribution, (Object)wsl.distribution);
        }

        private static final String patchCommandLine$lambda$0() {
            String string;
            String it = string = GitExecutable.SETSID_PATH;
            boolean bl = false;
            return SystemInfo.isLinux && Companion.getHasSetSid() ? string : null;
        }

        private static final Map getLocaleEnv$lambda$0(Wsl this$0) {
            return this$0.computeWslSupportedLocaleKey(this$0.distribution);
        }

        private static final String computeWslSupportedLocaleKey$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((Object)StringsKt.trim((CharSequence)it)).toString();
        }

        private static final boolean computeWslSupportedLocaleKey$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !StringsKt.isBlank((CharSequence)it);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\n\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lgit4idea/config/GitExecutable$Wsl$WslSupportedLocaleKey;", "Lgit4idea/repo/GitConfigKey;", "", "", "distribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "<init>", "(Lcom/intellij/execution/wsl/WSLDistribution;)V", "getDistribution", "()Lcom/intellij/execution/wsl/WSLDistribution;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
        private static final class WslSupportedLocaleKey
        implements GitConfigKey<Map<String, ? extends String>> {
            @NotNull
            private final WSLDistribution distribution;

            public WslSupportedLocaleKey(@NotNull WSLDistribution distribution) {
                Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
                this.distribution = distribution;
            }

            @NotNull
            public final WSLDistribution getDistribution() {
                return this.distribution;
            }

            @NotNull
            public final WSLDistribution component1() {
                return this.distribution;
            }

            @NotNull
            public final WslSupportedLocaleKey copy(@NotNull WSLDistribution distribution) {
                Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
                return new WslSupportedLocaleKey(distribution);
            }

            public static /* synthetic */ WslSupportedLocaleKey copy$default(WslSupportedLocaleKey wslSupportedLocaleKey, WSLDistribution wSLDistribution, int n, Object object) {
                if ((n & 1) != 0) {
                    wSLDistribution = wslSupportedLocaleKey.distribution;
                }
                return wslSupportedLocaleKey.copy(wSLDistribution);
            }

            @NotNull
            public String toString() {
                return "WslSupportedLocaleKey(distribution=" + this.distribution + ")";
            }

            public int hashCode() {
                return this.distribution.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof WslSupportedLocaleKey)) {
                    return false;
                }
                WslSupportedLocaleKey wslSupportedLocaleKey = (WslSupportedLocaleKey)other;
                return Intrinsics.areEqual((Object)this.distribution, (Object)wslSupportedLocaleKey.distribution);
            }
        }
    }
}

