/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import git4idea.merge.GitConflictAction;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001a\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H$J\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H$\u00a8\u0006\u0018"}, d2={"Lgit4idea/merge/GitConflictAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "text", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/util/function/Supplier;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getConflicts", "", "Lgit4idea/repo/GitConflict;", "project", "Lcom/intellij/openapi/project/Project;", "isEnabled", "", "conflicts", "perform", "intellij.vcs.git"})
public abstract class GitConflictAction
extends DumbAwareAction {
    public GitConflictAction(@NotNull Supplier<String> text2) {
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        super(text2, Presentation.NULL_STRING);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List<GitConflict> nodes = this.getConflicts(project, e);
        e.getPresentation().setVisible(!((Collection)nodes).isEmpty());
        e.getPresentation().setEnabled(this.isEnabled(project, nodes));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        List<GitConflict> nodes = this.getConflicts(project2, e);
        this.perform(project2, nodes);
    }

    private final List<GitConflict> getConflicts(Project project, AnActionEvent e) {
        if (e.getData(ChangesListView.DATA_KEY) == null) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (objectArray == null) {
            return CollectionsKt.emptyList();
        }
        Object[] changes = objectArray;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])changes), GitConflictAction::getConflicts$lambda$0), (Function1)getConflicts.2.INSTANCE), arg_0 -> GitConflictAction.getConflicts$lambda$1(repositoryManager, arg_0)));
    }

    protected abstract boolean isEnabled(@NotNull Project var1, @NotNull List<? extends GitConflict> var2);

    protected abstract void perform(@NotNull Project var1, @NotNull List<? extends GitConflict> var2);

    private static final boolean getConflicts$lambda$0(Change it) {
        return Intrinsics.areEqual((Object)it.getFileStatus(), (Object)FileStatus.MERGED_WITH_CONFLICTS);
    }

    private static final GitConflict getConflicts$lambda$1(GitRepositoryManager $repositoryManager, FilePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = (GitRepository)$repositoryManager.getRepositoryForFileQuick(path);
        return object != null && (object = object.getStagingAreaHolder()) != null ? ((GitStagingAreaHolder)object).findConflict(path) : null;
    }
}

