/*
 * Decompiled with CFR 0.152.
 */
package git4idea.pull;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitPullSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialogKt;
import git4idea.merge.dialog.CmdLabel;
import git4idea.merge.dialog.FlatComboBoxUI;
import git4idea.merge.dialog.GitOptionsPanel;
import git4idea.merge.dialog.GitOptionsPopupBuilder;
import git4idea.merge.dialog.OptionInfo;
import git4idea.pull.GitPullDialog;
import git4idea.pull.GitPullOption;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.ComboBoxWithAutoCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0017\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001O\u0018\u0000 j2\u00020\u0001:\u0001jB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010/\u001a\u00020)H\u0014J\u0016\u00100\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010'0'0&H\u0016J\b\u00101\u001a\u000202H\u0014J\b\u00103\u001a\u00020'H\u0014J\u000e\u00104\u001a\b\u0012\u0004\u0012\u0002050\u0005H\u0014J\b\u00106\u001a\u000207H\u0014J\u000b\u00108\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0011J\u0006\u00109\u001a\u00020\u001cJ\u0006\u0010:\u001a\u00020\u001dJ\u0006\u0010;\u001a\u00020.J\n\u0010<\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010=\u001a\u000207H\u0002J\b\u0010>\u001a\u000207H\u0002J6\u0010?\u001a0\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u001d0\u001d0\u00050\u001b0\u001bH\u0002J*\u0010@\u001a\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u001d0\u001d0\u00050\u001b2\u0006\u0010A\u001a\u00020\u0016H\u0002J\n\u0010B\u001a\u0004\u0018\u000105H\u0002J\n\u0010C\u001a\u0004\u0018\u000105H\u0002J\n\u0010D\u001a\u0004\u0018\u000105H\u0002J\n\u0010E\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010F\u001a\u000207H\u0002J\b\u0010G\u001a\u000207H\u0002J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020'0\u00052\u0006\u0010A\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u001cH\u0002J\u0014\u0010J\u001a\u0004\u0018\u00010\u001c2\b\u0010A\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010K\u001a\u0002072\u0006\u0010L\u001a\u00020\fH\u0002J\b\u0010M\u001a\u000207H\u0002J\u001d\u0010N\u001a\u00020O2\u0006\u0010A\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010PJ\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020\f0!H\u0002J\u0010\u0010R\u001a\u00020.2\u0006\u0010L\u001a\u00020\fH\u0002J\u001d\u0010S\u001a\u0017\u0012\u0013\u0012\u00110'\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\bU\u00a2\u0006\u0002\bV0TH\u0002J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010L\u001a\u00020\fH\u0002J\u000e\u0010X\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J\b\u0010Y\u001a\u000207H\u0002J\u0010\u0010Z\u001a\u00020.2\u0006\u0010L\u001a\u00020\fH\u0002J\b\u0010[\u001a\u000207H\u0002J\b\u0010\\\u001a\u00020)H\u0002J\b\u0010]\u001a\u00020.H\u0002J\b\u0010^\u001a\u00020)H\u0002J\b\u0010_\u001a\u00020`H\u0002J\u0016\u0010a\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160#H\u0002J\u000e\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0002J\u0016\u0010c\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010'0'0&H\u0002J\u0010\u0010d\u001a\u00020)2\u0006\u0010e\u001a\u000202H\u0002J\b\u0010f\u001a\u00020gH\u0002J\u0012\u0010h\u001a\f0'\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\biH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0014\u001a0\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016 \u0017*\u0017\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00180\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0019\u001a0\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u0016\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u001d0\u001d0\u00050\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001f0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010'0'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lgit4idea/pull/GitPullDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "defaultRoot", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "selectedOptions", "", "Lgit4idea/pull/GitPullOption;", "getSelectedOptions", "()Ljava/util/Set;", "fetchSupport", "Lgit4idea/fetch/GitFetchSupport;", "Lorg/jetbrains/annotations/NotNull;", "pullSettings", "Lgit4idea/config/GitPullSettings;", "repositories", "", "Lgit4idea/repo/GitRepository;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Unmodifiable;", "branches", "", "", "Lgit4idea/repo/GitRemote;", "Lgit4idea/GitRemoteBranch;", "optionInfos", "Lgit4idea/merge/dialog/OptionInfo;", "popupBuilder", "Lgit4idea/merge/dialog/GitOptionsPopupBuilder;", "repositoryField", "Lcom/intellij/openapi/ui/ComboBox;", "remoteField", "branchField", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "", "commandPanel", "Ljavax/swing/JPanel;", "optionsPanel", "Lgit4idea/merge/dialog/GitOptionsPanel;", "panel", "isNoVerifySupported", "", "createCenterPanel", "getPreferredFocusedComponent", "createSouthPanel", "Ljavax/swing/JComponent;", "getHelpId", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "doOKAction", "", "gitRoot", "getSelectedRemote", "getSelectedBranch", "isCommitAfterMerge", "getRemote", "loadSettings", "saveSettings", "collectBranches", "getBranchesInRepo", "repository", "validateRepositoryField", "validateRemoteField", "validateBranchField", "getSelectedRepository", "updateRemotesField", "updateBranchesField", "getRemoteBranches", "remote", "getCurrentOrDefaultRemote", "optionChosen", "option", "performFetch", "getFetchTask", "git4idea/pull/GitPullDialog$getFetchTask$1", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;)Lgit4idea/pull/GitPullDialog$getFetchTask$1;", "createPopupBuilder", "isOptionSelected", "createOptionsDropDown", "Lcom/intellij/ui/components/DropDownLink;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/jvm/internal/EnhancedNullability;", "getOptionInfo", "getOptions", "updateUi", "isOptionEnabled", "updateTitle", "createPanel", "showRootField", "createCommandPanel", "createCmdLabel", "Lgit4idea/merge/dialog/CmdLabel;", "createRepoField", "createRemoteField", "createBranchField", "createBranchFieldPopupComponent", "content", "getFetchActionShortcut", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "getFetchActionShortcutText", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPullDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPullDialog.kt\ngit4idea/pull/GitPullDialog\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,434:1\n30#2,2:435\n1642#3,10:437\n1915#3:447\n1916#3:449\n1652#3:450\n1300#3,2:451\n1315#3,4:453\n1068#3:457\n1512#3:458\n1538#3,3:459\n1541#3,3:469\n1586#3:473\n1661#3,3:474\n1786#3,3:477\n1#4:448\n1#4:472\n383#5,7:462\n*S KotlinDebug\n*F\n+ 1 GitPullDialog.kt\ngit4idea/pull/GitPullDialog\n*L\n66#1:435,2\n112#1:437,10\n112#1:447\n112#1:449\n112#1:450\n148#1:451,2\n148#1:453,4\n151#1:457\n152#1:458\n152#1:459,3\n152#1:469,3\n205#1:473\n205#1:474,3\n290#1:477,3\n112#1:448\n152#1:462,7\n*E\n"})
public final class GitPullDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<VirtualFile> roots;
    @NotNull
    private final VirtualFile defaultRoot;
    @NotNull
    private final Set<GitPullOption> selectedOptions;
    @NotNull
    private final GitFetchSupport fetchSupport;
    @NotNull
    private final GitPullSettings pullSettings;
    private final List<GitRepository> repositories;
    @NotNull
    private final Map<GitRepository, Map<GitRemote, List<GitRemoteBranch>>> branches;
    @NotNull
    private final Map<GitPullOption, OptionInfo<GitPullOption>> optionInfos;
    @NotNull
    private final GitOptionsPopupBuilder<GitPullOption> popupBuilder;
    @NotNull
    private final ComboBox<GitRepository> repositoryField;
    @NotNull
    private final ComboBox<GitRemote> remoteField;
    @NotNull
    private final ComboBoxWithAutoCompletion<String> branchField;
    @NotNull
    private final JPanel commandPanel;
    @NotNull
    private final GitOptionsPanel<GitPullOption> optionsPanel;
    @NotNull
    private final JPanel panel;
    private final boolean isNoVerifySupported;

    public GitPullDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull VirtualFile defaultRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)defaultRoot, (String)"defaultRoot");
        super(project);
        this.project = project;
        this.roots = roots;
        this.defaultRoot = defaultRoot;
        this.selectedOptions = new LinkedHashSet();
        GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"fetchSupport(...)");
        this.fetchSupport = gitFetchSupport;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitPullSettings> serviceClass$iv = GitPullSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.pullSettings = (GitPullSettings)object;
        this.repositories = DvcsUtil.sortRepositories((Collection)GitRepositoryManager.getInstance(this.project).getRepositories());
        this.branches = MapsKt.toMutableMap(this.collectBranches());
        this.optionInfos = new LinkedHashMap();
        this.popupBuilder = this.createPopupBuilder();
        this.repositoryField = this.createRepoField();
        this.remoteField = this.createRemoteField();
        this.branchField = this.createBranchField();
        this.commandPanel = this.createCommandPanel();
        this.optionsPanel = new GitOptionsPanel((Function1)new Function1<GitPullOption, Unit>((Object)this){

            public final void invoke(GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitPullDialog.access$optionChosen((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>((Object)this){

            public final OptionInfo<GitPullOption> invoke(GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$getOptionInfo((GitPullDialog)((Object)this.receiver), p0);
            }
        });
        this.panel = this.createPanel();
        this.isNoVerifySupported = GitVersionSpecialty.NO_VERIFY_SUPPORTED.existsIn(GitExecutableManager.getInstance().getVersion(this.project));
        this.updateTitle();
        this.setOKButtonText(GitBundle.message((String)"pull.button", (Object[])new Object[0]));
        this.loadSettings();
        this.updateRemotesField();
        this.setAutoAdjustable(false);
        this.init();
        this.getWindow().setMinimumSize((Dimension)new JBDimension(200, 60));
        this.updateUi();
        this.validate();
        this.pack();
    }

    @NotNull
    public final Set<GitPullOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.panel;
    }

    @NotNull
    public ComboBoxWithAutoCompletion<String> getPreferredFocusedComponent() {
        return this.branchField;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createSouthPanel(...)");
        return GitMergeDialogKt.createSouthPanelWithOptionsDropDown(jComponent, this.createOptionsDropDown());
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.Pull";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new KFunction[]{new Function0<ValidationInfo>((Object)this){

            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateRepositoryField((GitPullDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateRemoteField((GitPullDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>((Object)this){

            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateBranchField((GitPullDialog)((Object)this.receiver));
            }
        }};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)((Function0)it).invoke() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        try {
            this.saveSettings();
        }
        finally {
            super.doOKAction();
        }
    }

    @NotNull
    public final VirtualFile gitRoot() {
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
            throw new IllegalStateException("No selected repository found".toString());
        }
        return gitRepository;
    }

    @NotNull
    public final GitRemote getSelectedRemote() {
        GitRemote gitRemote = (GitRemote)this.remoteField.getItem();
        if (gitRemote == null) {
            throw new IllegalStateException("No selected remote found".toString());
        }
        return gitRemote;
    }

    @NotNull
    public final GitRemoteBranch getSelectedBranch() {
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null) {
            throw new IllegalStateException("No selected repository found".toString());
        }
        GitRepository repository2 = gitRepository;
        GitRemote remote = this.getSelectedRemote();
        String branchName = remote.getName() + "/" + this.branchField.getItem();
        GitRemoteBranch gitRemoteBranch = repository2.getBranches().findRemoteBranch(branchName);
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(("Unable to find remote branch: " + branchName).toString());
        }
        return gitRemoteBranch;
    }

    public final boolean isCommitAfterMerge() {
        return !this.selectedOptions.contains((Object)GitPullOption.NO_COMMIT);
    }

    private final GitRemote getRemote() {
        return (GitRemote)this.remoteField.getItem();
    }

    private final void loadSettings() {
        Collection collection = this.selectedOptions;
        Set<GitPullOption> set = this.pullSettings.getOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getOptions(...)");
        CollectionsKt.addAll((Collection)collection, (Iterable)set);
    }

    private final void saveSettings() {
        this.pullSettings.setOptions(this.selectedOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, Map<GitRemote, List<GitRemoteBranch>>> collectBranches() {
        void $this$associateWithTo$iv$iv;
        List<GitRepository> list = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list, (String)"repositories");
        Iterable $this$associateWith$iv = list;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void repository2;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)repository2);
            Map<GitRemote, List<GitRemoteBranch>> map3 = this.getBranchesInRepo((GitRepository)repository2);
            map2.put(t, map3);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRemote, List<GitRemoteBranch>> getBranchesInRepo(GitRepository repository2) {
        void $this$groupByTo$iv$iv;
        Collection<GitRemoteBranch> collection = repository2.getBranches().getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRemoteBranches(...)");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GitRemoteBranch branch = (GitRemoteBranch)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)branch.getNameForRemoteOperations());
                branch = (GitRemoteBranch)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)branch.getNameForRemoteOperations())));
            }
        });
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            GitRemoteBranch branch = (GitRemoteBranch)element$iv$iv;
            boolean bl = false;
            GitRemote key$iv$iv = branch.getRemote();
            Map map2 = destination$iv$iv;
            GitRemote key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final ValidationInfo validateRepositoryField() {
        return this.getSelectedRepository() != null ? null : new ValidationInfo(GitBundle.message((String)"pull.repository.not.selected.error", (Object[])new Object[0]), (JComponent)this.repositoryField);
    }

    private final ValidationInfo validateRemoteField() {
        return this.getRemote() != null ? null : new ValidationInfo(GitBundle.message((String)"pull.remote.not.selected", (Object[])new Object[0]), (JComponent)this.remoteField);
    }

    private final ValidationInfo validateBranchField() {
        String string = GitBundle.message((String)"pull.branch.not.selected.error", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return GitMergeDialogKt.validateBranchExists(this.branchField, string);
    }

    private final GitRepository getSelectedRepository() {
        return (GitRepository)this.repositoryField.getItem();
    }

    private final void updateRemotesField() {
        GitRepository repository2 = this.getSelectedRepository();
        ComboBoxModel comboBoxModel = this.remoteField.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<@[FlexibleNullability] git4idea.repo.GitRemote?>");
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        Object object = repository2;
        if (object == null || (object = object.getRemotes()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        model.update((List)object);
        model.setSelectedItem((Object)this.getCurrentOrDefaultRemote(repository2));
    }

    private final void updateBranchesField() {
        Object object;
        Object branchToSelect = (String)this.branchField.getItem();
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        GitRemote gitRemote = this.getRemote();
        if (gitRemote == null) {
            return;
        }
        GitRemote remote = gitRemote;
        List<String> list = GitBranchUtil.sortBranchNames((Collection<String>)this.getRemoteBranches(repository2, remote));
        Intrinsics.checkNotNullExpressionValue(list, (String)"sortBranchNames(...)");
        List<String> branches = list;
        ComboBoxModel comboBoxModel = this.branchField.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<@[FlexibleNullability] kotlin.String?>");
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        model.update(branches);
        if (!(branchToSelect != null && branches.contains(branchToSelect) || (object = repository2.getCurrentBranch()) != null && (object = object.findTrackedBranch(repository2)) != null && (object = object.getNameForRemoteOperations()) != null)) {
            Object v5;
            block6: {
                Iterable iterable = branches;
                for (Object t : iterable) {
                    String branch = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)branch, (Object)repository2.getCurrentBranchName())) continue;
                    v5 = t;
                    break block6;
                }
                v5 = null;
            }
            if ((object = (String)v5) == null) {
                object = branchToSelect = "";
            }
        }
        if (((CharSequence)branchToSelect).length() == 0) {
            this.startTrackingValidation();
        }
        this.branchField.setSelectedItem(branchToSelect);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRemoteBranches(GitRepository repository2, GitRemote remote) {
        List list;
        Map<GitRemote, List<GitRemoteBranch>> map2 = this.branches.get(repository2);
        if (map2 != null && (map2 = map2.get(remote)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)((Object)map2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getNameForRemoteOperations());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final GitRemote getCurrentOrDefaultRemote(GitRepository repository2) {
        Object object = repository2;
        if (object == null || (object = object.getRemotes()) == null) {
            return null;
        }
        Object remotes = object;
        if (remotes.isEmpty()) {
            return null;
        }
        GitBranchTrackInfo gitBranchTrackInfo = GitUtil.getTrackInfoForCurrentBranch(repository2);
        if (gitBranchTrackInfo == null || (gitBranchTrackInfo = gitBranchTrackInfo.getRemote()) == null) {
            gitBranchTrackInfo = GitUtil.getDefaultOrFirstRemote((Collection<GitRemote>)remotes);
        }
        return gitBranchTrackInfo;
    }

    private final void optionChosen(GitPullOption option) {
        if (!this.selectedOptions.contains((Object)option)) {
            ((Collection)this.selectedOptions).add(option);
        } else {
            ((Collection)this.selectedOptions).remove((Object)option);
        }
        this.updateUi();
        this.validate();
        this.pack();
    }

    private final void performFetch() {
        if (this.fetchSupport.isFetchRunning()) {
            return;
        }
        GitRepository repository2 = this.getSelectedRepository();
        GitRemote remote = this.getRemote();
        if (repository2 == null || remote == null) {
            VcsNotifier.getInstance((Project)this.project).notifyError("git.fetch.error", GitBundle.message((String)"pull.fetch.failed.notification.title", (Object[])new Object[0]), GitBundle.message((String)"pull.fetch.failed.notification.text", (Object[])new Object[0]));
            return;
        }
        GitVcs.runInBackground(this.getFetchTask(repository2, remote));
    }

    private final getFetchTask.1 getFetchTask(GitRepository repository2, GitRemote remote) {
        Project project = this.project;
        String string = GitBundle.message((String)"fetching", (Object[])new Object[0]);
        return new Task.Backgroundable(this, repository2, remote, project, string){
            final /* synthetic */ GitPullDialog this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;
            {
                this.this$0 = $receiver;
                this.$repository = $repository;
                this.$remote = $remote;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitPullDialog.access$getFetchSupport$p(this.this$0).fetch(this.$repository, this.$remote);
            }

            public void onSuccess() {
                GitPullDialog.access$getBranches$p(this.this$0).put(this.$repository, GitPullDialog.access$getBranchesInRepo(this.this$0, this.$repository));
                if (Intrinsics.areEqual((Object)GitPullDialog.access$getSelectedRepository(this.this$0), (Object)this.$repository) && Intrinsics.areEqual((Object)GitPullDialog.access$getRemote(this.this$0), (Object)this.$remote)) {
                    GitPullDialog.access$updateBranchesField(this.this$0);
                }
            }
        };
    }

    private final GitOptionsPopupBuilder<GitPullOption> createPopupBuilder() {
        String string = GitBundle.message((String)"pull.options.modify.popup.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new GitOptionsPopupBuilder<GitPullOption>(this.project, string, (Function0)new Function0<List<? extends GitPullOption>>((Object)this){

            public final List<GitPullOption> invoke() {
                return GitPullDialog.access$getOptions((GitPullDialog)((Object)this.receiver));
            }
        }, (Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>((Object)this){

            public final OptionInfo<GitPullOption> invoke(GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$getOptionInfo((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, Boolean>((Object)this){

            public final Boolean invoke(GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$isOptionSelected((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, Boolean>((Object)this){

            public final Boolean invoke(GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return GitPullDialog.access$isOptionEnabled((GitPullDialog)((Object)this.receiver), p0);
            }
        }, (Function1)new Function1<GitPullOption, Unit>((Object)this){

            public final void invoke(GitPullOption p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                GitPullDialog.access$optionChosen((GitPullDialog)((Object)this.receiver), p0);
            }
        }, null, 128, null);
    }

    private final boolean isOptionSelected(GitPullOption option) {
        return this.selectedOptions.contains((Object)option);
    }

    private final DropDownLink<String> createOptionsDropDown() {
        DropDownLink dropDownLink;
        DropDownLink $this$createOptionsDropDown_u24lambda_u241 = dropDownLink = new DropDownLink((Object)GitBundle.message((String)"merge.options.modify", (Object[])new Object[0]), arg_0 -> GitPullDialog.createOptionsDropDown$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createOptionsDropDown_u24lambda_u241.setMnemonic(77);
        return dropDownLink;
    }

    private final OptionInfo<GitPullOption> getOptionInfo(GitPullOption option) {
        OptionInfo optionInfo = this.optionInfos.computeIfAbsent(option, arg_0 -> GitPullDialog.getOptionInfo$lambda$1(arg_0 -> GitPullDialog.getOptionInfo$lambda$0(option, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)optionInfo, (String)"computeIfAbsent(...)");
        return optionInfo;
    }

    private final List<GitPullOption> getOptions() {
        List list;
        List $this$getOptions_u24lambda_u240 = list = ArraysKt.toMutableList((Object[])GitPullOption.values());
        boolean bl = false;
        if (!this.isNoVerifySupported) {
            $this$getOptions_u24lambda_u240.remove((Object)GitPullOption.NO_VERIFY);
        }
        return list;
    }

    private final void updateUi() {
        this.optionsPanel.rerender(this.selectedOptions);
        this.panel.invalidate();
    }

    private final boolean isOptionEnabled(GitPullOption option) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.selectedOptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitPullOption it = (GitPullOption)((Object)element$iv);
                    boolean bl2 = false;
                    if (it.isOptionSuitable(option)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void updateTitle() {
        String string;
        GitRepository gitRepository = this.getSelectedRepository();
        String currentBranchName = gitRepository != null ? gitRepository.getCurrentBranchName() : null;
        Object[] objectArray = (Object[])currentBranchName;
        if (objectArray == null || objectArray.length() == 0) {
            string = GitBundle.message((String)"pull.dialog.title", (Object[])new Object[0]);
        } else {
            objectArray = new Object[]{currentBranchName};
            string = GitBundle.message((String)"pull.dialog.with.branch.title", (Object[])objectArray);
        }
        this.setTitle(string);
    }

    private final JPanel createPanel() {
        JPanel jPanel;
        JPanel $this$createPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3), new AC().grow()));
        $this$createPanel_u24lambda_u240.add((Component)this.commandPanel, new CC().growX());
        $this$createPanel_u24lambda_u240.add((Component)this.optionsPanel, new CC().newline().width("100%").alignY("top"));
        return jPanel;
    }

    private final boolean showRootField() {
        return this.roots.size() > 1;
    }

    private final JPanel createCommandPanel() {
        AC aC;
        JPanel jPanel;
        JPanel $this$createCommandPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        if (this.showRootField()) {
            var4_4 = new int[]{0, 3};
            aC = new AC().grow(100.0f, var4_4);
        } else {
            var4_4 = new int[]{2};
            aC = new AC().grow(100.0f, var4_4);
        }
        AC colConstraints = aC;
        $this$createCommandPanel_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").gridGap("0", "0").noVisualPadding(), colConstraints));
        if (this.showRootField()) {
            $this$createCommandPanel_u24lambda_u240.add((Component)this.repositoryField, new CC().gapAfter("0").minWidth("115").growX());
        }
        $this$createCommandPanel_u24lambda_u240.add((Component)this.createCmdLabel(), new CC().gapAfter("0").alignY("top").minWidth("85"));
        $this$createCommandPanel_u24lambda_u240.add((Component)this.remoteField, new CC().alignY("top").minWidth("90"));
        $this$createCommandPanel_u24lambda_u240.add((Component)((Object)this.branchField), new CC().alignY("top").minWidth("250").growX());
        return jPanel;
    }

    private final CmdLabel createCmdLabel() {
        return new CmdLabel("git pull", new Insets(1, this.showRootField() ? 0 : 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)85), this.branchField.getPreferredSize().height, true));
    }

    private final ComboBox<GitRepository> createRepoField() {
        ComboBox<GitRepository> comboBox;
        List<GitRepository> list = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list, (String)"repositories");
        ComboBox<GitRepository> $this$createRepoField_u24lambda_u240 = comboBox = GitMergeDialogKt.createRepositoryField(list, this.defaultRoot);
        boolean bl = false;
        $this$createRepoField_u24lambda_u240.addActionListener(arg_0 -> GitPullDialog.createRepoField$lambda$0$0(this, arg_0));
        return comboBox;
    }

    private final ComboBox<GitRemote> createRemoteField() {
        ComboBox comboBox;
        ComboBox $this$createRemoteField_u24lambda_u240 = comboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        boolean bl = false;
        $this$createRemoteField_u24lambda_u240.setSwingPopup(false);
        $this$createRemoteField_u24lambda_u240.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)HtmlChunk.text((String)GitBundle.message((String)"util.remote.renderer.none", (Object[])new Object[0])).italic().wrapWith(HtmlChunk.Element.html()).toString(), arg_0 -> GitPullDialog.createRemoteField$lambda$0$1(GitPullDialog::createRemoteField$lambda$0$0, arg_0)));
        Insets insets = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), 0);
        String string = GitBundle.message((String)"pull.branch.no.matching.remotes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createRemoteField_u24lambda_u240.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, insets, string, null, 9, null)));
        $this$createRemoteField_u24lambda_u240.setItem((Object)this.getCurrentOrDefaultRemote(this.getSelectedRepository()));
        $this$createRemoteField_u24lambda_u240.addItemListener(arg_0 -> GitPullDialog.createRemoteField$lambda$0$2(this, arg_0));
        return comboBox;
    }

    private final ComboBoxWithAutoCompletion<String> createBranchField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$createBranchField_u24lambda_u240 = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel((List)new ArrayList()), this.project);
        boolean bl = false;
        $this$createBranchField_u24lambda_u240.setPrototypeDisplayValue("origin/long-enough-branch-name");
        String string = GitBundle.message((String)"pull.branch.field.placeholder", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createBranchField_u24lambda_u240.setPlaceholder(string);
        new RefreshAction($this$createBranchField_u24lambda_u240, this){
            final /* synthetic */ ComboBoxWithAutoCompletion<String> $this_apply;
            final /* synthetic */ GitPullDialog this$0;
            {
                this.$this_apply = $this_apply;
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ComboPopup comboPopup = this.$this_apply.getPopup();
                if (comboPopup != null) {
                    comboPopup.hide();
                }
                GitPullDialog.access$performFetch(this.this$0);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(true);
            }
        }.registerCustomShortcutSet(this.getFetchActionShortcut(), (JComponent)((Object)$this$createBranchField_u24lambda_u240));
        Insets insets = new Insets(1, 0, 1, 1);
        Insets insets2 = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), DarculaUIUtil.BW.get());
        String string2 = GitBundle.message((String)"pull.branch.nothing.to.pull", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$createBranchField_u24lambda_u240.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(insets, insets2, string2, (Function1<? super JComponent, ? extends JComponent>)((Function1)new Function1<JComponent, JPanel>((Object)this){

            public final JPanel invoke(JComponent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return GitPullDialog.access$createBranchFieldPopupComponent((GitPullDialog)((Object)this.receiver), p0);
            }
        }))));
        return comboBoxWithAutoCompletion;
    }

    private final JPanel createBranchFieldPopupComponent(JComponent content) {
        JPanel jPanel;
        JPanel $this$createBranchFieldPopupComponent_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createBranchFieldPopupComponent_u24lambda_u240.setLayout((LayoutManager)new MigLayout(new LC().insets("0")));
        $this$createBranchFieldPopupComponent_u24lambda_u240.add((Component)content, new CC().width("100%"));
        Object[] objectArray = new Object[]{this.getFetchActionShortcutText()};
        JLabel jLabel = HintUtil.createAdComponent((String)GitBundle.message((String)"pull.dialog.fetch.shortcuts.hint", (Object[])objectArray), (Border)JBUI.CurrentTheme.BigPopup.advertiserBorder(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createAdComponent(...)");
        JLabel hintLabel = jLabel;
        hintLabel.setPreferredSize((Dimension)JBDimension.create((Dimension)hintLabel.getPreferredSize(), (boolean)true).withHeight(17));
        $this$createBranchFieldPopupComponent_u24lambda_u240.add((Component)hintLabel, new CC().newline().width("100%"));
        return jPanel;
    }

    private final ShortcutSet getFetchActionShortcut() {
        ShortcutSet shortcutSet = ActionManager.getInstance().getAction("Refresh").getShortcutSet();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"getShortcutSet(...)");
        ShortcutSet refreshActionShortcut = shortcutSet;
        Shortcut[] shortcutArray = refreshActionShortcut.getShortcuts();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        if (!(((Object[])shortcutArray).length == 0)) {
            return refreshActionShortcut;
        }
        return (ShortcutSet)GitPullDialog.Companion.getFETCH_ACTION_SHORTCUT();
    }

    private final String getFetchActionShortcutText() {
        String string = KeymapUtil.getPreferredShortcutText((Shortcut[])this.getFetchActionShortcut().getShortcuts());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPreferredShortcutText(...)");
        return string;
    }

    private static final JBPopup createOptionsDropDown$lambda$0(GitPullDialog this$0, DropDownLink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JBPopup)this$0.popupBuilder.createPopup();
    }

    private static final OptionInfo getOptionInfo$lambda$0(GitPullOption $option, GitPullOption it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new OptionInfo<GitPullOption>($option, $option.getOption(), $option.getDescription());
    }

    private static final OptionInfo getOptionInfo$lambda$1(Function1 $tmp0, Object p0) {
        return (OptionInfo)$tmp0.invoke(p0);
    }

    private static final void createRepoField$lambda$0$0(GitPullDialog this$0, ActionEvent it) {
        this$0.updateTitle();
        this$0.updateRemotesField();
    }

    private static final String createRemoteField$lambda$0$0(GitRemote it) {
        return it.getName();
    }

    private static final String createRemoteField$lambda$0$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void createRemoteField$lambda$0$2(GitPullDialog this$0, ItemEvent e) {
        if (e.getStateChange() == 1) {
            this$0.updateBranchesField();
        }
    }

    public static final /* synthetic */ ValidationInfo access$validateRepositoryField(GitPullDialog $this) {
        return $this.validateRepositoryField();
    }

    public static final /* synthetic */ ValidationInfo access$validateRemoteField(GitPullDialog $this) {
        return $this.validateRemoteField();
    }

    public static final /* synthetic */ ValidationInfo access$validateBranchField(GitPullDialog $this) {
        return $this.validateBranchField();
    }

    public static final /* synthetic */ GitFetchSupport access$getFetchSupport$p(GitPullDialog $this) {
        return $this.fetchSupport;
    }

    public static final /* synthetic */ Map access$getBranches$p(GitPullDialog $this) {
        return $this.branches;
    }

    public static final /* synthetic */ Map access$getBranchesInRepo(GitPullDialog $this, GitRepository repository2) {
        return $this.getBranchesInRepo(repository2);
    }

    public static final /* synthetic */ GitRepository access$getSelectedRepository(GitPullDialog $this) {
        return $this.getSelectedRepository();
    }

    public static final /* synthetic */ GitRemote access$getRemote(GitPullDialog $this) {
        return $this.getRemote();
    }

    public static final /* synthetic */ void access$updateBranchesField(GitPullDialog $this) {
        $this.updateBranchesField();
    }

    public static final /* synthetic */ List access$getOptions(GitPullDialog $this) {
        return $this.getOptions();
    }

    public static final /* synthetic */ OptionInfo access$getOptionInfo(GitPullDialog $this, GitPullOption option) {
        return $this.getOptionInfo(option);
    }

    public static final /* synthetic */ boolean access$isOptionSelected(GitPullDialog $this, GitPullOption option) {
        return $this.isOptionSelected(option);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(GitPullDialog $this, GitPullOption option) {
        return $this.isOptionEnabled(option);
    }

    public static final /* synthetic */ void access$optionChosen(GitPullDialog $this, GitPullOption option) {
        $this.optionChosen(option);
    }

    public static final /* synthetic */ void access$performFetch(GitPullDialog $this) {
        $this.performFetch();
    }

    public static final /* synthetic */ JPanel access$createBranchFieldPopupComponent(GitPullDialog $this, JComponent content) {
        return $this.createBranchFieldPopupComponent(content);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/pull/GitPullDialog$Companion;", "", "<init>", "()V", "FETCH_ACTION_SHORTCUT", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "getFETCH_ACTION_SHORTCUT", "()Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final CustomShortcutSet getFETCH_ACTION_SHORTCUT() {
            return ClientSystemInfo.Companion.isMac() ? new CustomShortcutSet(KeyStroke.getKeyStroke(82, 256)) : new CustomShortcutSet(KeyStroke.getKeyStroke(116, 128));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

