/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.util.paths.RootDirtySet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRefreshUsageCollector;
import git4idea.GitVcsDirtyScope;
import git4idea.index.GitFileStatus;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStagingAreaHolder {
    private static final Logger LOG = Logger.getInstance(GitStagingAreaHolder.class);
    public static final Topic<StagingAreaListener> TOPIC = Topic.create((String)"GitStagingAreaHolder change", StagingAreaListener.class);
    private final Project myProject;
    private final GitRepository myRepository;
    private final Object LOCK;
    private final List<GitFileStatus> myRecords;

    public GitStagingAreaHolder(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myRecords = new ArrayList<GitFileStatus>();
        this.myProject = repository2.getProject();
        this.myRepository = repository2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<GitFileStatus> getAllRecords() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<GitFileStatus> arrayList = new ArrayList<GitFileStatus>(this.myRecords);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        GitStagingAreaHolder.$$$reportNull$$$0(1);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GitFileStatus findRecord(@NotNull FilePath path) {
        if (path == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return (GitFileStatus)ContainerUtil.find(this.myRecords, it -> it.getPath().equals((Object)path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myRecords.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasConflicts() {
        Object object = this.LOCK;
        synchronized (object) {
            return ContainerUtil.exists(this.myRecords, record -> GitIndexStatusUtilKt.isConflicted(record.getIndex(), record.getWorkTree()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<GitConflict> getAllConflicts() {
        Object object = this.LOCK;
        // MONITORENTER : object
        List list = ContainerUtil.mapNotNull(this.myRecords, this::createConflict);
        // MONITOREXIT : object
        if (list != null) return list;
        GitStagingAreaHolder.$$$reportNull$$$0(3);
        return list;
    }

    @Nullable
    public GitConflict findConflict(@NotNull FilePath path) {
        if (path == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(4);
        }
        return this.createConflict(this.findRecord(path));
    }

    @Nullable
    private GitConflict createConflict(@Nullable GitFileStatus record) {
        if (record == null) {
            return null;
        }
        return GitStagingAreaHolder.createConflict(this.myRepository.getRoot(), record);
    }

    @Nullable
    public static GitConflict createConflict(@NotNull VirtualFile root, @NotNull GitFileStatus record) {
        if (root == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(5);
        }
        if (record == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(6);
        }
        if (!GitIndexStatusUtilKt.isConflicted(record.getIndex(), record.getWorkTree())) {
            return null;
        }
        return new GitConflict(root, record.getPath(), GitStagingAreaHolder.getConflictStatus(record.getIndex()), GitStagingAreaHolder.getConflictStatus(record.getWorkTree()));
    }

    @NotNull
    private static GitConflict.Status getConflictStatus(char status) {
        if (status == 'A') {
            GitConflict.Status status2 = GitConflict.Status.ADDED;
            if (status2 == null) {
                GitStagingAreaHolder.$$$reportNull$$$0(7);
            }
            return status2;
        }
        if (status == 'D') {
            GitConflict.Status status3 = GitConflict.Status.DELETED;
            if (status3 == null) {
                GitStagingAreaHolder.$$$reportNull$$$0(8);
            }
            return status3;
        }
        GitConflict.Status status4 = GitConflict.Status.MODIFIED;
        if (status4 == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(9);
        }
        return status4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public List<GitFileStatus> refresh(@NotNull RootDirtySet dirtyPaths) throws VcsException {
        if (dirtyPaths == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(10);
        }
        VirtualFile root = this.myRepository.getRoot();
        StructuredIdeActivity activity = GitRefreshUsageCollector.logStatusRefresh(this.myProject, dirtyPaths.isEverythingDirty());
        List<GitFileStatus> rootRecords = GitIndexStatusUtilKt.getStatus(this.myProject, root, dirtyPaths.collectFilePaths(), true, false, false);
        activity.finished();
        this.removeUnwantedRecords(rootRecords, dirtyPaths);
        Object object = this.LOCK;
        synchronized (object) {
            this.myRecords.removeIf(record -> GitStagingAreaHolder.isUnder(record, dirtyPaths));
            this.myRecords.addAll(rootRecords);
        }
        ((StagingAreaListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, TOPIC)).stagingAreaChanged(this.myRepository);
        List<GitFileStatus> list = rootRecords;
        if (list == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(11);
        }
        return list;
    }

    private void removeUnwantedRecords(@NotNull Collection<GitFileStatus> rootRecords, @NotNull RootDirtySet dirtyPaths) {
        if (rootRecords == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(12);
        }
        if (dirtyPaths == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(13);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile repoRoot = this.myRepository.getRoot();
        int removedFiles = 0;
        int maxFilesToReport = 10;
        Iterator<GitFileStatus> it = rootRecords.iterator();
        while (it.hasNext()) {
            boolean isUnderOurRoot;
            GitFileStatus record = it.next();
            boolean isUnderDirtyScope = GitStagingAreaHolder.isUnder(record, dirtyPaths);
            if (!isUnderDirtyScope) {
                it.remove();
                continue;
            }
            VirtualFile recordRoot = vcsManager.getVcsRootFor(record.getPath());
            boolean bl = isUnderOurRoot = repoRoot.equals(recordRoot) || GitStagingAreaHolder.isSubmoduleStatus(record, recordRoot);
            if (isUnderOurRoot) continue;
            it.remove();
            if (++removedFiles >= maxFilesToReport && !LOG.isDebugEnabled()) continue;
            LOG.warn(String.format("Ignoring change under another root: %s; root: %s; mapped root: %s", record, repoRoot.getPresentableUrl(), recordRoot != null ? recordRoot.getPresentableUrl() : "null"));
        }
        if (removedFiles >= maxFilesToReport) {
            LOG.warn(String.format("Ignoring changed files under another root: %s files total", removedFiles));
        }
    }

    private static boolean isUnder(@NotNull GitFileStatus record, @NotNull RootDirtySet dirtySet) {
        if (record == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(14);
        }
        if (dirtySet == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(15);
        }
        return dirtySet.belongsTo(record.getPath()) || record.getOrigPath() != null && dirtySet.belongsTo(record.getOrigPath());
    }

    private static boolean isSubmoduleStatus(@NotNull GitFileStatus record, @Nullable VirtualFile candidateRoot) {
        if (record == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(16);
        }
        if (candidateRoot == null) {
            return false;
        }
        String recordPath = record.getPath().getPath();
        String rootPath = candidateRoot.getPath();
        return recordPath.equals(rootPath);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<VirtualFile, RootDirtySet> collectDirtyPathsPerRoot(@NotNull GitVcsDirtyScope dirtyScope, @NotNull Map<GitRepository, GitSubmodule> knownSubmodules) {
        if (dirtyScope == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(17);
        }
        if (knownSubmodules == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(18);
        }
        Project project = dirtyScope.getProject();
        HashMap<VirtualFile, RootDirtySet> dirtySetPerRoot = new HashMap<VirtualFile, RootDirtySet>(dirtyScope.getDirtySetsPerRoot());
        for (VirtualFile root2 : dirtySetPerRoot.keySet()) {
            GitRepository gitRepository;
            RootDirtySet rootPaths = (RootDirtySet)dirtySetPerRoot.get(root2);
            if (rootPaths.isEverythingDirty() || (gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root2)) == null) continue;
            List<GitFileStatus> records = gitRepository.getStagingAreaHolder().getAllRecords();
            for (GitFileStatus record : records) {
                FilePath filePath = record.getPath();
                FilePath origPath = record.getOrigPath();
                if (origPath != null) {
                    rootPaths.markDirty(origPath);
                    rootPaths.markDirty(filePath);
                    continue;
                }
                if (!GitStagingAreaHolder.isStatusCodeForPotentialRename(record.getIndex()) && !GitStagingAreaHolder.isStatusCodeForPotentialRename(record.getWorkTree())) continue;
                rootPaths.markDirty(filePath);
            }
        }
        for (GitSubmodule submodule : knownSubmodules.values()) {
            VirtualFile submoduleRoot = submodule.getRepository().getRoot();
            VirtualFile parentRoot = submodule.getParent().getRoot();
            RootDirtySet dirtySet = (RootDirtySet)dirtySetPerRoot.get(submoduleRoot);
            if (dirtySet == null || !dirtySet.isEverythingDirty()) continue;
            RootDirtySet rootPaths = dirtySetPerRoot.computeIfAbsent(parentRoot, root -> GitVcsDirtyScope.createDirtySetForRoot(root));
            rootPaths.markDirty(VcsUtil.getFilePath((VirtualFile)submoduleRoot));
        }
        HashMap<VirtualFile, RootDirtySet> hashMap = dirtySetPerRoot;
        if (hashMap == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    private static boolean isStatusCodeForPotentialRename(char statusCode) {
        return GitIndexStatusUtilKt.isRenamed(statusCode) || GitIndexStatusUtilKt.isDeleted(statusCode) || GitIndexStatusUtilKt.isAdded(statusCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 8, 9, 11, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/status/GitStagingAreaHolder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRecords";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtySet";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownSubmodules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/status/GitStagingAreaHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRecords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConflicts";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictStatus";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDirtyPathsPerRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConflict";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConflict";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeUnwantedRecords";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSubmoduleStatus";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectDirtyPathsPerRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 8, 9, 11, 19 -> new IllegalStateException(string);
        };
    }

    public static interface StagingAreaListener {
        public void stagingAreaChanged(@NotNull GitRepository var1);
    }
}

