/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.ui.RepositoryComboboxListCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBLabel;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public final class GitBranchIsNotFullyMergedDialog
extends DialogWrapper {
    @NotNull
    private final Map<GitRepository, List<GitCommit>> myCommits;
    @NotNull
    private final GitCommitListWithDiffPanel myCommitListWithDiffPanel;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    private final String myRemovedBranch;
    @NotNull
    private final Map<GitRepository, String> myBaseBranches;
    @NotNull
    private final GitRepository myInitialRepository;

    public static boolean showAndGetAnswer(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(0);
        }
        if (commits == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(1);
        }
        if (baseBranches == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(2);
        }
        if (removedBranch == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(3);
        }
        GitBranchIsNotFullyMergedDialog dialog2 = new GitBranchIsNotFullyMergedDialog(project, commits, baseBranches, removedBranch);
        DialogManager.show(dialog2);
        return dialog2.isOK();
    }

    private GitBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(4);
        }
        if (commits == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(5);
        }
        if (baseBranches == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(6);
        }
        if (removedBranch == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(7);
        }
        super(project, false);
        this.myCommits = commits;
        this.myRepositories = commits.keySet();
        this.myBaseBranches = baseBranches;
        this.myRemovedBranch = removedBranch;
        this.myInitialRepository = this.calcInitiallySelectedRepository();
        this.myCommitListWithDiffPanel = new GitCommitListWithDiffPanel(project, new ArrayList<GitCommit>((Collection)this.myCommits.get(this.myInitialRepository)));
        this.init();
        this.setTitle(GitBundle.message((String)"branch.not.fully.merged.dialog.title", (Object[])new Object[0]));
        this.setOKButtonText(GitBundle.message((String)"branch.not.fully.merged.dialog.restore.button", (Object[])new Object[0]));
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
    }

    @NotNull
    private GitRepository calcInitiallySelectedRepository() {
        for (GitRepository repository2 : this.myRepositories) {
            if (this.myCommits.get(repository2).isEmpty()) continue;
            GitRepository gitRepository = repository2;
            if (gitRepository == null) {
                GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(8);
            }
            return gitRepository;
        }
        throw new AssertionError((Object)("The dialog shouldn't be shown. Unmerged commits: " + String.valueOf(this.myCommits)));
    }

    @NlsContexts.Label
    @NotNull
    private String makeDescription(@NotNull GitRepository repository2) {
        String baseBranch;
        if (repository2 == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(9);
        }
        String description = (baseBranch = this.myBaseBranches.get(repository2)) == null ? GitBundle.message((String)"branch.not.fully.merged.dialog.all.commits.from.branch.were.merged", (Object[])new Object[]{this.myRemovedBranch}) : GitBundle.message((String)"branch.not.fully.merged.dialog.the.branch.was.not.fully.merged.to", (Object[])new Object[]{this.myRemovedBranch, baseBranch});
        String string = XmlStringUtil.wrapInHtml((CharSequence)description);
        if (string == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected JComponent createNorthPanel() {
        final JBLabel descriptionLabel = new JBLabel(this.makeDescription(this.myInitialRepository));
        final JComboBox<GitRepository> repositorySelector = new JComboBox<GitRepository>(this.myRepositories.toArray(new GitRepository[0]));
        repositorySelector.setRenderer((ListCellRenderer<GitRepository>)new RepositoryComboboxListCellRenderer());
        repositorySelector.setSelectedItem(this.myInitialRepository);
        repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRepository selectedRepo = (GitRepository)repositorySelector.getSelectedItem();
                descriptionLabel.setText(GitBranchIsNotFullyMergedDialog.this.makeDescription(selectedRepo));
                GitBranchIsNotFullyMergedDialog.this.myCommitListWithDiffPanel.setCommits(GitBranchIsNotFullyMergedDialog.this.myCommits.get(selectedRepo));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(GitBundle.message((String)"branch.not.fully.merged.dialog.repository.label", (Object[])new Object[0]) + " ");
        label.setLabelFor((Component)repoSelectorPanel);
        repoSelectorPanel.add((Component)label, "West");
        repoSelectorPanel.add(repositorySelector);
        if (this.myRepositories.size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)descriptionLabel);
        northPanel.add((Component)repoSelectorPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add(this.myCommitListWithDiffPanel);
        return rootPanel;
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(11);
        }
        return actionArray;
    }

    protected Action @NotNull [] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(12);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitListWithDiffPanel.getPreferredFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return GitBranchIsNotFullyMergedDialog.class.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranches";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedBranch";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchIsNotFullyMergedDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchIsNotFullyMergedDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitiallySelectedRepository";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetAnswer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

